/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.capra.ui.plantuml;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.capra.core.adapters.Connection;
import org.eclipse.capra.core.helpers.ArtifactHelper;
import org.eclipse.capra.core.helpers.EMFHelper;
import org.eclipse.capra.core.preferences.CapraPreferences;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.emf.ecore.EObject;

public class Connections {
    private static final String SHOW_FULL_TRACE_INFORMATION = "org.eclipse.capra.preferences.showFullTraceInformation";
    private static final String QUOTE_CHARACTERS = "[\"']";
    private static final String NEWLINE_CHARACTERS = "[\r\n]+";
    private List<Connection> connections;
    private EObject origin;
    private Set<EObject> allObjects;
    private Map<String, String> object2Id;
    private Map<String, String> id2Label;
    private Map<String, String> id2Location;
    private ArtifactHelper artifactHelper;

    private String sanitize(String input) {
        return input.replaceAll(QUOTE_CHARACTERS, " ").replaceAll(NEWLINE_CHARACTERS, " ");
    }

    Connections(List<Connection> connections, List<EObject> selectedObjects, EObject artifactModel) {
        this.artifactHelper = new ArtifactHelper(artifactModel);
        this.connections = connections;
        this.origin = selectedObjects.get(0);
        this.allObjects = new LinkedHashSet<EObject>();
        this.allObjects.addAll(selectedObjects);
        connections.forEach(c -> {
            this.allObjects.addAll(c.getOrigins());
            this.allObjects.addAll(c.getTargets());
        });
        this.object2Id = new LinkedHashMap<String, String>();
        int i = 0;
        for (EObject o2 : this.allObjects) {
            this.object2Id.put(EMFHelper.getIdentifier((EObject)o2), "o" + i++);
        }
        this.id2Label = new LinkedHashMap<String, String>();
        this.allObjects.forEach(o -> {
            String id = this.object2Id.get(EMFHelper.getIdentifier((EObject)o));
            this.id2Label.put(id, this.artifactHelper.getArtifactLabel(o));
        });
        this.id2Location = new LinkedHashMap<String, String>();
        this.allObjects.forEach(o -> {
            String id = this.object2Id.get(EMFHelper.getIdentifier((EObject)o));
            this.id2Location.put(id, this.artifactHelper.getArtifactLocation(o));
        });
    }

    public String originLabel() {
        return this.sanitize(this.id2Label.get(this.object2Id.get(EMFHelper.getIdentifier((EObject)this.origin))));
    }

    public String originLocation() {
        return this.id2Location.get(this.object2Id.get(EMFHelper.getIdentifier((EObject)this.origin)));
    }

    public boolean originHasLocation() {
        return !Strings.isNullOrEmpty((String)this.id2Location.get(this.object2Id.get(EMFHelper.getIdentifier((EObject)this.origin))));
    }

    public String originId() {
        return this.object2Id.get(EMFHelper.getIdentifier((EObject)this.origin));
    }

    public Collection<String> objectIdsWithoutOrigin() {
        ArrayList<String> all = new ArrayList<String>();
        all.addAll(this.object2Id.values());
        all.remove(this.originId());
        return all;
    }

    public String label(String id) {
        return this.sanitize(this.id2Label.get(id));
    }

    public String location(String id) {
        return this.id2Location.get(id);
    }

    public boolean hasLocation(String id) {
        return !Strings.isNullOrEmpty((String)this.id2Location.get(id));
    }

    public List<String> arrows() {
        HashSet arrows = new HashSet();
        this.connections.forEach(c -> c.getOrigins().forEach(org -> c.getTargets().forEach(trg -> arrows.add(String.valueOf(this.object2Id.get(EMFHelper.getIdentifier((EObject)org))) + "--" + this.object2Id.get(EMFHelper.getIdentifier((EObject)trg)) + ": " + this.getConnectionLabel((Connection)c)))));
        return arrows.stream().collect(Collectors.toList());
    }

    private String getConnectionLabel(Connection c) {
        IEclipsePreferences store = CapraPreferences.getPreferences();
        if (store.getBoolean(SHOW_FULL_TRACE_INFORMATION, false)) {
            return EMFHelper.getIdentifier((EObject)c.getTlink());
        }
        return c.getTlink().eClass().getName();
    }
}

