/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.set.mutable;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Iterator;
import java.util.RandomAccess;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.collections.api.LazyIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.Function2;
import org.eclipse.collections.api.block.function.primitive.BooleanFunction;
import org.eclipse.collections.api.block.function.primitive.ByteFunction;
import org.eclipse.collections.api.block.function.primitive.CharFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleFunction;
import org.eclipse.collections.api.block.function.primitive.FloatFunction;
import org.eclipse.collections.api.block.function.primitive.IntFunction;
import org.eclipse.collections.api.block.function.primitive.LongFunction;
import org.eclipse.collections.api.block.function.primitive.ShortFunction;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.predicate.Predicate2;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.collection.primitive.MutableBooleanCollection;
import org.eclipse.collections.api.collection.primitive.MutableByteCollection;
import org.eclipse.collections.api.collection.primitive.MutableCharCollection;
import org.eclipse.collections.api.collection.primitive.MutableDoubleCollection;
import org.eclipse.collections.api.collection.primitive.MutableFloatCollection;
import org.eclipse.collections.api.collection.primitive.MutableIntCollection;
import org.eclipse.collections.api.collection.primitive.MutableLongCollection;
import org.eclipse.collections.api.collection.primitive.MutableShortCollection;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.map.MapIterable;
import org.eclipse.collections.api.map.MutableMap;
import org.eclipse.collections.api.multimap.set.MutableSetMultimap;
import org.eclipse.collections.api.multimap.set.UnsortedSetMultimap;
import org.eclipse.collections.api.partition.set.PartitionMutableSet;
import org.eclipse.collections.api.partition.set.PartitionSet;
import org.eclipse.collections.api.set.ImmutableSet;
import org.eclipse.collections.api.set.MultiReaderSet;
import org.eclipse.collections.api.set.MutableSet;
import org.eclipse.collections.api.set.ParallelUnsortedSetIterable;
import org.eclipse.collections.api.set.SetIterable;
import org.eclipse.collections.api.set.UnsortedSetIterable;
import org.eclipse.collections.api.set.primitive.BooleanSet;
import org.eclipse.collections.api.set.primitive.ByteSet;
import org.eclipse.collections.api.set.primitive.CharSet;
import org.eclipse.collections.api.set.primitive.DoubleSet;
import org.eclipse.collections.api.set.primitive.FloatSet;
import org.eclipse.collections.api.set.primitive.IntSet;
import org.eclipse.collections.api.set.primitive.LongSet;
import org.eclipse.collections.api.set.primitive.MutableBooleanSet;
import org.eclipse.collections.api.set.primitive.MutableByteSet;
import org.eclipse.collections.api.set.primitive.MutableCharSet;
import org.eclipse.collections.api.set.primitive.MutableDoubleSet;
import org.eclipse.collections.api.set.primitive.MutableFloatSet;
import org.eclipse.collections.api.set.primitive.MutableIntSet;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.api.set.primitive.MutableShortSet;
import org.eclipse.collections.api.set.primitive.ShortSet;
import org.eclipse.collections.api.tuple.Pair;
import org.eclipse.collections.impl.collection.mutable.AbstractMultiReaderMutableCollection;
import org.eclipse.collections.impl.factory.Iterables;
import org.eclipse.collections.impl.factory.Sets;
import org.eclipse.collections.impl.lazy.parallel.set.MultiReaderParallelUnsortedSetIterable;
import org.eclipse.collections.impl.set.mutable.SynchronizedMutableSet;
import org.eclipse.collections.impl.set.mutable.UnifiedSet;
import org.eclipse.collections.impl.set.mutable.UnmodifiableMutableSet;
import org.eclipse.collections.impl.utility.LazyIterate;

public final class MultiReaderUnifiedSet<T>
extends AbstractMultiReaderMutableCollection<T>
implements RandomAccess,
Externalizable,
MultiReaderSet<T> {
    private static final long serialVersionUID = 1L;
    private MutableSet<T> delegate;

    @Deprecated
    public MultiReaderUnifiedSet() {
    }

    private MultiReaderUnifiedSet(MutableSet<T> newDelegate) {
        this(newDelegate, new ReentrantReadWriteLock());
    }

    private MultiReaderUnifiedSet(MutableSet<T> newDelegate, ReadWriteLock newLock) {
        this.lock = newLock;
        this.lockWrapper = new AbstractMultiReaderMutableCollection.ReadWriteLockWrapper(newLock);
        this.delegate = newDelegate;
    }

    public static <T> MultiReaderUnifiedSet<T> newSet() {
        return new MultiReaderUnifiedSet(UnifiedSet.newSet());
    }

    public static <T> MultiReaderUnifiedSet<T> newSet(int capacity) {
        return new MultiReaderUnifiedSet(UnifiedSet.newSet(capacity));
    }

    public static <T> MultiReaderUnifiedSet<T> newSet(Iterable<T> iterable) {
        return new MultiReaderUnifiedSet<T>(UnifiedSet.newSet(iterable));
    }

    public static <T> MultiReaderUnifiedSet<T> newSetWith(T ... elements) {
        return new MultiReaderUnifiedSet<T>(UnifiedSet.newSetWith(elements));
    }

    @Override
    protected MutableSet<T> getDelegate() {
        return this.delegate;
    }

    UntouchableMutableSet<T> asReadUntouchable() {
        return new UntouchableMutableSet((MutableSet)this.delegate.asUnmodifiable());
    }

    UntouchableMutableSet<T> asWriteUntouchable() {
        return new UntouchableMutableSet(this.delegate);
    }

    @Override
    public void withReadLockAndDelegate(Procedure<? super MutableSet<T>> procedure) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            UntouchableMutableSet<T> untouchableSet = this.asReadUntouchable();
            procedure.value(untouchableSet);
            untouchableSet.becomeUseless();
        }
    }

    @Override
    public void withWriteLockAndDelegate(Procedure<? super MutableSet<T>> procedure) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireWriteLock();){
            UntouchableMutableSet<T> untouchableSet = this.asWriteUntouchable();
            procedure.value(untouchableSet);
            untouchableSet.becomeUseless();
        }
    }

    @Override
    public MutableSet<T> asSynchronized() {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            SynchronizedMutableSet synchronizedMutableSet = SynchronizedMutableSet.of(this);
            return synchronizedMutableSet;
        }
    }

    @Override
    public ImmutableSet<T> toImmutable() {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            ImmutableSet<T> immutableSet = Sets.immutable.withAll(this.delegate);
            return immutableSet;
        }
    }

    @Override
    public MutableSet<T> asUnmodifiable() {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            UnmodifiableMutableSet unmodifiableMutableSet = UnmodifiableMutableSet.of(this);
            return unmodifiableMutableSet;
        }
    }

    @Override
    public MutableSet<T> clone() {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            MultiReaderUnifiedSet<T> multiReaderUnifiedSet = new MultiReaderUnifiedSet<T>(this.delegate.clone());
            return multiReaderUnifiedSet;
        }
    }

    @Override
    public <V> MutableSet<V> collect(Function<? super T, ? extends V> function) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            UnsortedSetIterable unsortedSetIterable = this.delegate.collect((Function)function);
            return unsortedSetIterable;
        }
    }

    @Override
    public MutableBooleanSet collectBoolean(BooleanFunction<? super T> booleanFunction) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            BooleanSet booleanSet = this.delegate.collectBoolean((BooleanFunction)booleanFunction);
            return booleanSet;
        }
    }

    @Override
    public MutableByteSet collectByte(ByteFunction<? super T> byteFunction) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            ByteSet byteSet = this.delegate.collectByte((ByteFunction)byteFunction);
            return byteSet;
        }
    }

    @Override
    public MutableCharSet collectChar(CharFunction<? super T> charFunction) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            CharSet charSet = this.delegate.collectChar((CharFunction)charFunction);
            return charSet;
        }
    }

    @Override
    public MutableDoubleSet collectDouble(DoubleFunction<? super T> doubleFunction) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            DoubleSet doubleSet = this.delegate.collectDouble((DoubleFunction)doubleFunction);
            return doubleSet;
        }
    }

    @Override
    public MutableFloatSet collectFloat(FloatFunction<? super T> floatFunction) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            FloatSet floatSet = this.delegate.collectFloat((FloatFunction)floatFunction);
            return floatSet;
        }
    }

    @Override
    public MutableIntSet collectInt(IntFunction<? super T> intFunction) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            IntSet intSet = this.delegate.collectInt((IntFunction)intFunction);
            return intSet;
        }
    }

    @Override
    public MutableLongSet collectLong(LongFunction<? super T> longFunction) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            LongSet longSet = this.delegate.collectLong((LongFunction)longFunction);
            return longSet;
        }
    }

    @Override
    public MutableShortSet collectShort(ShortFunction<? super T> shortFunction) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            ShortSet shortSet = this.delegate.collectShort((ShortFunction)shortFunction);
            return shortSet;
        }
    }

    @Override
    public <V> MutableSet<V> flatCollect(Function<? super T, ? extends Iterable<V>> function) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            UnsortedSetIterable unsortedSetIterable = this.delegate.flatCollect(function);
            return unsortedSetIterable;
        }
    }

    @Override
    public <V> MutableSet<V> collectIf(Predicate<? super T> predicate, Function<? super T, ? extends V> function) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            UnsortedSetIterable unsortedSetIterable = this.delegate.collectIf((Predicate)predicate, (Function)function);
            return unsortedSetIterable;
        }
    }

    @Override
    public <P, V> MutableSet<V> collectWith(Function2<? super T, ? super P, ? extends V> function, P parameter) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            UnsortedSetIterable unsortedSetIterable = this.delegate.collectWith(function, (Object)parameter);
            return unsortedSetIterable;
        }
    }

    @Override
    public MutableSet<T> newEmpty() {
        return MultiReaderUnifiedSet.newSet();
    }

    @Override
    public MutableSet<T> reject(Predicate<? super T> predicate) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            UnsortedSetIterable unsortedSetIterable = this.delegate.reject((Predicate)predicate);
            return unsortedSetIterable;
        }
    }

    @Override
    public <P> MutableSet<T> rejectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            UnsortedSetIterable unsortedSetIterable = this.delegate.rejectWith(predicate, (Object)parameter);
            return unsortedSetIterable;
        }
    }

    @Override
    public MutableSet<T> tap(Procedure<? super T> procedure) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            this.forEach(procedure);
            MultiReaderUnifiedSet multiReaderUnifiedSet = this;
            return multiReaderUnifiedSet;
        }
    }

    @Override
    public MutableSet<T> select(Predicate<? super T> predicate) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            UnsortedSetIterable unsortedSetIterable = this.delegate.select((Predicate)predicate);
            return unsortedSetIterable;
        }
    }

    @Override
    public <P> MutableSet<T> selectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            UnsortedSetIterable unsortedSetIterable = this.delegate.selectWith(predicate, (Object)parameter);
            return unsortedSetIterable;
        }
    }

    @Override
    public PartitionMutableSet<T> partition(Predicate<? super T> predicate) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            PartitionSet partitionSet = this.delegate.partition((Predicate)predicate);
            return partitionSet;
        }
    }

    @Override
    public <P> PartitionMutableSet<T> partitionWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            PartitionSet partitionSet = this.delegate.partitionWith(predicate, (Object)parameter);
            return partitionSet;
        }
    }

    @Override
    public <S> MutableSet<S> selectInstancesOf(Class<S> clazz) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            UnsortedSetIterable unsortedSetIterable = this.delegate.selectInstancesOf((Class)clazz);
            return unsortedSetIterable;
        }
    }

    @Override
    public MutableSet<T> with(T element) {
        this.add(element);
        return this;
    }

    @Override
    public MutableSet<T> without(T element) {
        this.remove(element);
        return this;
    }

    @Override
    public MutableSet<T> withAll(Iterable<? extends T> elements) {
        this.addAllIterable(elements);
        return this;
    }

    @Override
    public MutableSet<T> withoutAll(Iterable<? extends T> elements) {
        this.removeAllIterable(elements);
        return this;
    }

    @Override
    public boolean equals(Object o) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            boolean bl = this.delegate.equals(o);
            return bl;
        }
    }

    @Override
    public int hashCode() {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            int n = this.delegate.hashCode();
            return n;
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.delegate);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.delegate = (MutableSet)in.readObject();
        this.lock = new ReentrantReadWriteLock();
        this.lockWrapper = new AbstractMultiReaderMutableCollection.ReadWriteLockWrapper(this.lock);
    }

    @Override
    public <V> MutableSetMultimap<V, T> groupBy(Function<? super T, ? extends V> function) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            UnsortedSetMultimap unsortedSetMultimap = this.delegate.groupBy((Function)function);
            return unsortedSetMultimap;
        }
    }

    @Override
    public <V> MutableSetMultimap<V, T> groupByEach(Function<? super T, ? extends Iterable<V>> function) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            UnsortedSetMultimap unsortedSetMultimap = this.delegate.groupByEach(function);
            return unsortedSetMultimap;
        }
    }

    @Override
    public <V> MutableMap<V, T> groupByUniqueKey(Function<? super T, ? extends V> function) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            MapIterable mapIterable = this.delegate.groupByUniqueKey((Function)function);
            return mapIterable;
        }
    }

    @Override
    @Deprecated
    public <S> MutableSet<Pair<T, S>> zip(Iterable<S> that) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            UnsortedSetIterable unsortedSetIterable = this.delegate.zip((Iterable)that);
            return unsortedSetIterable;
        }
    }

    @Override
    @Deprecated
    public MutableSet<Pair<T, Integer>> zipWithIndex() {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            UnsortedSetIterable unsortedSetIterable = this.delegate.zipWithIndex();
            return unsortedSetIterable;
        }
    }

    @Override
    public RichIterable<RichIterable<T>> chunk(int size) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            RichIterable richIterable = this.delegate.chunk(size);
            return richIterable;
        }
    }

    @Override
    public MutableSet<T> union(SetIterable<? extends T> set) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            UnsortedSetIterable unsortedSetIterable = this.delegate.union((SetIterable)set);
            return unsortedSetIterable;
        }
    }

    @Override
    public <R extends Set<T>> R unionInto(SetIterable<? extends T> set, R targetSet) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            R r = this.delegate.unionInto(set, targetSet);
            return r;
        }
    }

    @Override
    public MutableSet<T> intersect(SetIterable<? extends T> set) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            UnsortedSetIterable unsortedSetIterable = this.delegate.intersect((SetIterable)set);
            return unsortedSetIterable;
        }
    }

    @Override
    public <R extends Set<T>> R intersectInto(SetIterable<? extends T> set, R targetSet) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            R r = this.delegate.intersectInto(set, targetSet);
            return r;
        }
    }

    @Override
    public MutableSet<T> difference(SetIterable<? extends T> subtrahendSet) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            UnsortedSetIterable unsortedSetIterable = this.delegate.difference((SetIterable)subtrahendSet);
            return unsortedSetIterable;
        }
    }

    @Override
    public <R extends Set<T>> R differenceInto(SetIterable<? extends T> subtrahendSet, R targetSet) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            R r = this.delegate.differenceInto(subtrahendSet, targetSet);
            return r;
        }
    }

    @Override
    public MutableSet<T> symmetricDifference(SetIterable<? extends T> setB) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            UnsortedSetIterable unsortedSetIterable = this.delegate.symmetricDifference((SetIterable)setB);
            return unsortedSetIterable;
        }
    }

    @Override
    public <R extends Set<T>> R symmetricDifferenceInto(SetIterable<? extends T> set, R targetSet) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            R r = this.delegate.symmetricDifferenceInto(set, targetSet);
            return r;
        }
    }

    @Override
    public boolean isSubsetOf(SetIterable<? extends T> candidateSuperset) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            boolean bl = this.delegate.isSubsetOf(candidateSuperset);
            return bl;
        }
    }

    @Override
    public boolean isProperSubsetOf(SetIterable<? extends T> candidateSuperset) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            boolean bl = this.delegate.isProperSubsetOf(candidateSuperset);
            return bl;
        }
    }

    @Override
    public MutableSet<UnsortedSetIterable<T>> powerSet() {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            UnsortedSetIterable unsortedSetIterable = this.delegate.powerSet();
            return unsortedSetIterable;
        }
    }

    @Override
    public <B> LazyIterable<Pair<T, B>> cartesianProduct(SetIterable<B> set) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            LazyIterable lazyIterable = this.delegate.cartesianProduct(set);
            return lazyIterable;
        }
    }

    @Override
    public ParallelUnsortedSetIterable<T> asParallel(ExecutorService executorService, int batchSize) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            MultiReaderParallelUnsortedSetIterable multiReaderParallelUnsortedSetIterable = new MultiReaderParallelUnsortedSetIterable(this.delegate.asParallel(executorService, batchSize), this.lock);
            return multiReaderParallelUnsortedSetIterable;
        }
    }

    private static final class UntouchableIterator<T>
    implements Iterator<T> {
        private Iterator<T> delegate;

        private UntouchableIterator(Iterator<T> newDelegate) {
            this.delegate = newDelegate;
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public T next() {
            return this.delegate.next();
        }

        @Override
        public void remove() {
            this.delegate.remove();
        }

        public void becomeUseless() {
            this.delegate = null;
        }
    }

    static final class UntouchableMutableSet<T>
    extends AbstractMultiReaderMutableCollection.UntouchableMutableCollection<T>
    implements MutableSet<T> {
        private final MutableList<UntouchableIterator<T>> requestedIterators = Iterables.mList();

        private UntouchableMutableSet(MutableSet<T> newDelegate) {
            this.delegate = newDelegate;
        }

        public void becomeUseless() {
            this.delegate = null;
            this.requestedIterators.each(UntouchableIterator::becomeUseless);
        }

        @Override
        public MutableSet<T> with(T element) {
            this.add(element);
            return this;
        }

        @Override
        public MutableSet<T> without(T element) {
            this.remove(element);
            return this;
        }

        @Override
        public MutableSet<T> withAll(Iterable<? extends T> elements) {
            this.addAllIterable(elements);
            return this;
        }

        @Override
        public MutableSet<T> withoutAll(Iterable<? extends T> elements) {
            this.removeAllIterable(elements);
            return this;
        }

        @Override
        public MutableSet<T> asSynchronized() {
            throw new UnsupportedOperationException("Cannot call asSynchronized() on " + this.getClass().getSimpleName());
        }

        @Override
        public MutableSet<T> asUnmodifiable() {
            throw new UnsupportedOperationException("Cannot call asUnmodifiable() on " + this.getClass().getSimpleName());
        }

        @Override
        public ImmutableSet<T> toImmutable() {
            return Sets.immutable.withAll(this.getDelegate());
        }

        @Override
        public LazyIterable<T> asLazy() {
            return LazyIterate.adapt(this);
        }

        @Override
        public MutableSet<T> clone() {
            return this.getDelegate().clone();
        }

        @Override
        public <V> MutableSet<V> collect(Function<? super T, ? extends V> function) {
            return this.getDelegate().collect((Function)function);
        }

        @Override
        public MutableBooleanSet collectBoolean(BooleanFunction<? super T> booleanFunction) {
            return this.getDelegate().collectBoolean((BooleanFunction)booleanFunction);
        }

        @Override
        public <R extends MutableBooleanCollection> R collectBoolean(BooleanFunction<? super T> booleanFunction, R target) {
            return this.getDelegate().collectBoolean(booleanFunction, target);
        }

        @Override
        public MutableByteSet collectByte(ByteFunction<? super T> byteFunction) {
            return this.getDelegate().collectByte((ByteFunction)byteFunction);
        }

        @Override
        public <R extends MutableByteCollection> R collectByte(ByteFunction<? super T> byteFunction, R target) {
            return this.getDelegate().collectByte(byteFunction, target);
        }

        @Override
        public MutableCharSet collectChar(CharFunction<? super T> charFunction) {
            return this.getDelegate().collectChar((CharFunction)charFunction);
        }

        @Override
        public <R extends MutableCharCollection> R collectChar(CharFunction<? super T> charFunction, R target) {
            return this.getDelegate().collectChar(charFunction, target);
        }

        @Override
        public MutableDoubleSet collectDouble(DoubleFunction<? super T> doubleFunction) {
            return this.getDelegate().collectDouble((DoubleFunction)doubleFunction);
        }

        @Override
        public <R extends MutableDoubleCollection> R collectDouble(DoubleFunction<? super T> doubleFunction, R target) {
            return this.getDelegate().collectDouble(doubleFunction, target);
        }

        @Override
        public MutableFloatSet collectFloat(FloatFunction<? super T> floatFunction) {
            return this.getDelegate().collectFloat((FloatFunction)floatFunction);
        }

        @Override
        public <R extends MutableFloatCollection> R collectFloat(FloatFunction<? super T> floatFunction, R target) {
            return this.getDelegate().collectFloat(floatFunction, target);
        }

        @Override
        public MutableIntSet collectInt(IntFunction<? super T> intFunction) {
            return this.getDelegate().collectInt((IntFunction)intFunction);
        }

        @Override
        public <R extends MutableIntCollection> R collectInt(IntFunction<? super T> intFunction, R target) {
            return this.getDelegate().collectInt(intFunction, target);
        }

        @Override
        public MutableLongSet collectLong(LongFunction<? super T> longFunction) {
            return this.getDelegate().collectLong((LongFunction)longFunction);
        }

        @Override
        public <R extends MutableLongCollection> R collectLong(LongFunction<? super T> longFunction, R target) {
            return this.getDelegate().collectLong(longFunction, target);
        }

        @Override
        public MutableShortSet collectShort(ShortFunction<? super T> shortFunction) {
            return this.getDelegate().collectShort((ShortFunction)shortFunction);
        }

        @Override
        public <R extends MutableShortCollection> R collectShort(ShortFunction<? super T> shortFunction, R target) {
            return this.getDelegate().collectShort(shortFunction, target);
        }

        @Override
        public <V> MutableSet<V> flatCollect(Function<? super T, ? extends Iterable<V>> function) {
            return this.getDelegate().flatCollect(function);
        }

        @Override
        public <V> MutableSet<V> collectIf(Predicate<? super T> predicate, Function<? super T, ? extends V> function) {
            return this.getDelegate().collectIf((Predicate)predicate, (Function)function);
        }

        @Override
        public <P, V> MutableSet<V> collectWith(Function2<? super T, ? super P, ? extends V> function, P parameter) {
            return this.getDelegate().collectWith(function, (Object)parameter);
        }

        @Override
        public <V> MutableSetMultimap<V, T> groupBy(Function<? super T, ? extends V> function) {
            return this.getDelegate().groupBy((Function)function);
        }

        @Override
        public <V> MutableSetMultimap<V, T> groupByEach(Function<? super T, ? extends Iterable<V>> function) {
            return this.getDelegate().groupByEach(function);
        }

        @Override
        public <V> MutableMap<V, T> groupByUniqueKey(Function<? super T, ? extends V> function) {
            return this.getDelegate().groupByUniqueKey((Function)function);
        }

        @Override
        public MutableSet<T> newEmpty() {
            return this.getDelegate().newEmpty();
        }

        @Override
        public MutableSet<T> reject(Predicate<? super T> predicate) {
            return this.getDelegate().reject((Predicate)predicate);
        }

        @Override
        public <P> MutableSet<T> rejectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
            return this.getDelegate().rejectWith(predicate, (Object)parameter);
        }

        @Override
        public MutableSet<T> tap(Procedure<? super T> procedure) {
            this.forEach(procedure);
            return this;
        }

        @Override
        public MutableSet<T> select(Predicate<? super T> predicate) {
            return this.getDelegate().select((Predicate)predicate);
        }

        @Override
        public <P> MutableSet<T> selectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
            return this.getDelegate().selectWith(predicate, (Object)parameter);
        }

        @Override
        public PartitionMutableSet<T> partition(Predicate<? super T> predicate) {
            return this.getDelegate().partition((Predicate)predicate);
        }

        @Override
        public <P> PartitionMutableSet<T> partitionWith(Predicate2<? super T, ? super P> predicate, P parameter) {
            return this.getDelegate().partitionWith(predicate, (Object)parameter);
        }

        @Override
        public <S> MutableSet<S> selectInstancesOf(Class<S> clazz) {
            return this.getDelegate().selectInstancesOf((Class)clazz);
        }

        @Override
        public Iterator<T> iterator() {
            UntouchableIterator iterator = new UntouchableIterator(this.delegate.iterator());
            this.requestedIterators.add(iterator);
            return iterator;
        }

        @Override
        @Deprecated
        public <S> MutableSet<Pair<T, S>> zip(Iterable<S> that) {
            return this.getDelegate().zip((Iterable)that);
        }

        @Override
        @Deprecated
        public MutableSet<Pair<T, Integer>> zipWithIndex() {
            return this.getDelegate().zipWithIndex();
        }

        @Override
        public MutableSet<T> union(SetIterable<? extends T> set) {
            return this.getDelegate().union((SetIterable)set);
        }

        @Override
        public <R extends Set<T>> R unionInto(SetIterable<? extends T> set, R targetSet) {
            return this.getDelegate().unionInto(set, targetSet);
        }

        @Override
        public MutableSet<T> intersect(SetIterable<? extends T> set) {
            return this.getDelegate().intersect((SetIterable)set);
        }

        @Override
        public <R extends Set<T>> R intersectInto(SetIterable<? extends T> set, R targetSet) {
            return this.getDelegate().intersectInto(set, targetSet);
        }

        @Override
        public MutableSet<T> difference(SetIterable<? extends T> subtrahendSet) {
            return this.getDelegate().difference((SetIterable)subtrahendSet);
        }

        @Override
        public <R extends Set<T>> R differenceInto(SetIterable<? extends T> subtrahendSet, R targetSet) {
            return this.getDelegate().differenceInto(subtrahendSet, targetSet);
        }

        @Override
        public MutableSet<T> symmetricDifference(SetIterable<? extends T> setB) {
            return this.getDelegate().symmetricDifference((SetIterable)setB);
        }

        @Override
        public <R extends Set<T>> R symmetricDifferenceInto(SetIterable<? extends T> set, R targetSet) {
            return this.getDelegate().symmetricDifferenceInto(set, targetSet);
        }

        @Override
        public boolean isSubsetOf(SetIterable<? extends T> candidateSuperset) {
            return this.getDelegate().isSubsetOf(candidateSuperset);
        }

        @Override
        public boolean isProperSubsetOf(SetIterable<? extends T> candidateSuperset) {
            return this.getDelegate().isProperSubsetOf(candidateSuperset);
        }

        @Override
        public MutableSet<UnsortedSetIterable<T>> powerSet() {
            return this.getDelegate().powerSet();
        }

        @Override
        public <B> LazyIterable<Pair<T, B>> cartesianProduct(SetIterable<B> set) {
            return this.getDelegate().cartesianProduct(set);
        }

        @Override
        public ParallelUnsortedSetIterable<T> asParallel(ExecutorService executorService, int batchSize) {
            return this.getDelegate().asParallel(executorService, batchSize);
        }

        private MutableSet<T> getDelegate() {
            return (MutableSet)this.delegate;
        }
    }
}

