/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.set.immutable;

import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.eclipse.collections.api.LazyIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.Function2;
import org.eclipse.collections.api.block.function.primitive.BooleanFunction;
import org.eclipse.collections.api.block.function.primitive.ByteFunction;
import org.eclipse.collections.api.block.function.primitive.CharFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleFunction;
import org.eclipse.collections.api.block.function.primitive.FloatFunction;
import org.eclipse.collections.api.block.function.primitive.IntFunction;
import org.eclipse.collections.api.block.function.primitive.LongFunction;
import org.eclipse.collections.api.block.function.primitive.ShortFunction;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.predicate.Predicate2;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.collection.MutableCollection;
import org.eclipse.collections.api.multimap.MutableMultimap;
import org.eclipse.collections.api.multimap.set.ImmutableSetMultimap;
import org.eclipse.collections.api.partition.set.PartitionImmutableSet;
import org.eclipse.collections.api.set.ImmutableSet;
import org.eclipse.collections.api.set.ParallelUnsortedSetIterable;
import org.eclipse.collections.api.set.SetIterable;
import org.eclipse.collections.api.set.UnsortedSetIterable;
import org.eclipse.collections.api.set.primitive.ImmutableBooleanSet;
import org.eclipse.collections.api.set.primitive.ImmutableByteSet;
import org.eclipse.collections.api.set.primitive.ImmutableCharSet;
import org.eclipse.collections.api.set.primitive.ImmutableDoubleSet;
import org.eclipse.collections.api.set.primitive.ImmutableFloatSet;
import org.eclipse.collections.api.set.primitive.ImmutableIntSet;
import org.eclipse.collections.api.set.primitive.ImmutableLongSet;
import org.eclipse.collections.api.set.primitive.ImmutableShortSet;
import org.eclipse.collections.api.tuple.Pair;
import org.eclipse.collections.impl.block.factory.Functions;
import org.eclipse.collections.impl.block.factory.Predicates;
import org.eclipse.collections.impl.block.procedure.CollectIfProcedure;
import org.eclipse.collections.impl.block.procedure.CollectProcedure;
import org.eclipse.collections.impl.block.procedure.FlatCollectProcedure;
import org.eclipse.collections.impl.block.procedure.MultimapEachPutProcedure;
import org.eclipse.collections.impl.block.procedure.MultimapPutProcedure;
import org.eclipse.collections.impl.block.procedure.PartitionPredicate2Procedure;
import org.eclipse.collections.impl.block.procedure.PartitionProcedure;
import org.eclipse.collections.impl.block.procedure.RejectProcedure;
import org.eclipse.collections.impl.block.procedure.SelectInstancesOfProcedure;
import org.eclipse.collections.impl.block.procedure.SelectProcedure;
import org.eclipse.collections.impl.block.procedure.primitive.CollectBooleanProcedure;
import org.eclipse.collections.impl.block.procedure.primitive.CollectByteProcedure;
import org.eclipse.collections.impl.block.procedure.primitive.CollectCharProcedure;
import org.eclipse.collections.impl.block.procedure.primitive.CollectDoubleProcedure;
import org.eclipse.collections.impl.block.procedure.primitive.CollectFloatProcedure;
import org.eclipse.collections.impl.block.procedure.primitive.CollectIntProcedure;
import org.eclipse.collections.impl.block.procedure.primitive.CollectLongProcedure;
import org.eclipse.collections.impl.block.procedure.primitive.CollectShortProcedure;
import org.eclipse.collections.impl.collection.immutable.AbstractImmutableCollection;
import org.eclipse.collections.impl.factory.Sets;
import org.eclipse.collections.impl.list.mutable.FastList;
import org.eclipse.collections.impl.multimap.set.UnifiedSetMultimap;
import org.eclipse.collections.impl.partition.set.PartitionUnifiedSet;
import org.eclipse.collections.impl.set.mutable.UnifiedSet;
import org.eclipse.collections.impl.set.mutable.primitive.BooleanHashSet;
import org.eclipse.collections.impl.set.mutable.primitive.ByteHashSet;
import org.eclipse.collections.impl.set.mutable.primitive.CharHashSet;
import org.eclipse.collections.impl.set.mutable.primitive.DoubleHashSet;
import org.eclipse.collections.impl.set.mutable.primitive.FloatHashSet;
import org.eclipse.collections.impl.set.mutable.primitive.IntHashSet;
import org.eclipse.collections.impl.set.mutable.primitive.LongHashSet;
import org.eclipse.collections.impl.set.mutable.primitive.ShortHashSet;
import org.eclipse.collections.impl.utility.Iterate;
import org.eclipse.collections.impl.utility.internal.SetIterables;

public abstract class AbstractImmutableSet<T>
extends AbstractImmutableCollection<T>
implements ImmutableSet<T>,
Set<T> {
    @Override
    public Set<T> castToSet() {
        return this;
    }

    protected int nullSafeHashCode(Object element) {
        return element == null ? 0 : element.hashCode();
    }

    @Override
    public ImmutableSet<T> newWith(T element) {
        if (!this.contains(element)) {
            UnifiedSet result = UnifiedSet.newSet(this);
            result.add(element);
            return result.toImmutable();
        }
        return this;
    }

    @Override
    public ImmutableSet<T> newWithout(T element) {
        if (this.contains(element)) {
            UnifiedSet result = UnifiedSet.newSet(this);
            result.remove(element);
            return result.toImmutable();
        }
        return this;
    }

    @Override
    public ImmutableSet<T> newWithAll(Iterable<? extends T> elements) {
        UnifiedSet<T> result = UnifiedSet.newSet(elements);
        result.addAll(this);
        return result.toImmutable();
    }

    @Override
    public ImmutableSet<T> newWithoutAll(Iterable<? extends T> elements) {
        UnifiedSet result = UnifiedSet.newSet(this);
        this.removeAllFrom(elements, result);
        return result.toImmutable();
    }

    @Override
    public ImmutableSet<T> tap(Procedure<? super T> procedure) {
        this.forEach(procedure);
        return this;
    }

    @Override
    public ImmutableSet<T> select(Predicate<? super T> predicate) {
        FastList intermediateResult = FastList.newList();
        this.forEach(new SelectProcedure<T>(predicate, intermediateResult));
        return Sets.immutable.withAll(intermediateResult);
    }

    @Override
    public <P> ImmutableSet<T> selectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return this.select((Predicate)Predicates.bind(predicate, parameter));
    }

    @Override
    public ImmutableSet<T> reject(Predicate<? super T> predicate) {
        FastList intermediateResult = FastList.newList();
        this.forEach(new RejectProcedure<T>(predicate, intermediateResult));
        return Sets.immutable.withAll(intermediateResult);
    }

    @Override
    public <P> ImmutableSet<T> rejectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return this.reject((Predicate)Predicates.bind(predicate, parameter));
    }

    @Override
    public PartitionImmutableSet<T> partition(Predicate<? super T> predicate) {
        PartitionUnifiedSet partitionUnifiedSet = new PartitionUnifiedSet();
        this.forEach(new PartitionProcedure<T>(predicate, partitionUnifiedSet));
        return partitionUnifiedSet.toImmutable();
    }

    @Override
    public <P> PartitionImmutableSet<T> partitionWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        PartitionUnifiedSet partitionUnifiedSet = new PartitionUnifiedSet();
        this.forEach(new PartitionPredicate2Procedure<T, P>(predicate, parameter, partitionUnifiedSet));
        return partitionUnifiedSet.toImmutable();
    }

    @Override
    public <S> ImmutableSet<S> selectInstancesOf(Class<S> clazz) {
        UnifiedSet result = UnifiedSet.newSet(this.size());
        this.forEach(new SelectInstancesOfProcedure<S>(clazz, result));
        return result.toImmutable();
    }

    @Override
    public <V> ImmutableSet<V> collect(Function<? super T, ? extends V> function) {
        UnifiedSet result = UnifiedSet.newSet();
        this.forEach(new CollectProcedure<T, V>(function, result));
        return result.toImmutable();
    }

    @Override
    public ImmutableBooleanSet collectBoolean(BooleanFunction<? super T> booleanFunction) {
        BooleanHashSet result = new BooleanHashSet();
        this.forEach(new CollectBooleanProcedure<T>(booleanFunction, result));
        return result.toImmutable();
    }

    @Override
    public ImmutableByteSet collectByte(ByteFunction<? super T> byteFunction) {
        ByteHashSet result = new ByteHashSet();
        this.forEach(new CollectByteProcedure<T>(byteFunction, result));
        return result.toImmutable();
    }

    @Override
    public ImmutableCharSet collectChar(CharFunction<? super T> charFunction) {
        CharHashSet result = new CharHashSet(this.size());
        this.forEach(new CollectCharProcedure<T>(charFunction, result));
        return result.toImmutable();
    }

    @Override
    public ImmutableDoubleSet collectDouble(DoubleFunction<? super T> doubleFunction) {
        DoubleHashSet result = new DoubleHashSet(this.size());
        this.forEach(new CollectDoubleProcedure<T>(doubleFunction, result));
        return result.toImmutable();
    }

    @Override
    public ImmutableFloatSet collectFloat(FloatFunction<? super T> floatFunction) {
        FloatHashSet result = new FloatHashSet(this.size());
        this.forEach(new CollectFloatProcedure<T>(floatFunction, result));
        return result.toImmutable();
    }

    @Override
    public ImmutableIntSet collectInt(IntFunction<? super T> intFunction) {
        IntHashSet result = new IntHashSet(this.size());
        this.forEach(new CollectIntProcedure<T>(intFunction, result));
        return result.toImmutable();
    }

    @Override
    public ImmutableLongSet collectLong(LongFunction<? super T> longFunction) {
        LongHashSet result = new LongHashSet(this.size());
        this.forEach(new CollectLongProcedure<T>(longFunction, result));
        return result.toImmutable();
    }

    @Override
    public ImmutableShortSet collectShort(ShortFunction<? super T> shortFunction) {
        ShortHashSet result = new ShortHashSet(this.size());
        this.forEach(new CollectShortProcedure<T>(shortFunction, result));
        return result.toImmutable();
    }

    @Override
    public <P, V> ImmutableSet<V> collectWith(Function2<? super T, ? super P, ? extends V> function, P parameter) {
        return this.collect((Function)Functions.bind(function, parameter));
    }

    @Override
    public <V> ImmutableSet<V> collectIf(Predicate<? super T> predicate, Function<? super T, ? extends V> function) {
        UnifiedSet result = UnifiedSet.newSet();
        this.forEach(new CollectIfProcedure<T, V>(result, function, predicate));
        return result.toImmutable();
    }

    @Override
    public <V> ImmutableSet<V> flatCollect(Function<? super T, ? extends Iterable<V>> function) {
        UnifiedSet result = UnifiedSet.newSet();
        this.forEach(new FlatCollectProcedure(function, result));
        return result.toImmutable();
    }

    @Override
    public ImmutableSet<T> toImmutable() {
        return this;
    }

    @Override
    public <V> ImmutableSetMultimap<V, T> groupBy(Function<? super T, ? extends V> function) {
        return this.groupBy(function, UnifiedSetMultimap.newMultimap()).toImmutable();
    }

    @Override
    public <V, R extends MutableMultimap<V, T>> R groupBy(Function<? super T, ? extends V> function, R target) {
        this.forEach(MultimapPutProcedure.on(target, function));
        return target;
    }

    @Override
    public <V> ImmutableSetMultimap<V, T> groupByEach(Function<? super T, ? extends Iterable<V>> function) {
        return this.groupByEach(function, UnifiedSetMultimap.newMultimap()).toImmutable();
    }

    @Override
    public <V, R extends MutableMultimap<V, T>> R groupByEach(Function<? super T, ? extends Iterable<V>> function, R target) {
        this.forEach(MultimapEachPutProcedure.on(target, function));
        return target;
    }

    @Override
    @Deprecated
    public <S> ImmutableSet<Pair<T, S>> zip(Iterable<S> that) {
        if (that instanceof Collection || that instanceof RichIterable) {
            int thatSize = Iterate.sizeOf(that);
            UnifiedSet target = UnifiedSet.newSet(Math.min(this.size(), thatSize));
            return this.zip(that, target).toImmutable();
        }
        return this.zip(that, UnifiedSet.newSet()).toImmutable();
    }

    @Override
    @Deprecated
    public ImmutableSet<Pair<T, Integer>> zipWithIndex() {
        return this.zipWithIndex(UnifiedSet.newSet(this.size())).toImmutable();
    }

    @Override
    protected MutableCollection<T> newMutable(int size) {
        return UnifiedSet.newSet(size);
    }

    @Override
    public ImmutableSet<T> union(SetIterable<? extends T> set) {
        return SetIterables.union(this, set).toImmutable();
    }

    @Override
    public <R extends Set<T>> R unionInto(SetIterable<? extends T> set, R targetSet) {
        return SetIterables.unionInto(this, set, targetSet);
    }

    @Override
    public ImmutableSet<T> intersect(SetIterable<? extends T> set) {
        return SetIterables.intersect(this, set).toImmutable();
    }

    @Override
    public <R extends Set<T>> R intersectInto(SetIterable<? extends T> set, R targetSet) {
        return SetIterables.intersectInto(this, set, targetSet);
    }

    @Override
    public ImmutableSet<T> difference(SetIterable<? extends T> subtrahendSet) {
        return SetIterables.difference(this, subtrahendSet).toImmutable();
    }

    @Override
    public <R extends Set<T>> R differenceInto(SetIterable<? extends T> subtrahendSet, R targetSet) {
        return SetIterables.differenceInto(this, subtrahendSet, targetSet);
    }

    @Override
    public ImmutableSet<T> symmetricDifference(SetIterable<? extends T> setB) {
        return SetIterables.symmetricDifference(this, setB).toImmutable();
    }

    @Override
    public <R extends Set<T>> R symmetricDifferenceInto(SetIterable<? extends T> set, R targetSet) {
        return SetIterables.symmetricDifferenceInto(this, set, targetSet);
    }

    @Override
    public boolean isSubsetOf(SetIterable<? extends T> candidateSuperset) {
        return SetIterables.isSubsetOf(this, candidateSuperset);
    }

    @Override
    public boolean isProperSubsetOf(SetIterable<? extends T> candidateSuperset) {
        return SetIterables.isProperSubsetOf(this, candidateSuperset);
    }

    @Override
    public ImmutableSet<UnsortedSetIterable<T>> powerSet() {
        return SetIterables.immutablePowerSet(this);
    }

    @Override
    public <B> LazyIterable<Pair<T, B>> cartesianProduct(SetIterable<B> set) {
        return SetIterables.cartesianProduct(this, set);
    }

    @Override
    public ParallelUnsortedSetIterable<T> asParallel(ExecutorService executorService, int batchSize) {
        return this.toSet().asParallel(executorService, batchSize);
    }

    protected abstract class ImmutableSetIterator
    implements Iterator<T> {
        private int next;

        protected ImmutableSetIterator() {
        }

        protected abstract T getElement(int var1);

        @Override
        public boolean hasNext() {
            return this.next < AbstractImmutableSet.this.size();
        }

        @Override
        public T next() {
            return this.getElement(this.next++);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Cannot remove from an ImmutableSet");
        }
    }
}

