/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.list.primitive;

import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Spliterator;
import java.util.function.LongConsumer;
import org.eclipse.collections.api.LazyLongIterable;
import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.primitive.MutableLongBag;
import org.eclipse.collections.api.block.function.primitive.LongToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectLongIntToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectLongToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.LongPredicate;
import org.eclipse.collections.api.block.procedure.primitive.LongIntProcedure;
import org.eclipse.collections.api.block.procedure.primitive.LongLongProcedure;
import org.eclipse.collections.api.block.procedure.primitive.LongProcedure;
import org.eclipse.collections.api.factory.Lists;
import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.api.list.ImmutableList;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.list.primitive.ImmutableLongList;
import org.eclipse.collections.api.list.primitive.LongList;
import org.eclipse.collections.api.list.primitive.MutableLongList;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.api.tuple.primitive.LongLongPair;
import org.eclipse.collections.api.tuple.primitive.LongObjectPair;
import org.eclipse.collections.impl.bag.mutable.primitive.LongHashBag;
import org.eclipse.collections.impl.block.factory.primitive.LongPredicates;
import org.eclipse.collections.impl.factory.primitive.LongLists;
import org.eclipse.collections.impl.lazy.primitive.CollectLongToObjectIterable;
import org.eclipse.collections.impl.lazy.primitive.LazyLongIterableAdapter;
import org.eclipse.collections.impl.lazy.primitive.ReverseLongIterable;
import org.eclipse.collections.impl.lazy.primitive.SelectLongIterable;
import org.eclipse.collections.impl.list.IntervalUtils;
import org.eclipse.collections.impl.list.mutable.primitive.LongArrayList;
import org.eclipse.collections.impl.set.mutable.primitive.LongHashSet;
import org.eclipse.collections.impl.tuple.primitive.PrimitiveTuples;
import org.eclipse.collections.impl.utility.Iterate;

public final class LongInterval
implements ImmutableLongList,
Serializable {
    private static final long serialVersionUID = 1L;
    private final long from;
    private final long to;
    private final long step;
    private final int size;

    private LongInterval(long from, long to, long step) {
        this.from = from;
        this.to = to;
        this.step = step;
        this.size = IntervalUtils.intSize(this.from, this.to, this.step);
    }

    public static LongInterval from(long newFrom) {
        return LongInterval.fromToBy(newFrom, newFrom, 1L);
    }

    public LongInterval to(long newTo) {
        return LongInterval.fromToBy(this.from, newTo, this.step);
    }

    public LongInterval by(long newStep) {
        return LongInterval.fromToBy(this.from, this.to, newStep);
    }

    public static LongInterval zero() {
        return LongInterval.from(0L);
    }

    public static LongInterval oneTo(long count) {
        return LongInterval.oneToBy(count, 1L);
    }

    public static LongInterval oneToBy(long count, long step) {
        if (count < 1L) {
            throw new IllegalArgumentException("Only positive ranges allowed using oneToBy");
        }
        return LongInterval.fromToBy(1L, count, step);
    }

    public static LongInterval zeroTo(long count) {
        return LongInterval.zeroToBy(count, 1L);
    }

    public static LongInterval zeroToBy(long count, long step) {
        return LongInterval.fromToBy(0L, count, step);
    }

    public static LongInterval fromTo(long from, long to) {
        if (from <= to) {
            return LongInterval.fromToBy(from, to, 1L);
        }
        return LongInterval.fromToBy(from, to, -1L);
    }

    public static LongInterval evensFromTo(long from, long to) {
        if (from % 2L != 0L) {
            from = from < to ? ++from : --from;
        }
        if (to % 2L != 0L) {
            to = to > from ? --to : ++to;
        }
        return LongInterval.fromToBy(from, to, to > from ? 2L : -2L);
    }

    public static LongInterval oddsFromTo(long from, long to) {
        if (from % 2L == 0L) {
            from = from < to ? ++from : --from;
        }
        if (to % 2L == 0L) {
            to = to > from ? --to : ++to;
        }
        return LongInterval.fromToBy(from, to, to > from ? 2L : -2L);
    }

    public static LongInterval fromToBy(long from, long to, long stepBy) {
        IntervalUtils.checkArguments(from, to, stepBy);
        return new LongInterval(from, to, stepBy);
    }

    @Override
    public boolean containsAll(long ... values) {
        for (long value : values) {
            if (this.contains(value)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAll(LongIterable source) {
        LongIterator iterator = source.longIterator();
        while (iterator.hasNext()) {
            if (this.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    public boolean containsNone(int ... values) {
        int[] nArray = values;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            long value = nArray[i];
            if (!this.contains(value)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean contains(long value) {
        return IntervalUtils.contains(value, this.from, this.to, this.step);
    }

    @Override
    public void forEachWithIndex(LongIntProcedure procedure) {
        int index = 0;
        if (this.goForward()) {
            for (long i = this.from; i <= this.to; i += this.step) {
                procedure.value((int)i, index++);
            }
        } else {
            for (long i = this.from; i >= this.to; i += this.step) {
                procedure.value((int)i, index++);
            }
        }
    }

    public void forEachWithLongIndex(LongLongProcedure procedure) {
        long index = 0L;
        if (this.goForward()) {
            for (long i = this.from; i <= this.to; i += this.step) {
                procedure.value((int)i, index++);
            }
        } else {
            for (long i = this.from; i >= this.to; i += this.step) {
                procedure.value((int)i, index++);
            }
        }
    }

    @Override
    public void forEach(LongProcedure procedure) {
        this.each(procedure);
    }

    private boolean goForward() {
        return this.from <= this.to && this.step > 0L;
    }

    @Override
    public void each(LongProcedure procedure) {
        if (this.goForward()) {
            for (long i = this.from; i <= this.to; i += this.step) {
                procedure.value((int)i);
            }
        } else {
            for (long i = this.from; i >= this.to; i += this.step) {
                procedure.value((int)i);
            }
        }
    }

    @Override
    public int count(LongPredicate predicate) {
        int count = 0;
        for (int i = 0; i < this.size(); ++i) {
            if (!predicate.accept(this.get(i))) continue;
            ++count;
        }
        return count;
    }

    @Override
    public boolean anySatisfy(LongPredicate predicate) {
        for (int i = 0; i < this.size(); ++i) {
            if (!predicate.accept(this.get(i))) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean allSatisfy(LongPredicate predicate) {
        for (int i = 0; i < this.size(); ++i) {
            if (predicate.accept(this.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean noneSatisfy(LongPredicate predicate) {
        for (int i = 0; i < this.size(); ++i) {
            if (!predicate.accept(this.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object otherList) {
        if (otherList == this) {
            return true;
        }
        if (!(otherList instanceof LongList)) {
            return false;
        }
        LongList list = (LongList)otherList;
        if (this.size() != list.size()) {
            return false;
        }
        if (this.from == this.to) {
            return this.from == list.get(0);
        }
        if (otherList instanceof LongInterval) {
            LongInterval otherInterval = (LongInterval)otherList;
            return this.getFirst() == otherInterval.getFirst() && this.getLast() == otherInterval.getLast() && this.step == otherInterval.step;
        }
        if (this.from < this.to) {
            int listIndex = 0;
            for (long i = this.from; i <= this.to; i += this.step) {
                if (i == list.get(listIndex++)) continue;
                return false;
            }
        } else {
            int listIndex = 0;
            for (long i = this.from; i >= this.to; i += this.step) {
                if (i == list.get(listIndex++)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        if (this.from == this.to) {
            hashCode = 31 * hashCode + (int)(this.from ^ this.from >>> 32);
        } else if (this.from < this.to) {
            for (long i = this.from; i <= this.to; i += this.step) {
                hashCode = 31 * hashCode + (int)(i ^ i >>> 32);
            }
        } else {
            for (long i = this.from; i >= this.to; i += this.step) {
                hashCode = 31 * hashCode + (int)(i ^ i >>> 32);
            }
        }
        return hashCode;
    }

    @Override
    public LongInterval toReversed() {
        return LongInterval.fromToBy(this.to, this.from, -this.step);
    }

    @Override
    public ImmutableLongList distinct() {
        return this;
    }

    @Override
    public ImmutableLongList subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException("subList not yet implemented!");
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public long dotProduct(LongList list) {
        if (this.size() != list.size()) {
            throw new IllegalArgumentException("Lists used in dotProduct must be the same size");
        }
        long sum = 0L;
        for (int i = 0; i < this.size(); ++i) {
            sum += this.get(i) * list.get(i);
        }
        return sum;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean notEmpty() {
        return !this.isEmpty();
    }

    @Override
    public String makeString() {
        return this.makeString(", ");
    }

    @Override
    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    @Override
    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    @Override
    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    @Override
    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            for (int i = 0; i < this.size(); ++i) {
                if (i > 0) {
                    appendable.append(separator);
                }
                long value = this.get(i);
                appendable.append(String.valueOf(value));
            }
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public long[] toArray() {
        long[] result = new long[this.size()];
        this.forEachWithIndex((each, index) -> {
            result[index] = each;
        });
        return result;
    }

    @Override
    public long[] toArray(long[] result) {
        if (result.length < this.size()) {
            result = new long[this.size()];
        }
        long[] finalBypass = result;
        this.forEachWithIndex((each, index) -> {
            finalBypass[index] = each;
        });
        return result;
    }

    @Override
    public <T> T injectInto(T injectedValue, ObjectLongToObjectFunction<? super T, ? extends T> function) {
        T result = injectedValue;
        if (this.goForward()) {
            for (long i = this.from; i <= this.to; i += this.step) {
                result = function.valueOf(result, (int)i);
            }
        } else {
            for (long i = this.from; i >= this.to; i += this.step) {
                result = function.valueOf(result, (int)i);
            }
        }
        return result;
    }

    @Override
    public <T> T injectIntoWithIndex(T injectedValue, ObjectLongIntToObjectFunction<? super T, ? extends T> function) {
        T result = injectedValue;
        int index = 0;
        if (this.goForward()) {
            for (long i = this.from; i <= this.to; i += this.step) {
                result = function.valueOf(result, (int)i, index);
                ++index;
            }
        } else {
            for (long i = this.from; i >= this.to; i += this.step) {
                result = function.valueOf(result, (int)i, index);
                ++index;
            }
        }
        return result;
    }

    @Override
    public RichIterable<LongIterable> chunk(int size) {
        MutableList<LongIterable> result;
        block7: {
            if (size <= 0) {
                throw new IllegalArgumentException("Size for groups must be positive but was: " + size);
            }
            result = Lists.mutable.empty();
            if (!this.notEmpty()) break block7;
            long innerFrom = this.from;
            long lastUpdated = this.from;
            if (this.from <= this.to) {
                while (lastUpdated + this.step <= this.to) {
                    MutableLongList batch = LongLists.mutable.empty();
                    for (long i = innerFrom; i <= this.to && batch.size() < size; i += this.step) {
                        batch.add((int)i);
                        lastUpdated = (int)i;
                    }
                    result.add(batch);
                    innerFrom = lastUpdated + this.step;
                }
            } else {
                while (lastUpdated + this.step >= this.to) {
                    MutableLongList batch = LongLists.mutable.empty();
                    for (long i = innerFrom; i >= this.to && batch.size() < size; i += this.step) {
                        batch.add((int)i);
                        lastUpdated = (int)i;
                    }
                    result.add(batch);
                    innerFrom = lastUpdated + this.step;
                }
            }
        }
        return result;
    }

    @Override
    public String toString() {
        return this.makeString("[", ", ", "]");
    }

    @Override
    public LongIterator longIterator() {
        return new LongIntervalIterator();
    }

    @Override
    public long getFirst() {
        return this.from;
    }

    @Override
    public long getLast() {
        return IntervalUtils.valueAtIndex(this.size() - 1, this.from, this.to, this.step);
    }

    @Override
    public long get(int index) {
        this.checkBounds("index", index);
        return IntervalUtils.valueAtIndex(index, this.from, this.to, this.step);
    }

    private void checkBounds(String name, int index) {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException(name + ": " + index + ' ' + this);
        }
    }

    @Override
    public int indexOf(long value) {
        return IntervalUtils.indexOf(value, this.from, this.to, this.step);
    }

    @Override
    public int lastIndexOf(long value) {
        return this.indexOf(value);
    }

    @Override
    public ImmutableLongList select(LongPredicate predicate) {
        return LongArrayList.newList(new SelectLongIterable(this, predicate)).toImmutable();
    }

    @Override
    public ImmutableLongList reject(LongPredicate predicate) {
        return LongArrayList.newList(new SelectLongIterable(this, LongPredicates.not(predicate))).toImmutable();
    }

    @Override
    public long detectIfNone(LongPredicate predicate, long ifNone) {
        return new SelectLongIterable(this, predicate).detectIfNone(predicate, ifNone);
    }

    @Override
    public <V> ImmutableList<V> collect(LongToObjectFunction<? extends V> function) {
        return new CollectLongToObjectIterable<V>(this, function).toList().toImmutable();
    }

    @Override
    public LazyLongIterable asReversed() {
        return ReverseLongIterable.adapt(this);
    }

    @Override
    public long sum() {
        if (this.size() == 1) {
            return this.getFirst();
        }
        long fl = this.getFirst() + this.getLast();
        long s = this.size();
        if (s % 2L == 0L) {
            s /= 2L;
        } else {
            fl /= 2L;
        }
        return s * fl;
    }

    @Override
    public long max() {
        if (this.from >= this.to) {
            return this.getFirst();
        }
        return this.getLast();
    }

    @Override
    public long min() {
        if (this.from <= this.to) {
            return this.getFirst();
        }
        return this.getLast();
    }

    @Override
    public long minIfEmpty(long defaultValue) {
        return this.min();
    }

    @Override
    public long maxIfEmpty(long defaultValue) {
        return this.max();
    }

    @Override
    public double average() {
        return this.median();
    }

    @Override
    public double median() {
        return ((double)this.getFirst() + (double)this.getLast()) / 2.0;
    }

    @Override
    public int binarySearch(long value) {
        return IntervalUtils.binarySearch(value, this.from, this.to, this.step);
    }

    @Override
    public long[] toSortedArray() {
        long[] array = this.toArray();
        Arrays.sort(array);
        return array;
    }

    @Override
    public MutableLongList toList() {
        return LongArrayList.newList(this);
    }

    @Override
    public MutableLongList toSortedList() {
        return LongArrayList.newList(this).sortThis();
    }

    @Override
    public MutableLongSet toSet() {
        return LongHashSet.newSet(this);
    }

    @Override
    public MutableLongBag toBag() {
        return LongHashBag.newBag(this);
    }

    @Override
    public LazyLongIterable asLazy() {
        return new LazyLongIterableAdapter(this);
    }

    @Override
    public ImmutableLongList toImmutable() {
        return this;
    }

    @Override
    public ImmutableLongList newWith(long element) {
        return LongArrayList.newList(this).with(element).toImmutable();
    }

    @Override
    public ImmutableLongList newWithout(long element) {
        return LongArrayList.newList(this).without(element).toImmutable();
    }

    @Override
    public ImmutableLongList newWithAll(LongIterable elements) {
        return LongArrayList.newList(this).withAll(elements).toImmutable();
    }

    @Override
    public ImmutableLongList newWithoutAll(LongIterable elements) {
        return LongArrayList.newList(this).withoutAll(elements).toImmutable();
    }

    @Override
    public ImmutableList<LongLongPair> zipLong(LongIterable iterable) {
        int size = this.size();
        int othersize = iterable.size();
        MutableList target = Lists.mutable.withInitialCapacity(Math.min(size, othersize));
        LongIterator iterator = this.longIterator();
        LongIterator otherIterator = iterable.longIterator();
        for (int i = 0; i < size && otherIterator.hasNext(); ++i) {
            target.add(PrimitiveTuples.pair(iterator.next(), otherIterator.next()));
        }
        return target.toImmutable();
    }

    @Override
    public <T> ImmutableList<LongObjectPair<T>> zip(Iterable<T> iterable) {
        int size = this.size();
        int othersize = Iterate.sizeOf(iterable);
        MutableList target = Lists.mutable.withInitialCapacity(Math.min(size, othersize));
        LongIterator iterator = this.longIterator();
        Iterator<T> otherIterator = iterable.iterator();
        for (int i = 0; i < size && otherIterator.hasNext(); ++i) {
            target.add(PrimitiveTuples.pair(iterator.next(), otherIterator.next()));
        }
        return target.toImmutable();
    }

    @Override
    public Spliterator.OfLong spliterator() {
        return new LongIntervalSpliterator(this.from, this.to, this.step);
    }

    private class LongIntervalIterator
    implements LongIterator {
        private long current;

        private LongIntervalIterator() {
            this.current = LongInterval.this.from;
        }

        @Override
        public boolean hasNext() {
            if (LongInterval.this.from <= LongInterval.this.to) {
                return this.current <= LongInterval.this.to;
            }
            return this.current >= LongInterval.this.to;
        }

        @Override
        public long next() {
            if (this.hasNext()) {
                long result = (int)this.current;
                this.current += LongInterval.this.step;
                return result;
            }
            throw new NoSuchElementException();
        }
    }

    private static final class LongIntervalSpliterator
    implements Spliterator.OfLong {
        private long current;
        private final long to;
        private final long step;
        private final boolean isAscending;

        private LongIntervalSpliterator(long from, long to, long step) {
            this.current = from;
            this.to = to;
            this.step = step;
            this.isAscending = from <= to;
        }

        @Override
        public Comparator<? super Long> getComparator() {
            if (this.isAscending) {
                return Comparator.naturalOrder();
            }
            return Comparator.reverseOrder();
        }

        @Override
        public Spliterator.OfLong trySplit() {
            LongIntervalSpliterator leftSpliterator = null;
            long numberOfStepsToMid = (int)(this.estimateSize() / 2L);
            long mid = this.current + this.step * numberOfStepsToMid;
            if (this.isAscending) {
                if (this.current < mid) {
                    leftSpliterator = new LongIntervalSpliterator(this.current, mid - 1L, this.step);
                    this.current = mid;
                }
            } else if (this.current > mid) {
                leftSpliterator = new LongIntervalSpliterator(this.current, mid + 1L, this.step);
                this.current = mid;
            }
            return leftSpliterator;
        }

        @Override
        public long estimateSize() {
            return (this.to - this.current) / this.step + 1L;
        }

        @Override
        public int characteristics() {
            return 1365;
        }

        @Override
        public boolean tryAdvance(LongConsumer action) {
            action.accept(this.current);
            this.current += this.step;
            if (this.isAscending) {
                return this.current <= this.to;
            }
            return this.current >= this.to;
        }
    }
}

