/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.primitive;

import java.util.Arrays;
import org.eclipse.collections.api.LazyLongIterable;
import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.bag.primitive.MutableLongBag;
import org.eclipse.collections.api.list.primitive.MutableLongList;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.impl.bag.mutable.primitive.LongHashBag;
import org.eclipse.collections.impl.lazy.primitive.LazyLongIterableAdapter;
import org.eclipse.collections.impl.list.mutable.primitive.LongArrayList;
import org.eclipse.collections.impl.set.mutable.primitive.LongHashSet;

public abstract class AbstractLongIterable
implements LongIterable {
    @Override
    public String toString() {
        return this.makeString("[", ", ", "]");
    }

    @Override
    public long minIfEmpty(long defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        return this.min();
    }

    @Override
    public long maxIfEmpty(long defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        return this.max();
    }

    @Override
    public double average() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        return (double)this.sum() / (double)this.size();
    }

    @Override
    public double median() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        long[] sortedArray = this.toSortedArray();
        int middleIndex = sortedArray.length >> 1;
        if (sortedArray.length > 1 && (sortedArray.length & 1) == 0) {
            long first = sortedArray[middleIndex];
            long second = sortedArray[middleIndex - 1];
            return ((double)first + (double)second) / 2.0;
        }
        return sortedArray[middleIndex];
    }

    @Override
    public long[] toSortedArray() {
        long[] array = this.toArray();
        Arrays.sort(array);
        return array;
    }

    @Override
    public MutableLongList toSortedList() {
        return this.toList().sortThis();
    }

    @Override
    public LazyLongIterable asLazy() {
        return new LazyLongIterableAdapter(this);
    }

    @Override
    public MutableLongList toList() {
        return LongArrayList.newList(this);
    }

    @Override
    public MutableLongSet toSet() {
        return LongHashSet.newSet(this);
    }

    @Override
    public MutableLongBag toBag() {
        return LongHashBag.newBag(this);
    }
}

