/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.set.mutable.primitive;

import org.eclipse.collections.api.ByteIterable;
import org.eclipse.collections.api.factory.set.primitive.MutableByteSetFactory;
import org.eclipse.collections.api.set.primitive.MutableByteSet;
import org.eclipse.collections.impl.factory.primitive.ByteSets;
import org.eclipse.collections.impl.set.mutable.primitive.ByteHashSet;
import org.eclipse.collections.impl.utility.Iterate;

public enum MutableByteSetFactoryImpl implements MutableByteSetFactory
{
    INSTANCE;


    @Override
    public MutableByteSet empty() {
        return new ByteHashSet();
    }

    @Override
    public MutableByteSet of() {
        return this.empty();
    }

    @Override
    public MutableByteSet with() {
        return this.empty();
    }

    @Override
    public MutableByteSet of(byte ... items) {
        return this.with(items);
    }

    @Override
    public MutableByteSet with(byte ... items) {
        if (items == null || items.length == 0) {
            return this.empty();
        }
        return ByteHashSet.newSetWith(items);
    }

    @Override
    public MutableByteSet ofAll(ByteIterable items) {
        return this.withAll(items);
    }

    @Override
    public MutableByteSet withAll(ByteIterable items) {
        return ByteHashSet.newSet(items);
    }

    @Override
    public MutableByteSet ofAll(Iterable<Byte> iterable) {
        return this.withAll(iterable);
    }

    @Override
    public MutableByteSet withAll(Iterable<Byte> iterable) {
        return Iterate.collectByte(iterable, Byte::byteValue, ByteSets.mutable.empty());
    }
}

