/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.immutable.primitive;

import org.eclipse.collections.api.factory.map.primitive.ImmutableLongObjectMapFactory;
import org.eclipse.collections.api.map.primitive.ImmutableLongObjectMap;
import org.eclipse.collections.api.map.primitive.LongObjectMap;
import org.eclipse.collections.impl.map.immutable.primitive.ImmutableLongObjectEmptyMap;
import org.eclipse.collections.impl.map.immutable.primitive.ImmutableLongObjectHashMap;
import org.eclipse.collections.impl.map.immutable.primitive.ImmutableLongObjectSingletonMap;

public enum ImmutableLongObjectMapFactoryImpl implements ImmutableLongObjectMapFactory
{
    INSTANCE;


    @Override
    public <V> ImmutableLongObjectMap<V> empty() {
        return ImmutableLongObjectEmptyMap.INSTANCE;
    }

    @Override
    public <V> ImmutableLongObjectMap<V> of() {
        return this.empty();
    }

    @Override
    public <V> ImmutableLongObjectMap<V> with() {
        return this.empty();
    }

    @Override
    public <V> ImmutableLongObjectMap<V> of(long key, V value) {
        return this.with(key, value);
    }

    @Override
    public <V> ImmutableLongObjectMap<V> with(long key, V value) {
        return new ImmutableLongObjectSingletonMap<V>(key, value);
    }

    @Override
    public <V> ImmutableLongObjectMap<V> ofAll(LongObjectMap<? extends V> map) {
        return this.withAll(map);
    }

    @Override
    public <V> ImmutableLongObjectMap<V> withAll(LongObjectMap<? extends V> map) {
        if (map instanceof ImmutableLongObjectMap) {
            return (ImmutableLongObjectMap)map;
        }
        if (map.isEmpty()) {
            return this.with();
        }
        if (map.size() == 1) {
            long[] array = new long[1];
            map.forEachKey(each -> {
                array[0] = each;
            });
            return new ImmutableLongObjectSingletonMap<V>(array[0], map.get(array[0]));
        }
        return new ImmutableLongObjectHashMap<V>(map);
    }
}

