/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.jdt;

import java.net.URI;
import java.net.URISyntaxException;
import net.sourceforge.plantuml.eclipse.utils.ILinkOpener;
import net.sourceforge.plantuml.eclipse.utils.LinkData;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.debug.ui.actions.OpenTypeAction;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.ui.PartInitException;

public class JavaLinkOpener
implements ILinkOpener {
    public static final String JAVA_LINK_PREFIX = "java:";

    public int supportsLink(LinkData link) {
        try {
            URI uri = new URI(link.href);
            if ("java".equals(uri.getScheme()) && this.getJavaElement(link) != null) {
                return 1;
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return -1;
    }

    protected IJavaElement getJavaElement(LinkData link) {
        try {
            URI uri = new URI(link.href);
            String className = uri.getPath();
            if (className != null) {
                if (className.startsWith("/")) {
                    className = className.substring(1);
                }
            } else {
                className = uri.getSchemeSpecificPart();
            }
            IType type = OpenTypeAction.findTypeInWorkspace((String)className, (boolean)false);
            String fragment = uri.getFragment();
            if (fragment != null) {
                IJavaElement[] iJavaElementArray = type.getChildren();
                int n = iJavaElementArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IJavaElement child = iJavaElementArray[n2];
                    if (fragment.equals(child.getElementName())) {
                        return child;
                    }
                    ++n2;
                }
            }
            return type;
        }
        catch (Exception e) {
            return null;
        }
    }

    public void openLink(LinkData link) {
        try {
            IJavaElement javaElement = this.getJavaElement(link);
            JavaUI.openInEditor((IJavaElement)javaElement);
        }
        catch (PartInitException partInitException) {
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
    }
}

