/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.jdt;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import net.sourceforge.plantuml.text.AbstractClassDiagramTextProvider;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.internal.debug.ui.actions.OpenTypeAction;
import org.eclipse.jface.viewers.ISelection;

public abstract class JdtDiagramTextProvider
extends AbstractClassDiagramTextProvider {
    private final int genFlags = GEN_MEMBERS | GEN_MODIFIERS | GEN_EXTENDS | GEN_IMPLEMENTS | GEN_ASSOCIATIONS | GEN_CLASS_HYPERLINKS;
    private final Collection<String> multiAssociationClassNames = new ArrayList<String>(Arrays.asList("java.util.Collection", "java.util.List", "java.util.Set"));
    private final boolean useJavaLinks = true;

    public boolean supportsSelection(ISelection selection) {
        return false;
    }

    public void generateForType(IType type, StringBuilder result, Collection<IType> allTypes) {
        this.generateForType(type, result, this.genFlags, allTypes);
    }

    private boolean isInTypes(String typeName, Collection<IType> allTypes) {
        for (IType type : allTypes) {
            if (!this.getTypeName(type, false).equals(typeName) && !this.getTypeName(type, true).equals(typeName) && !type.getFullyQualifiedName().equals(typeName)) continue;
            return true;
        }
        return false;
    }

    public void addMultiAssociationClassName(String className) {
        this.multiAssociationClassNames.add(className);
    }

    public boolean isMultiAssociationClassName(String className) {
        return this.multiAssociationClassNames.contains(className);
    }

    protected String getHyperlink(IType type) {
        return "java:" + type.getFullyQualifiedName();
    }

    public void generateForType(IType type, StringBuilder result, int genFlags, Collection<IType> allTypes) {
        ArrayList<Assoc> associations = JdtDiagramTextProvider.includes((int)genFlags, (int[])new int[]{GEN_ASSOCIATIONS}) ? new ArrayList<Assoc>() : null;
        result.append(this.getClassType(type));
        result.append(" ");
        this.appendNameDeclaration(this.getTypeName(type, true), result);
        if (JdtDiagramTextProvider.includes((int)genFlags, (int[])new int[]{GEN_CLASS_HYPERLINKS})) {
            this.appendLink(this.getHyperlink(type), false, result);
        }
        result.append(" {\n");
        try {
            StringBuilder body = new StringBuilder();
            if (JdtDiagramTextProvider.includes((int)genFlags, (int[])new int[]{GEN_MEMBERS})) {
                IField[] iFieldArray = type.getFields();
                int n = iFieldArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IField field = iFieldArray[n2];
                    Assoc assoc = null;
                    if (JdtDiagramTextProvider.includes((int)genFlags, (int[])new int[]{GEN_ASSOCIATIONS}) && this.acceptAssociation(type, field)) {
                        assoc = this.generateAssociation(type, field);
                    }
                    if (assoc != null && this.isInTypes(assoc.targetName, allTypes) && associations != null) {
                        assoc.name = field.getElementName();
                        associations.add(assoc);
                    } else {
                        body.append("\t");
                        if (!Flags.isEnum((int)type.getFlags())) {
                            if (JdtDiagramTextProvider.includes((int)genFlags, (int[])new int[]{GEN_MODIFIERS}) && !Flags.isInterface((int)type.getFlags())) {
                                body.append(this.getMemberModifiers((IMember)field));
                            }
                            body.append(this.getTypeName(field.getTypeSignature(), true));
                            body.append(" ");
                        }
                        body.append(field.getElementName());
                        body.append("\n");
                    }
                    ++n2;
                }
                iFieldArray = type.getMethods();
                n = iFieldArray.length;
                n2 = 0;
                while (n2 < n) {
                    IField method = iFieldArray[n2];
                    body.append("\t");
                    if (JdtDiagramTextProvider.includes((int)genFlags, (int[])new int[]{GEN_MODIFIERS}) && !Flags.isInterface((int)type.getFlags())) {
                        body.append(this.getMemberModifiers((IMember)method));
                    }
                    if (!method.isConstructor()) {
                        body.append(this.getTypeName(method.getReturnType(), true));
                        body.append(" ");
                    }
                    body.append(method.getElementName());
                    body.append("(");
                    String[] parameterTypes = method.getParameterTypes();
                    String[] parameterNames = null;
                    parameterNames = method.getParameterNames();
                    int i = 0;
                    while (i < method.getNumberOfParameters()) {
                        if (body.charAt(body.length() - 1) != '(') {
                            body.append(", ");
                        }
                        body.append(this.getTypeName(parameterTypes[i], true));
                        if (parameterNames != null) {
                            body.append(" ");
                            body.append(parameterNames[i]);
                        }
                        ++i;
                    }
                    body.append(")\n");
                    ++n2;
                }
            }
            result.append((CharSequence)body);
        }
        catch (JavaModelException body) {
            // empty catch block
        }
        result.append("}\n");
        if (JdtDiagramTextProvider.includes((int)genFlags, (int[])new int[]{GEN_ASSOCIATIONS}) && associations != null) {
            for (Assoc assoc : associations) {
                this.generateRelatedType(type, assoc.targetName, "-->", null, result, genFlags, null, assoc.name, assoc.multi ? "*" : "1");
            }
        }
        try {
            if (JdtDiagramTextProvider.includes((int)genFlags, (int[])new int[]{GEN_EXTENDS})) {
                this.generateRelatedType(type, this.getTypeName(type.getSuperclassTypeSignature(), true), "<|--", type.isInterface() ? "interface" : null, result, genFlags);
            }
            if (JdtDiagramTextProvider.includes((int)genFlags, (int[])new int[]{GEN_IMPLEMENTS})) {
                String[] interfaceSignatures = type.getSuperInterfaceTypeSignatures();
                int i = 0;
                while (i < interfaceSignatures.length) {
                    this.generateRelatedType(type, this.getTypeName(interfaceSignatures[i], true), type.isInterface() ? "<|--" : "<|..", "interface", result, genFlags);
                    ++i;
                }
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
    }

    protected String getTypeName(IType type, boolean includeTypeParameters) {
        String typeName = type.getElementName();
        if (includeTypeParameters) {
            try {
                ITypeParameter[] typeParameters = type.getTypeParameters();
                int i = 0;
                while (i < typeParameters.length) {
                    ITypeParameter typeParameter = typeParameters[i];
                    typeName = String.valueOf(typeName) + (i == 0 ? "<" : ",");
                    typeName = String.valueOf(typeName) + typeParameter.getElementName();
                    if (i == typeParameters.length - 1) {
                        typeName = String.valueOf(typeName) + ">";
                    }
                    ++i;
                }
            }
            catch (JavaModelException javaModelException) {
                // empty catch block
            }
        }
        return typeName;
    }

    protected boolean acceptAssociation(IType type, IField field) {
        try {
            int flags = field.getFlags();
            return !Flags.isEnum((int)flags) && !Flags.isStatic((int)flags);
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
    }

    protected Assoc generateAssociation(IType type, IField field) throws JavaModelException {
        String fieldSignature = field.getTypeSignature();
        String fieldTypeName = this.getTypeName(fieldSignature, true);
        Assoc assoc = null;
        if (fieldTypeName.endsWith("[]")) {
            assoc = new Assoc();
            assoc.targetName = fieldTypeName.substring(0, fieldTypeName.length() - 2);
            assoc.multi = true;
        } else {
            String[][] resolvedFieldType = type.resolveType(fieldTypeName);
            String[] typeArguments = Signature.getTypeArguments((String)fieldSignature);
            if (resolvedFieldType != null && resolvedFieldType.length > 0 && typeArguments != null && typeArguments.length == 1 && this.isMultiAssociationClassName(Signature.toQualifiedName((String[])resolvedFieldType[0]))) {
                assoc = new Assoc();
                assoc.multi = true;
                assoc.targetName = this.getTypeName(typeArguments[0], true);
            } else {
                assoc = new Assoc();
                assoc.multi = false;
                assoc.targetName = fieldTypeName;
            }
        }
        return assoc;
    }

    private void generateRelatedType(IType type, String className, String relation, String classType, StringBuilder result, int genFlags) {
        this.generateRelatedType(type, className, relation, classType, result, genFlags, null, null, null);
    }

    private void generateRelatedType(IType type, String className, String relation, String classType, StringBuilder result, int genFlags, String startLabel, String middleLabel, String endLabel) {
        if (className != null && !className.equals("Object")) {
            String link = null;
            if (JdtDiagramTextProvider.includes((int)genFlags, (int[])new int[]{GEN_CLASS_HYPERLINKS})) {
                try {
                    IType relatedType = OpenTypeAction.findTypeInWorkspace((String)className, (boolean)false);
                    if (relatedType != null) {
                        link = this.getHyperlink(relatedType);
                    }
                }
                catch (CoreException relatedType) {
                    // empty catch block
                }
            }
            this.appendClassStart(null, classType != null ? classType : "class", className, link, result);
            this.appendClassEnd(result);
            String typeName = this.getTypeName(type, true);
            if (relation == "-->") {
                this.appendRelation(typeName, false, startLabel, relation, null, className, false, endLabel, middleLabel, result);
            } else {
                this.appendRelation(className, false, startLabel, relation, null, typeName, false, endLabel, middleLabel, result);
            }
        }
    }

    protected String getTypeName(String signature, boolean includeTypeParameters) {
        if (signature != null) {
            int pos;
            if (!includeTypeParameters && (pos = signature.indexOf(60)) > 0) {
                signature = signature.substring(0, pos);
            }
            return Signature.toString((String)signature).replace("java.lang.", "");
        }
        return null;
    }

    private String getMemberModifiers(IMember member) {
        try {
            String modifiers = this.getMemberVisibilityModifier(member);
            int flags = member.getFlags();
            if (Flags.isStatic((int)flags)) {
                modifiers = String.valueOf(modifiers) + "{static}";
            } else if (Flags.isAbstract((int)flags)) {
                modifiers = String.valueOf(modifiers) + "{abstract}";
            }
            return modifiers;
        }
        catch (JavaModelException e) {
            return "";
        }
    }

    private String getMemberVisibilityModifier(IMember member) throws JavaModelException {
        int flags;
        block6: {
            block5: {
                try {
                    flags = member.getFlags();
                    if (!Flags.isPrivate((int)flags)) break block5;
                    return "-";
                }
                catch (JavaModelException e) {
                    return "";
                }
            }
            if (!Flags.isProtected((int)flags)) break block6;
            return "#";
        }
        if (Flags.isPublic((int)flags)) {
            return "+";
        }
        return "~";
    }

    private String getClassType(IType type) {
        int flags;
        block6: {
            block5: {
                try {
                    flags = type.getFlags();
                    if (!Flags.isEnum((int)flags)) break block5;
                    return "enum";
                }
                catch (JavaModelException e) {
                    return "";
                }
            }
            if (!Flags.isInterface((int)flags)) break block6;
            return "interface";
        }
        if (Flags.isAbstract((int)flags)) {
            return "abstract class";
        }
        return "class";
    }

    private static class Assoc {
        String name;
        String targetName;
        boolean multi;

        private Assoc() {
        }
    }
}

