/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.ui.internal.themes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.tm4e.ui.internal.themes.ThemeAssociationRegistry;
import org.eclipse.tm4e.ui.internal.utils.PreferenceUtils;
import org.eclipse.tm4e.ui.themes.ITheme;
import org.eclipse.tm4e.ui.themes.IThemeAssociation;
import org.eclipse.tm4e.ui.themes.IThemeManager;
import org.eclipse.tm4e.ui.themes.ITokenProvider;
import org.eclipse.tm4e.ui.themes.ThemeAssociation;

public abstract class AbstractThemeManager
implements IThemeManager {
    private final Map<String, ITheme> themes = new LinkedHashMap<String, ITheme>();
    private final ThemeAssociationRegistry themeAssociationRegistry = new ThemeAssociationRegistry();

    @Override
    public void registerTheme(ITheme theme) {
        this.themes.put(theme.getId(), theme);
    }

    @Override
    public void unregisterTheme(ITheme theme) {
        this.themes.remove(theme.getId());
    }

    @Override
    public @Nullable ITheme getThemeById(String themeId) {
        return this.themes.get(themeId);
    }

    @Override
    public ITheme[] getThemes() {
        Collection<ITheme> themes = this.themes.values();
        return (ITheme[])themes.toArray(ITheme[]::new);
    }

    @Override
    public ITheme getDefaultTheme() {
        boolean dark = this.isDarkEclipseTheme();
        return this.getDefaultTheme(dark);
    }

    ITheme getDefaultTheme(boolean dark) {
        for (ITheme theme : this.themes.values()) {
            if (theme.isDark() != dark || !theme.isDefault()) continue;
            return theme;
        }
        throw new IllegalStateException("Should never be reached");
    }

    @Override
    public ITheme[] getThemes(boolean dark) {
        return (ITheme[])this.themes.values().stream().filter(theme -> theme.isDark() == dark).collect(Collectors.toList()).toArray(ITheme[]::new);
    }

    @Override
    public boolean isDarkEclipseTheme() {
        return this.isDarkEclipseTheme(PreferenceUtils.getE4PreferenceCSSThemeId());
    }

    @Override
    public boolean isDarkEclipseTheme(@Nullable String eclipseThemeId) {
        return eclipseThemeId != null && eclipseThemeId.toLowerCase().contains("dark");
    }

    @Override
    public ITheme getThemeForScope(String scopeName, boolean dark) {
        String themeId;
        ITheme theme;
        IThemeAssociation association = this.themeAssociationRegistry.getThemeAssociationFor(scopeName, dark);
        if (association != null && (theme = this.getThemeById(themeId = association.getThemeId())) != null) {
            return theme;
        }
        return this.getDefaultTheme(dark);
    }

    @Override
    public ITheme getThemeForScope(String scopeName) {
        return this.getThemeForScope(scopeName, this.isDarkEclipseTheme());
    }

    @Override
    public IThemeAssociation[] getThemeAssociationsForScope(String scopeName) {
        ArrayList<IThemeAssociation> associations = new ArrayList<IThemeAssociation>();
        IThemeAssociation light = this.themeAssociationRegistry.getThemeAssociationFor(scopeName, false);
        if (light == null) {
            light = new ThemeAssociation(this.getDefaultTheme(false).getId(), scopeName, false);
        }
        associations.add(light);
        IThemeAssociation dark = this.themeAssociationRegistry.getThemeAssociationFor(scopeName, true);
        if (dark == null) {
            dark = new ThemeAssociation(this.getDefaultTheme(true).getId(), scopeName, true);
        }
        associations.add(dark);
        return (IThemeAssociation[])associations.toArray(IThemeAssociation[]::new);
    }

    @Override
    public void registerThemeAssociation(IThemeAssociation association) {
        this.themeAssociationRegistry.register(association);
    }

    @Override
    public void unregisterThemeAssociation(IThemeAssociation association) {
        this.themeAssociationRegistry.unregister(association);
    }

    @Override
    public IThemeAssociation[] getAllThemeAssociations() {
        List<IThemeAssociation> associations = this.themeAssociationRegistry.getThemeAssociations();
        return (IThemeAssociation[])associations.toArray(IThemeAssociation[]::new);
    }

    @Override
    public ITokenProvider getThemeForScope(String scopeName, RGB background) {
        return this.getThemeForScope(scopeName, 0.299 * (double)background.red + 0.587 * (double)background.green + 0.114 * (double)background.blue < 128.0);
    }
}

