/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.full.interceptors.definition.lifecycle.order;

import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.spi.Bean;
import java.lang.annotation.Annotation;
import java.util.List;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.full.interceptors.definition.lifecycle.order.AccountTransaction;
import org.jboss.cdi.tck.tests.full.interceptors.definition.lifecycle.order.AnotherInterceptor;
import org.jboss.cdi.tck.tests.full.interceptors.definition.lifecycle.order.Transaction;
import org.jboss.cdi.tck.tests.full.interceptors.definition.lifecycle.order.TransactionalInterceptor;
import org.jboss.cdi.tck.util.ActionSequence;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.impl.BeansXml;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"cdi-full"})
@SpecVersion(spec="cdi", version="2.0")
public class LifecycleInterceptorOrderTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(LifecycleInterceptorOrderTest.class)).withBeansXml(new BeansXml().interceptors(TransactionalInterceptor.class))).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="enabled_interceptors", id="g"), @SpecAssertion(section="enabled_interceptors", id="h")})
    public void testLifecycleCallbackInvocationOrder() {
        ActionSequence.reset();
        Bean<AccountTransaction> bean = this.getUniqueBean(AccountTransaction.class, new Annotation[0]);
        CreationalContext ctx = this.getCurrentManager().createCreationalContext(bean);
        AccountTransaction transaction = (AccountTransaction)bean.create(ctx);
        transaction.execute();
        bean.destroy((Object)transaction, ctx);
        List<String> postConstruct = ActionSequence.getSequenceData("postConstruct");
        Assert.assertEquals((int)postConstruct.size(), (int)4);
        Assert.assertEquals((String)postConstruct.get(0), (String)AnotherInterceptor.class.getName());
        Assert.assertEquals((String)postConstruct.get(1), (String)TransactionalInterceptor.class.getName());
        Assert.assertEquals((String)postConstruct.get(2), (String)Transaction.class.getName());
        Assert.assertEquals((String)postConstruct.get(3), (String)AccountTransaction.class.getName());
        List<String> preDestroy = ActionSequence.getSequenceData("preDestroy");
        Assert.assertEquals((int)preDestroy.size(), (int)4);
        Assert.assertEquals((String)postConstruct.get(0), (String)AnotherInterceptor.class.getName());
        Assert.assertEquals((String)postConstruct.get(1), (String)TransactionalInterceptor.class.getName());
        Assert.assertEquals((String)postConstruct.get(2), (String)Transaction.class.getName());
        Assert.assertEquals((String)postConstruct.get(3), (String)AccountTransaction.class.getName());
    }
}

