/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.mc.policy.spi_impl;

import com.sun.xml.ws.policy.PolicyAssertion;
import com.sun.xml.ws.policy.spi.PolicyAssertionValidator;
import com.sun.xml.ws.rx.mc.policy.McAssertionNamespace;
import com.sun.xml.ws.rx.mc.policy.wsmc200702.MakeConnectionSupportedAssertion;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.namespace.QName;

public class McAssertionValidator
implements PolicyAssertionValidator {
    private static final ArrayList<QName> SERVER_SIDE_ASSERTIONS = new ArrayList(1);
    private static final ArrayList<QName> CLIENT_SIDE_ASSERTIONS = new ArrayList(1);
    private static final List<String> SUPPORTED_DOMAINS = Collections.unmodifiableList(McAssertionNamespace.namespacesList());

    @Override
    public PolicyAssertionValidator.Fitness validateClientSide(PolicyAssertion assertion) {
        return CLIENT_SIDE_ASSERTIONS.contains(assertion.getName()) ? PolicyAssertionValidator.Fitness.SUPPORTED : PolicyAssertionValidator.Fitness.UNKNOWN;
    }

    @Override
    public PolicyAssertionValidator.Fitness validateServerSide(PolicyAssertion assertion) {
        QName assertionName = assertion.getName();
        if (SERVER_SIDE_ASSERTIONS.contains(assertionName)) {
            return PolicyAssertionValidator.Fitness.SUPPORTED;
        }
        if (CLIENT_SIDE_ASSERTIONS.contains(assertionName)) {
            return PolicyAssertionValidator.Fitness.UNSUPPORTED;
        }
        return PolicyAssertionValidator.Fitness.UNKNOWN;
    }

    @Override
    public String[] declareSupportedDomains() {
        return SUPPORTED_DOMAINS.toArray(new String[0]);
    }

    static {
        SERVER_SIDE_ASSERTIONS.add(MakeConnectionSupportedAssertion.NAME);
        CLIENT_SIDE_ASSERTIONS.addAll(SERVER_SIDE_ASSERTIONS);
    }
}

