/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.cluster;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Node;
import com.sun.enterprise.config.serverbeans.Nodes;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.Servers;
import com.sun.enterprise.universal.glassfish.ASenvPropertyReader;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.util.io.InstanceDirs;
import com.sun.enterprise.v3.admin.cluster.NodeUtils;
import com.sun.enterprise.v3.admin.cluster.SecureAdminBootstrapHelper;
import com.sun.enterprise.v3.admin.cluster.Strings;
import jakarta.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.cluster.ssh.launcher.SSHLauncher;
import org.glassfish.hk2.api.IterableProvider;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.jvnet.hk2.annotations.Service;

@Service(name="create-instance")
@I18n(value="create.instance")
@PerLookup
@ExecuteOn(value={RuntimeType.DAS})
@RestEndpoints(value={@RestEndpoint(configBean=Domain.class, opType=RestEndpoint.OpType.POST, path="create-instance", description="Create Instance")})
public class CreateInstanceCommand
implements AdminCommand {
    private static final String NL = System.getProperty("line.separator");
    @Inject
    private CommandRunner cr;
    @Inject
    ServiceLocator habitat;
    @Inject
    IterableProvider<Node> nodeList;
    @Inject
    private Nodes nodes;
    @Inject
    private Servers servers;
    @Inject
    private ServerEnvironment env;
    @Param(name="node", alias="nodeagent")
    String node;
    @Param(name="config", optional=true)
    @I18n(value="generic.config")
    String configRef;
    @Param(name="cluster", optional=true)
    String clusterName;
    @Param(name="lbenabled", optional=true)
    private Boolean lbEnabled;
    @Param(name="checkports", optional=true, defaultValue="true")
    private boolean checkPorts;
    @Param(optional=true, defaultValue="false")
    private boolean terse;
    @Param(name="portbase", optional=true)
    private String portBase;
    @Param(name="systemproperties", optional=true, separator=58)
    private String systemProperties;
    @Param(name="instance_name", primary=true)
    private String instance;
    private Logger logger = null;
    private AdminCommandContext ctx;
    private Node theNode = null;
    private String nodeHost = null;
    private String nodeDir = null;
    private String installDir = null;
    private String registerInstanceMessage = null;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        this.ctx = context;
        this.logger = context.getLogger();
        if (!this.env.isDas()) {
            String msg = Strings.get("notAllowed");
            this.logger.warning(msg);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(msg);
            return;
        }
        this.theNode = this.nodes.getNode(this.node);
        if (this.theNode == null) {
            String msg = Strings.get("noSuchNode", this.node);
            this.logger.warning(msg);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(msg);
            return;
        }
        if (this.lbEnabled != null && this.clusterName == null) {
            String msg = Strings.get("lbenabledNotForStandaloneInstance");
            this.logger.warning(msg);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(msg);
            return;
        }
        this.nodeHost = this.theNode.getNodeHost();
        this.nodeDir = this.theNode.getNodeDirAbsolute();
        this.installDir = this.theNode.getInstallDir();
        if (this.theNode.isLocal()) {
            this.validateInstanceDirUnique(report, context);
            if (report.getActionExitCode() != ActionReport.ExitCode.SUCCESS && report.getActionExitCode() != ActionReport.ExitCode.WARNING) {
                return;
            }
        }
        CommandRunner.CommandInvocation ci = this.cr.getCommandInvocation("_register-instance", report, context.getSubject());
        ParameterMap map = new ParameterMap();
        map.add((Object)"node", (Object)this.node);
        map.add((Object)"config", (Object)this.configRef);
        map.add((Object)"cluster", (Object)this.clusterName);
        if (this.lbEnabled != null) {
            map.add((Object)"lbenabled", (Object)this.lbEnabled.toString());
        }
        if (!this.checkPorts) {
            map.add((Object)"checkports", (Object)"false");
        }
        if (StringUtils.ok((String)this.portBase)) {
            map.add((Object)"portbase", (Object)this.portBase);
        }
        map.add((Object)"systemproperties", (Object)this.systemProperties);
        map.add((Object)"DEFAULT", (Object)this.instance);
        ci.parameters(map);
        ci.execute();
        if (report.getActionExitCode() != ActionReport.ExitCode.SUCCESS && report.getActionExitCode() != ActionReport.ExitCode.WARNING) {
            return;
        }
        this.registerInstanceMessage = report.getMessage();
        if (this.theNode.isLocal() && this.installDir == null) {
            ci = this.cr.getCommandInvocation("_update-node", report, context.getSubject());
            map = new ParameterMap();
            map.add((Object)"installdir", (Object)"${com.sun.aas.productRoot}");
            map.add((Object)"type", (Object)"CONFIG");
            map.add((Object)"DEFAULT", (Object)this.theNode.getName());
            ci.parameters(map);
            ci.execute();
            if (report.getActionExitCode() != ActionReport.ExitCode.SUCCESS && report.getActionExitCode() != ActionReport.ExitCode.WARNING) {
                return;
            }
        }
        if (!this.validateDasOptions(context)) {
            report.setActionExitCode(ActionReport.ExitCode.WARNING);
            return;
        }
        this.createInstanceFilesystem(context);
    }

    private void validateInstanceDirUnique(ActionReport report, AdminCommandContext context) {
        CommandRunner.CommandInvocation listInstances = this.cr.getCommandInvocation("list-instances", report, context.getSubject());
        ParameterMap map = new ParameterMap();
        map.add((Object)"whichTarget", (Object)this.theNode.getName());
        listInstances.parameters(map);
        listInstances.execute();
        Properties pro = listInstances.report().getExtraProperties();
        if (pro != null) {
            List instanceList = (List)pro.get("instanceList");
            if (instanceList == null) {
                return;
            }
            for (HashMap instanceMap : instanceList) {
                File nodeDirFile = this.nodeDir == null ? this.defaultLocalNodeDirFile() : new File(this.nodeDir);
                File instanceDir = new File(new File(nodeDirFile.toString(), this.theNode.getName()), this.instance);
                String instanceName = (String)instanceMap.get("name");
                File instanceListDir = new File(new File(nodeDirFile.toString(), this.theNode.getName()), this.instance);
                if (!this.instance.equalsIgnoreCase(instanceName) || !instanceDir.equals(instanceListDir)) continue;
                String msg = Strings.get("Instance.duplicateInstanceDir", this.instance, instanceName);
                this.logger.warning(msg);
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                report.setMessage(msg);
                return;
            }
        }
    }

    private File defaultLocalNodeDirFile() {
        Map systemProps = Collections.unmodifiableMap(new ASenvPropertyReader().getProps());
        String nodeDirDefault = (String)systemProps.get("com.sun.aas.agentRoot");
        return new File(nodeDirDefault);
    }

    private File getDomainInstanceDir() {
        return this.env.getInstanceRoot();
    }

    private void createInstanceFilesystem(AdminCommandContext context) {
        ActionReport report = this.ctx.getActionReport();
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        try {
            Server dasServer = this.servers.getServer("server");
            SSHLauncher sshL = this.theNode.isLocal() ? null : new SSHLauncher(this.theNode);
            List<String> command = this.generateCommand(dasServer, sshL);
            String humanCommand = this.makeCommandHuman(command);
            if (this.userManagedNodeType()) {
                String msg = Strings.get("create.instance.config", this.instance, humanCommand);
                msg = StringUtils.cat((String)NL, (String[])new String[]{this.registerInstanceMessage, msg});
                report.setMessage(msg);
                return;
            }
            String firstErrorMessage = Strings.get("create.instance.filesystem.failed", this.instance, this.node, this.nodeHost);
            NodeUtils nodeUtils = new NodeUtils(this.habitat);
            StringBuilder output = new StringBuilder();
            nodeUtils.runAdminCommandOnNode(this.theNode, command, this.ctx, firstErrorMessage, humanCommand, output);
            if (report.getActionExitCode() != ActionReport.ExitCode.SUCCESS) {
                report.setActionExitCode(ActionReport.ExitCode.WARNING);
                return;
            }
            String msg = Strings.get("create.instance.success", this.instance, this.nodeHost);
            if (!this.terse) {
                msg = StringUtils.cat((String)NL, (String[])new String[]{output.toString().trim(), this.registerInstanceMessage, msg});
            }
            report.setMessage(msg);
            try (SecureAdminBootstrapHelper bootstrapHelper = this.createBootstrapHelper(sshL);){
                bootstrapHelper.bootstrapInstance();
            }
        }
        catch (SecureAdminBootstrapHelper.BootstrapException | IOException e) {
            String message = Strings.get("create.instance.boot.failed", this.instance, this.node, e.getMessage());
            this.logger.log(Level.SEVERE, message, e);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(message);
        }
        if (report.getActionExitCode() != ActionReport.ExitCode.SUCCESS) {
            report.setActionExitCode(ActionReport.ExitCode.WARNING);
        }
    }

    private List<String> generateCommand(Server dasServer, SSHLauncher sshL) throws SecureAdminBootstrapHelper.BootstrapException {
        ArrayList<String> command = new ArrayList<String>();
        if (!this.theNode.isLocal()) {
            command.add("--host");
            command.add(this.resolveAdminHost(sshL));
        }
        command.add("--port");
        command.add(Integer.toString(dasServer.getAdminPort()));
        command.add("_create-instance-filesystem");
        if (this.nodeDir != null) {
            command.add("--nodedir");
            command.add(StringUtils.quotePathIfNecessary((String)this.nodeDir));
        }
        command.add("--node");
        command.add(this.node);
        command.add(this.instance);
        return command;
    }

    private SecureAdminBootstrapHelper createBootstrapHelper(SSHLauncher sshL) throws IOException, SecureAdminBootstrapHelper.BootstrapException {
        if (this.theNode.isLocal()) {
            File nodeDirFile = this.nodeDir == null ? this.defaultLocalNodeDirFile() : new File(this.nodeDir);
            File localInstanceDir = new InstanceDirs(nodeDirFile.toString(), this.theNode.getName(), this.instance).getInstanceDir();
            return SecureAdminBootstrapHelper.getLocalHelper(this.env.getInstanceRoot(), localInstanceDir);
        }
        String thisNodeDir = this.nodeDir == null ? null : this.nodeDir + "/" + this.node;
        return SecureAdminBootstrapHelper.getRemoteHelper(sshL, this.getDomainInstanceDir(), thisNodeDir, this.instance, this.theNode);
    }

    private boolean validateDasOptions(AdminCommandContext context) {
        boolean isDasOptionsValid = true;
        if (this.theNode.isLocal() || !this.theNode.isLocal() && this.theNode.getType().equals("SSH")) {
            ActionReport report = this.ctx.getActionReport();
            report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
            NodeUtils nodeUtils = new NodeUtils(this.habitat);
            Server dasServer = this.servers.getServer("server");
            String dasHost = dasServer.getAdminHost();
            String dasPort = Integer.toString(dasServer.getAdminPort());
            ArrayList<String> command = new ArrayList<String>();
            if (!this.theNode.isLocal()) {
                command.add("--host");
                command.add(dasHost);
            }
            command.add("--port");
            command.add(dasPort);
            command.add("_validate-das-options");
            if (this.nodeDir != null) {
                command.add("--nodedir");
                command.add(this.nodeDir);
            }
            command.add("--node");
            command.add(this.node);
            command.add(this.instance);
            nodeUtils.runAdminCommandOnNode(this.theNode, command, this.ctx, "", null, null);
            if (report.getActionExitCode() != ActionReport.ExitCode.SUCCESS) {
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                isDasOptionsValid = false;
            }
        }
        return isDasOptionsValid;
    }

    private String makeCommandHuman(List<String> command) {
        StringBuilder fullCommand = new StringBuilder();
        fullCommand.append("lib");
        fullCommand.append(System.getProperty("file.separator"));
        fullCommand.append("nadmin ");
        for (String s : command) {
            if (s.equals("_create-instance-filesystem")) {
                fullCommand.append(" ");
                fullCommand.append("create-local-instance");
                continue;
            }
            fullCommand.append(" ");
            fullCommand.append(s);
        }
        return fullCommand.toString();
    }

    private boolean userManagedNodeType() {
        if (this.theNode.isLocal()) {
            return false;
        }
        return !this.theNode.getType().equals("SSH");
    }

    private String resolveAdminHost(SSHLauncher sshLauncher) throws SecureAdminBootstrapHelper.BootstrapException {
        String string;
        Socket socket = new Socket();
        try {
            socket.connect(new InetSocketAddress(InetAddress.getByName(sshLauncher.getHost()), sshLauncher.getPort()));
            string = socket.getLocalAddress().getHostName();
        }
        catch (Throwable throwable) {
            try {
                try {
                    socket.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new SecureAdminBootstrapHelper.BootstrapException("Failed to resolve the admin host visible from the remote node " + this.node, e);
            }
        }
        socket.close();
        return string;
    }
}

