/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.config.manager.tasks;

import com.sun.faces.RIConstants;
import com.sun.faces.config.ConfigManager;
import com.sun.faces.config.ConfigurationException;
import com.sun.faces.config.manager.DbfFactory;
import com.sun.faces.config.manager.documents.DocumentInfo;
import com.sun.faces.config.processor.FacesFlowDefinitionConfigProcessor;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.Timer;
import com.sun.faces.util.Util;
import jakarta.servlet.ServletContext;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.text.MessageFormat;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ParseConfigResourceToDOMTask
implements Callable<DocumentInfo> {
    public static final String WEB_INF_MARKER = "com.sun.faces.webinf";
    private static final Logger LOGGER = FacesLogger.CONFIG.getLogger();
    private static final String EMPTY_FACES_CONFIG = "com/sun/faces/empty-faces-config.xml";
    private static final String FACES_CONFIG_TAGNAME = "faces-config";
    private static final String FACELET_TAGLIB_TAGNAME = "facelet-taglib";
    private static final String FACES_TO_1_1_PRIVATE_XSL = "/com/sun/faces/faces1_0-1_1toSchema.xsl";
    private ServletContext servletContext;
    private URI documentURI;
    private DocumentBuilderFactory factory;
    private boolean validating;

    public ParseConfigResourceToDOMTask(ServletContext servletContext, boolean validating, URI documentURI) throws Exception {
        this.servletContext = servletContext;
        this.documentURI = documentURI;
        this.validating = validating;
    }

    @Override
    public DocumentInfo call() throws Exception {
        try {
            Timer timer = Timer.getInstance();
            if (timer != null) {
                timer.startTiming();
            }
            Document document = this.getDocument();
            if (timer != null) {
                timer.stopTiming();
                timer.logResult("Parse " + this.documentURI.toURL().toExternalForm());
            }
            return new DocumentInfo(document, this.documentURI);
        }
        catch (Exception e) {
            throw new ConfigurationException(MessageFormat.format("Unable to parse document ''{0}'': {1}", this.documentURI.toURL().toExternalForm(), e.getMessage()), e);
        }
    }

    private Document getDocument() throws Exception {
        DocumentBuilder documentBuilder = this.getNonValidatingBuilder();
        URL documentURL = this.documentURI.toURL();
        Document configDocument = this.parseDocumentFromURL(documentBuilder, documentURL);
        String documentNS = null;
        if (configDocument == null) {
            if (FacesFlowDefinitionConfigProcessor.uriIsFlowDefinition(this.documentURI)) {
                documentNS = "https://jakarta.ee/xml/ns/jakartaee";
                configDocument = FacesFlowDefinitionConfigProcessor.synthesizeEmptyFlowDefinition(this.documentURI);
            }
        } else {
            Element documentElement = configDocument.getDocumentElement();
            documentNS = documentElement.getNamespaceURI();
            String rootElementTagName = documentElement.getTagName();
            if (this.isNonFacesConfigDocument(rootElementTagName)) {
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.log(Level.WARNING, MessageFormat.format("Config document {0} with namespace URI {1} is not a faces-config or facelet-taglib file.  Ignoring.", this.documentURI.toURL().toExternalForm(), documentNS));
                }
                return this.getEmptyFacesConfig(documentBuilder);
            }
        }
        Document returnDoc = configDocument;
        if (this.validating && documentNS != null) {
            DOMSource domSource = new DOMSource(configDocument, documentURL.toExternalForm());
            Element documentElement = ((Document)domSource.getNode()).getDocumentElement();
            switch (documentNS) {
                case "https://jakarta.ee/xml/ns/jakartaee": 
                case "http://xmlns.jcp.org/xml/ns/javaee": 
                case "http://java.sun.com/xml/ns/javaee": {
                    returnDoc = this.loadDocument(this.findMatchingSchema(documentNS, this.getVersion(documentElement), documentElement.getLocalName()), domSource);
                    break;
                }
                default: {
                    returnDoc = this.loadDocument(this.findMatchingSchema(documentNS, null, null), ParseConfigResourceToDOMTask.transformDocument(documentNS, domSource));
                }
            }
        }
        if (documentURL.toExternalForm().contains("/WEB-INF/faces-config.xml")) {
            Attr webInf = returnDoc.createAttribute(WEB_INF_MARKER);
            webInf.setValue("true");
            returnDoc.getDocumentElement().getAttributes().setNamedItem(webInf);
        }
        return returnDoc;
    }

    private Document parseDocumentFromURL(DocumentBuilder documentBuilder, URL documentURL) throws SAXException, IOException {
        InputSource documentInputSource = new InputSource(ParseConfigResourceToDOMTask.getInputStream(documentURL));
        documentInputSource.setSystemId(this.documentURI.toURL().toExternalForm());
        try {
            return documentBuilder.parse(documentInputSource);
        }
        catch (SAXParseException spe) {
            InputStream stream = documentInputSource.getByteStream();
            stream.close();
            stream = new InputSource(ParseConfigResourceToDOMTask.getInputStream(documentURL)).getByteStream();
            if (this.streamIsZeroLengthOrEmpty(stream) && documentURL.toExternalForm().endsWith("faces-config.xml")) {
                return documentBuilder.parse(new InputSource(ParseConfigResourceToDOMTask.getInputStream(this.getClass().getClassLoader().getResource(EMPTY_FACES_CONFIG))));
            }
            return null;
        }
    }

    private Schema findMatchingSchema(String documentNS, String version, String localName) {
        return DbfFactory.getSchema(this.servletContext, documentNS, version, localName);
    }

    private Document loadDocument(Schema schema, DOMSource domSource) throws Exception {
        DocumentBuilder builder = this.getBuilderForSchema(schema);
        if (builder.isValidating()) {
            builder.getSchema().newValidator().validate(domSource);
        }
        return (Document)domSource.getNode();
    }

    private Document loadDocument(Schema schema, DOMResult domResult) throws Exception {
        DocumentBuilder builder = this.getBuilderForSchema(schema);
        if (builder.isValidating()) {
            builder.getSchema().newValidator().validate(new DOMSource(domResult.getNode()));
        }
        return (Document)domResult.getNode();
    }

    private String getVersion(Node documentElement) {
        Attr version = (Attr)documentElement.getAttributes().getNamedItem("version");
        if (version == null) {
            throw new ConfigurationException("No document version available.");
        }
        return version.getValue();
    }

    private boolean streamIsZeroLengthOrEmpty(InputStream is) throws IOException {
        boolean isZeroLengthOrEmpty = 0 == is.available();
        int size = 1024;
        byte[] buffer = new byte[1024];
        while (!isZeroLengthOrEmpty && -1 != is.read(buffer, 0, 1024)) {
            String bufferAsString = new String(buffer, RIConstants.CHAR_ENCODING).trim();
            isZeroLengthOrEmpty = 0 == bufferAsString.length();
            buffer[0] = 0;
            for (int i = 1; i < 1024; i += i) {
                System.arraycopy(buffer, 0, buffer, i, 1024 - i < i ? 1024 - i : i);
            }
        }
        return isZeroLengthOrEmpty;
    }

    private static DOMResult transformDocument(String documentNS, DOMSource domSource) throws Exception {
        DOMResult domResult = new DOMResult();
        ParseConfigResourceToDOMTask.getTransformer(documentNS).transform(domSource, domResult);
        ((Document)domResult.getNode()).setDocumentURI(((Document)domSource.getNode()).getDocumentURI());
        return domResult;
    }

    private static Transformer getTransformer(String documentNS) throws Exception {
        String xslToApply;
        switch (documentNS) {
            case "http://java.sun.com/JSF/Configuration": {
                xslToApply = FACES_TO_1_1_PRIVATE_XSL;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return Util.createTransformerFactory().newTransformer(new StreamSource(ParseConfigResourceToDOMTask.getInputStream(ConfigManager.class.getResource(xslToApply))));
    }

    private static InputStream getInputStream(URL url) throws IOException {
        URLConnection connection = url.openConnection();
        connection.setUseCaches(false);
        return new BufferedInputStream(connection.getInputStream());
    }

    private DocumentBuilder getNonValidatingBuilder() throws Exception {
        DocumentBuilderFactory tFactory = DbfFactory.getFactory();
        tFactory.setValidating(false);
        DocumentBuilder tBuilder = tFactory.newDocumentBuilder();
        tBuilder.setEntityResolver(DbfFactory.FACES_ENTITY_RESOLVER);
        tBuilder.setErrorHandler(DbfFactory.FACES_ERROR_HANDLER);
        return tBuilder;
    }

    private DocumentBuilder getBuilderForSchema(Schema schema) throws Exception {
        this.factory = DbfFactory.getFactory();
        try {
            this.factory.setSchema(schema);
        }
        catch (UnsupportedOperationException upe) {
            return this.getNonValidatingBuilder();
        }
        DocumentBuilder builder = this.factory.newDocumentBuilder();
        builder.setEntityResolver(DbfFactory.FACES_ENTITY_RESOLVER);
        builder.setErrorHandler(DbfFactory.FACES_ERROR_HANDLER);
        return builder;
    }

    private boolean isNonFacesConfigDocument(String rootElementTagName) {
        return !FACES_CONFIG_TAGNAME.equals(rootElementTagName) && !FACELET_TAGLIB_TAGNAME.equals(rootElementTagName);
    }

    private Document getEmptyFacesConfig(DocumentBuilder documentBuilder) throws SAXException, IOException {
        return documentBuilder.parse(new InputSource(ParseConfigResourceToDOMTask.getInputStream(this.getClass().getClassLoader().getResource(EMPTY_FACES_CONFIG))));
    }
}

