/*
 * Decompiled with CFR 0.152.
 */
package jakarta.enterprise.concurrent;

import jakarta.enterprise.concurrent.LastExecution;
import jakarta.enterprise.concurrent.ZonedTrigger;
import java.time.DateTimeException;
import java.time.DayOfWeek;
import java.time.Month;
import java.time.Year;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Function;

public class CronTrigger
implements ZonedTrigger {
    private static final Map<String, Integer> DAYS_OF_WEEK = new HashMap<String, Integer>(7);
    private static final Map<String, Integer> MONTHS = new HashMap<String, Integer>(12);
    private static final int[] ALL_DAYS_OF_MONTH;
    private static final int[] ALL_DAYS_OF_WEEK;
    private static final int[] ALL_MONTHS;
    private static final int LAST = -1;
    private static final int[] ZERO;
    private int[] daysOfMonth = ALL_DAYS_OF_MONTH;
    private int[] daysOfWeek = ALL_DAYS_OF_WEEK;
    private int[] hours = ZERO;
    private int[] minutes = ZERO;
    private int[] months = ALL_MONTHS;
    private int[] seconds = ZERO;
    private final ZoneId zone;

    public CronTrigger(String cron, ZoneId zone) {
        this(zone);
        String[] c = cron.split(" ");
        if (c.length == 5) {
            this.minutes(c[0]).hours(c[1]).daysOfMonth(c[2]).months(c[3]).daysOfWeek(c[4]);
        } else if (c.length == 6) {
            this.seconds(c[0]).minutes(c[1]).hours(c[2]).daysOfMonth(c[3]).months(c[4]).daysOfWeek(c[5]);
        } else {
            throw new IllegalArgumentException(cron);
        }
    }

    public CronTrigger(ZoneId zone) {
        this.zone = zone == null ? ZoneId.systemDefault() : zone;
    }

    @Override
    public ZonedDateTime getNextRunTime(LastExecution lastExecutionInfo, ZonedDateTime taskScheduledTime) {
        return this.next(lastExecutionInfo == null ? taskScheduledTime : lastExecutionInfo.getRunEnd(this.zone));
    }

    @Override
    public final ZoneId getZoneId() {
        return this.zone;
    }

    public CronTrigger daysOfMonth(int ... d) {
        this.daysOfMonth = this.parse("daysOfMonth", 1, 31, d);
        return this;
    }

    public CronTrigger daysOfMonth(String d) {
        this.daysOfMonth = this.parse("daysOfMonth", 1, 31, -1, d, CronTrigger::parseDayOfMonth);
        return this;
    }

    public CronTrigger daysOfWeek(DayOfWeek ... d) {
        if (d.length == 0) {
            throw new IllegalArgumentException("daysOfWeek: []");
        }
        this.daysOfWeek = Arrays.stream(d).map(DayOfWeek::getValue).sorted().distinct().mapToInt(Integer::intValue).toArray();
        return this;
    }

    public CronTrigger daysOfWeek(String d) {
        this.daysOfWeek = this.parse("daysOfWeek", 1, 7, 49, d, CronTrigger::parseDayOfWeek);
        return this;
    }

    public CronTrigger hours(int ... h) {
        this.hours = this.parse("hours", 0, 23, h);
        return this;
    }

    public CronTrigger hours(String h) {
        this.hours = this.parse("hours", 0, 23, 23, h, Integer::parseInt);
        return this;
    }

    public CronTrigger minutes(int ... m) {
        this.minutes = this.parse("minutes", 0, 59, m);
        return this;
    }

    public CronTrigger minutes(String m) {
        this.minutes = this.parse("minutes", 0, 59, 59, m, Integer::parseInt);
        return this;
    }

    public CronTrigger months(Month ... m) {
        if (m.length == 0) {
            throw new IllegalArgumentException("months: []");
        }
        this.months = Arrays.stream(m).map(Month::getValue).sorted().distinct().mapToInt(Integer::intValue).toArray();
        return this;
    }

    public CronTrigger months(String m) {
        this.months = this.parse("months", 1, 12, 12, m, CronTrigger::parseMonth);
        return this;
    }

    public CronTrigger seconds(int ... s) {
        this.seconds = this.parse("seconds", 0, 59, s);
        return this;
    }

    public CronTrigger seconds(String s) {
        this.seconds = this.parse("seconds", 0, 59, 59, s, Integer::parseInt);
        return this;
    }

    public String toString() {
        StringBuilder s = new StringBuilder("CronTrigger@").append(Integer.toHexString(this.hashCode()));
        this.toStringBuilder(s, "seconds", this.seconds, 60);
        this.toStringBuilder(s, "minutes", this.minutes, 60);
        this.toStringBuilder(s, "hours", this.hours, 24);
        this.toStringBuilder(s, "days", this.daysOfMonth, 31);
        this.toStringBuilder(s, "months", this.months, 12);
        if (this.daysOfWeek.length == 7 && this.daysOfWeek[6] == 7) {
            s.append(" *");
        } else {
            for (int i = 0; i < this.daysOfWeek.length; ++i) {
                int d = (this.daysOfWeek[i] - 1) % 7 + 1;
                int ord = (this.daysOfWeek[i] - 1) / 7;
                s.append(i == 0 ? (char)' ' : ',').append(DayOfWeek.of(d).name().substring(0, 3));
                if (ord <= 0) continue;
                s.append('#').append(ord == 6 ? "L" : Integer.valueOf(ord));
            }
        }
        return s.toString();
    }

    private void toStringBuilder(StringBuilder s, String label, int[] list, int max) {
        if (list.length == max) {
            s.append(" *");
        } else {
            s.append(' ').append(label).append(' ');
            StringBuilder l = new StringBuilder();
            for (int i = 0; i < list.length; ++i) {
                if (list[i] < 0) {
                    l.append((String)(list[i] == -1 ? "L" : -list[i] + "L")).append(',');
                    continue;
                }
                s.append(list[i]).append(',');
            }
            s.append(l.toString());
        }
    }

    protected ZonedDateTime next(ZonedDateTime from) {
        ZonedDateTime time = from.getNano() == 0 ? from : from.plusSeconds(1L).withNano(0);
        for (int i = 0; i < 1000 && time != null; ++i) {
            int dayOfLastWeek;
            int year = time.getYear();
            int monthIndex = Arrays.binarySearch(this.months, time.getMonthValue());
            if (monthIndex < 0) {
                time = this.nextMonth(-monthIndex - 2, year);
                continue;
            }
            int dayOfMonth = time.getDayOfMonth();
            int lastDayOfMonth = time.getMonth().length(Year.isLeap(year));
            int dayIndex = Arrays.binarySearch(this.daysOfMonth, dayOfMonth);
            int lastDayIndex = Arrays.binarySearch(this.daysOfMonth, dayOfMonth - lastDayOfMonth - 1);
            if (dayIndex < 0 && lastDayIndex < 0) {
                time = this.nextDayOfMonth(-dayIndex - 2, -lastDayIndex - 2, monthIndex, year, time);
                continue;
            }
            dayIndex = dayIndex < 0 ? -dayIndex - 2 : dayIndex;
            lastDayIndex = lastDayIndex < 0 ? -lastDayIndex - 2 : lastDayIndex;
            int dayOfWeek = time.getDayOfWeek().getValue();
            int ordinalDayOfWeek = ((dayOfMonth - 1) / 7 + 1) * 7 + dayOfWeek;
            int n = dayOfLastWeek = lastDayOfMonth - dayOfMonth >= 7 ? -1 : 42 + dayOfWeek;
            if (Arrays.binarySearch(this.daysOfWeek, dayOfWeek) < 0 && Arrays.binarySearch(this.daysOfWeek, ordinalDayOfWeek) < 0 && Arrays.binarySearch(this.daysOfWeek, dayOfLastWeek) < 0) {
                time = this.nextDayOfMonth(dayIndex, lastDayIndex, monthIndex, year, time);
                continue;
            }
            int hourIndex = Arrays.binarySearch(this.hours, time.getHour());
            if (hourIndex < 0) {
                time = this.nextHour(-hourIndex - 2, dayIndex, lastDayIndex, dayOfMonth, monthIndex, year, time);
                continue;
            }
            int minuteIndex = Arrays.binarySearch(this.minutes, time.getMinute());
            if (minuteIndex < 0) {
                time = this.nextMinute(-minuteIndex - 2, hourIndex, dayIndex, lastDayIndex, dayOfMonth, monthIndex, year, time);
                continue;
            }
            int secondIndex = Arrays.binarySearch(this.seconds, time.getSecond());
            if (secondIndex < 0) {
                time = this.nextSecond(-secondIndex - 2, minuteIndex, hourIndex, dayIndex, lastDayIndex, dayOfMonth, monthIndex, year, time);
                continue;
            }
            return time;
        }
        throw new DateTimeException("Unable to determine next time after " + from + " with " + this);
    }

    private ZonedDateTime nextDayOfMonth(int dayIndex, int lastDayIndex, int monthIndex, int year, ZonedDateTime time) {
        int ld;
        int lastDayOfMonth = Month.of(this.months[monthIndex]).length(Year.isLeap(year));
        int dd = dayIndex + 1 < this.daysOfMonth.length ? this.daysOfMonth[dayIndex + 1] : 32;
        int dayOfMonth = Math.min(dd, ld = lastDayIndex + 1 < this.daysOfMonth.length && this.daysOfMonth[lastDayIndex + 1] < 0 ? 1 + lastDayOfMonth + this.daysOfMonth[lastDayIndex + 1] : 32);
        if (dayOfMonth > lastDayOfMonth) {
            return this.nextMonth(monthIndex, year);
        }
        return ZonedDateTime.of(year, this.months[monthIndex], dayOfMonth, this.hours[0], this.minutes[0], this.seconds[0], 0, time.getZone());
    }

    private ZonedDateTime nextHour(int hourIndex, int dayIndex, int lastDayIndex, int dayOfMonth, int monthIndex, int year, ZonedDateTime time) {
        if (hourIndex >= 0) {
            ZonedDateTime dst = ZonedDateTime.of(year, this.months[monthIndex], dayOfMonth, this.hours[hourIndex], this.minutes[0], this.seconds[0], 0, time.getZone());
            ZonedDateTime std = dst.plusHours(1L);
            if (dst.getHour() == std.getHour() && time.isAfter(dst) && time.isBefore(std)) {
                return std;
            }
        }
        if (hourIndex + 1 < this.hours.length) {
            return ZonedDateTime.of(year, this.months[monthIndex], dayOfMonth, this.hours[hourIndex + 1], this.minutes[0], this.seconds[0], 0, time.getZone());
        }
        return this.nextDayOfMonth(dayIndex, lastDayIndex, monthIndex, year, time);
    }

    private ZonedDateTime nextMinute(int minuteIndex, int hourIndex, int dayIndex, int lastDayIndex, int dayOfMonth, int monthIndex, int year, ZonedDateTime time) {
        if (minuteIndex + 1 < this.minutes.length) {
            return time.withMinute(this.minutes[minuteIndex + 1]).withSecond(this.seconds[0]);
        }
        return this.nextHour(hourIndex, dayIndex, lastDayIndex, dayOfMonth, monthIndex, year, time);
    }

    private ZonedDateTime nextMonth(int month, int year) {
        int lastDayOfMonth;
        int ld;
        int d;
        int dd;
        int dayOfMonth;
        int cycles = 0;
        int m = month;
        int y = year;
        do {
            if (++m >= this.months.length) {
                m = 0;
                ++y;
            }
            d = 0;
            int i = 0;
            while (i < this.daysOfMonth.length && this.daysOfMonth[i] < 0) {
                d = ++i;
            }
            lastDayOfMonth = Month.of(this.months[m]).length(Year.isLeap(y));
        } while (((dayOfMonth = Math.min(dd = d < this.daysOfMonth.length && this.daysOfMonth[d] > 0 ? this.daysOfMonth[d] : 32, ld = this.daysOfMonth[0] < 0 ? 1 + lastDayOfMonth + this.daysOfMonth[0] : 32)) < 1 || dayOfMonth > lastDayOfMonth) && ++cycles < 1000);
        return cycles < 1000 ? ZonedDateTime.of(y, this.months[m], dayOfMonth, this.hours[0], this.minutes[0], this.seconds[0], 0, this.zone) : null;
    }

    private ZonedDateTime nextSecond(int secondIndex, int minuteIndex, int hourIndex, int dayIndex, int lastDayIndex, int dayOfMonth, int monthIndex, int year, ZonedDateTime time) {
        if (secondIndex + 1 < this.seconds.length) {
            return time.withSecond(this.seconds[secondIndex + 1]);
        }
        return this.nextMinute(minuteIndex, hourIndex, dayIndex, lastDayIndex, dayOfMonth, monthIndex, year, time);
    }

    private static final void add(SortedSet<Integer> vals, int start, int end, int increment) {
        for (int val = start; val <= end; val += increment) {
            vals.add(val);
        }
    }

    private int[] parse(String type, int min, int max, int[] list) {
        if (list.length == 0) {
            throw new IllegalArgumentException(type + ": []");
        }
        TreeSet<Integer> vals = new TreeSet<Integer>();
        for (int i = 0; i < list.length; ++i) {
            if (list[i] < min || list[i] > max) {
                throw new IllegalArgumentException(type + ": " + list[i]);
            }
            vals.add(list[i]);
        }
        return vals.stream().mapToInt(Integer::intValue).toArray();
    }

    private int[] parse(String name, int min, int max, int maxExt, String field, Function<String, Integer> parser) {
        if (field == null || field.length() == 0) {
            throw new IllegalArgumentException(name + ": []");
        }
        TreeSet<Integer> vals = new TreeSet<Integer>();
        for (String f : field.split(",")) {
            try {
                if ("*".equals(f) || "?".equals(f)) {
                    CronTrigger.add(vals, min, max, 1);
                    continue;
                }
                int slash = f.indexOf(47, 1);
                if (slash > 0 && slash < f.length() - 1) {
                    int val1 = slash == 1 && f.charAt(0) == '*' ? min : parser.apply(f.substring(0, slash));
                    int increment = parser.apply(f.substring(slash + 1));
                    if (val1 < min || val1 > max || increment < 1 || maxExt > max) {
                        throw new IllegalArgumentException(name + ": " + f);
                    }
                    CronTrigger.add(vals, val1, max, increment);
                    continue;
                }
                int dash = f.indexOf(45, 1);
                if (dash > 0 && dash < f.length() - 1) {
                    int val2;
                    int val1 = parser.apply(f.substring(0, dash));
                    String end = f.substring(dash + 1);
                    int n = val2 = "L".equals(end) ? max : parser.apply(end);
                    if (val1 < min || val1 > max || val2 < min || val2 > max) {
                        throw new IllegalArgumentException(name + ": " + f);
                    }
                    if (val2 >= val1) {
                        CronTrigger.add(vals, val1, val2, 1);
                        continue;
                    }
                    CronTrigger.add(vals, val1, max, 1);
                    CronTrigger.add(vals, min, val2, 1);
                    continue;
                }
                int val = parser.apply(f);
                if ((val < min || val > maxExt) && maxExt != -1) {
                    throw new IllegalArgumentException(name + ": " + f);
                }
                vals.add(val);
            }
            catch (NumberFormatException x) {
                throw new IllegalArgumentException(name + ": " + f, x);
            }
        }
        return vals.stream().mapToInt(Integer::intValue).toArray();
    }

    private static int parseDayOfMonth(String day) throws IllegalArgumentException {
        try {
            if (day.charAt(day.length() - 1) == 'L') {
                int d;
                int n = d = day.length() == 1 ? -1 : -Integer.parseInt(day.substring(0, day.length() - 1));
                if (d > -1 || d < -31) {
                    throw new IllegalArgumentException("dayOfMonth: " + day);
                }
                return d;
            }
            int d = Integer.parseInt(day);
            if (d < 1 || d > 31) {
                throw new IllegalArgumentException("dayOfMonth: " + day);
            }
            return d;
        }
        catch (NumberFormatException x) {
            throw new IllegalArgumentException("dayOfMonth: " + day, x);
        }
    }

    private static int parseDayOfWeek(String dayName) throws IllegalArgumentException {
        String day = dayName;
        int ordinal = 0;
        int n = day.indexOf(35);
        try {
            if (n > 0) {
                int n2 = ordinal = day.charAt(n + 1) == 'L' ? 6 : Integer.parseInt(day.substring(n + 1));
                if (ordinal < 1 || ordinal > 6) {
                    throw new IllegalArgumentException("dayOfWeek: " + day);
                }
                day = day.substring(0, n);
            }
            if (day.length() < 3) {
                int d = Integer.parseInt(day);
                return d == 0 ? 7 : d;
            }
        }
        catch (NumberFormatException x) {
            throw new IllegalArgumentException("dayOfWeek: " + day, x);
        }
        day = day.toUpperCase();
        Integer d = DAYS_OF_WEEK.get(day);
        if (d == null) {
            d = DayOfWeek.valueOf(day).getValue();
        }
        return 7 * ordinal + d;
    }

    private static int parseMonth(String monthName) throws IllegalArgumentException {
        String month = monthName;
        if (month.length() < 3) {
            try {
                return Integer.parseInt(month);
            }
            catch (NumberFormatException x) {
                throw new IllegalArgumentException("month: " + month, x);
            }
        }
        Integer m = MONTHS.get(month = month.toUpperCase());
        return m == null ? Month.valueOf(month).getValue() : m.intValue();
    }

    static {
        for (DayOfWeek dayOfWeek : DayOfWeek.values()) {
            DAYS_OF_WEEK.put(dayOfWeek.name().substring(0, 3), dayOfWeek.getValue());
        }
        for (Enum enum_ : Month.values()) {
            MONTHS.put(enum_.name().substring(0, 3), ((Month)enum_).getValue());
        }
        ALL_DAYS_OF_MONTH = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31};
        ALL_DAYS_OF_WEEK = new int[]{1, 2, 3, 4, 5, 6, 7};
        ALL_MONTHS = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12};
        ZERO = new int[]{0};
    }
}

