/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.oxm.record;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.xml.namespace.QName;
import org.eclipse.persistence.core.queries.CoreAttributeGroup;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.core.helper.CoreClassConstants;
import org.eclipse.persistence.internal.core.helper.CoreField;
import org.eclipse.persistence.internal.core.sessions.CoreAbstractSession;
import org.eclipse.persistence.internal.oxm.Constants;
import org.eclipse.persistence.internal.oxm.ConversionManager;
import org.eclipse.persistence.internal.oxm.Marshaller;
import org.eclipse.persistence.internal.oxm.Namespace;
import org.eclipse.persistence.internal.oxm.NamespaceResolver;
import org.eclipse.persistence.internal.oxm.ObjectBuilder;
import org.eclipse.persistence.internal.oxm.Root;
import org.eclipse.persistence.internal.oxm.XMLBinaryDataHelper;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.XPathNode;
import org.eclipse.persistence.internal.oxm.XPathPredicate;
import org.eclipse.persistence.internal.oxm.mappings.Descriptor;
import org.eclipse.persistence.internal.oxm.mappings.Field;
import org.eclipse.persistence.internal.oxm.mappings.Login;
import org.eclipse.persistence.internal.oxm.record.AbstractMarshalRecordImpl;
import org.eclipse.persistence.internal.oxm.record.MarshalRecord;
import org.eclipse.persistence.oxm.record.ValidatingMarshalRecord;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

public abstract class MarshalRecord<MARSHALLER extends Marshaller>
extends AbstractMarshalRecordImpl<CoreAbstractSession, CoreField, MARSHALLER, NamespaceResolver>
implements org.eclipse.persistence.internal.oxm.record.MarshalRecord<CoreAbstractSession, CoreField, MARSHALLER, NamespaceResolver> {
    private ArrayList<XPathNode> groupingElements;
    private HashMap positionalNodes;
    protected XPathFragment textWrapperFragment;
    private MarshalRecord.CycleDetectionStack<Object> cycleDetectionStack = new MarshalRecord.CycleDetectionStack();
    private Stack<CoreAttributeGroup> attributeGroupStack;
    protected static final String COLON_W_SCHEMA_NIL_ATTRIBUTE = ":nil";
    protected static final String TRUE = "true";

    protected MarshalRecord() {
        super(null);
        this.namespaceResolver = new NamespaceResolver();
    }

    @Override
    public void forceValueWrapper() {
    }

    public HashMap getPositionalNodes() {
        if (this.positionalNodes == null) {
            this.positionalNodes = new HashMap();
        }
        return this.positionalNodes;
    }

    public String getLocalName() {
        throw XMLMarshalException.operationNotSupported("getLocalName");
    }

    public String getNamespaceURI() {
        throw XMLMarshalException.operationNotSupported("getNamespaceURI");
    }

    public void clear() {
        throw XMLMarshalException.operationNotSupported("clear");
    }

    public Document getDocument() {
        throw XMLMarshalException.operationNotSupported("getDocument");
    }

    @Override
    public Node getDOM() {
        return null;
    }

    @Override
    public void addGroupingElement(XPathNode xPathNode) {
        if (null == this.groupingElements) {
            this.groupingElements = new ArrayList(2);
        }
        this.groupingElements.add(xPathNode);
    }

    @Override
    public void removeGroupingElement(XPathNode xPathNode) {
        if (null != this.groupingElements) {
            this.groupingElements.remove(xPathNode);
        }
    }

    public String transformToXML() {
        return null;
    }

    @Override
    public void setSession(CoreAbstractSession session) {
        super.setSession(session);
        if (session != null && session.getDatasourceLogin() instanceof Login) {
            this.equalNamespaceResolvers = ((Login)session.getDatasourceLogin()).hasEqualNamespaceResolvers();
        }
    }

    @Override
    public void add(CoreField key, Object value) {
        if (null == value) {
            return;
        }
        Field xmlField = this.convertToXMLField(key);
        XPathFragment lastFragment = xmlField.getLastXPathFragment();
        if (lastFragment.nameIsText()) {
            this.characters(xmlField.getSchemaType(), value, null, xmlField.isCDATA());
        } else if (lastFragment.isAttribute()) {
            this.attribute(lastFragment, (NamespaceResolver)xmlField.getNamespaceResolver(), value, xmlField.getSchemaType());
        } else {
            this.element(lastFragment);
        }
    }

    @Override
    public Object put(CoreField key, Object value) {
        this.add(key, value);
        return null;
    }

    public void namespaceDeclarations(NamespaceResolver namespaceResolver) {
        if (namespaceResolver == null) {
            return;
        }
        String namespaceURI = namespaceResolver.getDefaultNamespaceURI();
        if (null != namespaceURI) {
            this.defaultNamespaceDeclaration(namespaceURI);
        }
        if (namespaceResolver.hasPrefixesToNamespaces()) {
            for (Map.Entry<String, String> entry : namespaceResolver.getPrefixesToNamespaces().entrySet()) {
                String namespacePrefix = entry.getKey();
                this.namespaceDeclaration(namespacePrefix, entry.getValue());
            }
        }
    }

    @Override
    public boolean emptyCollection(XPathFragment xPathFragment, NamespaceResolver namespaceResolver, boolean openGrouping) {
        if (openGrouping) {
            XPathFragment groupingFragment = this.openStartGroupingElements(namespaceResolver);
            this.closeStartGroupingElements(groupingFragment);
            return true;
        }
        return false;
    }

    @Override
    public void namespaceDeclaration(String prefix, String namespaceURI) {
        this.attribute("http://www.w3.org/2000/xmlns/", prefix, "xmlns:" + prefix, namespaceURI);
    }

    public void defaultNamespaceDeclaration(String defaultNamespace) {
        this.attribute("http://www.w3.org/2000/xmlns/", "xmlns", "xmlns", defaultNamespace);
    }

    public abstract void startDocument(String var1, String var2);

    public void writeHeader() {
    }

    public abstract void endDocument();

    public void marshalWithoutRootElement(ObjectBuilder treeObjectBuilder, Object object, Descriptor descriptor, Root root, boolean isXMLRoot) {
    }

    @Override
    public void startPrefixMapping(String prefix, String namespaceURI) {
    }

    public void startPrefixMappings(NamespaceResolver namespaceResolver) {
        if (namespaceResolver != null && namespaceResolver.hasPrefixesToNamespaces()) {
            for (Map.Entry<String, String> entry : namespaceResolver.getPrefixesToNamespaces().entrySet()) {
                this.startPrefixMapping(entry.getKey(), entry.getValue());
            }
        }
    }

    @Override
    public void endPrefixMapping(String prefix) {
    }

    public void endPrefixMappings(NamespaceResolver namespaceResolver) {
    }

    @Override
    public void openStartElement(XPathFragment xPathFragment, NamespaceResolver namespaceResolver) {
        this.addPositionalNodes(xPathFragment, namespaceResolver);
    }

    public abstract void element(XPathFragment var1);

    @Override
    public abstract void attribute(XPathFragment var1, NamespaceResolver var2, String var3);

    @Override
    public abstract void attribute(String var1, String var2, String var3, String var4);

    @Override
    public abstract void closeStartElement();

    @Override
    public abstract void endElement(XPathFragment var1, NamespaceResolver var2);

    @Override
    public abstract void characters(String var1);

    @Override
    public void attribute(XPathFragment xPathFragment, NamespaceResolver namespaceResolver, Object value, QName schemaType) {
        if (schemaType != null && Constants.QNAME_QNAME.equals(schemaType)) {
            String convertedValue = this.getStringForQName((QName)value);
            this.attribute(xPathFragment, namespaceResolver, convertedValue);
        } else {
            String convertedValue = ((ConversionManager)this.session.getDatasourcePlatform().getConversionManager()).convertObject(value, CoreClassConstants.STRING, schemaType);
            this.attribute(xPathFragment, namespaceResolver, convertedValue);
        }
    }

    @Override
    public void characters(QName schemaType, Object value, String mimeType, boolean isCDATA) {
        if (mimeType != null) {
            value = value instanceof List ? XMLBinaryDataHelper.getXMLBinaryDataHelper().getBytesListForBinaryValues((List)value, this.marshaller, mimeType) : (Object)XMLBinaryDataHelper.getXMLBinaryDataHelper().getBytesForBinaryValue(value, this.marshaller, mimeType).getData();
        }
        if (schemaType != null && Constants.QNAME_QNAME.equals(schemaType)) {
            String convertedValue = this.getStringForQName((QName)value);
            this.characters(convertedValue);
        } else {
            String convertedValue = ((ConversionManager)this.session.getDatasourcePlatform().getConversionManager()).convertObject(value, CoreClassConstants.STRING, schemaType);
            if (isCDATA) {
                this.cdata(convertedValue);
            } else {
                this.characters(convertedValue);
            }
        }
    }

    @Override
    public String getValueToWrite(QName schemaType, Object value, ConversionManager conversionManager) {
        if (value == null) {
            return null;
        }
        if (schemaType != null && Constants.QNAME_QNAME.equals(schemaType)) {
            return this.getStringForQName((QName)value);
        }
        if (value.getClass() == String.class) {
            return (String)value;
        }
        return conversionManager.convertObject(value, CoreClassConstants.STRING, schemaType);
    }

    protected String getStringForQName(QName qName) {
        if (null == qName) {
            return null;
        }
        String namespaceURI = qName.getNamespaceURI();
        if (null == namespaceURI || namespaceURI.isEmpty()) {
            if (this.getNamespaceResolver() != null && ((NamespaceResolver)this.getNamespaceResolver()).getDefaultNamespaceURI() != null) {
                this.defaultNamespaceDeclaration(namespaceURI);
            }
            return qName.getLocalPart();
        }
        Object namespaceResolver = this.getNamespaceResolver();
        if (namespaceResolver == null) {
            throw XMLMarshalException.namespaceResolverNotSpecified(namespaceURI);
        }
        if (namespaceURI.equals(((NamespaceResolver)namespaceResolver).getDefaultNamespaceURI())) {
            return qName.getLocalPart();
        }
        String prefix = ((NamespaceResolver)namespaceResolver).resolveNamespaceURI(namespaceURI);
        if (null == prefix) {
            prefix = namespaceURI.equals("http://www.w3.org/2001/XMLSchema") ? ((NamespaceResolver)namespaceResolver).generatePrefix("xsd") : ((NamespaceResolver)namespaceResolver).generatePrefix();
            this.namespaceDeclaration(prefix, namespaceURI);
        }
        if ("".equals(prefix)) {
            return qName.getLocalPart();
        }
        return prefix + ":" + qName.getLocalPart();
    }

    @Override
    public abstract void cdata(String var1);

    @Override
    public void node(Node node, NamespaceResolver resolver) {
        this.node(node, resolver, null, null);
    }

    public abstract void node(Node var1, NamespaceResolver var2, String var3, String var4);

    @Override
    public XPathFragment openStartGroupingElements(NamespaceResolver namespaceResolver) {
        if (null == this.groupingElements) {
            return null;
        }
        XPathFragment xPathFragment = null;
        int groupingElementsSize = this.groupingElements.size();
        for (int x = 0; x < groupingElementsSize; ++x) {
            XPathNode xPathNode = this.groupingElements.get(x);
            xPathFragment = xPathNode.getXPathFragment();
            this.openStartElement(xPathFragment, namespaceResolver);
            this.predicateAttribute(xPathFragment, namespaceResolver);
            if (x == groupingElementsSize - 1) continue;
            this.closeStartElement();
        }
        this.groupingElements = null;
        return xPathFragment;
    }

    @Override
    public void closeStartGroupingElements(XPathFragment groupingFragment) {
        if (null != groupingFragment) {
            this.closeStartElement();
        }
    }

    protected void addPositionalNodes(XPathFragment xPathFragment, NamespaceResolver namespaceResolver) {
        if (xPathFragment.containsIndex()) {
            String shortName = xPathFragment.getShortName();
            Integer index = (Integer)this.getPositionalNodes().get(shortName);
            int start = null == index ? 1 : index;
            for (int x = start; x < xPathFragment.getIndexValue(); ++x) {
                this.element(xPathFragment);
            }
            this.getPositionalNodes().put(shortName, xPathFragment.getIndexValue() + 1);
        }
    }

    @Override
    public void beforeContainmentMarshal(Object child) {
        Object marshalListener;
        if (null != this.marshaller && null != (marshalListener = this.marshaller.getMarshalListener())) {
            try {
                marshalListener.beforeMarshal(child);
            }
            catch (EclipseLinkException e) {
                ErrorHandler errorHandler = this.marshaller.getErrorHandler();
                if (null == errorHandler) {
                    throw e;
                }
                try {
                    ValidatingMarshalRecord.MarshalSAXParseException saxParseException = new ValidatingMarshalRecord.MarshalSAXParseException(null, null, null, -1, -1, e, child);
                    errorHandler.error(saxParseException);
                }
                catch (SAXException saxParseException) {
                    throw e;
                }
            }
        }
        this.setOwningObject(child);
    }

    @Override
    public void afterContainmentMarshal(Object parent, Object child) {
        Object marshalListener;
        if (null != this.marshaller && null != (marshalListener = this.marshaller.getMarshalListener())) {
            try {
                marshalListener.afterMarshal(child);
            }
            catch (EclipseLinkException e) {
                ErrorHandler errorHandler = this.marshaller.getErrorHandler();
                if (null == errorHandler) {
                    throw e;
                }
                try {
                    ValidatingMarshalRecord.MarshalSAXParseException saxParseException = new ValidatingMarshalRecord.MarshalSAXParseException(null, null, null, -1, -1, e, child);
                    errorHandler.error(saxParseException);
                }
                catch (SAXException saxParseException) {
                    throw e;
                }
            }
        }
        this.setOwningObject(parent);
    }

    @Override
    public ArrayList<XPathNode> getGroupingElements() {
        return this.groupingElements;
    }

    @Override
    public void setGroupingElement(ArrayList<XPathNode> elements) {
        this.groupingElements = elements;
    }

    @Override
    public void predicateAttribute(XPathFragment xPathFragment, NamespaceResolver namespaceResolver) {
        XPathFragment predicateXPathFragment;
        XPathPredicate predicate;
        if (null != xPathFragment && null != (predicate = xPathFragment.getPredicate()) && (predicateXPathFragment = predicate.getXPathFragment()).isAttribute()) {
            this.attribute(predicateXPathFragment, namespaceResolver, predicate.getValue());
        }
    }

    @Override
    public void startCollection() {
    }

    @Override
    public void emptyAttribute(XPathFragment xPathFragment, NamespaceResolver namespaceResolver) {
        XPathFragment groupingFragment = this.openStartGroupingElements(namespaceResolver);
        this.attribute(xPathFragment, namespaceResolver, "");
        this.closeStartGroupingElements(groupingFragment);
    }

    @Override
    public void emptyComplex(XPathFragment xPathFragment, NamespaceResolver namespaceResolver) {
        XPathFragment groupingFragment = this.openStartGroupingElements(namespaceResolver);
        this.closeStartGroupingElements(groupingFragment);
        this.openStartElement(xPathFragment, namespaceResolver);
        this.closeStartElement();
        this.endElement(xPathFragment, namespaceResolver);
    }

    @Override
    public void emptySimple(NamespaceResolver namespaceResolver) {
        XPathFragment groupingFragment = this.openStartGroupingElements(namespaceResolver);
        this.closeStartGroupingElements(groupingFragment);
    }

    @Override
    public void nilSimple(NamespaceResolver namespaceResolver) {
        XPathFragment groupingFragment = this.openStartGroupingElements(namespaceResolver);
        String xsiPrefix = this.processNamespaceResolverForXSIPrefix(namespaceResolver);
        StringBuilder qName = new StringBuilder(Constants.ATTRIBUTE.charValue());
        qName.append(xsiPrefix).append(COLON_W_SCHEMA_NIL_ATTRIBUTE);
        XPathFragment nilFragment = new XPathFragment(qName.toString());
        nilFragment.setNamespaceURI("http://www.w3.org/2001/XMLSchema-instance");
        this.attribute(nilFragment, namespaceResolver, TRUE);
        this.closeStartGroupingElements(groupingFragment);
    }

    @Override
    public void nilComplex(XPathFragment xPathFragment, NamespaceResolver namespaceResolver) {
        XPathFragment groupingFragment = this.openStartGroupingElements(namespaceResolver);
        this.closeStartGroupingElements(groupingFragment);
        this.openStartElement(xPathFragment, namespaceResolver);
        String xsiPrefix = this.processNamespaceResolverForXSIPrefix(namespaceResolver);
        XPathFragment nilFragment = new XPathFragment(Constants.ATTRIBUTE + xsiPrefix + COLON_W_SCHEMA_NIL_ATTRIBUTE);
        nilFragment.setNamespaceURI("http://www.w3.org/2001/XMLSchema-instance");
        this.attribute(nilFragment, namespaceResolver, TRUE);
        this.closeStartElement();
        this.endElement(xPathFragment, namespaceResolver);
    }

    @Override
    public void endCollection() {
    }

    protected String processNamespaceResolverForXSIPrefix(NamespaceResolver namespaceResolver) {
        String xsiPrefix;
        if (null == namespaceResolver) {
            xsiPrefix = "xsi";
            namespaceResolver = new NamespaceResolver();
            namespaceResolver.put(xsiPrefix, "http://www.w3.org/2001/XMLSchema-instance");
            this.namespaceDeclaration(xsiPrefix, "http://www.w3.org/2001/XMLSchema-instance");
        } else {
            xsiPrefix = namespaceResolver.resolveNamespaceURI("http://www.w3.org/2001/XMLSchema-instance");
            if (null == xsiPrefix) {
                xsiPrefix = namespaceResolver.generatePrefix("xsi");
                this.namespaceDeclaration(xsiPrefix, "http://www.w3.org/2001/XMLSchema-instance");
            }
        }
        return xsiPrefix;
    }

    @Override
    public XPathFragment getTextWrapperFragment() {
        return null;
    }

    protected String getNameForFragment(XPathFragment xPathFragment) {
        String prefix;
        if (!this.hasCustomNamespaceMapper()) {
            return xPathFragment.getShortName();
        }
        if (xPathFragment.getNamespaceURI() != null && !xPathFragment.getNamespaceURI().isEmpty() && (prefix = this.getPrefixForFragment(xPathFragment)) != null && !prefix.isEmpty()) {
            return prefix + ":" + xPathFragment.getLocalName();
        }
        return xPathFragment.getLocalName();
    }

    protected byte[] getPrefixBytes(XPathFragment xPathFragment) {
        if (!this.hasCustomNamespaceMapper()) {
            return xPathFragment.getPrefixBytes();
        }
        String prefix = this.getPrefixForFragment(xPathFragment);
        if (null == prefix || prefix.isEmpty()) {
            return null;
        }
        return prefix.getBytes(Constants.DEFAULT_CHARSET);
    }

    protected String getPrefixForFragment(XPathFragment xPathFragment) {
        if (!this.hasCustomNamespaceMapper) {
            return xPathFragment.getPrefix();
        }
        String uri = xPathFragment.getNamespaceURI();
        if (uri == null || uri.isEmpty()) {
            return "";
        }
        String defaultNamespace = ((NamespaceResolver)this.getNamespaceResolver()).getDefaultNamespaceURI();
        if (defaultNamespace != null && defaultNamespace.equals(uri)) {
            return "";
        }
        String prefix = ((NamespaceResolver)this.getNamespaceResolver()).resolveNamespaceURI(uri);
        if (prefix != null) {
            return prefix;
        }
        Iterator<Namespace> iterator = ((NamespaceResolver)this.getNamespaceResolver()).getNamespaces().iterator();
        while (iterator.hasNext()) {
            Namespace next;
            Namespace ns = next = iterator.next();
            uri = ns.getNamespaceURI();
            prefix = ns.getPrefix();
        }
        return xPathFragment.getPrefix();
    }

    @Override
    public MarshalRecord.CycleDetectionStack<Object> getCycleDetectionStack() {
        return this.cycleDetectionStack;
    }

    private Field convertToXMLField(CoreField field) {
        return (Field)field;
    }

    @Override
    public boolean isWrapperAsCollectionName() {
        return false;
    }

    @Override
    public CoreAttributeGroup getCurrentAttributeGroup() {
        if (this.attributeGroupStack == null || this.attributeGroupStack.isEmpty()) {
            return DEFAULT_ATTRIBUTE_GROUP;
        }
        return this.attributeGroupStack.peek();
    }

    @Override
    public void pushAttributeGroup(CoreAttributeGroup group) {
        if (group == DEFAULT_ATTRIBUTE_GROUP && this.attributeGroupStack == null) {
            return;
        }
        if (this.attributeGroupStack == null) {
            this.attributeGroupStack = new Stack();
        }
        this.attributeGroupStack.push(group);
    }

    @Override
    public void popAttributeGroup() {
        if (this.attributeGroupStack != null) {
            this.attributeGroupStack.pop();
        }
    }

    @Override
    public void flush() {
    }

    static List<String> splitCData(String value) {
        if (value == null) {
            return Collections.emptyList();
        }
        LinkedList<String> parts = new LinkedList<String>();
        int index = -1;
        String remainder = value;
        while (0 <= (index = remainder.indexOf("]]>"))) {
            String part = remainder.substring(0, index + 2);
            parts.add(part);
            remainder = remainder.substring(index + 2);
        }
        parts.add(remainder);
        return parts;
    }
}

