/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.multibroker.raptor.handlers;

import com.sun.messaging.jmq.io.GPacket;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ClusterTakeoverMEInfo;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ClusterTakeoverMEPrepareInfo;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.GPacketHandler;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ProtocolGlobals;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.RaptorProtocol;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;

public class TakeoverMEHandler
extends GPacketHandler {
    private static boolean DEBUG = false;

    public TakeoverMEHandler(RaptorProtocol p) {
        super(p);
    }

    @Override
    public void handle(BrokerAddress sender, GPacket pkt) {
        if (DEBUG) {
            this.logger.log(4, "TakeoverMEHandler");
        }
        if (pkt.getType() == 57) {
            this.handleTakeoverMEPrepare(sender, pkt);
        } else if (pkt.getType() == 58) {
            this.handleTakeoverMEPrepareReply(sender, pkt);
        } else if (pkt.getType() == 59) {
            this.handleTakeoverME(sender, pkt);
        } else if (pkt.getType() == 60) {
            this.handleTakeoverMEReply(sender, pkt);
        } else if (pkt.getType() == 61) {
            this.handleTakeoverMEReplyAck(sender, pkt);
        } else {
            this.logger.log(16, "TakeoverMEHandler Internal error : Cannot handle this packet :" + pkt.toLongString());
        }
    }

    private void handleTakeoverMEPrepare(BrokerAddress sender, GPacket pkt) {
        ClusterTakeoverMEPrepareInfo tme = ClusterTakeoverMEPrepareInfo.newInstance(pkt, this.c);
        try {
            this.p.receivedTakeoverMEPrepare(sender, pkt, tme);
        }
        catch (Exception e) {
            int status = 500;
            String reason = e.getMessage();
            if (!(e instanceof BrokerException)) {
                Object[] args = new String[]{ProtocolGlobals.getPacketTypeDisplayString(pkt.getType()), sender.toString(), e.toString()};
                reason = this.br.getKString("B3269", args);
                this.logger.log(32, reason);
            }
            tme.sendReply(sender, status, reason, null);
        }
    }

    private void handleTakeoverME(BrokerAddress sender, GPacket pkt) {
        ClusterTakeoverMEInfo tme = ClusterTakeoverMEInfo.newInstance(pkt, this.c);
        try {
            this.p.receivedTakeoverME(sender, pkt, tme);
        }
        catch (Exception e) {
            int status = 500;
            String reason = e.getMessage();
            if (!(e instanceof BrokerException)) {
                Object[] args = new String[]{ProtocolGlobals.getPacketTypeDisplayString(pkt.getType()), sender.toString(), e.toString()};
                reason = this.br.getKString("B3269", args);
                this.logger.log(32, reason);
            }
            tme.sendReply(sender, status, reason, null);
        }
    }

    private void handleTakeoverMEPrepareReply(BrokerAddress sender, GPacket pkt) {
        this.p.receivedTakeoverMEPrepareReply(sender, pkt);
    }

    private void handleTakeoverMEReply(BrokerAddress sender, GPacket pkt) {
        this.p.receivedTakeoverMEReply(sender, pkt);
    }

    private void handleTakeoverMEReplyAck(BrokerAddress sender, GPacket pkt) {
        this.p.receivedTakeoverMEReplyAck(sender, pkt);
    }
}

