/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.processor.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;

public final class Objects {
    private Objects() {
    }

    public static boolean areEqual(boolean first, boolean second) {
        return first == second;
    }

    public static boolean areEqual(char first, char second) {
        return first == second;
    }

    public static boolean areEqual(long first, long second) {
        return first == second;
    }

    public static boolean areEqual(float first, float second) {
        return Float.floatToIntBits(first) == Float.floatToIntBits(second);
    }

    public static boolean areEqual(double first, double second) {
        return Double.doubleToLongBits(first) == Double.doubleToLongBits(second);
    }

    public static boolean areEqual(Object first, Object second) {
        return first == null ? second == null : first.equals(second);
    }

    public static <T> T checkNonNull(T ref) {
        if (ref == null) {
            throw new IllegalArgumentException();
        }
        return ref;
    }

    public static <T> T checkNonNull(T ref, String message) {
        if (ref == null) {
            throw new IllegalArgumentException(message);
        }
        return ref;
    }

    public static <T> T checkNonNull(T ref, String message, Object ... args) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format(message, args));
        }
        return ref;
    }

    public static class ToStringBuilder {
        private final List<String> fieldValue = new ArrayList<String>();
        private final String className;

        private ToStringBuilder(String className) {
            this.className = className;
        }

        public static ToStringBuilder of(Class<?> clazz) {
            return new ToStringBuilder(Objects.checkNonNull(clazz.getSimpleName()));
        }

        public static ToStringBuilder of(String className) {
            return new ToStringBuilder(Objects.checkNonNull(className));
        }

        public static ToStringBuilder of(Object self) {
            return ToStringBuilder.of(Objects.checkNonNull(self.getClass()));
        }

        public ToStringBuilder add(Object value) {
            this.fieldValue.add(value == null ? "null" : value.toString());
            return this;
        }

        public ToStringBuilder add(String field, Object value) {
            String result = Objects.checkNonNull(field) + "=" + String.valueOf(value);
            this.fieldValue.add(result);
            return this;
        }

        public String toString() {
            StringBuilder result = new StringBuilder();
            result.append(this.className);
            result.append("{");
            int size = this.fieldValue.size();
            int count = 0;
            for (String s : this.fieldValue) {
                result.append(s);
                if (++count >= size) continue;
                result.append(",");
            }
            return result.append("}").toString();
        }
    }

    public static class HashCodeBuilder {
        private final int seed;
        private int hash;

        private HashCodeBuilder(int seed) {
            this.seed = seed;
            this.hash = 17;
        }

        public static HashCodeBuilder builder() {
            return new HashCodeBuilder(31);
        }

        public static HashCodeBuilder builder(int seed) {
            return new HashCodeBuilder(seed);
        }

        public HashCodeBuilder add(boolean b) {
            this.hash = this.calc() + (b ? 1 : 0);
            return this;
        }

        public HashCodeBuilder add(char c) {
            this.hash = this.calc() + c;
            return this;
        }

        public HashCodeBuilder add(int i) {
            this.hash = this.calc() + i;
            return this;
        }

        public HashCodeBuilder add(long lng) {
            this.hash = this.calc() + (int)(lng ^ lng >>> 32);
            return this;
        }

        public HashCodeBuilder add(float flt) {
            return this.add(Float.floatToIntBits(flt));
        }

        public HashCodeBuilder add(double dbl) {
            return this.add(Double.doubleToLongBits(dbl));
        }

        public HashCodeBuilder add(Object obj) {
            if (obj == null) {
                this.add(0);
            } else if (!obj.getClass().isArray()) {
                this.add(obj.hashCode());
            } else {
                int len = Array.getLength(obj);
                for (int i = 0; i < len; ++i) {
                    Object arrayObj = Array.get(obj, i);
                    this.add(arrayObj);
                }
            }
            return this;
        }

        public int toHashCode() {
            return this.hash;
        }

        public int hashCode() {
            return this.toHashCode();
        }

        public boolean equals(Object obj) {
            return obj == this;
        }

        private int calc() {
            return this.seed * this.hash;
        }
    }
}

