/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.krazo.security;

import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.core.Form;
import jakarta.ws.rs.core.MediaType;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import org.eclipse.krazo.security.FormEntityProvider;

public class DefaultFormEntityProvider
implements FormEntityProvider {
    private static final String DEFAULT_CHARSET = "UTF-8";

    @Override
    public Form getForm(ContainerRequestContext context) throws IOException {
        InputStream is = context.getEntityStream();
        InputStream bufferedStream = is.markSupported() ? is : new BufferedInputStream(is);
        bufferedStream.mark(Integer.MAX_VALUE);
        MediaType contentType = context.getMediaType();
        String charset = (String)contentType.getParameters().get("charset");
        String entity = DefaultFormEntityProvider.toString(bufferedStream, charset != null ? charset : DEFAULT_CHARSET);
        Form form = DefaultFormEntityProvider.parseForm(entity);
        bufferedStream.reset();
        context.setEntityStream(bufferedStream);
        return form;
    }

    private static Form parseForm(String entity) throws UnsupportedEncodingException {
        String[] pairs;
        Form form = new Form();
        for (String pair : pairs = entity.split("&")) {
            int position = pair.indexOf("=");
            if (position == -1) continue;
            String nn = URLDecoder.decode(pair.substring(0, position), DEFAULT_CHARSET);
            String vv = URLDecoder.decode(pair.substring(position + 1), DEFAULT_CHARSET);
            form.param(nn, vv);
        }
        return form;
    }

    private static String toString(InputStream bais, String encoding) throws IOException {
        int character;
        StringBuilder out = new StringBuilder();
        InputStreamReader reader = new InputStreamReader(bais, encoding);
        while ((character = reader.read()) != -1) {
            out.append((char)character);
        }
        return out.toString();
    }
}

