/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.auth.ldap;

import com.sun.messaging.jmq.auth.api.FailedLoginException;
import com.sun.messaging.jmq.auth.api.server.model.UserRepository;
import com.sun.messaging.jmq.auth.jaas.MQGroup;
import com.sun.messaging.jmq.auth.jaas.MQUser;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.util.Password;
import com.sun.messaging.jmq.util.log.Logger;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import javax.naming.AuthenticationException;
import javax.naming.Context;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.security.auth.Refreshable;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginException;

public class LdapUserRepository
implements UserRepository {
    public static final String TYPE = "ldap";
    private static boolean DEBUG = false;
    private static final Logger logger = Globals.getLogger();
    private static final BrokerResources br = Globals.getBrokerResources();
    private String authType;
    private static String INITIAL_CONTEXT_FACTORY = "com.sun.jndi.ldap.LdapCtxFactory";
    private static final int DEFAULT_TIMELIMIT_MILLIS = 180000;
    private static final String DN_USRFORMAT = "dn";
    private static final String PROP_SERVER_SUFFIX = ".server";
    public static final String PROP_BINDDN_SUFFIX = ".principal";
    public static final String PROP_BINDPW_SUFFIX = ".password";
    private static final String PROP_UIDATTR_SUFFIX = ".uidattr";
    private static final String PROP_USRFORMAT_SUFFIX = ".usrformat";
    private static final String PROP_USRFILTER_SUFFIX = ".usrfilter";
    private static final String PROP_BASE_SUFFIX = ".base";
    private static final String PROP_GRPBASE_SUFFIX = ".grpbase";
    private static final String PROP_GIDATTR_SUFFIX = ".gidattr";
    private static final String PROP_MEMATTR_SUFFIX = ".memattr";
    private static final String PROP_GRPFILTER_SUFFIX = ".grpfilter";
    private static final String PROP_GRPSEARCH_SUFFIX = ".grpsearch";
    private static final String PROP_TIMEOUT_SUFFIX = ".timeout";
    private static final String PROP_SSL_SUFFIX = ".ssl.enabled";
    private static final String PROP_SSLFACTORY_SUFFIX = ".ssl.socketfactory";
    private String server = null;
    private String bindDN = null;
    private String bindPW = null;
    private String base = null;
    private LdapName ldapbase = null;
    private String uidattr = null;
    private String usrformat = null;
    private String usrfilter = null;
    private int timelimitMillis = 180000;
    private boolean grpsearch = true;
    private String grpbase = null;
    private String gidattr = null;
    private String memattr = null;
    private String grpfilter = null;
    private String repository = null;
    private boolean sslprotocol = false;
    private String sslfactory = null;

    @Override
    public void open(String authType, Properties authProperties, Refreshable cacheData) throws LoginException {
        String ssl;
        String grpsrch;
        String tlimit;
        this.authType = authType;
        String rep = authProperties.getProperty("imq.authentication." + authType + ".user_repository");
        if (rep == null) {
            throw new LoginException(Globals.getBrokerResources().getKString("B4041", authType));
        }
        this.repository = rep;
        if (!rep.equals(TYPE)) {
            Object[] args = new String[]{rep, TYPE, this.getClass().getName()};
            throw new LoginException(Globals.getBrokerResources().getKString("B4070", args));
        }
        String prefix = "imq.user_repository." + rep;
        this.server = authProperties.getProperty(prefix + PROP_SERVER_SUFFIX);
        if (this.server == null || this.server.trim().equals("")) {
            Object[] args = new String[]{authType, rep, PROP_SERVER_SUFFIX};
            throw new LoginException(Globals.getBrokerResources().getKString("B4064", args));
        }
        this.server = "ldap://" + this.server;
        this.bindDN = authProperties.getProperty(prefix + PROP_BINDDN_SUFFIX);
        if (this.bindDN != null && !this.bindDN.trim().equals("")) {
            boolean setProp;
            this.bindPW = authProperties.getProperty(prefix + PROP_BINDPW_SUFFIX);
            Password pw = null;
            boolean bl = setProp = this.bindPW == null || this.bindPW.equals("");
            for (int retry = 0; (this.bindPW == null || this.bindPW.trim().equals("")) && retry < 5; ++retry) {
                pw = new Password();
                if (pw.echoPassword()) {
                    System.err.println(Globals.getBrokerResources().getString("B2242"));
                }
                System.err.print(Globals.getBrokerResources().getString("B0031", this.bindDN));
                System.err.flush();
                this.bindPW = pw.getPassword();
            }
            if (this.bindPW == null || this.bindPW.trim().equals("")) {
                logger.log(16, "B2078", (Object)this.bindPW);
                this.bindDN = null;
            } else if (setProp) {
                authProperties.put(prefix + PROP_BINDPW_SUFFIX, this.bindPW);
            }
        } else {
            this.bindDN = null;
        }
        this.usrformat = authProperties.getProperty(prefix + PROP_USRFORMAT_SUFFIX);
        if (this.usrformat != null) {
            this.usrformat = this.usrformat.trim();
            if (this.usrformat.equals("")) {
                this.usrformat = null;
            } else if (!this.usrformat.trim().equals(DN_USRFORMAT)) {
                throw new LoginException(Globals.getBrokerResources().getKString("B4293", prefix + PROP_USRFORMAT_SUFFIX, this.usrformat));
            }
        }
        this.base = authProperties.getProperty(prefix + PROP_BASE_SUFFIX);
        if (this.base != null && this.base.trim().equals("")) {
            this.base = null;
        }
        if (!(this.base != null || this.usrformat != null && this.usrformat.equals(DN_USRFORMAT))) {
            Object[] args = new String[]{authType, rep, PROP_BASE_SUFFIX};
            throw new LoginException(Globals.getBrokerResources().getKString("B4064", args));
        }
        this.ldapbase = null;
        if (this.base != null && this.usrformat != null && this.usrformat.equals(DN_USRFORMAT)) {
            try {
                this.ldapbase = new LdapName(this.base);
            }
            catch (Exception e) {
                throw new LoginException(e.toString());
            }
        }
        this.uidattr = authProperties.getProperty(prefix + PROP_UIDATTR_SUFFIX);
        if (this.uidattr == null || this.uidattr.trim().equals("")) {
            Object[] args = new String[]{authType, rep, PROP_UIDATTR_SUFFIX};
            throw new LoginException(Globals.getBrokerResources().getKString("B4064", args));
        }
        this.usrfilter = authProperties.getProperty(prefix + PROP_USRFILTER_SUFFIX);
        if (this.usrfilter != null && this.usrfilter.trim().equals("")) {
            this.usrfilter = null;
        }
        if ((tlimit = authProperties.getProperty(prefix + PROP_TIMEOUT_SUFFIX)) != null) {
            try {
                this.timelimitMillis = Integer.parseInt(tlimit) * 1000;
            }
            catch (NumberFormatException e) {
                this.timelimitMillis = -1;
            }
        }
        if (this.timelimitMillis < 0) {
            this.timelimitMillis = 180000;
        }
        if ((grpsrch = authProperties.getProperty(prefix + PROP_GRPSEARCH_SUFFIX)) != null && grpsrch.equals("false")) {
            this.grpsearch = false;
        }
        if (this.grpsearch) {
            this.grpbase = authProperties.getProperty(prefix + PROP_GRPBASE_SUFFIX);
            if (this.grpbase == null || this.grpbase.trim().equals("")) {
                Object[] args = new String[]{authType, rep, PROP_GRPBASE_SUFFIX};
                throw new LoginException(Globals.getBrokerResources().getKString("B4064", args));
            }
            this.gidattr = authProperties.getProperty(prefix + PROP_GIDATTR_SUFFIX);
            if (this.gidattr == null || this.gidattr.trim().equals("")) {
                Object[] args = new String[]{authType, rep, PROP_GIDATTR_SUFFIX};
                throw new LoginException(Globals.getBrokerResources().getKString("B4064", args));
            }
            this.memattr = authProperties.getProperty(prefix + PROP_MEMATTR_SUFFIX);
            if (this.memattr == null || this.memattr.trim().equals("")) {
                Object[] args = new String[]{authType, rep, PROP_MEMATTR_SUFFIX};
                throw new LoginException(Globals.getBrokerResources().getKString("B4064", args));
            }
            this.grpfilter = authProperties.getProperty(prefix + PROP_GRPFILTER_SUFFIX);
            if (this.grpfilter != null && this.grpfilter.trim().equals("")) {
                this.grpfilter = null;
            }
        }
        if ((ssl = authProperties.getProperty(prefix + PROP_SSL_SUFFIX)) != null && ssl.equals("true")) {
            this.sslprotocol = true;
            ssl = authProperties.getProperty(prefix + PROP_SSLFACTORY_SUFFIX);
            if (ssl != null && !ssl.trim().equals("")) {
                this.sslfactory = ssl.trim();
            }
        }
    }

    @Override
    public Subject findMatch(String user, Object credential, Object extra, String matchType) throws LoginException {
        if (matchType != null && matchType.equals("basic")) {
            return this.jmqbasicFindMatch(user, (String)credential);
        }
        String matchtyp = matchType == null ? "null" : matchType;
        Object[] args = new String[]{matchtyp, this.authType, TYPE, "basic"};
        throw new LoginException(Globals.getBrokerResources().getKString("B4079", args));
    }

    private Subject jmqbasicFindMatch(String user, String userpwd) throws LoginException {
        if (DEBUG) {
            logger.log(8, "Authenticate[basic] " + user + ":" + userpwd + (String)(this.usrformat == null ? ":" : ":usrformat=" + this.usrformat));
        }
        if (userpwd == null || userpwd.trim().equals("")) {
            throw new LoginException(Globals.getBrokerResources().getKString("B4066", user));
        }
        if (user == null || user.trim().equals("")) {
            throw new LoginException(Globals.getBrokerResources().getKString("B4067", user));
        }
        String url = this.server;
        if (DEBUG) {
            logger.log(8, "LDAP server: " + url);
        }
        Hashtable<String, String> env = new Hashtable<String, String>(11);
        env.put("java.naming.factory.initial", INITIAL_CONTEXT_FACTORY);
        env.put("java.naming.provider.url", url);
        env.put("java.naming.referral", "follow");
        if (this.sslprotocol) {
            env.put("java.naming.security.protocol", "ssl");
            if (this.sslfactory != null) {
                env.put("java.naming.ldap.factory.socket", this.sslfactory);
            }
        }
        String dnName = null;
        boolean dnformat = false;
        if (this.usrformat != null && this.usrformat.equals(DN_USRFORMAT)) {
            dnformat = true;
            dnName = user;
            user = this.handleDNusrformat(user);
        } else {
            dnName = this.searchDN(user, env);
        }
        Context ctx = null;
        try {
            if (!dnformat) {
                logger.log(8, br.getKString("B1305", user, dnName));
            } else {
                logger.log(8, br.getKString("B1306", dnName, user));
            }
            env.put("java.naming.security.authentication", "simple");
            env.put("java.naming.security.principal", dnName);
            env.put("java.naming.security.credentials", userpwd);
            try {
                ctx = new InitialDirContext(env);
                ctx.close();
                Subject subject = new Subject();
                subject.getPrincipals().add(new MQUser(user));
                try {
                    this.findGroups(dnName, subject);
                }
                catch (NamingException e) {
                    String emsg = Globals.getBrokerResources().getKString("B4075", user + " [" + dnName + "]");
                    logger.logStack(32, emsg, (Throwable)e);
                    throw new LoginException(emsg + ":" + e.getMessage());
                }
                Subject e = subject;
                return e;
            }
            catch (AuthenticationException e) {
                try {
                    if (DEBUG) {
                        logger.log(8, e.getMessage(), (Throwable)e);
                    }
                    throw new FailedLoginException(e.getMessage());
                }
                catch (Exception e2) {
                    if (e2 instanceof FailedLoginException) {
                        throw (FailedLoginException)e2;
                    }
                    if (e2 instanceof LoginException) {
                        throw (LoginException)e2;
                    }
                    String emsg = null;
                    emsg = e2 instanceof NamingException ? ((NamingException)e2).toString(true) : e2.toString();
                    logger.logStack(32, emsg, (Throwable)e2);
                    throw new LoginException(emsg);
                }
            }
        }
        finally {
            try {
                if (ctx != null) {
                    ctx.close();
                }
            }
            catch (NamingException namingException) {}
        }
    }

    private String searchDN(String user, Hashtable env) throws LoginException {
        if (this.bindDN != null && this.bindPW != null) {
            env.put("java.naming.security.authentication", "simple");
            env.put("java.naming.security.principal", this.bindDN);
            env.put("java.naming.security.credentials", this.bindPW);
        }
        InitialDirContext ctx = null;
        try {
            ctx = new InitialDirContext(env);
            SearchControls ctls = new SearchControls();
            ctls.setReturningAttributes(new String[]{this.uidattr});
            ctls.setSearchScope(2);
            ctls.setTimeLimit(this.timelimitMillis);
            String filter = this.uidattr + "=" + user;
            if (this.usrfilter != null) {
                filter = "(&(" + this.usrfilter + ")(" + filter + "))";
            }
            if (DEBUG) {
                logger.log(8, "filter:" + filter + ":");
            }
            NamingEnumeration<SearchResult> enm = ctx.search(this.base, filter, ctls);
            int count = 0;
            String dnName = null;
            while (enm.hasMore()) {
                if (count != 0) {
                    enm.close();
                    throw new NamingException(Globals.getBrokerResources().getKString("B4065", user, this.repository));
                }
                SearchResult sr = enm.next();
                if (!sr.isRelative()) {
                    throw new NamingException(Globals.getBrokerResources().getKString("B4071", sr.getName()));
                }
                Attributes attrs = sr.getAttributes();
                if (attrs == null) {
                    throw new NamingException(Globals.getBrokerResources().getKString("B4068", user, this.repository) + "[SearchResult.getAttributes()=null]");
                }
                Attribute attr = attrs.get(this.uidattr);
                if (attr == null) {
                    throw new NamingException(Globals.getBrokerResources().getKString("B4068", user, this.repository) + "[Attribute.get(" + this.uidattr + ")=null]");
                }
                if (!user.equals(attr.get())) {
                    throw new FailedLoginException(Globals.getBrokerResources().getKString("B4068", user, this.repository) + "[Attribute.get(" + this.uidattr + ")=" + String.valueOf(attr) + "]");
                }
                dnName = sr.getName() + ", " + this.base;
                ++count;
            }
            ctx.close();
            if (dnName == null) {
                throw new FailedLoginException(Globals.getBrokerResources().getKString("B4068", user, this.repository));
            }
            if (DEBUG) {
                logger.log(8, "dn=" + dnName);
            }
            String string = dnName;
            return string;
        }
        catch (Exception e) {
            if (e instanceof FailedLoginException) {
                throw (FailedLoginException)e;
            }
            String emsg = null;
            emsg = e instanceof NamingException ? ((NamingException)e).toString(true) : e.toString();
            logger.logStack(32, emsg, (Throwable)e);
            throw new LoginException(emsg);
        }
        finally {
            try {
                if (ctx != null) {
                    ctx.close();
                }
            }
            catch (NamingException namingException) {}
        }
    }

    private String handleDNusrformat(String user) throws LoginException {
        String dnuser = user;
        try {
            LdapName ldapn = new LdapName(user);
            if (this.ldapbase != null && !ldapn.startsWith(this.ldapbase)) {
                throw new LoginException(br.getKString("B4296", user, this.ldapbase.toString()));
            }
            Iterator<Rdn> itr = ldapn.getRdns().iterator();
            Attributes attrs = null;
            Attribute attr = null;
            Object attrv = null;
            while (itr.hasNext()) {
                attrs = itr.next().toAttributes();
                attr = attrs.get(this.uidattr);
                if (attr == null) continue;
                attrv = attr.get(0);
                if (attrv == null) break;
                if (!(attrv instanceof String)) {
                    throw new LoginException(br.getKString("B4295", this.uidattr + "[" + dnuser + "]", attrv.getClass().getName()));
                }
                if (((String)attrv).trim().equals("")) break;
                return (String)attrv;
            }
            throw new LoginException(br.getKString("B4294", this.uidattr, dnuser));
        }
        catch (Exception e) {
            if (e instanceof LoginException) {
                throw (LoginException)e;
            }
            String emsg = null;
            emsg = e instanceof NamingException ? ((NamingException)e).toString(true) : e.toString();
            logger.logStack(32, emsg, (Throwable)e);
            throw new LoginException(e.getMessage());
        }
    }

    private void findGroups(String dn, Subject subject) throws NamingException {
        if (!this.grpsearch) {
            return;
        }
        Hashtable<String, String> env = new Hashtable<String, String>(11);
        env.put("java.naming.factory.initial", INITIAL_CONTEXT_FACTORY);
        env.put("java.naming.provider.url", this.server);
        env.put("java.naming.referral", "follow");
        if (this.bindDN != null) {
            env.put("java.naming.security.authentication", "simple");
            env.put("java.naming.security.principal", this.bindDN);
            env.put("java.naming.security.credentials", this.bindPW);
        }
        if (this.sslprotocol) {
            env.put("java.naming.security.protocol", "ssl");
            if (this.sslfactory != null) {
                env.put("java.naming.ldap.factory.socket", this.sslfactory);
            }
        }
        try (InitialDirContext ctx = null;){
            ctx = new InitialDirContext(env);
            SearchControls ctls = new SearchControls();
            String[] attr = new String[]{this.gidattr};
            ctls.setReturningAttributes(attr);
            ctls.setSearchScope(1);
            ctls.setTimeLimit(this.timelimitMillis);
            String filter = this.memattr + "=" + dn;
            if (this.grpfilter != null) {
                filter = "(&(" + this.grpfilter + ")(" + filter + "))";
            }
            if (DEBUG) {
                logger.log(8, "filter:" + filter + ":");
            }
            NamingEnumeration<SearchResult> em = ctx.search(this.grpbase, filter, ctls);
            SearchResult sr = null;
            Attributes attrs = null;
            Attribute grp = null;
            String group = null;
            while (em.hasMore()) {
                sr = em.next();
                if (!sr.isRelative()) {
                    throw new NamingException(Globals.getBrokerResources().getKString("B4071", sr.getName()));
                }
                attrs = sr.getAttributes();
                if (attrs == null || (grp = attrs.get(this.gidattr)) == null || (group = (String)grp.get(0)) == null || group.equals("")) continue;
                if (DEBUG) {
                    logger.log(8, "found group:" + group + ":");
                }
                final Subject tempSubject = subject;
                final String tempGroup = group;
                AccessController.doPrivileged(new PrivilegedAction<Object>(this){

                    @Override
                    public Object run() {
                        tempSubject.getPrincipals().add(new MQGroup(tempGroup));
                        return null;
                    }
                });
            }
        }
    }

    @Override
    public Refreshable getCacheData() {
        return null;
    }

    @Override
    public void close() throws LoginException {
    }
}

