/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.jms.util;

import com.sun.appserv.connectors.internal.api.ConnectorRuntimeException;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.SystemProperty;
import com.sun.enterprise.connectors.jms.JMSLoggerInfo;
import com.sun.enterprise.connectors.jms.config.JmsService;
import com.sun.enterprise.connectors.jms.inflow.MdbContainerProps;
import com.sun.enterprise.connectors.jms.system.MQAddressList;
import com.sun.enterprise.deployment.ConnectorConfigProperty;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.enterprise.util.zip.ZipFile;
import com.sun.enterprise.util.zip.ZipFileException;
import java.io.File;
import java.io.FileInputStream;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.ejb.config.MdbContainer;
import org.glassfish.embeddable.GlassFishVariable;
import org.glassfish.internal.api.Globals;
import org.glassfish.internal.api.RelativePathResolver;
import org.jvnet.hk2.config.types.Property;

public class JmsRaUtil {
    private static final String MQ_RAR = "imqjmsra.rar";
    private static final Path SYSTEM_APP_DIR = Path.of("lib", "install", "applications");
    private static final Path MQ_RAR_MANIFEST = Path.of("META-INF", "MANIFEST.MF");
    private static final String MANIFEST_TAG = "Implementation-Version";
    private static final String propName_reconnect_delay_in_seconds = "reconnect-delay-in-seconds";
    private static final String propName_reconnect_max_retries = "reconnect-max-retries";
    private static final String propName_reconnect_enabled = "reconnect-enabled";
    private static final int DEFAULT_RECONNECT_DELAY = 60;
    private static final int DEFAULT_RECONNECT_RETRIES = 60;
    private static final String propName_cmt_max_runtime_exceptions = "cmt-max-runtime-exceptions";
    private static final int DEFAULT_CMT_MAX_RUNTIME_EXCEPTIONS = 1;
    private static final String ENABLE_AUTO_CLUSTERING = "com.sun.enterprise.connectors.system.enableAutoClustering";
    private int cmtMaxRuntimeExceptions = 1;
    private int reconnectDelayInSeconds = 60;
    private int reconnectMaxRetries = 60;
    private boolean reconnectEnabled;
    JmsService js;
    MQAddressList list;
    private static final Logger _logger = JMSLoggerInfo.getLogger();

    public JmsRaUtil() throws ConnectorRuntimeException {
        this(null);
    }

    public JmsRaUtil(JmsService js) throws ConnectorRuntimeException {
        try {
            this.js = js != null ? js : (JmsService)Globals.get(JmsService.class);
            this.list = new MQAddressList(this.js);
        }
        catch (Exception ce) {
            throw JmsRaUtil.handleException(ce);
        }
    }

    public void setupAddressList() throws ConnectorRuntimeException {
        try {
            this.list.setup();
        }
        catch (Exception e) {
            throw JmsRaUtil.handleException(e);
        }
    }

    public String getUrl() {
        try {
            return this.list.toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean isClustered(List clusters, String instanceName) {
        return JmsRaUtil.enableClustering() && JmsRaUtil.isServerClustered(clusters, instanceName);
    }

    public static boolean isServerClustered(List clusters, String instanceName) {
        return JmsRaUtil.getClusterForServer(clusters, instanceName) != null;
    }

    public static Cluster getClusterForServer(List clusters, String instanceName) {
        for (Object cluster : clusters) {
            List servers = ((Cluster)cluster).getInstances();
            for (Object server : servers) {
                if (!((Server)server).getName().equals(instanceName)) continue;
                return (Cluster)cluster;
            }
        }
        return null;
    }

    private static boolean enableClustering() {
        try {
            String enablecluster = System.getProperty(ENABLE_AUTO_CLUSTERING);
            _logger.log(Level.FINE, "Sun MQ Auto cluster system property " + enablecluster);
            if (enablecluster != null && enablecluster.trim().equals("false")) {
                _logger.log(Level.FINE, "Disabling Sun MQ Auto Clustering");
                return false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        _logger.log(Level.FINE, "Enabling Sun MQ Auto Clustering");
        return true;
    }

    public String getJMSServiceType() {
        return this.js.getType();
    }

    public MQAddressList getUrlList() {
        return this.list;
    }

    public boolean getReconnectEnabled() {
        return Boolean.parseBoolean(this.js.getReconnectEnabled());
    }

    public String getReconnectInterval() {
        return this.js.getReconnectIntervalInSeconds();
    }

    public String getReconnectAttempts() {
        return this.js.getReconnectAttempts();
    }

    public String getAddressListIterations() {
        return this.js.getAddresslistIterations();
    }

    public String getAddressListBehaviour() {
        return this.js.getAddresslistBehavior();
    }

    public void setMdbContainerProperties() {
        List props;
        MdbContainer mdbc;
        block18: {
            mdbc = null;
            try {
                mdbc = (MdbContainer)Globals.get(MdbContainer.class);
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "AS-JMS-CORE-00023", new Object[]{e.getMessage()});
                if (!_logger.isLoggable(Level.FINE)) break block18;
                _logger.log(Level.FINE, e.getClass().getName(), e);
            }
        }
        if (mdbc != null && (props = mdbc.getProperty()) != null) {
            for (Object prop : props) {
                String name;
                Property p = (Property)prop;
                if (p == null || (name = p.getName()) == null) continue;
                try {
                    if (name.equals(propName_reconnect_enabled)) {
                        if (p.getValue() == null) continue;
                        this.reconnectEnabled = Boolean.parseBoolean(p.getValue());
                        continue;
                    }
                    if (name.equals(propName_reconnect_delay_in_seconds)) {
                        try {
                            this.reconnectDelayInSeconds = Integer.parseInt(p.getValue());
                        }
                        catch (Exception e) {
                            _logger.log(Level.WARNING, "AS-JMS-CORE-00023", new Object[]{e.getMessage()});
                        }
                        continue;
                    }
                    if (name.equals(propName_reconnect_max_retries)) {
                        try {
                            this.reconnectMaxRetries = Integer.parseInt(p.getValue());
                        }
                        catch (Exception e) {
                            _logger.log(Level.WARNING, "AS-JMS-CORE-00023", new Object[]{e.getMessage()});
                        }
                        continue;
                    }
                    if (!name.equals(propName_cmt_max_runtime_exceptions)) continue;
                    try {
                        this.cmtMaxRuntimeExceptions = Integer.parseInt(p.getValue());
                    }
                    catch (Exception e) {
                        _logger.log(Level.WARNING, "AS-JMS-CORE-00023", new Object[]{e.getMessage()});
                    }
                }
                catch (Exception e) {
                    _logger.log(Level.WARNING, "AS-JMS-CORE-00023", new Object[]{e.getMessage()});
                    if (!_logger.isLoggable(Level.FINE)) continue;
                    _logger.log(Level.FINE, e.getClass().getName(), e);
                }
            }
        }
        if (this.reconnectDelayInSeconds < 0) {
            this.reconnectDelayInSeconds = 60;
        }
        if (this.reconnectMaxRetries < 0) {
            this.reconnectMaxRetries = 60;
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "reconnect-delay-in-seconds=" + this.reconnectDelayInSeconds + ", reconnect-max-retries=" + this.reconnectMaxRetries + ", reconnect-enabled=" + this.reconnectEnabled);
        }
        MdbContainerProps.setReconnectDelay(this.reconnectDelayInSeconds);
        MdbContainerProps.setReconnectMaxRetries(this.reconnectMaxRetries);
        MdbContainerProps.setReconnectEnabled(this.reconnectEnabled);
        MdbContainerProps.setMaxRuntimeExceptions(this.cmtMaxRuntimeExceptions);
    }

    public void configureDescriptor(ConnectorDescriptor cd) {
        Object[] envProps;
        for (Object envProp2 : envProps = cd.getConfigProperties().toArray()) {
            String userValue;
            ConnectorConfigProperty envProp = (ConnectorConfigProperty)envProp2;
            String name = envProp.getName();
            if (!name.equals("ConnectionURL") || (userValue = this.getUrl()) == null) continue;
            cd.removeConfigProperty(envProp);
            cd.addConfigProperty(new ConnectorConfigProperty(name, userValue, userValue, envProp.getType()));
        }
    }

    public void upgradeIfNecessary() {
        String deployedMqVersion;
        String installedMqVersion;
        String imqLibPath = System.getProperty(GlassFishVariable.IMQ_LIB.getSystemPropertyName());
        if (imqLibPath == null) {
            _logger.log(Level.SEVERE, "IMQ lib root system property not set: " + GlassFishVariable.IMQ_LIB.getSystemPropertyName());
            return;
        }
        String installRoot = System.getProperty(GlassFishVariable.INSTALL_ROOT.getSystemPropertyName());
        if (installRoot == null) {
            _logger.log(Level.SEVERE, "Install root system property not set: " + GlassFishVariable.INSTALL_ROOT.getSystemPropertyName());
            return;
        }
        Path imqLib = new File(imqLibPath).toPath();
        Path deployedDir = new File(installRoot).toPath().resolve(SYSTEM_APP_DIR).resolve("jmsra");
        File imqLibRar = imqLib.resolve(MQ_RAR).toFile();
        try {
            installedMqVersion = this.getInstalledMqVersion(imqLibRar);
            _logger.log(Level.FINE, "installedMQVersion: {0}", installedMqVersion);
            deployedMqVersion = this.getDeployedMqVersion(deployedDir);
            _logger.log(Level.FINE, "deployedMQVersion: {0}", deployedMqVersion);
        }
        catch (Exception e) {
            throw new IllegalStateException("Upgrade failed - could not resolve deployed and installed version.", e);
        }
        if (installedMqVersion == null) {
            _logger.log(Level.INFO, "No JMS RA installation RAR found on path {0}. Nothing for upgrade.", imqLibRar);
            return;
        }
        if (!Objects.equals(installedMqVersion, deployedMqVersion)) {
            try {
                _logger.log(Level.INFO, "AS-JMS-CORE-00024", new Object[]{deployedMqVersion, installedMqVersion});
                FileUtils.whack((File)deployedDir.toFile());
                ZipFile rarFile = new ZipFile(imqLibRar, deployedDir.toFile());
                rarFile.explode();
                _logger.log(Level.INFO, "AS-JMS-CORE-00025");
            }
            catch (ZipFileException e) {
                _logger.log(Level.SEVERE, "Upgrading a MQ resource adapter failed", e);
            }
        }
    }

    private String getInstalledMqVersion(File imqLibRar) throws Exception {
        if (!imqLibRar.exists()) {
            return null;
        }
        _logger.log(Level.FINEST, "Found installation JMS RAR: {0}", imqLibRar);
        try (JarFile jFile = new JarFile(imqLibRar);){
            Manifest mf = jFile.getManifest();
            String string = mf.getMainAttributes().getValue(MANIFEST_TAG);
            return string;
        }
    }

    private String getDeployedMqVersion(Path deployedDir) throws Exception {
        File manifestFile = deployedDir.resolve(MQ_RAR_MANIFEST).toFile();
        if (!manifestFile.exists()) {
            return null;
        }
        _logger.log(Level.FINEST, "Found deployed JMS RA Manifest file {0}", manifestFile);
        try (FileInputStream fis = new FileInputStream(manifestFile);){
            Manifest mf = new Manifest(fis);
            String string = mf.getMainAttributes().getValue(MANIFEST_TAG);
            return string;
        }
    }

    private static ConnectorRuntimeException handleException(Exception e) {
        ConnectorRuntimeException cre = new ConnectorRuntimeException(e.getMessage());
        cre.initCause((Throwable)e);
        return cre;
    }

    public static String getJMSPropertyValue(Server as) {
        SystemProperty sp = as.getSystemProperty("JMS_PROVIDER_PORT");
        if (sp != null) {
            return sp.getValue();
        }
        Cluster cluster = as.getCluster();
        if (cluster != null && (sp = cluster.getSystemProperty("JMS_PROVIDER_PORT")) != null) {
            return sp.getValue();
        }
        Config config = as.getConfig();
        if (config != null) {
            sp = config.getSystemProperty("JMS_PROVIDER_PORT");
        }
        if (sp != null) {
            return sp.getValue();
        }
        return null;
    }

    public static String getUnAliasedPwd(String alias) {
        try {
            String unalisedPwd = RelativePathResolver.getRealPasswordFromAlias((String)alias);
            return unalisedPwd == null || unalisedPwd.isEmpty() ? alias : unalisedPwd;
        }
        catch (Exception e) {
            _logger.log(Level.WARNING, "Failed to unalias password.", e);
            return alias;
        }
    }
}

