/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.sqlstore;

import com.sun.jdo.api.persistence.support.JDOException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Properties;
import java.util.ResourceBundle;
import org.glassfish.persistence.common.I18NHelper;

public class RuntimeVersion {
    private static Properties _properties = new Properties();
    private static final ResourceBundle vendor_info = I18NHelper.loadBundle(RuntimeVersion.class);
    private static String product_version = "product.version.number";
    private static String build_time = "product.build.time";
    private static String runtime_version = "runtime.version.number";
    private static String vendor_name = "VendorName";
    private static String version_number = "VersionNumber";
    private static String vendor = I18NHelper.getMessage((ResourceBundle)vendor_info, (String)"vendor");

    public static void main(String[] args) {
        if (args == null || args.length == 0 || args.length == 1 && args[0].equals("-version")) {
            RuntimeVersion rt = new RuntimeVersion();
            RuntimeVersion.loadProperties("/com/sun/jdo/spi/persistence/support/sqlstore/sys.properties");
            System.out.println(RuntimeVersion.parse_version());
        }
        System.exit(0);
    }

    public RuntimeVersion() {
    }

    public RuntimeVersion(String fileName) {
        RuntimeVersion.loadProperties(fileName);
    }

    public static void loadProperties(String fileName) {
        try {
            InputStream in = RuntimeVersion.class.getResourceAsStream(fileName);
            if (in == null) {
                throw new FileNotFoundException(fileName);
            }
            _properties.load(in);
            in.close();
        }
        catch (IOException e) {
            throw new JDOException(null, (Exception)e);
        }
    }

    public static Properties getVendorProperties(String fileName) {
        RuntimeVersion.loadProperties(fileName);
        return RuntimeVersion.getVendorProperties();
    }

    public static Properties getVendorProperties() {
        if (_properties == null) {
            return null;
        }
        Properties _vendorProperties = new Properties();
        _vendorProperties.setProperty(vendor_name, vendor);
        _vendorProperties.setProperty(version_number, RuntimeVersion.parse_version());
        return _vendorProperties;
    }

    private static String parse_version() {
        if (_properties == null) {
            return null;
        }
        String majorVersion = _properties.getProperty(product_version);
        String minorVersion = _properties.getProperty(runtime_version);
        String buildTime = _properties.getProperty(build_time);
        String s = null;
        try {
            DateFormat dateFormatter = DateFormat.getDateTimeInstance();
            SimpleDateFormat propertyFormat = new SimpleDateFormat("MM/dd/yy hh:mm:ss");
            s = dateFormatter.format(propertyFormat.parse(buildTime));
        }
        catch (Exception e) {
            s = "";
        }
        return I18NHelper.getMessage((ResourceBundle)vendor_info, (String)"fullVersion", (Object[])new Object[]{majorVersion, minorVersion, s});
    }
}

