/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.common;

import com.sun.enterprise.util.LocalStringManagerImpl;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.glassfish.api.ActionReport;

public abstract class ActionReporter
extends ActionReport {
    public static final String EOL_MARKER = "%%%EOL%%%";
    private static final long serialVersionUID = -472074342932691854L;
    private Throwable exception;
    private String actionDescription;
    private ActionReport.ExitCode exitCode = ActionReport.ExitCode.SUCCESS;
    private final List<ActionReporter> subActions = Collections.synchronizedList(new ArrayList());

    public void setFailure() {
        this.setActionExitCode(ActionReport.ExitCode.FAILURE);
    }

    public boolean isFailure() {
        return this.getActionExitCode() == ActionReport.ExitCode.FAILURE;
    }

    public void setWarning() {
        this.setActionExitCode(ActionReport.ExitCode.WARNING);
    }

    public boolean isWarning() {
        return this.getActionExitCode() == ActionReport.ExitCode.WARNING;
    }

    public boolean isSuccess() {
        return this.getActionExitCode() == ActionReport.ExitCode.SUCCESS;
    }

    public void setSuccess() {
        this.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }

    public final void setActionDescription(String message) {
        this.actionDescription = message;
    }

    public final String getActionDescription() {
        return this.actionDescription;
    }

    public final void setFailureCause(Throwable t) {
        this.exception = t;
    }

    public final Throwable getFailureCause() {
        return this.exception;
    }

    public final ActionReport addSubActionsReport() {
        ActionReporter subAction;
        try {
            subAction = (ActionReporter)((Object)((Object)((Object)this)).getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (ReflectiveOperationException ex) {
            throw new IllegalStateException("Failed to create subAction of type " + ((Object)((Object)this)).getClass().getName(), ex);
        }
        this.subActions.add(subAction);
        return subAction;
    }

    public final List<ActionReporter> getSubActionsReport() {
        return this.subActions;
    }

    public final void setActionExitCode(ActionReport.ExitCode exitCode) {
        this.exitCode = exitCode;
    }

    public final ActionReport.ExitCode getActionExitCode() {
        return this.exitCode;
    }

    public String getContentType() {
        return "text/html; charset=utf-8";
    }

    public void getCombinedMessages(ActionReporter aReport, StringBuilder sb) {
        String failMsg;
        if (aReport == null || sb == null) {
            return;
        }
        String mainMsg = "";
        if (aReport.getMessage() != null && !aReport.getMessage().isEmpty()) {
            LocalStringManagerImpl localStrings;
            mainMsg = aReport.getMessage();
            String format = "{0}";
            if (ActionReport.ExitCode.WARNING.equals((Object)aReport.getActionExitCode())) {
                localStrings = new LocalStringManagerImpl(ActionReporter.class);
                format = localStrings.getLocalString("flag.message.as.warning", "Warning: {0}");
            }
            if (ActionReport.ExitCode.FAILURE.equals((Object)aReport.getActionExitCode())) {
                localStrings = new LocalStringManagerImpl(ActionReporter.class);
                format = localStrings.getLocalString("flag.message.as.failure", "Failure: {0}");
            }
            if (sb.length() > 0) {
                sb.append(EOL_MARKER);
            }
            sb.append(MessageFormat.format(format, mainMsg));
        }
        if (aReport.getFailureCause() != null && aReport.getFailureCause().getMessage() != null && !aReport.getFailureCause().getMessage().isEmpty() && !(failMsg = aReport.getFailureCause().getMessage()).equals(mainMsg)) {
            if (sb.length() > 0) {
                sb.append(EOL_MARKER);
            }
            sb.append(failMsg);
        }
        for (ActionReporter sub : aReport.getSubActionsReport()) {
            this.getCombinedMessages(sub, sb);
        }
    }

    public boolean hasSuccesses() {
        return ActionReporter.has(this, ActionReport.ExitCode.SUCCESS);
    }

    public boolean hasWarnings() {
        return ActionReporter.has(this, ActionReport.ExitCode.WARNING);
    }

    public boolean hasFailures() {
        return ActionReporter.has(this, ActionReport.ExitCode.FAILURE);
    }

    private static boolean has(ActionReporter reporter, ActionReport.ExitCode value) {
        if (reporter.getActionExitCode() != null && reporter.getActionExitCode().equals((Object)value)) {
            return true;
        }
        LinkedList<ActionReporter> workingCopy = new LinkedList<ActionReporter>();
        workingCopy.addAll(reporter.getSubActionsReport());
        while (!workingCopy.isEmpty()) {
            ActionReporter lar = (ActionReporter)((Object)workingCopy.remove());
            ActionReport.ExitCode ec = lar.getActionExitCode();
            if (ec != null && ec.equals((Object)value)) {
                return true;
            }
            workingCopy.addAll(lar.getSubActionsReport());
        }
        return false;
    }
}

