/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.progress;

import com.sun.enterprise.util.StringUtils;
import java.io.Serializable;
import java.util.Date;
import org.glassfish.api.admin.AdminCommandEventBroker;
import org.glassfish.api.admin.CommandProgress;
import org.glassfish.api.admin.progress.ProgressStatusBase;
import org.glassfish.api.admin.progress.ProgressStatusEvent;
import org.glassfish.api.admin.progress.ProgressStatusEventCreateChild;
import org.glassfish.api.admin.progress.ProgressStatusEventProgress;
import org.glassfish.api.admin.progress.ProgressStatusImpl;
import org.glassfish.api.admin.progress.ProgressStatusMessage;
import org.glassfish.api.admin.progress.ProgressStatusMirroringImpl;

public class CommandProgressImpl
extends ProgressStatusImpl
implements CommandProgress,
Serializable {
    private static final long serialVersionUID = 1L;
    private LastChangedMessage lastMessage;
    private Date startTime = new Date();
    private Date endTime;
    private transient AdminCommandEventBroker eventBroker;
    private boolean spinner = false;

    public CommandProgressImpl(String name, String id) {
        super(name, -1, null, id);
    }

    protected synchronized void fireEvent(ProgressStatusEvent event) {
        ProgressStatusMessage msgEvent;
        if (event == null) {
            return;
        }
        if (event instanceof ProgressStatusMessage && StringUtils.ok((String)(msgEvent = (ProgressStatusMessage)event).getMessage())) {
            this.lastMessage = new LastChangedMessage(msgEvent.getSourceId(), msgEvent.getMessage());
        }
        if (event instanceof ProgressStatusEventProgress) {
            this.spinner = ((ProgressStatusEventProgress)event).isSpinner();
        }
        if (this.eventBroker != null) {
            this.eventBroker.fireEvent("ProgressStatus/change", (Object)event);
        }
    }

    public void setEventBroker(AdminCommandEventBroker eventBroker) {
        this.eventBroker = eventBroker;
        if (eventBroker != null) {
            eventBroker.fireEvent("ProgressStatus/state", (Object)new CommandProgressImpl(this.name, this.id));
        }
    }

    public synchronized ProgressStatusMirroringImpl createMirroringChild(int allocatedSteps) {
        this.allocateStapsForChildProcess(allocatedSteps);
        String childId = (this.id == null ? "" : this.id) + "." + (this.children.size() + 1);
        ProgressStatusMirroringImpl result = new ProgressStatusMirroringImpl(null, (ProgressStatusBase)this, childId);
        this.children.add(new ProgressStatusBase.ChildProgressStatus(allocatedSteps, (ProgressStatusBase)result));
        this.fireEvent((ProgressStatusEvent)new ProgressStatusEventCreateChild(this.id, null, result.getId(), allocatedSteps, -1));
        return result;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getLastMessage() {
        if (this.lastMessage != null) {
            StringBuilder result = new StringBuilder();
            result.append(this.lastMessage.getContextString());
            if (result.length() > 0) {
                result.append(": ");
            }
            result.append(this.lastMessage.getMessage());
            return result.toString();
        }
        return null;
    }

    public void complete() {
        this.complete(null);
    }

    public void complete(String message) {
        this.endTime = new Date();
        super.complete(message);
    }

    public boolean isSpinnerActive() {
        return this.spinner;
    }

    public class LastChangedMessage
    implements ProgressStatusMessage,
    Serializable {
        private String sourceId;
        private String message;
        private String contextString;

        private LastChangedMessage(String sourceId, String message) {
            this.sourceId = sourceId;
            if (message != null && message.isEmpty()) {
                message = null;
            }
            this.message = message;
        }

        public String getMessage() {
            return this.message;
        }

        public String getSourceId() {
            return this.sourceId;
        }

        public String getContextString() {
            if (this.contextString == null) {
                ProgressStatusBase parent;
                StringBuilder result = new StringBuilder();
                ProgressStatusBase fnd = CommandProgressImpl.this.findById(this.sourceId);
                if (StringUtils.ok((String)fnd.getName())) {
                    result.append(fnd.getName());
                }
                while ((parent = fnd.getParrent()) != null) {
                    if (StringUtils.ok((String)parent.getName())) {
                        if (result.length() > 0) {
                            result.insert(0, '.');
                        }
                        result.insert(0, parent.getName());
                    }
                    fnd = parent;
                }
                this.contextString = result.toString();
            }
            return this.contextString;
        }
    }
}

