/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.shared.common.drda;

import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Properties;
import javax.net.SocketFactory;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class NaiveTrustManager
implements X509TrustManager {
    public static final String SSL_KEYSTORE = "javax.net.ssl.keyStore";
    public static final String SSL_KEYSTORE_PASSWORD = "javax.net.ssl.keyStorePassword";
    private static TrustManager[] thisManager = null;

    private NaiveTrustManager() {
    }

    public static SocketFactory getSocketFactory(Properties properties) throws NoSuchAlgorithmException, KeyManagementException, NoSuchProviderException, KeyStoreException, UnrecoverableKeyException, CertificateException, IOException {
        SSLContext sSLContext;
        if (thisManager == null) {
            thisManager = new TrustManager[]{new NaiveTrustManager()};
        }
        if ((sSLContext = SSLContext.getInstance("TLS")).getProvider().getName().equals("SunJSSE") && properties.getProperty(SSL_KEYSTORE) != null && properties.getProperty(SSL_KEYSTORE_PASSWORD) != null) {
            String string = properties.getProperty(SSL_KEYSTORE);
            String string2 = properties.getProperty(SSL_KEYSTORE_PASSWORD);
            KeyStore keyStore = KeyStore.getInstance("JKS");
            keyStore.load(new FileInputStream(string), string2.toCharArray());
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("SunX509", "SunJSSE");
            keyManagerFactory.init(keyStore, string2.toCharArray());
            sSLContext.init(keyManagerFactory.getKeyManagers(), thisManager, null);
        } else {
            sSLContext.init(null, thisManager, null);
        }
        return sSLContext.getSocketFactory();
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        throw new CertificateException();
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return new X509Certificate[0];
    }
}

