/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc;

import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.FilterReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.sql.SQLException;
import org.apache.derby.iapi.jdbc.CharacterStreamDescriptor;
import org.apache.derby.iapi.util.UTF8Util;
import org.apache.derby.impl.jdbc.ConnectionChild;
import org.apache.derby.impl.jdbc.EmbedResultSet;
import org.apache.derby.impl.jdbc.InternalClob;
import org.apache.derby.impl.jdbc.PositionedStoreStream;
import org.apache.derby.impl.jdbc.UTF8Reader;
import org.apache.derby.impl.jdbc.Util;
import org.apache.derby.shared.common.error.StandardException;

final class StoreStreamClob
implements InternalClob {
    private volatile boolean released = false;
    private final PositionedStoreStream positionedStoreStream;
    private CharacterStreamDescriptor csd;
    private final ConnectionChild conChild;
    private final Object synchronizationObject;
    private UTF8Reader internalReader;
    private FilterReader unclosableInternalReader;

    public StoreStreamClob(CharacterStreamDescriptor characterStreamDescriptor, ConnectionChild connectionChild) throws StandardException {
        try {
            this.positionedStoreStream = new PositionedStoreStream(characterStreamDescriptor.getStream());
        }
        catch (StandardException standardException) {
            if (standardException.getMessageId().equals("40XD0")) {
                throw StandardException.newException("XJ073.S", new Object[0]);
            }
            throw standardException;
        }
        catch (IOException iOException) {
            throw StandardException.newException("XCL30.S", iOException, "CLOB");
        }
        this.conChild = connectionChild;
        this.synchronizationObject = connectionChild.getConnectionSynchronization();
        this.csd = new CharacterStreamDescriptor.Builder().copyState(characterStreamDescriptor).stream(this.positionedStoreStream).positionAware(true).curBytePos(0L).curCharPos(0L).build();
    }

    @Override
    public void release() {
        if (!this.released) {
            if (this.internalReader != null) {
                this.internalReader.close();
            }
            this.positionedStoreStream.closeStream();
            this.released = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getCharLength() throws SQLException {
        this.checkIfValid();
        if (this.csd.getCharLength() == 0L) {
            long l = 0L;
            Object object = this.synchronizationObject;
            synchronized (object) {
                this.conChild.setupContextStack();
                try {
                    l = UTF8Util.skipUntilEOF(new BufferedInputStream(this.getRawByteStream()));
                }
                catch (Throwable throwable) {
                    throw StoreStreamClob.noStateChangeLOB(throwable);
                }
                finally {
                    ConnectionChild.restoreIntrFlagIfSeen(true, this.conChild.getEmbedConnection());
                    this.conChild.restoreContextStack();
                }
            }
            this.csd = new CharacterStreamDescriptor.Builder().copyState(this.csd).charLength(l).build();
        }
        return this.csd.getCharLength();
    }

    @Override
    public long getCharLengthIfKnown() {
        this.checkIfValid();
        return this.csd.getCharLength() == 0L ? -1L : this.csd.getCharLength();
    }

    @Override
    public InputStream getRawByteStream() throws IOException, SQLException {
        this.checkIfValid();
        try {
            this.positionedStoreStream.reposition(this.csd.getDataOffset());
        }
        catch (StandardException standardException) {
            throw Util.generateCsSQLException(standardException);
        }
        return this.positionedStoreStream;
    }

    @Override
    public Reader getReader(long l) throws IOException, SQLException {
        long l2;
        this.checkIfValid();
        try {
            this.positionedStoreStream.reposition(0L);
        }
        catch (StandardException standardException) {
            throw Util.generateCsSQLException(standardException);
        }
        UTF8Reader uTF8Reader = new UTF8Reader(this.csd, this.conChild, this.synchronizationObject);
        for (long i = l - 1L; i > 0L; i -= l2) {
            l2 = ((Reader)uTF8Reader).skip(i);
            if (l2 > 0L) continue;
            throw new EOFException("Reached end-of-stream prematurely");
        }
        return uTF8Reader;
    }

    @Override
    public Reader getInternalReader(long l) throws IOException, SQLException {
        if (this.internalReader == null) {
            if (this.positionedStoreStream.getPosition() != 0L) {
                try {
                    this.positionedStoreStream.resetStream();
                }
                catch (StandardException standardException) {
                    throw Util.generateCsSQLException(standardException);
                }
            }
            this.internalReader = new UTF8Reader(this.csd, this.conChild, this.synchronizationObject);
            this.unclosableInternalReader = new FilterReader(this, this.internalReader){

                @Override
                public void close() {
                }
            };
        }
        try {
            this.internalReader.reposition(l);
        }
        catch (StandardException standardException) {
            throw Util.generateCsSQLException(standardException);
        }
        return this.unclosableInternalReader;
    }

    @Override
    public long getUpdateCount() {
        return 0L;
    }

    @Override
    public Writer getWriter(long l) {
        throw new UnsupportedOperationException("A StoreStreamClob object is not updatable");
    }

    @Override
    public long insertString(String string, long l) {
        throw new UnsupportedOperationException("A StoreStreamClob object is not updatable");
    }

    @Override
    public boolean isReleased() {
        return this.released;
    }

    @Override
    public boolean isWritable() {
        return false;
    }

    @Override
    public void truncate(long l) {
        throw new UnsupportedOperationException("A StoreStreamClob object is not updatable");
    }

    private static SQLException noStateChangeLOB(Throwable throwable) {
        if (throwable instanceof StandardException && ((StandardException)throwable).getMessageId().equals("40XD0")) {
            throwable = StandardException.newException("XJ073.S", new Object[0]);
        }
        return EmbedResultSet.noStateChangeException(throwable);
    }

    private void checkIfValid() {
        if (this.released) {
            throw new IllegalStateException("The Clob has been released and is not valid");
        }
    }
}

