/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.internal.api;

import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;

class LazyEnumeration<T>
implements Enumeration<T> {
    private final Iterator<Enumeration<T>> enumerationIterator;
    private final Set<T> seenElements = new HashSet<T>();
    private Enumeration<T> currentEnumeration;
    private T nextElement;

    public LazyEnumeration(List<Enumeration<T>> enumerations) {
        this.enumerationIterator = enumerations.iterator();
        this.advance();
    }

    @Override
    public boolean hasMoreElements() {
        return this.nextElement != null;
    }

    @Override
    public T nextElement() {
        if (this.nextElement == null) {
            throw new NoSuchElementException();
        }
        T result = this.nextElement;
        this.advance();
        return result;
    }

    private void advance() {
        this.nextElement = null;
        while (this.nextElement == null) {
            while (this.currentEnumeration != null && this.currentEnumeration.hasMoreElements()) {
                T candidate = this.currentEnumeration.nextElement();
                if (!this.seenElements.add(candidate)) continue;
                this.nextElement = candidate;
                return;
            }
            if (!this.enumerationIterator.hasNext()) break;
            this.currentEnumeration = this.enumerationIterator.next();
        }
    }
}

