/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal.deserializer.types;

import java.time.Instant;
import java.time.YearMonth;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import org.eclipse.yasson.internal.deserializer.types.AbstractDateDeserializer;
import org.eclipse.yasson.internal.deserializer.types.TypeDeserializerBuilder;

class YearMonthTypeDeserializer
extends AbstractDateDeserializer<YearMonth> {
    private static final DateTimeFormatter DEFAULT_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM").withZone(UTC);

    YearMonthTypeDeserializer(TypeDeserializerBuilder builder) {
        super(builder);
    }

    @Override
    protected YearMonth fromInstant(Instant instant) {
        return YearMonth.from(instant.atZone(UTC));
    }

    @Override
    protected YearMonth parseDefault(String jsonValue, Locale locale) {
        return YearMonth.parse(jsonValue, DEFAULT_FORMAT.withLocale(locale));
    }

    @Override
    protected YearMonth parseWithFormatter(String jsonValue, DateTimeFormatter formatter) {
        return YearMonth.parse(jsonValue, formatter);
    }
}

