/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector;

import com.sun.appserv.ProxyHandler;
import com.sun.enterprise.util.Utility;
import com.sun.logging.LogCleanerUtil;
import jakarta.servlet.AsyncContext;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.FilterChain;
import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletConnection;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletRequestAttributeEvent;
import jakarta.servlet.ServletRequestAttributeListener;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.SessionCookieConfig;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletMapping;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import jakarta.servlet.http.HttpUpgradeHandler;
import jakarta.servlet.http.Part;
import jakarta.servlet.http.PushBuilder;
import jakarta.servlet.http.WebConnection;
import java.io.BufferedReader;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URLDecoder;
import java.net.UnknownHostException;
import java.nio.charset.UnsupportedCharsetException;
import java.security.Principal;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import javax.security.auth.Subject;
import org.apache.catalina.Connector;
import org.apache.catalina.Context;
import org.apache.catalina.Host;
import org.apache.catalina.HttpRequest;
import org.apache.catalina.HttpResponse;
import org.apache.catalina.LogFacade;
import org.apache.catalina.Logger;
import org.apache.catalina.Manager;
import org.apache.catalina.Pipeline;
import org.apache.catalina.Realm;
import org.apache.catalina.Session;
import org.apache.catalina.Wrapper;
import org.apache.catalina.authenticator.AuthenticatorBase;
import org.apache.catalina.authenticator.SingleSignOn;
import org.apache.catalina.connector.AsyncContextImpl;
import org.apache.catalina.connector.CoyoteInputStream;
import org.apache.catalina.connector.CoyoteReader;
import org.apache.catalina.connector.InputBuffer;
import org.apache.catalina.connector.MappingImpl;
import org.apache.catalina.connector.RequestFacade;
import org.apache.catalina.connector.Response;
import org.apache.catalina.connector.SessionTracker;
import org.apache.catalina.core.ApplicationPushBuilder;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.core.StandardWrapper;
import org.apache.catalina.fileupload.Multipart;
import org.apache.catalina.session.PersistentManagerBase;
import org.apache.catalina.session.StandardSession;
import org.apache.catalina.util.Enumerator;
import org.apache.catalina.util.ParameterMap;
import org.apache.catalina.util.RequestUtil;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.EmptyCompletionHandler;
import org.glassfish.grizzly.http.Protocol;
import org.glassfish.grizzly.http.server.Response;
import org.glassfish.grizzly.http.server.TimeoutHandler;
import org.glassfish.grizzly.http.server.util.MappingData;
import org.glassfish.grizzly.http.server.util.RequestUtils;
import org.glassfish.grizzly.http.util.B2CConverter;
import org.glassfish.grizzly.http.util.ByteChunk;
import org.glassfish.grizzly.http.util.CharChunk;
import org.glassfish.grizzly.http.util.DataChunk;
import org.glassfish.grizzly.http.util.FastHttpDateFormat;
import org.glassfish.grizzly.http.util.MessageBytes;
import org.glassfish.grizzly.http2.Http2Stream;
import org.glassfish.grizzly.memory.Buffers;
import org.glassfish.grizzly.memory.MemoryManager;
import org.glassfish.grizzly.utils.Charsets;
import org.glassfish.web.valve.GlassFishValve;

public class Request
implements HttpRequest,
HttpServletRequest {
    private static final java.util.logging.Logger log = LogFacade.getLogger();
    private static final ResourceBundle rb = log.getResourceBundle();
    protected static final String info = "org.apache.catalina.connector.Request/1.0";
    private static boolean enforceScope;
    private static ThreadLocal<Object> staticDateFormats;
    protected SimpleDateFormat[] formats;
    private static ThreadLocal<Object> reentrancyStatus;
    protected ArrayList<Cookie> cookies = new ArrayList();
    protected static final Locale defaultLocale;
    protected Map<String, Object> attributes = new HashMap<String, Object>();
    protected ArrayList<Locale> locales = new ArrayList();
    private Map<String, Object> notes = new HashMap<String, Object>();
    protected String authType;
    protected Object dispatcherTypeAttr;
    protected InputBuffer inputBuffer = new InputBuffer();
    protected CoyoteInputStream inputStream = new CoyoteInputStream(this.inputBuffer);
    protected CoyoteReader reader = new CoyoteReader(this.inputBuffer);
    protected boolean usingInputStream;
    protected boolean usingReader;
    protected Principal userPrincipal;
    protected boolean sessionParsed;
    protected boolean parametersProcessed;
    protected boolean cookiesParsed;
    protected boolean secure;
    protected Subject subject;
    protected static final int CACHED_POST_LEN = 8192;
    protected byte[] postData;
    protected ParameterMap<String, String[]> parameterMap = new ParameterMap();
    protected Session session;
    protected Object requestDispatcherPath;
    protected boolean requestedSessionCookie;
    protected String requestedSessionId;
    protected String requestedSessionVersion;
    private boolean isRequestedSessionIdFromSecureCookie;
    protected String requestedSessionCookiePath;
    protected CharChunk uriParamsCharChunk = new CharChunk();
    protected boolean requestedSessionURL;
    protected Socket socket;
    protected boolean localesParsed;
    protected int localPort = -1;
    protected String remoteAddr;
    protected String remoteHost;
    protected int remotePort = -1;
    protected String localName;
    protected String localAddr;
    protected boolean checkRestrictedResources = true;
    private boolean unsuccessfulSessionFind;
    protected boolean checkUnsuccessfulSessionFind = true;
    private int dispatchDepth = 0;
    private static int maxDispatchDepth;
    private String jrouteId;
    private SessionTracker sessionTracker = new SessionTracker();
    private boolean isDefaultContext;
    private String requestURI;
    protected org.glassfish.grizzly.http.server.Request grizzlyRequest;
    protected RequestFacade facade;
    protected RequestFacade defaultContextMaskingFacade;
    protected org.apache.catalina.Response response;
    protected Connector connector;
    protected MappingData mappingData = new MappingData();
    protected Wrapper wrapper;
    protected FilterChain filterChain;
    private boolean isAsyncSupported = true;
    private AtomicBoolean asyncStarted = new AtomicBoolean();
    private AsyncContextImpl asyncContext;
    private Thread asyncStartedThread;
    private Multipart multipart;
    protected Context context;
    protected ServletContext servletContext;
    protected GlassFishValve hostValve;
    private String contextPath;
    private String servletPath;
    private String pathInfo;
    private boolean initRequestFacadeHelper;
    public static final boolean discardDisconnectEvent;
    private boolean upgrade;
    private boolean afterService;
    private boolean resume;
    private HttpUpgradeHandler httpUpgradeHandler;
    private WebConnection webConnection;
    protected B2CConverter URIConverter = null;

    public Request() {
        this.formats = (SimpleDateFormat[])staticDateFormats.get();
        this.formats[0].setTimeZone(TimeZone.getTimeZone("GMT"));
        this.formats[1].setTimeZone(TimeZone.getTimeZone("GMT"));
        this.formats[2].setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    public void setGrizzlyRequest(org.glassfish.grizzly.http.server.Request grizzlyRequest) {
        this.grizzlyRequest = grizzlyRequest;
        this.inputBuffer.setRequest(grizzlyRequest);
        this.inputBuffer.setRequest(this);
    }

    public org.glassfish.grizzly.http.server.Request getGrizzlyRequest() {
        return this.grizzlyRequest;
    }

    public static void setEnforceScope(boolean enforce) {
        enforceScope = enforce;
    }

    @Override
    public void recycle() {
        if (this.isAsyncStarted()) {
            return;
        }
        this.context = null;
        this.servletContext = null;
        this.contextPath = null;
        this.servletPath = null;
        this.pathInfo = null;
        this.wrapper = null;
        this.dispatcherTypeAttr = null;
        this.requestDispatcherPath = null;
        this.authType = null;
        this.requestURI = null;
        this.inputBuffer.recycle();
        this.usingInputStream = false;
        this.usingReader = false;
        this.userPrincipal = null;
        this.subject = null;
        this.sessionParsed = false;
        this.parametersProcessed = false;
        this.cookiesParsed = false;
        this.locales.clear();
        this.localesParsed = false;
        this.secure = false;
        this.remoteAddr = null;
        this.remoteHost = null;
        this.remotePort = -1;
        this.localPort = -1;
        this.localAddr = null;
        this.localName = null;
        this.multipart = null;
        this.jrouteId = null;
        this.upgrade = false;
        this.afterService = false;
        this.resume = false;
        this.attributes.clear();
        this.notes.clear();
        this.cookies.clear();
        this.unsuccessfulSessionFind = false;
        if (this.session != null) {
            this.session.endAccess();
        }
        this.session = null;
        this.requestedSessionCookie = false;
        this.requestedSessionId = null;
        this.requestedSessionCookiePath = null;
        this.requestedSessionURL = false;
        this.uriParamsCharChunk.recycle();
        this.sessionTracker.reset();
        this.dispatchDepth = 0;
        this.parameterMap.setLocked(false);
        this.parameterMap.clear();
        this.mappingData.recycle();
        this.initRequestFacadeHelper = false;
        if (enforceScope) {
            if (this.facade != null) {
                this.facade.clear();
                this.facade = null;
            }
            if (this.defaultContextMaskingFacade != null) {
                this.defaultContextMaskingFacade.clear();
                this.defaultContextMaskingFacade = null;
            }
            if (this.inputStream != null) {
                this.inputStream.clear();
                this.inputStream = null;
            }
            if (this.reader != null) {
                this.reader.clear();
                this.reader = null;
            }
        }
        if (this.asyncContext != null) {
            this.asyncContext.clear();
            this.asyncContext = null;
        }
        this.isAsyncSupported = true;
        this.asyncStarted.set(false);
        this.asyncStartedThread = null;
    }

    public void setUnsuccessfulSessionFind(boolean unsuccessfulSessionFind) {
        this.unsuccessfulSessionFind = unsuccessfulSessionFind;
    }

    public boolean getUnsuccessfulSessionFind() {
        return this.unsuccessfulSessionFind;
    }

    public void setUpgrade(boolean upgrade) {
        this.upgrade = upgrade;
    }

    public boolean isUpgrade() {
        return this.upgrade;
    }

    public HttpUpgradeHandler getHttpUpgradeHandler() {
        return this.httpUpgradeHandler;
    }

    @Override
    public String getAuthorization() {
        return this.grizzlyRequest.getHeader("authorization");
    }

    @Override
    public Connector getConnector() {
        return this.connector;
    }

    @Override
    public void setConnector(Connector connector) {
        this.connector = connector;
    }

    @Override
    public Context getContext() {
        return this.context;
    }

    @Override
    public void setContext(Context context) {
        this.context = context;
        if (context != null) {
            String charsetEncoding;
            this.servletContext = context.getServletContext();
            Pipeline p = context.getParent().getPipeline();
            if (p != null) {
                this.hostValve = p.getBasic();
            }
            if ((charsetEncoding = this.getCharacterEncoding()) == null) {
                try {
                    String resEncoding;
                    String reqEncoding = this.servletContext.getRequestCharacterEncoding();
                    if (reqEncoding != null) {
                        this.setCharacterEncoding(reqEncoding);
                    }
                    if ((resEncoding = this.servletContext.getResponseCharacterEncoding()) != null) {
                        this.getResponse().getResponse().setCharacterEncoding(resEncoding);
                    }
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        this.initSessionTracker();
    }

    public void setDefaultContext(boolean isDefaultContext) {
        this.isDefaultContext = isDefaultContext;
    }

    @Override
    public FilterChain getFilterChain() {
        return this.filterChain;
    }

    @Override
    public void setFilterChain(FilterChain filterChain) {
        this.filterChain = filterChain;
    }

    @Override
    public Host getHost() {
        return (Host)this.mappingData.host;
    }

    @Override
    public void setHost(Host host) {
        this.mappingData.host = host;
    }

    @Override
    public String getInfo() {
        return info;
    }

    public HttpServletMapping getHttpServletMapping() {
        return new MappingImpl(this.mappingData);
    }

    public MappingData getMappingData() {
        return this.mappingData;
    }

    public void setMappingData(MappingData mappingData) {
        this.mappingData = mappingData;
    }

    public void updatePaths(MappingData mappingData) {
        this.pathInfo = mappingData.pathInfo.toString();
        this.servletPath = mappingData.wrapperPath.toString();
        this.contextPath = mappingData.contextPath.toString();
    }

    public HttpServletRequest getRequest() {
        return this.getRequest(false);
    }

    public HttpServletRequest getRequest(boolean maskDefaultContextMapping) {
        if (!maskDefaultContextMapping || !this.isDefaultContext) {
            if (this.facade == null) {
                this.facade = new RequestFacade(this);
            }
            if (!this.initRequestFacadeHelper) {
                this.attributes.put("org.glassfish.web.RequestFacadeHelper", this.facade.getRequestFacadeHelper());
                this.initRequestFacadeHelper = true;
            }
            return this.facade;
        }
        if (this.defaultContextMaskingFacade == null) {
            this.defaultContextMaskingFacade = new RequestFacade(this, true);
        }
        if (!this.initRequestFacadeHelper) {
            this.attributes.put("org.glassfish.web.RequestFacadeHelper", this.defaultContextMaskingFacade.getRequestFacadeHelper());
            this.initRequestFacadeHelper = true;
        }
        return this.defaultContextMaskingFacade;
    }

    @Override
    public org.apache.catalina.Response getResponse() {
        return this.response;
    }

    @Override
    public void setResponse(org.apache.catalina.Response response) {
        this.response = response;
        if (response instanceof Response) {
            this.sessionTracker.setResponse((Response)response);
        }
    }

    @Override
    public Socket getSocket() {
        return this.socket;
    }

    @Override
    public void setSocket(Socket socket) {
        this.socket = socket;
        this.remoteHost = null;
        this.remoteAddr = null;
        this.remotePort = -1;
        this.localPort = -1;
        this.localAddr = null;
        this.localName = null;
    }

    @Override
    public InputStream getStream() {
        if (this.inputStream == null) {
            this.inputStream = new CoyoteInputStream(this.inputBuffer);
        }
        return this.inputStream;
    }

    @Override
    public void setStream(InputStream stream) {
    }

    protected B2CConverter getURIConverter() {
        return this.URIConverter;
    }

    protected void setURIConverter(B2CConverter URIConverter) {
        this.URIConverter = URIConverter;
    }

    @Override
    public Wrapper getWrapper() {
        return this.wrapper;
    }

    @Override
    public void setWrapper(Wrapper wrapper) {
        this.wrapper = wrapper;
    }

    @Override
    public ServletInputStream createInputStream() throws IOException {
        if (this.inputStream == null) {
            this.inputStream = new CoyoteInputStream(this.inputBuffer);
        }
        return this.inputStream;
    }

    @Override
    public void finishRequest() throws IOException {
    }

    @Override
    public Object getNote(String name) {
        return this.notes.get(name);
    }

    @Override
    public Iterator<String> getNoteNames() {
        return this.notes.keySet().iterator();
    }

    @Override
    public void removeNote(String name) {
        this.notes.remove(name);
    }

    @Override
    public void setNote(String name, Object value) {
        this.notes.put(name, value);
    }

    @Override
    public void setContentLength(int length) {
        this.grizzlyRequest.getRequest().setContentLength(length);
    }

    @Override
    public void setContentType(String type) {
    }

    @Override
    public void setProtocol(String protocol) {
    }

    @Override
    public void setRemoteAddr(String remoteAddr) {
    }

    public void setRemoteHost(String remoteHost) {
    }

    @Override
    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    @Override
    public void setServerName(String name) {
        this.grizzlyRequest.setServerName(name);
    }

    @Override
    public void setServerPort(int port) {
        this.grizzlyRequest.setServerPort(port);
    }

    @Override
    public void setCheckRestrictedResources(boolean check) {
        this.checkRestrictedResources = check;
    }

    @Override
    public boolean getCheckRestrictedResources() {
        return this.checkRestrictedResources;
    }

    public Object getAttribute(String name) {
        if (name.equals("org.apache.catalina.core.DISPATCHER_TYPE")) {
            return this.dispatcherTypeAttr == null ? DispatcherType.REQUEST : this.dispatcherTypeAttr;
        }
        if (name.equals("org.apache.catalina.core.DISPATCHER_REQUEST_PATH")) {
            return this.requestDispatcherPath == null ? this.getRequestPathMB().toString() : this.requestDispatcherPath.toString();
        }
        if (name.equals("org.apache.catalina.CONSTRAINT_URI")) {
            return this.getRequestPathMB() != null ? this.getRequestPathMB().toString() : null;
        }
        Object attribute = this.attributes.get(name);
        if (attribute != null) {
            return attribute;
        }
        attribute = this.grizzlyRequest.getAttribute(name);
        if (attribute != null) {
            return attribute;
        }
        if ("org.apache.coyote.request.X509Certificate".equals(name)) {
            RequestUtils.populateCertificateAttribute((org.glassfish.grizzly.http.server.Request)this.grizzlyRequest);
            attribute = this.getAttribute("jakarta.servlet.request.X509Certificate");
            if (attribute != null) {
                this.attributes.put(name, attribute);
            }
        } else if (Request.isSSLAttribute(name)) {
            RequestUtils.populateSSLAttributes((org.glassfish.grizzly.http.server.Request)this.grizzlyRequest);
            attribute = this.attributes.get(name);
        }
        return attribute;
    }

    static boolean isSSLAttribute(String name) {
        return "jakarta.servlet.request.X509Certificate".equals(name) || "jakarta.servlet.request.cipher_suite".equals(name) || "jakarta.servlet.request.key_size".equals(name) || "jakarta.servlet.request.ssl_session_id".equals(name);
    }

    public Enumeration<String> getAttributeNames() {
        if (this.isSecure()) {
            this.populateSSLAttributes();
        }
        return new Enumerator<String>(this.attributes.keySet(), true);
    }

    public String getCharacterEncoding() {
        return this.grizzlyRequest.getCharacterEncoding();
    }

    public int getContentLength() {
        return this.grizzlyRequest.getContentLength();
    }

    public long getContentLengthLong() {
        return this.grizzlyRequest.getContentLengthLong();
    }

    public String getContentType() {
        return this.grizzlyRequest.getContentType();
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this.usingReader) {
            throw new IllegalStateException(rb.getString("AS-WEB-CORE-00052"));
        }
        this.usingInputStream = true;
        if (this.inputStream == null) {
            this.inputStream = new CoyoteInputStream(this.inputBuffer);
        }
        return this.inputStream;
    }

    public Locale getLocale() {
        return this.grizzlyRequest.getLocale();
    }

    public Enumeration<Locale> getLocales() {
        return new Enumerator<Locale>(this.grizzlyRequest.getLocales());
    }

    private void processParameters() {
        String contentType;
        if (this.parametersProcessed) {
            return;
        }
        this.getCharacterEncoding();
        if (this.isMultipartConfigured() && this.getMethod().equalsIgnoreCase("POST") && (contentType = this.getContentType()) != null && contentType.startsWith("multipart/form-data")) {
            this.getMultipart().init();
        }
        this.parametersProcessed = true;
    }

    public String getParameter(String name) {
        this.processParameters();
        return this.grizzlyRequest.getParameter(name);
    }

    public Map<String, String[]> getParameterMap() {
        if (this.parameterMap.isLocked()) {
            return this.parameterMap;
        }
        Enumeration<String> paramaterNames = this.getParameterNames();
        while (paramaterNames.hasMoreElements()) {
            String name = paramaterNames.nextElement();
            String[] values = this.getParameterValues(name);
            this.parameterMap.put(name, values);
        }
        this.parameterMap.setLocked(true);
        return this.parameterMap;
    }

    public Enumeration<String> getParameterNames() {
        this.processParameters();
        return new Enumerator<String>(this.grizzlyRequest.getParameterNames());
    }

    public String[] getParameterValues(String name) {
        this.processParameters();
        return this.grizzlyRequest.getParameterValues(name);
    }

    public String getProtocol() {
        return this.grizzlyRequest.getProtocol().getProtocolString();
    }

    public BufferedReader getReader() throws IOException {
        if (this.usingInputStream) {
            throw new IllegalStateException(rb.getString("AS-WEB-CORE-00053"));
        }
        this.usingReader = true;
        try {
            this.inputBuffer.checkConverter();
        }
        catch (UnsupportedCharsetException uce) {
            UnsupportedEncodingException uee = new UnsupportedEncodingException(uce.getMessage());
            uee.initCause(uce);
            throw uee;
        }
        if (this.reader == null) {
            this.reader = new CoyoteReader(this.inputBuffer);
        }
        return this.reader;
    }

    public String getRemoteAddr() {
        if (this.remoteAddr == null) {
            if (this.connector.getAuthPassthroughEnabled() && this.connector.getProxyHandler() != null) {
                this.remoteAddr = this.connector.getProxyHandler().getRemoteAddress(this.getRequest());
                if (this.remoteAddr == null && log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "AS-WEB-CORE-00054");
                }
                return this.remoteAddr;
            }
            if (this.socket != null) {
                InetAddress inet = this.socket.getInetAddress();
                this.remoteAddr = inet.getHostAddress();
            } else {
                this.remoteAddr = this.grizzlyRequest.getRemoteAddr();
            }
        }
        return this.remoteAddr;
    }

    public String getRemoteHost() {
        if (this.remoteHost == null) {
            if (!this.connector.getEnableLookups()) {
                this.remoteHost = this.getRemoteAddr();
            } else if (this.connector.getAuthPassthroughEnabled() && this.connector.getProxyHandler() != null) {
                String addr = this.connector.getProxyHandler().getRemoteAddress(this.getRequest());
                if (addr != null) {
                    try {
                        this.remoteHost = InetAddress.getByName(addr).getHostName();
                    }
                    catch (UnknownHostException e) {
                        String msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00055"), addr);
                        log.log(Level.WARNING, msg, e);
                    }
                } else if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "AS-WEB-CORE-00054");
                }
            } else if (this.socket != null) {
                InetAddress inet = this.socket.getInetAddress();
                this.remoteHost = inet.getHostName();
            } else {
                this.remoteHost = this.grizzlyRequest.getRemoteHost();
            }
        }
        return this.remoteHost;
    }

    public int getRemotePort() {
        if (this.remotePort == -1) {
            this.remotePort = this.socket != null ? this.socket.getPort() : this.grizzlyRequest.getRemotePort();
        }
        return this.remotePort;
    }

    public String getLocalName() {
        if (this.localName == null) {
            if (this.socket != null) {
                InetAddress inet = this.socket.getLocalAddress();
                this.localName = inet.getHostName();
            } else {
                this.localName = this.grizzlyRequest.getLocalName();
            }
        }
        return this.localName;
    }

    public String getLocalAddr() {
        if (this.localAddr == null) {
            if (this.socket != null) {
                InetAddress inet = this.socket.getLocalAddress();
                this.localAddr = inet.getHostAddress();
            } else {
                this.localAddr = this.grizzlyRequest.getLocalAddr();
            }
        }
        return this.localAddr;
    }

    public int getLocalPort() {
        if (this.localPort == -1) {
            this.localPort = this.socket != null ? this.socket.getLocalPort() : this.grizzlyRequest.getLocalPort();
        }
        return this.localPort;
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        if (this.servletContext == null) {
            return null;
        }
        if (path == null) {
            return null;
        }
        if (path.startsWith("/")) {
            return this.servletContext.getRequestDispatcher(path);
        }
        String servletPath = (String)this.getAttribute("jakarta.servlet.include.servlet_path");
        if (servletPath == null) {
            servletPath = this.getServletPath();
        }
        String pathInfo = this.getPathInfo();
        Object requestPath = null;
        requestPath = pathInfo == null ? servletPath : servletPath + pathInfo;
        int lastSlashPos = ((String)requestPath).lastIndexOf(47);
        String relativePath = null;
        relativePath = lastSlashPos >= 0 ? ((String)requestPath).substring(0, lastSlashPos + 1) + path : (String)requestPath + path;
        return this.servletContext.getRequestDispatcher(relativePath);
    }

    public String getScheme() {
        ProxyHandler proxyHandler;
        if (this.getConnector() != null && this.getConnector().getAuthPassthroughEnabled() && (proxyHandler = this.getConnector().getProxyHandler()) != null && proxyHandler.getSSLKeysize(this.getRequest()) > 0) {
            return "https";
        }
        return this.grizzlyRequest.getScheme();
    }

    public String getServerName() {
        return this.grizzlyRequest.getServerName();
    }

    public int getServerPort() {
        String host;
        if (this.isSecure() && (host = this.getHeader("host")) != null && host.indexOf(58) == -1) {
            return 443;
        }
        return this.grizzlyRequest.getServerPort();
    }

    public boolean isSecure() {
        return this.secure;
    }

    public void removeAttribute(String name) {
        Object value = null;
        boolean found = this.attributes.containsKey(name);
        if (!found) {
            return;
        }
        value = this.attributes.get(name);
        this.attributes.remove(name);
        List<EventListener> listeners = this.context.getApplicationEventListeners();
        if (listeners.isEmpty()) {
            return;
        }
        ServletRequestAttributeEvent event = new ServletRequestAttributeEvent(this.servletContext, (ServletRequest)this.getRequest(), name, value);
        for (EventListener eventListener : listeners) {
            if (!(eventListener instanceof ServletRequestAttributeListener)) continue;
            ServletRequestAttributeListener listener = (ServletRequestAttributeListener)eventListener;
            try {
                listener.attributeRemoved(event);
            }
            catch (Throwable t) {
                this.log(rb.getString("AS-WEB-CORE-00056"), t);
                this.attributes.put("jakarta.servlet.error.exception", t);
            }
        }
    }

    public void setAttribute(String name, Object value) {
        List<EventListener> listeners;
        if (name == null) {
            throw new IllegalArgumentException(rb.getString("AS-WEB-CORE-00057"));
        }
        if (value == null) {
            this.removeAttribute(name);
            return;
        }
        if (name.equals("org.apache.catalina.core.DISPATCHER_TYPE")) {
            this.dispatcherTypeAttr = value;
            return;
        }
        if (name.equals("org.apache.catalina.core.DISPATCHER_REQUEST_PATH")) {
            this.requestDispatcherPath = value;
            return;
        }
        boolean replaced = false;
        Object oldValue = this.attributes.put(name, value);
        if (oldValue != null) {
            replaced = true;
        }
        if (name.startsWith("grizzly.")) {
            this.grizzlyRequest.setAttribute(name, value);
        }
        if ((listeners = this.context.getApplicationEventListeners()).isEmpty()) {
            return;
        }
        ServletRequestAttributeEvent event = null;
        event = replaced ? new ServletRequestAttributeEvent(this.servletContext, (ServletRequest)this.getRequest(), name, oldValue) : new ServletRequestAttributeEvent(this.servletContext, (ServletRequest)this.getRequest(), name, value);
        for (EventListener eventListener : listeners) {
            if (!(eventListener instanceof ServletRequestAttributeListener)) continue;
            ServletRequestAttributeListener listener = (ServletRequestAttributeListener)eventListener;
            try {
                if (replaced) {
                    listener.attributeReplaced(event);
                    continue;
                }
                listener.attributeAdded(event);
            }
            catch (Throwable t) {
                this.log(rb.getString("AS-WEB-CORE-00056"), t);
                this.attributes.put("jakarta.servlet.error.exception", t);
            }
        }
    }

    public void setCharacterEncoding(String enc) throws UnsupportedEncodingException {
        if (this.parametersProcessed || this.usingReader) {
            String contextName = this.getContext() != null ? this.getContext().getName() : "UNKNOWN";
            log.log(Level.WARNING, "AS-WEB-CORE-00059", new Object[]{enc, contextName});
            return;
        }
        byte[] buffer = new byte[]{97};
        new String(buffer, RequestUtil.lookupCharset(enc));
        this.grizzlyRequest.setCharacterEncoding(enc);
    }

    public static void setMaxDispatchDepth(int depth) {
        maxDispatchDepth = depth;
    }

    public static int getMaxDispatchDepth() {
        return maxDispatchDepth;
    }

    public int incrementDispatchDepth() {
        return ++this.dispatchDepth;
    }

    public int decrementDispatchDepth() {
        return --this.dispatchDepth;
    }

    public boolean isMaxDispatchDepthReached() {
        return this.dispatchDepth > maxDispatchDepth;
    }

    public boolean authenticate(HttpServletResponse response) throws IOException, ServletException {
        if (this.context == null) {
            throw new ServletException("Internal error: Context null");
        }
        AuthenticatorBase authBase = (AuthenticatorBase)this.context.getAuthenticator();
        if (authBase == null) {
            throw new ServletException("Internal error: Authenticator null");
        }
        byte[] alreadyCalled = (byte[])reentrancyStatus.get();
        if (alreadyCalled[0] == 1) {
            try {
                return authBase.authenticate(this, (HttpResponse)this.getResponse(), this.context.getLoginConfig());
            }
            catch (Exception ex) {
                throw new ServletException("Exception thrown while attempting to authenticate", (Throwable)ex);
            }
        }
        alreadyCalled[0] = 1;
        try {
            Realm realm = this.context.getRealm();
            Request req = this;
            if (realm == null) {
                throw new ServletException("Internal error: realm null");
            }
            try {
                boolean bl = realm.invokeAuthenticateDelegate(req, (HttpResponse)this.getResponse(), this.context, authBase, true);
                return bl;
            }
            catch (Exception ex) {
                throw new ServletException("Exception thrown while attempting to authenticate", (Throwable)ex);
            }
        }
        finally {
            alreadyCalled[0] = 0;
        }
    }

    public void login(String username, String password) throws ServletException {
        this.login(username, password != null ? password.toCharArray() : null);
    }

    public void login(String username, char[] password) throws ServletException {
        Realm realm = this.context.getRealm();
        if (realm != null && realm.isSecurityExtensionEnabled(this.getServletContext())) {
            throw new ServletException(rb.getString("AS-WEB-CORE-00538"));
        }
        if (this.getAuthType() != null || this.getRemoteUser() != null || this.getUserPrincipal() != null) {
            throw new ServletException(rb.getString("AS-WEB-CORE-00536"));
        }
        if (this.context.getAuthenticator() == null) {
            throw new ServletException(rb.getString("AS-WEB-CORE-00537"));
        }
        this.context.getAuthenticator().login(username, password, this);
    }

    public void logout() throws ServletException {
        Realm realm;
        Realm realm2 = realm = this.context == null ? null : this.context.getRealm();
        if (realm == null) {
            if (this.getUserPrincipal() != null || this.getAuthType() != null) {
                throw new ServletException(rb.getString("AS-WEB-CORE-00539"));
            }
            return;
        }
        realm.logout(this);
    }

    @Override
    public void addCookie(Cookie cookie) {
        if (!this.cookiesParsed) {
            this.parseCookies();
        }
        this.cookies.add(cookie);
    }

    @Override
    public void addHeader(String name, String value) {
        this.grizzlyRequest.getRequest().getHeaders().addValue(name).setString(value);
    }

    @Override
    public void addLocale(Locale locale) {
        this.locales.add(locale);
    }

    @Override
    public void addParameter(String name, String[] values) {
        this.grizzlyRequest.addParameter(name, values);
    }

    @Override
    public void clearCookies() {
        this.cookiesParsed = true;
        this.cookies.clear();
    }

    @Override
    public void clearHeaders() {
        this.grizzlyRequest.getRequest().getHeaders().recycle();
    }

    @Override
    public void clearLocales() {
        this.locales.clear();
    }

    @Override
    public void clearParameters() {
        this.grizzlyRequest.getParameters().recycle();
        this.grizzlyRequest.getParameters().setQueryStringEncoding(Charsets.lookupCharset((String)this.getConnector().getURIEncoding()));
    }

    @Override
    public void replayPayload(byte[] payloadByteArray) {
        if (payloadByteArray == null) {
            return;
        }
        this.grizzlyRequest.replayPayload(Buffers.wrap((MemoryManager)this.grizzlyRequest.getContext().getMemoryManager(), (byte[])payloadByteArray));
    }

    @Override
    public void setAuthType(String type) {
        this.authType = type;
    }

    @Override
    public void setMethod(String method) {
        this.grizzlyRequest.setMethod(method);
    }

    @Override
    public void setQueryString(String query) {
        this.grizzlyRequest.setQueryString(query);
    }

    @Override
    public void setPathInfo(String pathInfo) {
        this.mappingData.pathInfo.setString(pathInfo);
        this.pathInfo = pathInfo;
    }

    @Override
    public void setRequestedSessionCookie(boolean flag) {
        this.requestedSessionCookie = flag;
    }

    @Override
    public void setRequestedSessionCookiePath(String cookiePath) {
        this.requestedSessionCookiePath = cookiePath;
    }

    @Override
    public void setRequestedSessionId(String id) {
        int index;
        this.requestedSessionId = id;
        if (id != null && this.connector.getJvmRoute() != null && (index = id.indexOf(".")) > 0) {
            this.requestedSessionId = id.substring(0, index);
        }
    }

    @Override
    public void setRequestedSessionURL(boolean flag) {
        this.requestedSessionURL = flag;
    }

    @Override
    public void setRequestURI(String uri) {
        this.grizzlyRequest.setRequestURI(uri);
    }

    @Override
    public String getDecodedRequestURI() {
        return this.getDecodedRequestURI(false);
    }

    public String getDecodedRequestURI(boolean maskDefaultContextMapping) {
        try {
            if (maskDefaultContextMapping || !this.isDefaultContext) {
                return this.grizzlyRequest.getDecodedRequestURI();
            }
            return this.getContextPath() + this.grizzlyRequest.getDecodedRequestURI();
        }
        catch (CharConversionException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public void setServletPath(String servletPath) {
        this.mappingData.wrapperPath.setString(servletPath);
        this.servletPath = servletPath;
    }

    @Override
    public void setUserPrincipal(Principal principal) {
        this.userPrincipal = principal;
    }

    public String getAuthType() {
        return this.authType;
    }

    public String getContextPath() {
        return this.getContextPath(false);
    }

    public String getContextPath(boolean maskDefaultContextMapping) {
        if (this.isDefaultContext && maskDefaultContextMapping) {
            return "";
        }
        return this.contextPath;
    }

    public Cookie[] getCookies() {
        if (!this.cookiesParsed) {
            this.parseCookies();
        }
        if (this.cookies.size() == 0) {
            return null;
        }
        return this.cookies.toArray(new Cookie[this.cookies.size()]);
    }

    public void setCookies(Cookie[] cookies) {
        this.cookies.clear();
        if (cookies != null) {
            for (Cookie element : cookies) {
                this.cookies.add(element);
            }
        }
    }

    public long getDateHeader(String name) {
        String value = this.getHeader(name);
        if (value == null) {
            return -1L;
        }
        long result = FastHttpDateFormat.parseDate((String)value, (DateFormat[])this.formats);
        if (result != -1L) {
            return result;
        }
        throw new IllegalArgumentException(value);
    }

    public String getHeader(String name) {
        return this.grizzlyRequest.getHeader(name);
    }

    public Enumeration<String> getHeaders(String name) {
        return new Enumerator<String>(this.grizzlyRequest.getHeaders(name).iterator());
    }

    public Enumeration<String> getHeaderNames() {
        return new Enumerator<String>(this.grizzlyRequest.getHeaderNames().iterator());
    }

    public int getIntHeader(String name) {
        String value = this.getHeader(name);
        if (value == null) {
            return -1;
        }
        return Integer.parseInt(value);
    }

    public Map<String, String> getTrailerFields() {
        return this.grizzlyRequest.getTrailers();
    }

    public boolean isTrailerFieldsReady() {
        return this.grizzlyRequest.areTrailersAvailable();
    }

    public String getMethod() {
        return this.grizzlyRequest.getMethod().getMethodString();
    }

    public String getPathInfo() {
        return this.pathInfo;
    }

    public String getPathTranslated() {
        if (this.servletContext == null) {
            return null;
        }
        if (this.getPathInfo() == null) {
            return null;
        }
        return this.servletContext.getRealPath(this.getPathInfo());
    }

    public PushBuilder newPushBuilder() {
        Http2Stream http2Stream = null;
        if (this.grizzlyRequest != null) {
            http2Stream = (Http2Stream)this.grizzlyRequest.getAttribute(Http2Stream.HTTP2_STREAM_ATTRIBUTE);
        }
        if (http2Stream != null && http2Stream.isPushEnabled()) {
            return new ApplicationPushBuilder(this);
        }
        return null;
    }

    public String getQueryString() {
        String queryString = this.grizzlyRequest.getQueryString();
        if (queryString == null || "".equals(queryString)) {
            return null;
        }
        return queryString;
    }

    public String getRemoteUser() {
        if (this.userPrincipal != null) {
            return this.userPrincipal.getName();
        }
        return null;
    }

    @Override
    public DataChunk getRequestPathMB() {
        return this.mappingData.requestPath;
    }

    public String getRequestedSessionId() {
        return this.requestedSessionId;
    }

    public String getRequestURI() {
        return this.getRequestURI(false);
    }

    public String getRequestURI(boolean maskDefaultContextMapping) {
        if (maskDefaultContextMapping) {
            return this.grizzlyRequest.getRequestURI();
        }
        if (this.requestURI == null) {
            this.requestURI = this.isDefaultContext ? this.getContextPath() + this.grizzlyRequest.getRequestURI() : this.grizzlyRequest.getRequestURI();
        }
        return this.requestURI;
    }

    public StringBuffer getRequestURL() {
        return this.getRequestURL(false);
    }

    public StringBuffer getRequestURL(boolean maskDefaultContextMapping) {
        StringBuffer url = new StringBuffer();
        String scheme = this.getScheme();
        int port = this.getServerPort();
        if (port < 0) {
            port = 80;
        }
        url.append(scheme);
        url.append("://");
        url.append(this.getServerName());
        if (scheme.equals("http") && port != 80 || scheme.equals("https") && port != 443) {
            url.append(':');
            url.append(port);
        }
        url.append(this.getRequestURI(maskDefaultContextMapping));
        return url;
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public HttpSession getSession() {
        Session session = this.doGetSession(true);
        if (session == null) {
            return null;
        }
        return session.getSession();
    }

    public HttpSession getSession(boolean create) {
        Session session = this.doGetSession(create);
        if (session == null) {
            return null;
        }
        return session.getSession();
    }

    public void setSession(Session newSess) {
        this.session = newSess;
    }

    public boolean isRequestedSessionIdFromCookie() {
        if (this.requestedSessionId == null) {
            return false;
        }
        return this.requestedSessionCookie;
    }

    public boolean isRequestedSessionIdFromURL() {
        if (this.requestedSessionId == null) {
            return false;
        }
        return this.requestedSessionURL;
    }

    public void setRequestedSessionIdFromSecureCookie(boolean secure) {
        this.isRequestedSessionIdFromSecureCookie = secure;
    }

    public boolean isRequestedSessionIdFromSecureCookie() {
        return this.isRequestedSessionIdFromSecureCookie;
    }

    public boolean isRequestedSessionIdValid() {
        if (Utility.isAnyNull((Object[])new Object[]{this.requestedSessionId, this.context == null})) {
            return false;
        }
        if (this.session != null && this.requestedSessionId.equals(this.session.getIdInternal())) {
            return this.session.isValid();
        }
        Manager manager = this.context.getManager();
        if (manager == null) {
            return false;
        }
        Session localSession = null;
        try {
            localSession = manager.isSessionVersioningSupported() ? manager.findSession(this.requestedSessionId, this.requestedSessionVersion) : manager.findSession(this.requestedSessionId, this);
        }
        catch (IOException e) {
            localSession = null;
        }
        return localSession != null && localSession.isValid();
    }

    public boolean isUserInRole(String role) {
        String realRole;
        Principal userPrincipal = this.getUserPrincipal();
        if (Utility.isAnyNull((Object[])new Object[]{userPrincipal, this.context})) {
            return false;
        }
        Realm realm = this.context.getRealm();
        if (realm == null) {
            return false;
        }
        if (this.wrapper != null && (realRole = this.wrapper.findSecurityReference(role)) != null && realm.hasRole(this, (HttpResponse)this.response, userPrincipal, realRole)) {
            return true;
        }
        return realm.hasRole(this, (HttpResponse)this.response, userPrincipal, role);
    }

    public Principal getUserPrincipal() {
        return this.userPrincipal;
    }

    public Session getSessionInternal() {
        return this.doGetSession(true);
    }

    @Override
    public Session getSessionInternal(boolean create) {
        return this.doGetSession(create);
    }

    @Override
    public String changeSessionId() {
        Manager manager = this.context.getManager();
        if (manager == null) {
            throw new IllegalStateException(rb.getString("AS-WEB-CORE-00061"));
        }
        Session session = this.getSessionInternal(false);
        if (session == null) {
            throw new IllegalStateException(rb.getString("AS-WEB-CORE-00061"));
        }
        manager.changeSessionId(session);
        String newSessionId = session.getId();
        if (this.requestedSessionId != null && this.requestedSessionId.length() > 0) {
            this.requestedSessionId = newSessionId;
        }
        this.addSessionCookie();
        return newSessionId;
    }

    @Override
    public String generateSessionId() {
        return null;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public <T extends HttpUpgradeHandler> T upgrade(Class<T> handlerClass) throws IOException, ServletException {
        this.upgrade = true;
        T handler = null;
        try {
            handler = ((StandardContext)this.getContext()).createHttpUpgradeHandlerInstance(handlerClass);
        }
        catch (ServletException | IOException ise) {
            throw ise;
        }
        catch (Throwable t) {
            throw new ServletException(t);
        }
        this.httpUpgradeHandler = handler;
        this.grizzlyRequest.getResponse().suspend();
        return handler;
    }

    public WebConnection getWebConnection() {
        return this.webConnection;
    }

    public void setWebConnection(WebConnection webConnection) {
        this.webConnection = webConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Session doGetSession(boolean create) {
        String ssoId;
        SingleSignOn sso;
        StandardHost reqHost;
        if (this.context == null) {
            return null;
        }
        if (this.session != null && !this.session.isValid()) {
            this.session = null;
        }
        if (this.session != null) {
            return this.session;
        }
        Manager manager = this.context.getManager();
        if (manager == null) {
            return null;
        }
        if (this.requestedSessionId != null) {
            if (!this.checkUnsuccessfulSessionFind || !this.unsuccessfulSessionFind) {
                try {
                    if (manager.isSessionVersioningSupported()) {
                        this.session = manager.findSession(this.requestedSessionId, this.requestedSessionVersion);
                        if (this.session instanceof StandardSession) {
                            this.incrementSessionVersion((StandardSession)this.session, this.context);
                        }
                    } else {
                        this.session = manager.findSession(this.requestedSessionId, this);
                    }
                    if (this.session == null) {
                        this.unsuccessfulSessionFind = true;
                    }
                }
                catch (IOException e) {
                    this.session = null;
                }
            }
            if (this.session != null && !this.session.isValid()) {
                this.session = null;
            }
            if (this.session != null) {
                this.session.access();
                return this.session;
            }
        }
        if (!create) {
            return null;
        }
        if (this.context != null && this.response != null && this.context.getCookies() && this.response.getResponse().isCommitted()) {
            throw new IllegalStateException(rb.getString("AS-WEB-CORE-00062"));
        }
        if (this.requestedSessionId != null && this.context.getReuseSessionID()) {
            this.session = manager.createSession(this.requestedSessionId);
            if (manager instanceof PersistentManagerBase) {
                ((PersistentManagerBase)manager).removeFromInvalidatedSessions(this.requestedSessionId);
            }
        } else if (this.sessionTracker.getActiveSessions() > 0) {
            SessionTracker e = this.sessionTracker;
            synchronized (e) {
                if (this.sessionTracker.getActiveSessions() > 0) {
                    String id = this.sessionTracker.getSessionId();
                    this.session = manager.createSession(id);
                    if (manager instanceof PersistentManagerBase) {
                        ((PersistentManagerBase)manager).removeFromInvalidatedSessions(id);
                    }
                }
            }
        } else {
            String id = this.generateSessionId();
            this.session = id != null ? manager.createSession(id) : manager.createSession();
        }
        if ((reqHost = (StandardHost)this.getHost()) != null && (sso = reqHost.getSingleSignOn()) != null && (ssoId = (String)this.getNote("org.apache.catalina.request.SSOID")) != null) {
            long ssoVersion = 0L;
            Long ssoVersionObj = (Long)this.getNote("org.apache.catalina.request.SSOVersion");
            if (ssoVersionObj != null) {
                ssoVersion = ssoVersionObj;
            }
            sso.associate(ssoId, ssoVersion, this.session);
            this.removeNote("org.apache.catalina.request.SSOID");
        }
        this.sessionTracker.track(this.session);
        if (this.session != null && this.getContext() != null) {
            if (manager.isSessionVersioningSupported()) {
                this.incrementSessionVersion((StandardSession)this.session, this.context);
            }
            this.addSessionCookie();
        }
        if (this.session != null) {
            this.session.access();
            return this.session;
        }
        return null;
    }

    protected void configureSessionCookie(Cookie cookie) {
        cookie.setHttpOnly(true);
        cookie.setMaxAge(-1);
        String contextPath = null;
        if (this.isDefaultContext) {
            cookie.setPath("/");
        } else {
            if (this.context != null) {
                contextPath = this.context.getPath();
            }
            if (contextPath != null && contextPath.length() > 0) {
                cookie.setPath(contextPath);
            } else {
                cookie.setPath("/");
            }
        }
        if (this.isSecure()) {
            cookie.setSecure(true);
        }
        if (this.context != null) {
            SessionCookieConfig sessionCookieConfig = this.context.getSessionCookieConfig();
            if (sessionCookieConfig.getDomain() != null) {
                cookie.setDomain(sessionCookieConfig.getDomain());
            }
            if (sessionCookieConfig.getPath() != null) {
                cookie.setPath(sessionCookieConfig.getPath());
            }
            if (sessionCookieConfig.getComment() != null) {
                cookie.setVersion(1);
                cookie.setComment(sessionCookieConfig.getComment());
            }
            if (!cookie.getSecure()) {
                cookie.setSecure(sessionCookieConfig.isSecure());
            }
            cookie.setHttpOnly(sessionCookieConfig.isHttpOnly());
            cookie.setMaxAge(sessionCookieConfig.getMaxAge());
        }
        if (this.requestedSessionCookiePath != null) {
            cookie.setPath(this.requestedSessionCookiePath);
        }
    }

    protected void parseCookies() {
        this.cookiesParsed = true;
        org.glassfish.grizzly.http.Cookie[] serverCookies = this.grizzlyRequest.getCookies();
        int count = serverCookies.length;
        if (count <= 0) {
            return;
        }
        this.cookies.clear();
        for (int i = 0; i < count; ++i) {
            org.glassfish.grizzly.http.Cookie scookie = serverCookies[i];
            try {
                Cookie cookie = this.makeCookie(scookie);
                cookie.setPath(scookie.getPath());
                String domain = scookie.getDomain();
                if (domain != null) {
                    cookie.setDomain(scookie.getDomain());
                }
                this.cookies.add(cookie);
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    protected Cookie makeCookie(org.glassfish.grizzly.http.Cookie scookie) {
        return this.makeCookie(scookie, false);
    }

    protected Cookie makeCookie(org.glassfish.grizzly.http.Cookie scookie, boolean decode) {
        String name = scookie.getName();
        String value = scookie.getValue();
        if (decode) {
            try {
                name = URLDecoder.decode(name, "UTF-8");
                value = URLDecoder.decode(value, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                name = URLDecoder.decode(name);
                value = URLDecoder.decode(value);
            }
        }
        return new Cookie(name, value);
    }

    protected byte[] getPostBody() throws IOException {
        int len = this.getContentLength();
        byte[] formData = null;
        if (len < 8192) {
            if (this.postData == null) {
                this.postData = new byte[8192];
            }
            formData = this.postData;
        } else {
            formData = new byte[len];
        }
        int actualLen = this.readPostBody(formData, len);
        if (actualLen == len) {
            return formData;
        }
        return null;
    }

    protected int readPostBody(byte[] body, int len) throws IOException {
        Buffer b = this.grizzlyRequest.getPostBody(len).duplicate();
        int length = b.limit() - b.position();
        b.get(body, b.position(), length);
        return length;
    }

    protected static final boolean isAlpha(String value) {
        if (value == null) {
            return false;
        }
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') continue;
            return false;
        }
        return true;
    }

    protected void obtainSessionId() {
        this.setRequestedSessionURL(true);
        this.setJrouteId(this.grizzlyRequest.getJrouteId());
        this.setRequestedSessionId(this.grizzlyRequest.getRequestedSessionId());
    }

    protected void parseSessionId(String sessionParameterName, CharChunk uriCharChunk) {
        String sessionParam = ";" + sessionParameterName + "=";
        String sessionId = this.parseParameterFromRequestURI(uriCharChunk, sessionParam);
        if (sessionId != null) {
            int jrouteIndex = sessionId.lastIndexOf(58);
            if (jrouteIndex > 0) {
                this.setRequestedSessionId(sessionId.substring(0, jrouteIndex));
                if (jrouteIndex < sessionId.length() - 1) {
                    this.setJrouteId(sessionId.substring(jrouteIndex + 1));
                }
            } else {
                this.setRequestedSessionId(sessionId);
            }
            this.setRequestedSessionURL(true);
            if (this.grizzlyRequest.getRequestURI() != null) {
                this.removeParameterFromRequestURI(sessionParam);
            }
        } else {
            this.setRequestedSessionId(null);
            this.setRequestedSessionURL(false);
        }
    }

    protected void parseSessionVersion(CharChunk uriCC) {
        String sessionVersionString = this.parseParameterFromRequestURI(uriCC, ";jsessionidversion=");
        if (sessionVersionString != null) {
            this.parseSessionVersionString(sessionVersionString);
            this.removeParameterFromRequestURI(";jsessionidversion=");
        }
    }

    protected void parseJReplica(CharChunk uriCC) {
        String jreplica = this.parseParameterFromRequestURI(uriCC, ";jreplica=");
        if (jreplica != null) {
            Session session = this.getSessionInternal(false);
            if (session != null) {
                session.setNote("com.sun.enterprise.http.jreplicaLocation", jreplica);
            }
            this.removeParameterFromRequestURI(";jreplica=");
        }
    }

    private void addSessionCookie() {
        String jvmRoute;
        if (this.context != null && this.context.getCookies() && this.response != null && (jvmRoute = ((StandardContext)this.getContext()).getJvmRoute()) == null) {
            Cookie newCookie = new Cookie(LogCleanerUtil.getSafeHeaderValue((String)this.getContext().getSessionCookieName()), LogCleanerUtil.getSafeHeaderValue((String)this.session.getId()));
            this.configureSessionCookie(newCookie);
            ((HttpResponse)this.response).addSessionCookieInternal(newCookie);
        }
    }

    private String parseParameterFromRequestURI(CharChunk uriCharChunk, String parameter) {
        String parameterValue = null;
        int semicolon = uriCharChunk.indexOf(parameter, 0, parameter.length(), 0);
        if (semicolon >= 0) {
            int start = uriCharChunk.getStart();
            int end = uriCharChunk.getEnd();
            int parameterStart = start + semicolon + parameter.length();
            int semicolon2 = uriCharChunk.indexOf(';', semicolon + parameter.length());
            parameterValue = semicolon2 >= 0 ? new String(uriCharChunk.getBuffer(), parameterStart, semicolon2 - semicolon - parameter.length()) : new String(uriCharChunk.getBuffer(), parameterStart, end - parameterStart);
        }
        return parameterValue;
    }

    private void removeParameterFromRequestURI(String parameter) {
        DataChunk uriDataChunk = this.grizzlyRequest.getRequest().getRequestURIRef().getRequestURIBC();
        int semicolon = uriDataChunk.indexOf(parameter, 0);
        if (semicolon > 0) {
            int end;
            int semicolon2 = uriDataChunk.indexOf(';', semicolon + parameter.length());
            if (semicolon2 >= 0) {
                end = semicolon2;
                uriDataChunk.notifyDirectUpdate();
            } else {
                end = uriDataChunk.getLength();
            }
            uriDataChunk.delete(semicolon, end);
        }
    }

    void parseSessionVersionString(String sessionVersionString) {
        if (sessionVersionString == null || !this.isSessionVersioningSupported()) {
            return;
        }
        HashMap<String, String> sessionVersions = RequestUtil.parseSessionVersionString(sessionVersionString);
        if (sessionVersions != null) {
            this.attributes.put("com.sun.enterprise.http.sessionVersions", sessionVersions);
            if (this.context != null) {
                String path = this.context.getPath();
                if ("".equals(path)) {
                    path = "/";
                }
                this.requestedSessionVersion = sessionVersions.get(path);
            }
        }
    }

    void parseJrouteCookie() {
        org.glassfish.grizzly.http.Cookie[] serverCookies = this.grizzlyRequest.getCookies();
        int count = serverCookies.length;
        if (count <= 0) {
            return;
        }
        for (int i = 0; i < count; ++i) {
            org.glassfish.grizzly.http.Cookie scookie = serverCookies[i];
            if (!scookie.getName().equals("JROUTE")) continue;
            this.setJrouteId(scookie.getValue());
            break;
        }
    }

    void setJrouteId(String jrouteId) {
        this.jrouteId = jrouteId;
    }

    @Override
    public String getJrouteId() {
        return this.jrouteId;
    }

    protected void parseSessionCookiesId() {
        Context context = (Context)this.getMappingData().context;
        if (context != null && !context.getCookies()) {
            return;
        }
        org.glassfish.grizzly.http.Cookie[] serverCookies = this.grizzlyRequest.getCookies();
        int count = serverCookies.length;
        if (count <= 0) {
            return;
        }
        String sessionCookieName = "JSESSIONID";
        if (context != null) {
            sessionCookieName = context.getSessionCookieName();
        }
        for (int i = 0; i < count; ++i) {
            org.glassfish.grizzly.http.Cookie scookie = serverCookies[i];
            if (!scookie.getName().equals(sessionCookieName)) continue;
            if (!this.isRequestedSessionIdFromCookie()) {
                this.setRequestedSessionId(scookie.getValue());
                this.parseSessionVersionString(this.getSessionVersionFromCookie());
                this.setRequestedSessionCookie(true);
                this.setRequestedSessionIdFromSecureCookie(scookie.isSecure());
                this.setRequestedSessionURL(false);
                continue;
            }
            if (this.isRequestedSessionIdValid()) continue;
            this.setRequestedSessionId(scookie.getValue());
            this.parseSessionVersionString(this.getSessionVersionFromCookie());
        }
    }

    private String getSessionVersionFromCookie() {
        if (!this.isSessionVersioningSupported()) {
            return null;
        }
        org.glassfish.grizzly.http.Cookie[] serverCookies = this.grizzlyRequest.getCookies();
        int count = serverCookies.length;
        if (count <= 0) {
            return null;
        }
        for (int i = 0; i < count; ++i) {
            org.glassfish.grizzly.http.Cookie scookie = serverCookies[i];
            if (!scookie.getName().equals("JSESSIONIDVERSION")) continue;
            return scookie.getValue();
        }
        return null;
    }

    CharChunk getURIParams() {
        return this.uriParamsCharChunk;
    }

    protected void convertURI(MessageBytes uri) throws Exception {
        ByteChunk bc = uri.getByteChunk();
        CharChunk cc = uri.getCharChunk();
        int length = bc.getLength();
        cc.allocate(length, -1);
        String enc = this.connector.getURIEncoding();
        if (enc != null && !enc.isEmpty() && !"ISO-8859-1".equalsIgnoreCase(enc)) {
            B2CConverter conv = this.getURIConverter();
            try {
                if (conv == null) {
                    conv = new B2CConverter(enc);
                    this.setURIConverter(conv);
                }
            }
            catch (IOException e) {
                log.log(Level.SEVERE, "AS-WEB-CORE-00063");
                this.connector.setURIEncoding(null);
            }
            if (conv != null) {
                try {
                    conv.convert(bc, cc, cc.getBuffer().length - cc.getEnd());
                    uri.setChars(cc.getBuffer(), cc.getStart(), cc.getLength());
                    return;
                }
                catch (IOException e) {
                    log.log(Level.SEVERE, "AS-WEB-CORE-00064");
                    cc.recycle();
                }
            }
        }
        byte[] bbuf = bc.getBuffer();
        char[] cbuf = cc.getBuffer();
        int start = bc.getStart();
        for (int i = 0; i < length; ++i) {
            cbuf[i] = (char)(bbuf[i + start] & 0xFF);
        }
        uri.setChars(cbuf, 0, length);
    }

    public DispatcherType getDispatcherType() {
        DispatcherType dispatcher = (DispatcherType)this.getAttribute("org.apache.catalina.core.DISPATCHER_TYPE");
        if (dispatcher == null) {
            dispatcher = DispatcherType.REQUEST;
        }
        return dispatcher;
    }

    public AsyncContext startAsync() throws IllegalStateException {
        return this.startAsync((ServletRequest)this.getRequest(), this.getResponse().getResponse(), true);
    }

    public AsyncContext startAsync(ServletRequest servletRequest, ServletResponse servletResponse) throws IllegalStateException {
        return this.startAsync(servletRequest, servletResponse, false);
    }

    private AsyncContext startAsync(ServletRequest servletRequest, ServletResponse servletResponse, boolean isStartAsyncWithZeroArg) throws IllegalStateException {
        if (servletRequest == null || servletResponse == null) {
            throw new IllegalArgumentException("Null request or response");
        }
        if (!this.isAsyncSupported()) {
            throw new IllegalStateException(rb.getString("AS-WEB-CORE-00065"));
        }
        AsyncContextImpl asyncContextLocal = this.asyncContext;
        if (asyncContextLocal != null) {
            if (this.isAsyncStarted()) {
                throw new IllegalStateException(rb.getString("AS-WEB-CORE-00066"));
            }
            if (asyncContextLocal.isAsyncComplete()) {
                throw new IllegalStateException(rb.getString("AS-WEB-CORE-00067"));
            }
            if (!asyncContextLocal.isStartAsyncInScope()) {
                throw new IllegalStateException(rb.getString("AS-WEB-CORE-00068"));
            }
            asyncContextLocal.reinitialize(servletRequest, servletResponse, isStartAsyncWithZeroArg);
        } else {
            AsyncContextImpl asyncContextFinal;
            this.asyncContext = asyncContextFinal = new AsyncContextImpl(this, servletRequest, (Response)this.getResponse(), servletResponse, isStartAsyncWithZeroArg);
            EmptyCompletionHandler<org.glassfish.grizzly.http.server.Response> requestCompletionHandler = new EmptyCompletionHandler<org.glassfish.grizzly.http.server.Response>(this){

                public void completed(org.glassfish.grizzly.http.server.Response response) {
                    asyncContextFinal.notifyAsyncListeners(AsyncContextImpl.AsyncEventType.COMPLETE, null);
                }
            };
            TimeoutHandler timeoutHandler = new TimeoutHandler(){

                public boolean onTimeout(org.glassfish.grizzly.http.server.Response response) {
                    return Request.this.processTimeout();
                }
            };
            this.grizzlyRequest.getResponse().suspend(-1L, TimeUnit.MILLISECONDS, (CompletionHandler)requestCompletionHandler, timeoutHandler);
            this.asyncStartedThread = Thread.currentThread();
        }
        this.asyncStarted.set(true);
        return this.asyncContext;
    }

    public boolean isAsyncStarted() {
        return this.asyncStarted.get();
    }

    void setAsyncStarted(boolean asyncStarted) {
        this.asyncStarted.set(asyncStarted);
    }

    @Override
    public void disableAsyncSupport() {
        this.isAsyncSupported = false;
    }

    void setAsyncTimeout(long timeout) {
        this.grizzlyRequest.getResponse().getSuspendContext().setTimeout(timeout, TimeUnit.MILLISECONDS);
    }

    public boolean isAsyncSupported() {
        return this.isAsyncSupported;
    }

    public AsyncContext getAsyncContext() {
        if (!this.isAsyncStarted()) {
            throw new IllegalStateException(rb.getString("AS-WEB-CORE-00069"));
        }
        return this.asyncContext;
    }

    public String toString() {
        return this.getMethod() + " " + this.getRequestURI() + (String)(this.getQueryString() != null ? "?" + this.getQueryString() : "");
    }

    void asyncComplete() {
        this.asyncStarted.set(false);
        if (this.asyncStartedThread != Thread.currentThread() || !this.asyncContext.isOkToConfigure()) {
            this.grizzlyRequest.getResponse().resume();
        } else {
            Response.SuspendedContextImpl suspendContext = (Response.SuspendedContextImpl)this.grizzlyRequest.getResponse().getSuspendContext();
            suspendContext.markResumed();
            suspendContext.getSuspendStatus().reset();
        }
    }

    void asyncTimeout() {
        if (this.asyncContext != null) {
            this.asyncContext.notifyAsyncListeners(AsyncContextImpl.AsyncEventType.TIMEOUT, null);
        }
        this.inputBuffer.disableReadHandler();
        if (this.response instanceof Response) {
            ((Response)this.response).disableWriteHandler();
        }
        this.errorDispatchAndComplete(null);
    }

    void onExitService() {
        AsyncContextImpl asyncContextImpl = this.asyncContext;
        if (asyncContextImpl != null) {
            asyncContextImpl.setOkToConfigure(false);
            if (this.asyncStarted.get()) {
                this.grizzlyRequest.getResponse().getSuspendContext().setTimeout(asyncContextImpl.getTimeout(), TimeUnit.MILLISECONDS);
            }
            asyncContextImpl.onExitService();
        }
        this.afterService = true;
        if (this.resume) {
            this.grizzlyRequest.getResponse().resume();
        }
    }

    void resumeAfterService() {
        if (this.afterService) {
            this.grizzlyRequest.getResponse().resume();
        } else {
            this.resume = true;
        }
    }

    private boolean processTimeout() {
        boolean result = true;
        AsyncContextImpl asyncContextLocal = this.asyncContext;
        try {
            this.asyncTimeout();
            result = asyncContextLocal != null && !asyncContextLocal.getAndResetDispatchInScope();
        }
        catch (Throwable throwable) {
            result = asyncContextLocal != null && !asyncContextLocal.getAndResetDispatchInScope();
            throw throwable;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void errorDispatchAndComplete(Throwable t) {
        AsyncContextImpl asyncContextImpl = this.asyncContext;
        if (asyncContextImpl != null && !asyncContextImpl.isDispatchInScope() && !asyncContextImpl.isAsyncComplete()) {
            ((HttpServletResponse)this.response).setStatus(500);
            this.response.setError();
            if (t != null) {
                this.setAttribute("jakarta.servlet.error.exception", t);
            }
            try {
                if (this.hostValve != null) {
                    this.hostValve.postInvoke(this, this.response);
                }
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "AS-WEB-CORE-00071", e);
            }
            finally {
                if (!asyncContextImpl.isAsyncComplete()) {
                    asyncContextImpl.complete();
                }
            }
        }
    }

    private Multipart getMultipart() {
        if (this.multipart == null) {
            this.multipart = new Multipart(this, this.wrapper.getMultipartLocation(), this.wrapper.getMultipartMaxFileSize(), this.wrapper.getMultipartMaxRequestSize(), this.wrapper.getMultipartFileSizeThreshold());
        }
        return this.multipart;
    }

    private boolean isMultipartConfigured() {
        if (this.wrapper instanceof StandardWrapper) {
            return ((StandardWrapper)this.wrapper).isMultipartConfigured();
        }
        return false;
    }

    private void checkMultipartConfiguration(String name) {
        if (!this.isMultipartConfigured()) {
            String msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00072"), name);
            throw new IllegalStateException(msg);
        }
    }

    public Collection<Part> getParts() throws IOException, ServletException {
        this.checkMultipartConfiguration("getParts");
        return this.getMultipart().getParts();
    }

    public Part getPart(String name) throws IOException, ServletException {
        this.checkMultipartConfiguration("getPart");
        return this.getMultipart().getPart(name);
    }

    private void log(String message, Throwable t) {
        Logger logger = null;
        if (this.connector != null && this.connector.getContainer() != null) {
            logger = this.connector.getContainer().getLogger();
        }
        String localName = "Request";
        if (logger != null) {
            logger.log(localName + " " + message, t, 2);
        } else {
            log.log(Level.WARNING, localName + " " + message, t);
        }
    }

    private void populateSSLAttributes() {
        RequestUtils.populateSSLAttributes((org.glassfish.grizzly.http.server.Request)this.grizzlyRequest);
        Object attr = this.grizzlyRequest.getAttribute("jakarta.servlet.request.X509Certificate");
        if (attr != null) {
            this.attributes.put("jakarta.servlet.request.X509Certificate", attr);
        }
        if ((attr = this.grizzlyRequest.getAttribute("jakarta.servlet.request.cipher_suite")) != null) {
            this.attributes.put("jakarta.servlet.request.cipher_suite", attr);
        }
        if ((attr = this.grizzlyRequest.getAttribute("jakarta.servlet.request.key_size")) != null) {
            this.attributes.put("jakarta.servlet.request.key_size", attr);
        }
        if ((attr = this.grizzlyRequest.getAttribute("jakarta.servlet.request.ssl_session_id")) != null) {
            this.attributes.put("jakarta.servlet.request.ssl_session_id", attr);
        }
    }

    private void initSessionTracker() {
        this.notes.put("com.sun.enterprise.http.sessionTracker", this.sessionTracker);
    }

    @Override
    public Session lockSession() {
        Session session = this.getSessionInternal(false);
        if (session != null) {
            long pollTime = 200L;
            int maxNumberOfRetries = 7;
            int tryNumber = 0;
            boolean keepTrying = true;
            boolean lockResult = false;
            while (keepTrying) {
                lockResult = session.lockForeground();
                if (lockResult) {
                    keepTrying = false;
                    break;
                }
                if (++tryNumber < maxNumberOfRetries) {
                    this.threadSleep(pollTime *= 2L);
                    continue;
                }
                log.log(Level.WARNING, "AS-WEB-CORE-00073", session);
                if (!(session instanceof StandardSession)) continue;
                ((StandardSession)session).unlockBackground();
            }
        }
        return session;
    }

    private void threadSleep(long sleepTime) {
        try {
            Thread.sleep(sleepTime);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void unlockSession() {
        Session session = this.getSessionInternal(false);
        if (session != null) {
            session.unlockForeground();
        }
    }

    private void incrementSessionVersion(StandardSession standardSession, Context context) {
        String path;
        if (standardSession == null || context == null) {
            return;
        }
        String versionString = Long.toString(standardSession.incrementVersion());
        Map<String, String> sessionVersions = this.getSessionVersionsRequestAttribute();
        if (sessionVersions == null) {
            sessionVersions = new HashMap<String, String>();
            this.setAttribute("com.sun.enterprise.http.sessionVersions", sessionVersions);
        }
        if ("".equals(path = context.getPath())) {
            path = "/";
        }
        sessionVersions.put(path, versionString);
    }

    Map<String, String> getSessionVersionsRequestAttribute() {
        return (Map)this.getAttribute("com.sun.enterprise.http.sessionVersions");
    }

    private boolean isSessionVersioningSupported() {
        return this.context != null && this.context.getManager() != null && this.context.getManager().isSessionVersioningSupported();
    }

    public String getRequestId() {
        return this.grizzlyRequest.getRequestId();
    }

    public String getProtocolRequestId() {
        return this.grizzlyRequest.getProtocolRequestId();
    }

    public ServletConnection getServletConnection() {
        String connectionId = this.grizzlyRequest.getConnection() == null ? null : Long.toString(this.grizzlyRequest.getConnection().getId());
        return new ServletConnectionImpl(connectionId, this.grizzlyRequest.getProtocol(), this.grizzlyRequest.isSecure());
    }

    static {
        staticDateFormats = new ThreadLocal<Object>(){

            @Override
            protected Object initialValue() {
                SimpleDateFormat[] f = new SimpleDateFormat[]{new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US), new SimpleDateFormat("EEEEEE, dd-MMM-yy HH:mm:ss zzz", Locale.US), new SimpleDateFormat("EEE MMMM d HH:mm:ss yyyy", Locale.US)};
                return f;
            }
        };
        reentrancyStatus = new ThreadLocal<Object>(){

            @Override
            protected synchronized Object initialValue() {
                return new byte[]{0};
            }
        };
        defaultLocale = Locale.getDefault();
        maxDispatchDepth = 20;
        discardDisconnectEvent = Boolean.getBoolean("org.glassfish.grizzly.discardDisconnect");
    }

    public static class ServletConnectionImpl
    implements ServletConnection {
        private final String connectionId;
        private final Protocol protocol;
        private final boolean secure;

        public ServletConnectionImpl(String connectionId, Protocol protocol, boolean secure) {
            this.connectionId = connectionId;
            this.protocol = protocol;
            this.secure = secure;
        }

        public String getConnectionId() {
            return this.connectionId;
        }

        public String getProtocol() {
            return this.protocol == null ? "unknown" : this.protocol.getProtocolString();
        }

        public String getProtocolConnectionId() {
            return "";
        }

        public boolean isSecure() {
            return this.secure;
        }
    }
}

