/*
 * Decompiled with CFR 0.152.
 */
package jakarta.activation;

import java.util.Iterator;
import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.Logger;

class ServiceLoaderUtil {
    ServiceLoaderUtil() {
    }

    static <P, T extends Exception> P firstByServiceLoader(Class<P> spiClass, ClassLoader loader, Logger logger, ExceptionHandler<T> handler) throws T {
        logger.log(Level.FINE, "Using java.util.ServiceLoader to find {0}", spiClass.getName());
        try {
            ServiceLoader<P> serviceLoader = ServiceLoader.load(spiClass, loader);
            Iterator<P> iterator = serviceLoader.iterator();
            if (iterator.hasNext()) {
                P impl = iterator.next();
                logger.log(Level.FINE, "ServiceProvider loading Facility used; returning object [{0}]", impl.getClass().getName());
                return impl;
            }
        }
        catch (Throwable t) {
            throw handler.createException(t, "Error while searching for service [" + spiClass.getName() + "]");
        }
        return null;
    }

    static void checkPackageAccess(String className) {
        int i;
        SecurityManager s = System.getSecurityManager();
        if (s != null && (i = className.lastIndexOf(46)) != -1) {
            s.checkPackageAccess(className.substring(0, i));
        }
    }

    static <P> Class<P> nullSafeLoadClass(String className, ClassLoader classLoader) throws ClassNotFoundException {
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        return Class.forName(className, false, classLoader);
    }

    static <P, T extends Exception> P newInstance(String className, Class<P> service, ClassLoader classLoader, ExceptionHandler<T> handler) throws T {
        try {
            Class<P> cls = ServiceLoaderUtil.safeLoadClass(className, classLoader);
            return service.cast(cls.getConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (ClassNotFoundException x) {
            throw handler.createException(x, "Provider " + className + " not found");
        }
        catch (Exception x) {
            throw handler.createException(x, "Provider " + className + " could not be instantiated: " + x);
        }
    }

    static <P> Class<P> safeLoadClass(String className, ClassLoader classLoader) throws ClassNotFoundException {
        ServiceLoaderUtil.checkPackageAccess(className);
        return ServiceLoaderUtil.nullSafeLoadClass(className, classLoader);
    }

    static abstract class ExceptionHandler<T extends Exception> {
        ExceptionHandler() {
        }

        public abstract T createException(Throwable var1, String var2);
    }
}

