/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jaxrs.platform.beanvalidation.validationexceptionmapper;

import com.sun.ts.tests.jaxrs.common.JAXRSCommonClient;
import com.sun.ts.tests.jaxrs.common.client.JaxrsCommonClient;
import com.sun.ts.tests.jaxrs.common.provider.StringBean;
import com.sun.ts.tests.jaxrs.common.provider.StringBeanEntityProvider;
import com.sun.ts.tests.jaxrs.common.util.JaxrsUtil;
import com.sun.ts.tests.jaxrs.platform.beanvalidation.annotation.ConstraintDeclarationAnnotation;
import com.sun.ts.tests.jaxrs.platform.beanvalidation.annotation.ConstraintDeclarationResource;
import com.sun.ts.tests.jaxrs.platform.beanvalidation.annotation.ConstraintDeclarationValidator;
import com.sun.ts.tests.jaxrs.platform.beanvalidation.annotation.ConstraintDefinitionAnnotation;
import com.sun.ts.tests.jaxrs.platform.beanvalidation.annotation.ConstraintDefinitionResource;
import com.sun.ts.tests.jaxrs.platform.beanvalidation.annotation.ConstraintDefinitionValidator;
import com.sun.ts.tests.jaxrs.platform.beanvalidation.annotation.NotFiveNorShort;
import com.sun.ts.tests.jaxrs.platform.beanvalidation.annotation.NotFiveNorShortStringBeanValidator;
import com.sun.ts.tests.jaxrs.platform.beanvalidation.annotation.NotNullOrOne;
import com.sun.ts.tests.jaxrs.platform.beanvalidation.annotation.NotNullOrOneStringBean;
import com.sun.ts.tests.jaxrs.platform.beanvalidation.annotation.NotNullOrOneStringBeanValidator;
import com.sun.ts.tests.jaxrs.platform.beanvalidation.annotation.NotShortNorFiveEntityProvider;
import com.sun.ts.tests.jaxrs.platform.beanvalidation.annotation.NotShortNorFiveStringBean;
import com.sun.ts.tests.jaxrs.platform.beanvalidation.annotation.Resource;
import com.sun.ts.tests.jaxrs.platform.beanvalidation.annotation.ValidateExecutableResource;
import com.sun.ts.tests.jaxrs.platform.beanvalidation.validationexceptionmapper.TSAppConfig;
import com.sun.ts.tests.jaxrs.platform.beanvalidation.validationexceptionmapper.ValidationExceptionMapper;
import jakarta.validation.ConstraintViolationException;
import jakarta.validation.ValidationException;
import java.io.IOException;
import java.io.InputStream;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
@Tags(value={@Tag(value="jaxrs"), @Tag(value="platform"), @Tag(value="web")})
public class JAXRSClientIT
extends JaxrsCommonClient {
    private static final long serialVersionUID = 210L;

    public JAXRSClientIT() {
        this.setup();
        this.setContextRoot("/jaxrs_platform_beanvalidation_validationexceptionmapper_web/resource");
    }

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        InputStream inStream = JAXRSClientIT.class.getClassLoader().getResourceAsStream("com/sun/ts/tests/jaxrs/platform/beanvalidation/validationexceptionmapper/web.xml.template");
        String webXml = JAXRSClientIT.editWebXmlString(inStream);
        inStream = JAXRSClientIT.class.getClassLoader().getResourceAsStream("com/sun/ts/tests/jaxrs/platform/beanvalidation/validationexceptionmapper/beans.xml");
        String beansXml = JAXRSClientIT.toString(inStream);
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"jaxrs_platform_beanvalidation_validationexceptionmapper_web.war");
        archive.addClasses(new Class[]{TSAppConfig.class, Resource.class, ConstraintDeclarationAnnotation.class, ConstraintDeclarationResource.class, ConstraintDeclarationValidator.class, ConstraintDefinitionAnnotation.class, ConstraintDefinitionResource.class, ConstraintDefinitionValidator.class, NotFiveNorShort.class, NotFiveNorShortStringBeanValidator.class, NotNullOrOne.class, NotNullOrOneStringBean.class, NotNullOrOneStringBeanValidator.class, NotShortNorFiveEntityProvider.class, NotShortNorFiveStringBean.class, ValidateExecutableResource.class, JaxrsUtil.class, StringBean.class, StringBeanEntityProvider.class, ValidationExceptionMapper.class});
        archive.addAsWebInfResource((Asset)new StringAsset(beansXml), "beans.xml");
        archive.setWebXML((Asset)new StringAsset(webXml));
        return archive;
    }

    @Test
    public void beanIsInvalidForBeingFiveCharsLongTest() throws Exception {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "notshortnorfive"));
        this.setProperty(JAXRSCommonClient.Property.CONTENT, "12345");
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, ConstraintViolationException.class.getName());
        this.invoke();
        JAXRSClientIT.logMsg("ExceptionMapper works as expected");
    }

    @Test
    public void returnIsInvalidForBeingFiveCharsLongTest() throws Exception {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "returnnotshortnorfive"));
        this.setProperty(JAXRSCommonClient.Property.CONTENT, "12345");
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, ConstraintViolationException.class.getName());
        this.invoke();
        JAXRSClientIT.logMsg("ExceptionMapper works as expected");
    }

    @Test
    public void beanAnnotatedIsInvalidForBeingFiveCharsLongTest() throws Exception {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "directannotatedarg"));
        this.setProperty(JAXRSCommonClient.Property.CONTENT, "12345");
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, ConstraintViolationException.class.getName());
        this.invoke();
        JAXRSClientIT.logMsg("ExceptionMapper works as expected");
    }

    @Test
    public void beanAnnotatedReturnIsInvalidForBeingFiveCharsLongTest() throws Exception {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "directannotatedreturn"));
        this.setProperty(JAXRSCommonClient.Property.CONTENT, "12345");
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, ConstraintViolationException.class.getName());
        this.invoke();
        JAXRSClientIT.logMsg("ExceptionMapper works as expected");
    }

    @Test
    public void constraintDeclarationExceptionThrownTest() throws Exception {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "declaration/constraintdeclarationexception"));
        this.setProperty(JAXRSCommonClient.Property.CONTENT, "throw ConstraintDeclarationException()");
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, ValidationException.class.getName());
        this.invoke();
        JAXRSClientIT.logMsg("ExceptionMapper works as expected");
    }

    @Test
    public void constraintDefinitionExceptionThrownTest() throws Exception {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "definition/constraintdefinitionexception"));
        this.setProperty(JAXRSCommonClient.Property.CONTENT, "throw ConstraintDefinitionException()");
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, ValidationException.class.getName());
        this.invoke();
        JAXRSClientIT.logMsg("ExceptionMapper works as expected");
    }

    @Test
    public void validateExecutableIsInvalidForBeingShortTest() throws Exception {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "executable/nogetter"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, ConstraintViolationException.class.getName());
        this.invoke();
        JAXRSClientIT.logMsg("ExceptionMapper works as expected");
    }
}

