/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.query.parameter;

import com.sun.ts.lib.harness.CleanupMethod;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.SetupMethod;
import com.sun.ts.lib.harness.Status;
import com.sun.ts.lib.util.TestUtil;
import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.query.parameter.Employee;
import jakarta.persistence.Query;
import java.util.List;
import java.util.Properties;

public class Client2
extends PMClientBase {
    protected final Employee[] empRef = new Employee[5];

    public static void main(String[] args) {
        Client2 theTests = new Client2();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        this.logTrace("setupEmployee");
        try {
            super.setup(args, p);
            this.getEntityManager();
        }
        catch (Exception e) {
            this.logErr("Exception: ", e);
            throw new Exception("Setup failed:", e);
        }
    }

    public void setupEmployee(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"setupEmployee");
        try {
            super.setup(args, p);
            this.createEmployeeData();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception: ", (Throwable)e);
            throw new EETest.Fault("Setup failed:", (Throwable)e);
        }
    }

    public void cleanup() throws Exception {
        TestUtil.logTrace((String)"calling super.cleanup");
        super.cleanup();
    }

    @SetupMethod(name="setupEmployee")
    @CleanupMethod(name="cleanupEmployee")
    public void parameterPositionalTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            List result = this.getEntityManager().createQuery("SELECT e.id FROM Employee e WHERE e.id > ?2 GROUP BY e.id HAVING e.id <=?1").setParameter(2, (Object)2).setParameter(1, (Object)4).getResultList();
            String[] expectedPKs = new String[]{"3", "4"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                this.logErr("Expected 1 result, got: " + result.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception:", e);
        }
        if (!pass) {
            throw new Exception("parameterPositionalTest failed");
        }
    }

    @SetupMethod(name="setupEmployee")
    @CleanupMethod(name="cleanupEmployee")
    public void parameterUpdateTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            Query q = this.getEntityManager().createQuery("UPDATE Employee e SET e.firstName=?1, e.lastName=?1 WHERE e.id=1").setParameter(1, (Object)"foo");
            int result_size = q.executeUpdate();
            if (result_size == 1) {
                this.logTrace("Updated 1 rows");
            }
            this.doFlush();
            this.clearCache();
            Employee emp = (Employee)this.getEntityManager().find(Employee.class, (Object)1);
            if (emp.getFirstName().equals("foo") && emp.getLastName().equals("foo")) {
                this.logTrace("Received expected result:" + emp.toString());
                pass = true;
            } else {
                this.logErr("Expected: firstName=foo, lastName=foo, actual: firstName=" + emp.getFirstName() + ", lastName=" + emp.getLastName());
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception:", e);
        }
        if (!pass) {
            throw new Exception("parameterUpdateTest failed");
        }
    }

    @SetupMethod(name="setupEmployee")
    @CleanupMethod(name="cleanupEmployee")
    public void parameterCaseTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            List result = this.getEntityManager().createQuery("SELECT e.id FROM Employee e WHERE e.id > :Id GROUP BY e.id HAVING e.id <=:iD").setParameter("Id", (Object)2).setParameter("iD", (Object)4).getResultList();
            String[] expectedPKs = new String[]{"3", "4"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                this.logErr("Expected 1 result, got: " + result.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception:", e);
        }
        if (!pass) {
            throw new Exception("parameterCaseTest failed");
        }
    }

    @SetupMethod(name="setupEmployee")
    @CleanupMethod(name="cleanupEmployee")
    public void parameterNamedParameterTwiceTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            Query q = this.getEntityManager().createQuery("SELECT e FROM Employee e WHERE e.id >=:ID AND e.id <=:ID");
            List result = q.setParameter("ID", (Object)2).getResultList();
            String[] expectedPKs = new String[]{"2"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                this.logErr("Expected 1 result, got: " + result.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception:", e);
        }
        if (!pass) {
            throw new Exception("parameterNamedParameterTwiceTest failed");
        }
    }

    public void createEmployeeData() throws Exception {
        this.logTrace("createDepartmentEmployeeData");
        this.getEntityTransaction().begin();
        try {
            this.empRef[0] = new Employee(1, "Alan", "Frechette");
            this.empRef[1] = new Employee(2, "Arthur", "Frechette");
            this.empRef[2] = new Employee(3, "Shelly", "McGowan");
            this.empRef[3] = new Employee(4, "Robert", "Bissett");
            this.empRef[4] = new Employee(5, "Stephen", "DMilla");
            this.logTrace("Start to persist employees ");
            for (Employee emp : this.empRef) {
                if (emp == null) continue;
                this.getEntityManager().persist((Object)emp);
                this.logTrace("persisted employee " + emp.getId());
            }
            this.doFlush();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Exception: ", e);
            throw new Exception("createDepartmentEmployeeData failed:", e);
        }
    }

    public void cleanupEmployee() throws Exception {
        this.logTrace("cleanup");
        this.removeTestData();
        this.logTrace("cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        this.logTrace("removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM EMPLOYEE").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Exception encountered while removing entities:", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in removeTestData:", re);
            }
        }
    }
}

