/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.el.api.jakarta_el.elcontext;

import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.harness.Status;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.el.api.resolver.BarELResolver;
import com.sun.ts.tests.common.el.api.resolver.ResolverTest;
import com.sun.ts.tests.common.vehicle.VehicleClient;
import com.sun.ts.tests.common.vehicle.VehicleRunnable;
import com.sun.ts.tests.common.vehicle.VehicleRunnerFactory;
import com.sun.ts.tests.common.vehicle.servlet.ServletVehicle;
import com.sun.ts.tests.el.common.elcontext.BareBonesELContext;
import com.sun.ts.tests.el.common.util.ELTestUtil;
import com.sun.ts.tests.el.common.util.SimpleBean;
import com.sun.ts.tests.el.common.util.SimpleInterface;
import jakarta.el.ELManager;
import jakarta.el.EvaluationListener;
import jakarta.el.StandardELContext;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.stream.Collectors;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.OverProtocol;
import org.jboss.arquillian.container.test.api.TargetsContainer;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.ExtendWith;
import tck.arquillian.protocol.common.TargetVehicle;

@ExtendWith(value={ArquillianExtension.class})
@Tags(value={@Tag(value="el"), @Tag(value="platform"), @Tag(value="web"), @Tag(value="tck-javatest")})
public class ELClientServletTest
extends ServiceEETest {
    static final String VEHICLE_ARCHIVE = "elcontext_servlet_vehicle";
    private static final System.Logger logger = System.getLogger(ELClientServletTest.class.getName());
    private Properties testProps;

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        logger.log(System.Logger.Level.INFO, "STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        logger.log(System.Logger.Level.INFO, "FINISHED TEST : " + testInfo.getDisplayName());
    }

    public static String inputStreamToString(InputStream inStream) throws IOException {
        try (BufferedReader bufReader = new BufferedReader(new InputStreamReader(inStream, StandardCharsets.UTF_8));){
            String string = bufReader.lines().collect(Collectors.joining(System.lineSeparator()));
            return string;
        }
    }

    public static String editWebXmlString(InputStream inStream, String servlet_vehicle) throws IOException {
        return ELClientServletTest.inputStreamToString(inStream).replaceAll("el_servlet_vehicle", servlet_vehicle);
    }

    @TargetsContainer(value="tck-javatest")
    @OverProtocol(value="javatest")
    @Deployment(name="elcontext_servlet_vehicle", order=2)
    public static WebArchive createDeploymentVehicle() throws IOException {
        WebArchive servlet_vehicle_web = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"elcontext_servlet_vehicle_web.war");
        servlet_vehicle_web.addClasses(new Class[]{EETest.Fault.class, EETest.SetupException.class, EETest.class, ServiceEETest.class, BarELResolver.class, ResolverTest.class, VehicleClient.class, VehicleRunnable.class, VehicleRunnerFactory.class, ServletVehicle.class, ELClientServletTest.class, TCKEvalListener.class, BareBonesELContext.class, ELTestUtil.class, SimpleBean.class, SimpleInterface.class});
        InputStream inStream = ELClientServletTest.class.getResourceAsStream("/vehicle/servlet/servlet_vehicle_web.xml");
        String webXml = ELClientServletTest.editWebXmlString(inStream, VEHICLE_ARCHIVE);
        servlet_vehicle_web.setWebXML((Asset)new StringAsset(webXml));
        return servlet_vehicle_web;
    }

    public static void main(String[] args) {
        ELClientServletTest theTests = new ELClientServletTest();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        this.testProps = p;
    }

    @AfterEach
    public void cleanup() throws Exception {
    }

    @Test
    @TargetVehicle(value="servlet")
    public void elContextPutGetContextTest() throws Exception {
        ELManager elm = new ELManager();
        StandardELContext elc = elm.getELContext();
        String testStr = "TCKContext";
        elc.putContext(String.class, (Object)testStr);
        String result = elc.getContext(String.class).toString();
        if (!testStr.equals(result)) {
            throw new Exception("Test FAILED Unexpected Context Returned!" + TestUtil.NEW_LINE + "Expected: " + testStr + TestUtil.NEW_LINE + "Received: " + result);
        }
    }

    @Test
    @TargetVehicle(value="servlet")
    public void elContextGetSetLocaleTest() throws Exception {
        ELManager elm = new ELManager();
        StandardELContext elc = elm.getELContext();
        String disName = "english";
        Locale en = new Locale(disName);
        elc.setLocale(en);
        String result = elc.getLocale().getDisplayName();
        if (!result.equalsIgnoreCase(disName)) {
            throw new Exception("Test FAILED Unexpected Locale Returned!" + TestUtil.NEW_LINE + "Expected: " + disName + TestUtil.NEW_LINE + "Received: " + result);
        }
    }

    @Test
    @TargetVehicle(value="servlet")
    public void elContextIsSetPropertyResolvedTest() throws Exception {
        ELManager elm = new ELManager();
        StandardELContext elc = elm.getELContext();
        boolean isProp = elc.isPropertyResolved();
        if (isProp) {
            throw new Exception("Test FAILED Unexpected result from isPropertyResolved()!" + TestUtil.NEW_LINE + "Should have been false!");
        }
        elc.setPropertyResolved(true);
        isProp = elc.isPropertyResolved();
        if (!isProp) {
            throw new Exception("Test FAILED Unexpected result from isPropertyResolved()!" + TestUtil.NEW_LINE + "Should have been true!");
        }
    }

    @Test
    @TargetVehicle(value="servlet")
    public void elContextPutContextNPETest() throws Exception {
        ELManager elm = new ELManager();
        StandardELContext elc = elm.getELContext();
        TestUtil.logMsg((String)"Testing: ELContext.putContext(String.class, null)");
        ELTestUtil.checkForNPE(elc, "putContext", new Class[]{Class.class, Object.class}, new Object[]{String.class, null});
        TestUtil.logMsg((String)"Testing: ELContext.putContext(null, testStrg)");
        ELTestUtil.checkForNPE(elc, "putContext", new Class[]{Class.class, Object.class}, new Object[]{String.class, null});
    }

    @Test
    @TargetVehicle(value="servlet")
    public void elContextGetContextNPETest() throws Exception {
        ELManager elm = new ELManager();
        StandardELContext elc = elm.getELContext();
        TestUtil.logMsg((String)"Testing: ELContext.getContext(null)");
        ELTestUtil.checkForNPE(elc, "getContext", new Class[]{Class.class}, new Object[]{null});
    }

    @Test
    @TargetVehicle(value="servlet")
    public void elContextAddGetListenersTest() throws Exception {
        ELManager elm = new ELManager();
        StandardELContext elc = elm.getELContext();
        TCKEvalListener listenerOne = new TCKEvalListener();
        TCKEvalListener listenerTwo = new TCKEvalListener();
        elc.addEvaluationListener((EvaluationListener)listenerOne);
        elc.addEvaluationListener((EvaluationListener)listenerTwo);
        List listeners = elc.getEvaluationListeners();
        if (!listeners.contains((Object)listenerOne) || !listeners.contains((Object)listenerTwo)) {
            throw new Exception("Test FAILED Was unable to find test listeners in List returned form ElContext.getListeners()!");
        }
    }

    private static class TCKEvalListener
    extends EvaluationListener {
        private TCKEvalListener() {
        }
    }
}

