/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.ee20.cditests.mdb;

import com.sun.ts.lib.util.RemoteLoggingInitException;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jms.ee20.cditests.mdb.EjbClientIF;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.Resource;
import jakarta.ejb.EJBException;
import jakarta.ejb.Stateful;
import jakarta.inject.Inject;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.JMSConnectionFactory;
import jakarta.jms.JMSConsumer;
import jakarta.jms.JMSContext;
import jakarta.jms.Message;
import jakarta.jms.Queue;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import java.util.Properties;

@Stateful(name="CDITestsMDBClntBean")
public class EjbClient
implements EjbClientIF {
    private static final boolean debug = false;
    private static final long serialVersionUID = 1L;
    long timeout;
    private static int testsExecuted = 0;
    @Inject
    @JMSConnectionFactory(value="jms/ConnectionFactory")
    transient JMSContext context;
    @Resource(name="jms/MyConnectionFactory")
    private transient ConnectionFactory cfactory;
    @Resource(name="jms/MDB_QUEUE")
    private transient Queue queueToMDB;
    @Resource(name="jms/mdbReplyQueue")
    private transient Queue replyQueue;
    @Resource(name="jms/mdbReplyTopic")
    private transient Topic replyTopic;

    private void cleanup() {
        TestUtil.logMsg((String)"cleanup");
    }

    @PostConstruct
    public void postConstruct() {
        System.out.println("EjbClient:postConstruct()");
        System.out.println("cfactory=" + this.cfactory);
        System.out.println("queueToMDB=" + this.queueToMDB);
        System.out.println("replyQueue=" + this.replyQueue);
        System.out.println("replyTopic=" + this.replyTopic);
        if (this.context == null || this.cfactory == null || this.queueToMDB == null || this.replyQueue == null || this.replyTopic == null) {
            throw new EJBException("postConstruct failed: injection failure");
        }
    }

    @Override
    public void init(Properties p) {
        try {
            TestUtil.init((Properties)p);
            this.timeout = Long.parseLong(p.getProperty("jms_timeout"));
        }
        catch (RemoteLoggingInitException e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException("init: failed");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException("init: failed");
        }
    }

    @Override
    public boolean echo(String testName) {
        boolean pass = false;
        if (testName.equals("testCDIInjectionOfMDBWithQueueReplyFromEjb")) {
            pass = this.testCDIInjectionOfMDBWithQueueReplyFromEjb();
        } else if (testName.equals("testCDIInjectionOfMDBWithTopicReplyFromEjb")) {
            pass = this.testCDIInjectionOfMDBWithTopicReplyFromEjb();
        }
        this.cleanup();
        return pass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean testCDIInjectionOfMDBWithQueueReplyFromEjb() {
        boolean pass = true;
        TextMessage messageSent = null;
        TextMessage messageRecv = null;
        JMSConsumer consumer = null;
        try {
            TestUtil.logMsg((String)"Creating TextMessage to send to MDB MsgBeanQ");
            messageSent = this.context.createTextMessage();
            messageSent.setText("Send message to MDB MsgBeanQ");
            messageSent.setStringProperty("TESTNAME", "testCDIInjectionOfMDBWithQueueReplyFromEjb");
            TestUtil.logMsg((String)"Creating JMSConsumer for MDB MsgBeanQ Reply Queue");
            consumer = this.context.createConsumer((Destination)this.replyQueue);
            TestUtil.logMsg((String)"Sending TextMessage to MDB MsgBeanQ");
            this.context.createProducer().send((Destination)this.queueToMDB, (Message)messageSent);
            for (int i = 1; i < 10; ++i) {
                TestUtil.logMsg((String)("Try receiving reply message from MDB MsgBeanQ (loop count=" + i + ")"));
                messageRecv = (TextMessage)consumer.receive(this.timeout);
                if (messageRecv != null) break;
            }
            if (messageRecv != null) {
                String testname = messageRecv.getStringProperty("TESTNAME");
                String reason = messageRecv.getStringProperty("REASON");
                String jmscontext = messageRecv.getStringProperty("JMSCONTEXT");
                String status = messageRecv.getStringProperty("STATUS");
                if (status.equals("Pass")) {
                    TestUtil.logMsg((String)("TEST=" + testname + " PASSED for JMSCONTEXT=" + jmscontext + " REASON=" + reason));
                    pass = true;
                } else {
                    TestUtil.logErr((String)("TEST=" + testname + " FAILED for JMSCONTEXT=" + jmscontext + " REASON=" + reason));
                    pass = false;
                }
            } else {
                TestUtil.logErr((String)"Did no receive a reply message from MDB MsgBeanQ");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e));
            pass = false;
        }
        finally {
            try {
                consumer.receive(this.timeout);
                while (consumer.receiveNoWait() != null) {
                }
                consumer.close();
            }
            catch (Exception exception) {}
        }
        return pass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean testCDIInjectionOfMDBWithTopicReplyFromEjb() {
        boolean pass = true;
        TextMessage messageSent = null;
        TextMessage messageRecv = null;
        JMSConsumer consumer = null;
        try {
            TestUtil.logMsg((String)"Creating TextMessage to send to MDB MsgBeanQ");
            messageSent = this.context.createTextMessage();
            messageSent.setText("Send message to MDB MsgBeanQ");
            messageSent.setStringProperty("TESTNAME", "testCDIInjectionOfMDBWithTopicReplyFromEjb");
            TestUtil.logMsg((String)"Creating JMSConsumer for MDB MsgBeanQ Reply Topic");
            consumer = this.context.createConsumer((Destination)this.replyTopic);
            TestUtil.logMsg((String)"Sending TextMessage to MDB MsgBeanQ");
            this.context.createProducer().send((Destination)this.queueToMDB, (Message)messageSent);
            for (int i = 1; i < 10; ++i) {
                TestUtil.logMsg((String)("Try receiving reply message from MDB MsgBeanQ (loop count=" + i + ")"));
                messageRecv = (TextMessage)consumer.receive(this.timeout);
                if (messageRecv != null) break;
            }
            if (messageRecv != null) {
                String testname = messageRecv.getStringProperty("TESTNAME");
                String reason = messageRecv.getStringProperty("REASON");
                String jmscontext = messageRecv.getStringProperty("JMSCONTEXT");
                String status = messageRecv.getStringProperty("STATUS");
                if (status.equals("Pass")) {
                    TestUtil.logMsg((String)("TEST=" + testname + " PASSED for JMSCONTEXT=" + jmscontext + " REASON=" + reason));
                    pass = true;
                } else {
                    TestUtil.logErr((String)("TEST=" + testname + " FAILED for JMSCONTEXT=" + jmscontext + " REASON=" + reason));
                    pass = false;
                }
            } else {
                TestUtil.logErr((String)"Did no receive a reply message from MDB MsgBeanQ");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e));
            pass = false;
        }
        finally {
            try {
                consumer.receive(this.timeout);
                while (consumer.receiveNoWait() != null) {
                }
                consumer.close();
            }
            catch (Exception exception) {}
        }
        return pass;
    }
}

