/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb30.assembly.initorder.appclientejb;

import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.Status;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.ejb30.assembly.initorder.common.InitOrderRemoteIF;
import com.sun.ts.tests.ejb30.common.helloejbjar.HelloRemoteIF;
import com.sun.ts.tests.ejb30.common.helper.Helper;
import com.sun.ts.tests.ejb30.common.helper.ServiceLocator;
import jakarta.annotation.Resource;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;

public class Client
extends EETest {
    @Resource(lookup="java:app/AppName")
    private static String appNameInjected;

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) {
    }

    public void cleanup() {
    }

    private static HelloRemoteIF getHelloBean() {
        return (HelloRemoteIF)ServiceLocator.lookupNoTry(HelloRemoteIF.GLOBAL_JNDI_NAME, new Context[0]);
    }

    public void initOrder() {
        List<String> expected = Arrays.asList("InitOrder2Bean", "InitOrderBean");
        List<String> records = Client.getHelloBean().getAndClearRecords();
        Helper.getLogger().info(Helper.assertEquals(null, expected, records));
    }

    public void appName() {
        String[] moduleAndBeanNames;
        TestUtil.logTrace((String)"appName(), java:app entries:");
        try {
            InitialContext c = new InitialContext();
            NamingEnumeration<Binding> bindings = c.listBindings("java:app");
            while (bindings.hasMore()) {
                Binding b = bindings.next();
                String name = b.getName();
                Object obj = b.getObject();
                TestUtil.logTrace((String)"java:app/%s entry: %s(%s)".formatted(name, obj, b.getClassName()));
                if (!(obj instanceof Context)) continue;
                Context ctx = (Context)obj;
                TestUtil.logTrace((String)"+ Context(%s) bindings: ".formatted(ctx.getNameInNamespace()));
                NamingEnumeration<Binding> ctxBindings = ctx.listBindings("");
                while (ctxBindings.hasMore()) {
                    Binding b2 = bindings.next();
                    String name2 = b2.getName();
                    Object obj2 = b2.getObject();
                    TestUtil.logTrace((String)"++ %s entry: %s(%s)".formatted(name2, obj2, b2.getClassName()));
                }
            }
            NamingEnumeration<NameClassPair> listings = c.list("java:app");
            while (listings.hasMore()) {
                NameClassPair ncp = listings.next();
                String name = ncp.getName();
                String className = ncp.getClassName();
                TestUtil.logTrace((String)"java:app/%s list: %s".formatted(name, className));
            }
        }
        catch (NamingException e) {
            TestUtil.logMsg((String)"java:app listBindings failed", (Throwable)e);
        }
        String expected = "renamed2";
        String lookup = "java:app/AppName";
        String actual = (String)ServiceLocator.lookupNoTry(lookup, new Context[0]);
        Helper.assertEquals("Check appNameInjected ", expected, appNameInjected);
        Helper.assertEquals("Check " + lookup, expected, actual);
        Helper.getLogger().info("Got expected " + lookup + ": " + actual);
        for (String m : moduleAndBeanNames = new String[]{"one_ejb/InitOrderBean", "two_ejb/InitOrder2Bean"}) {
            StringBuilder reason = new StringBuilder();
            String s = "java:global/renamed2/" + m;
            InitOrderRemoteIF b = (InitOrderRemoteIF)ServiceLocator.lookupNoTry(s, new Context[0]);
            reason.append(String.format("Looked up by global jndi name %s, and got %s", s, b));
            s = "java:global/ejb3_assembly_initorder_appclientejb/" + m;
            try {
                b = (InitOrderRemoteIF)ServiceLocator.lookup(s, new Context[0]);
                throw new RuntimeException("Expecting NamingException when looking up " + s + ", but got " + b);
            }
            catch (NamingException e) {
                reason.append(" Got expected ").append(e).append(" when looking up ").append(s);
                Helper.getLogger().info(reason.toString());
            }
        }
    }
}

