/*
 * Copyright (c) 2007, 2020 Oracle and/or its affiliates. All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0, which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the
 * Eclipse Public License v. 2.0 are satisfied: GNU General Public License,
 * version 2 with the GNU Classpath Exception, which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 */

/*
 * @(#)prepStmtClient4.java	1.15 03/05/16
 */

package com.sun.ts.tests.jdbc.ee.prepStmt.prepStmt4;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;

import javax.sql.DataSource;

import org.jboss.arquillian.junit5.ArquillianExtension;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.extension.ExtendWith;

import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.harness.Status;
import com.sun.ts.lib.util.TSNamingContextInterface;
import com.sun.ts.lib.util.TestUtil;
// Merant DataSource class
//import com.merant.sequelink.jdbcx.datasource.*;
import com.sun.ts.tests.jdbc.ee.common.DataSourceConnection;
import com.sun.ts.tests.jdbc.ee.common.DriverManagerConnection;
import com.sun.ts.tests.jdbc.ee.common.JDBCTestMsg;
import com.sun.ts.tests.jdbc.ee.common.csSchema;
import com.sun.ts.tests.jdbc.ee.common.dbSchema;
import com.sun.ts.tests.jdbc.ee.common.rsSchema;

/**
 * The prepStmtClient4 class tests methods of PreparedStatement interface using
 * Sun's J2EE Reference Implementation.
 * 
 * @author
 * @version 1.8, 11/24/00
 */
@ExtendWith(ArquillianExtension.class)
@Tag("jdbc")
@Tag("platform")

public class prepStmtClient4 extends ServiceEETest implements Serializable {
	private static final String testName = "jdbc.ee.prepStmt.prepStmt4";

	// Naming specific member variables
	private TSNamingContextInterface jc = null;

	// Harness requirements
	private transient Connection conn = null;

	private ResultSet rs = null;

	private Statement stmt = null;

	private DataSource ds1 = null;

	private PreparedStatement pstmt = null;

	private dbSchema dbSch = null;

	private rsSchema rsSch = null;

	private csSchema csSch = null;

	private String drManager = null;

	private transient DatabaseMetaData dbmd = null;

	private Properties sqlp = null;

	private Properties props = null;

	private JDBCTestMsg msg = null;

	/* Run test in standalone mode */
	public static void main(String[] args) {
		prepStmtClient4 theTests = new prepStmtClient4();
		Status s = theTests.run(args, System.out, System.err);
		s.exit();
	}

	/* Test setup: */
	/*
	 * @class.setup_props: Driver, the Driver name; db1, the database name with url;
	 * user1, the database user name; password1, the database password; db2, the
	 * database name with url; user2, the database user name; password2, the
	 * database password; DriverManager, flag for DriverManager; ptable, the primary
	 * table; ftable, the foreign table; cofSize, the initial size of the ptable;
	 * cofTypeSize, the initial size of the ftable; binarySize, size of binary data
	 * type; varbinarySize, size of varbinary data type; longvarbinarySize, size of
	 * longvarbinary data type;
	 * 
	 * @class.testArgs: -ap tssql.stmt
	 */

	public void setup(String[] args, Properties p) throws Exception {
		try {
			try {
				drManager = p.getProperty("DriverManager", "");
				if (drManager.length() == 0)
					throw new Exception("Invalid DriverManager Name");
				// sqlp = new Properties();
				props = p;
				/*
				 * String sqlStmt= p.getProperty("rsQuery",""); InputStream istr= new
				 * FileInputStream(sqlStmt); sqlp.load(istr);
				 */
				sqlp = p;

				if (drManager.equals("yes")) {
					logTrace("Using DriverManager");
					DriverManagerConnection dmCon = new DriverManagerConnection();
					conn = dmCon.getConnection(p);
				} else {
					logTrace("Using DataSource");
					DataSourceConnection dsCon = new DataSourceConnection();
					conn = dsCon.getConnection(p);
				}

				stmt = conn.createStatement();
				dbmd = conn.getMetaData();
				rsSch = new rsSchema();
				csSch = new csSchema();
				msg = new JDBCTestMsg();
			} catch (SQLException ex) {
				logErr("SQL Exception : " + ex.getMessage(), ex);
			}
		} catch (Exception e) {
			logErr("Setup Failed!");
			TestUtil.printStackTrace(e);
		}
	}

	/*
	 * @testName: testSetObject10
	 * 
	 * @assertion_ids: JDBC:SPEC:9; JDBC:JAVADOC:696; JDBC:JAVADOC:697;
	 * JavaEE:SPEC:186;
	 *
	 * @test_Strategy: Get a PreparedStatement object from the connection to the
	 * database. Using the setObject(int parameterIndex, Object x) method,update the
	 * column Min_val with the maximum value of Integer_Tab. Call the getObject(int
	 * columnno) method to retrieve this value. Extract the maximum value from the
	 * tssql.stmt file. Compare this value with the value returned by the
	 * getObject(int columnNo) method. Both the values should be equal.
	 */

	public void testSetObject10() throws Exception {
		Integer maxIntegerVal = null;
		Integer rIntegerVal = null;
		String smaxIntegerVal = null;

		try {
			// to create the Integer Table
			rsSch.createTab("Integer_Tab", sqlp, conn);

			String sPrepStmt = sqlp.getProperty("Integer_Tab_Min_Update", "");
			msg.setMsg("Prepared Statement String: " + sPrepStmt);

			msg.setMsg("extract the Maximum Value of Integer to be Updated");
			smaxIntegerVal = rsSch.extractVal("Integer_Tab", 1, sqlp, conn);
			maxIntegerVal = maxIntegerVal.valueOf(smaxIntegerVal);

			msg.setMsg("get the PreparedStatement object");
			pstmt = conn.prepareStatement(sPrepStmt);
			pstmt.setObject(1, maxIntegerVal);
			pstmt.executeUpdate();

			msg.setMsg("to query from the database to check the call of pstmt.executeUpdate");
			String Min_Val_Query = sqlp.getProperty("Integer_Query_Min", "");
			msg.setMsg(Min_Val_Query);
			rs = stmt.executeQuery(Min_Val_Query);
			rs.next();

			Object orIntegerVal = rs.getObject(1);

			msg.addOutputMsg("" + maxIntegerVal, orIntegerVal.toString());

			if (orIntegerVal.toString().trim().equals(smaxIntegerVal.trim())) {
				msg.setMsg("setObject Method sets the designated parameter with the Object");
			} else {
				msg.printTestError("setObject Method does not set the designated parameter with the Object",
						"test setObject Failed!");

			}
			msg.printTestMsg();
			msg.printOutputMsg();
		} catch (SQLException sqle) {
			msg.printSQLError(sqle, "Call to setObject is Failed!");

		} catch (Exception e) {
			msg.printError(e, "Call to setObject is Failed!");

		}

		finally {
			try {
				if (rs != null) {
					rs.close();
					rs = null;
				}
				if (pstmt != null) {
					pstmt.close();
					pstmt = null;
				}
				if (stmt != null) {
					stmt.close();
					stmt = null;
				}
				rsSch.dropTab("Integer_Tab", conn);
			} catch (Exception e) {
			}
		}
	}

	/*
	 * @testName: testSetObject11
	 * 
	 * @assertion_ids: JDBC:SPEC:9; JDBC:JAVADOC:696; JDBC:JAVADOC:697;
	 * JavaEE:SPEC:186;
	 *
	 * @test_Strategy: Get a PreparedStatement object from the connection to the
	 * database. Using the setObject(int parameterIndex, Object x) method,update the
	 * column Null_val with the minimum value of Integer_Tab. Call the getObject(int
	 * columnno) method to retrieve this value. Extract the minimum value from the
	 * tssql.stmt file. Compare this value with the value returned by the
	 * getObject(int columnNo) method. Both the values should be equal.
	 */

	public void testSetObject11() throws Exception {
		Integer minIntegerVal = null;
		Integer rIntegerVal = null;
		String sminIntegerVal = null;

		try {
			// to create the Integer Table
			rsSch.createTab("Integer_Tab", sqlp, conn);

			// to update Null value column with Minimum value
			String sPrepStmt = sqlp.getProperty("Integer_Tab_Null_Update", "");
			msg.setMsg("Prepared Statement String: " + sPrepStmt);

			msg.setMsg("extract the Maximum Value of Integer to be Updated");
			sminIntegerVal = rsSch.extractVal("Integer_Tab", 2, sqlp, conn);
			minIntegerVal = minIntegerVal.valueOf(sminIntegerVal);

			msg.setMsg("get the PreparedStatement object");
			pstmt = conn.prepareStatement(sPrepStmt);
			pstmt.setObject(1, minIntegerVal);
			pstmt.executeUpdate();

			msg.setMsg("to query from the database to check the call of pstmt.executeUpdate");
			String Null_Val_Query = sqlp.getProperty("Integer_Query_Null", "");
			msg.setMsg(Null_Val_Query);
			rs = stmt.executeQuery(Null_Val_Query);
			rs.next();

			Object orIntegerVal = rs.getObject(1);

			msg.addOutputMsg("" + minIntegerVal, orIntegerVal.toString());
			if (orIntegerVal.toString().trim().equals(sminIntegerVal.trim())) {
				msg.setMsg("setObject Method sets the designated parameter with the Object");
			} else {
				msg.printTestError("setObject Method does not set the designated parameter with the Object",
						"test setObject Failed!");

			}
			msg.printTestMsg();
			msg.printOutputMsg();
		} catch (SQLException sqle) {
			msg.printSQLError(sqle, "Call to setObject is Failed!");

		} catch (Exception e) {
			msg.printError(e, "Call to setObject is Failed!");

		}

		finally {
			try {
				if (rs != null) {
					rs.close();
					rs = null;
				}
				if (pstmt != null) {
					pstmt.close();
					pstmt = null;
				}
				if (stmt != null) {
					stmt.close();
					stmt = null;
				}
				rsSch.dropTab("Integer_Tab", conn);
			} catch (Exception e) {
			}
		}
	}

	/*
	 * @testName: testSetObject12
	 * 
	 * @assertion_ids: JDBC:SPEC:9; JDBC:JAVADOC:696; JDBC:JAVADOC:697;
	 * JavaEE:SPEC:186;
	 *
	 * @test_Strategy: Get a PreparedStatement object from the connection to the
	 * database. Using the setObject(int parameterIndex, Object x) method,update the
	 * column Min_val with the maximum value of Bigint_Tab. Call the getObject(int
	 * columnno) method to retrieve this value. Extract the maximum value from the
	 * tssql.stmt file. Compare this value with the value returned by the
	 * getObject(int columnNo) method. Both the values should be equal.
	 */

	public void testSetObject12() throws Exception {
		Long maxLongVal = null;
		Long rLongVal = null;
		String smaxLongVal = null;

		try {
			// to create the Bigint Table
			rsSch.createTab("Bigint_Tab", sqlp, conn);

			// to update Minimum value column with maximum
			String sPrepStmt = sqlp.getProperty("Bigint_Tab_Min_Update", "");
			msg.setMsg("Prepared Statement String: " + sPrepStmt);

			msg.setMsg("extract the Maximum Value of Long to be Updated ");
			smaxLongVal = rsSch.extractVal("Bigint_Tab", 1, sqlp, conn);
			maxLongVal = maxLongVal.valueOf(smaxLongVal);

			msg.setMsg("get the PreparedStatement object");
			pstmt = conn.prepareStatement(sPrepStmt);
			pstmt.setObject(1, maxLongVal);
			pstmt.executeUpdate();

			msg.setMsg("to query from the database to check the call of pstmt.executeUpdate");
			String Min_Val_Query = sqlp.getProperty("Bigint_Query_Min", "");
			msg.setMsg(Min_Val_Query);
			rs = stmt.executeQuery(Min_Val_Query);
			rs.next();

			Object orLongVal = rs.getObject(1);

			msg.addOutputMsg(smaxLongVal, orLongVal.toString());
			if (orLongVal.toString().trim().equals(smaxLongVal.trim())) {
				msg.setMsg("setObject Method sets the designated parameter with the Object");
			} else {
				msg.printTestError("setObject Method does not set the designated parameter with the Object",
						"test setObject Failed!");

			}
			msg.printTestMsg();
			msg.printOutputMsg();
		} catch (SQLException sqle) {
			msg.printSQLError(sqle, "Call to setObject is Failed!");

		} catch (Exception e) {
			msg.printError(e, "Call to setObject is Failed!");

		}

		finally {
			try {
				if (rs != null) {
					rs.close();
					rs = null;
				}
				if (pstmt != null) {
					pstmt.close();
					pstmt = null;
				}
				if (stmt != null) {
					stmt.close();
					stmt = null;
				}
				rsSch.dropTab("Bigint_Tab", conn);
			} catch (Exception e) {
			}
		}
	}

	/*
	 * @testName: testSetObject13
	 * 
	 * @assertion_ids: JDBC:SPEC:9; JDBC:JAVADOC:696; JDBC:JAVADOC:697;
	 * JavaEE:SPEC:186;
	 *
	 * @test_Strategy: Get a PreparedStatement object from the connection to the
	 * database. Using the setObject(int parameterIndex, Object x) method,update the
	 * column Null_val with the maximum value of Bigint_Tab. Call the getObject(int
	 * columnno) method to retrieve this value. Extract the maximum value from the
	 * tssql.stmt file. Compare this value with the value returned by the
	 * getObject(int columnNo) method. Both the values should be equal.
	 */

	public void testSetObject13() throws Exception {
		Long minLongVal = null;
		Long rLongVal = null;
		String sminLongVal = null;

		try {
			// to create the Bigint Table
			rsSch.createTab("Bigint_Tab", sqlp, conn);

			// to update Null value column with Minimum value
			String sPrepStmt = sqlp.getProperty("Bigint_Tab_Null_Update", "");
			msg.setMsg("Prepared Statement String: " + sPrepStmt);

			msg.setMsg("extract the Maximum Value of Long to be Updated");
			sminLongVal = rsSch.extractVal("Bigint_Tab", 2, sqlp, conn);
			minLongVal = minLongVal.valueOf(sminLongVal);

			msg.setMsg("get the PreparedStatement object");
			pstmt = conn.prepareStatement(sPrepStmt);
			pstmt.setObject(1, minLongVal);
			pstmt.executeUpdate();

			msg.setMsg("to query from the database to check the call of pstmt.executeUpdate");
			String Null_Val_Query = sqlp.getProperty("Bigint_Query_Null", "");
			msg.setMsg(Null_Val_Query);
			rs = stmt.executeQuery(Null_Val_Query);
			rs.next();

			Object orLongVal = rs.getObject(1);

			msg.addOutputMsg("" + minLongVal, orLongVal.toString());
			if (orLongVal.toString().trim().equals(sminLongVal.trim())) {
				msg.setMsg("setObject Method sets the designated parameter with the Object");
			} else {
				msg.printTestError("setObject Method does not set the designated parameter with the Object",
						"test setObject Failed!");

			}
			msg.printTestMsg();
			msg.printOutputMsg();
		} catch (SQLException sqle) {
			msg.printSQLError(sqle, "Call to setObject is Failed!");

		} catch (Exception e) {
			msg.printError(e, "Call to setObject is Failed!");

		}

		finally {
			try {
				if (rs != null) {
					rs.close();
					rs = null;
				}
				if (pstmt != null) {
					pstmt.close();
					pstmt = null;
				}
				if (stmt != null) {
					stmt.close();
					stmt = null;
				}
				rsSch.dropTab("Bigint_Tab", conn);
			} catch (Exception e) {
			}
		}
	}

	/*
	 * @testName: testSetObject14
	 * 
	 * @assertion_ids: JDBC:SPEC:9; JDBC:JAVADOC:696; JDBC:JAVADOC:697;
	 * JavaEE:SPEC:186;
	 *
	 * @test_Strategy: Get a PreparedStatement object from the connection to the
	 * database. Using the setObject(int parameterIndex, Object x) method,update the
	 * column Min_Val with the maximum value of Double_Tab. Call the getObject(int
	 * columnno) method to retrieve this value. Extract the maximum value from the
	 * tssql.stmt file. Compare this value with the value returned by the
	 * getObject(int columnno) method. Both the values should be equal.
	 */

	public void testSetObject14() throws Exception {
		Double maxDoubleVal = null;
		Double rDoubleVal = null;
		String smaxDoubleVal = null;

		try {
			// to create the Double Table
			rsSch.createTab("Double_Tab", sqlp, conn);

			// to update Minimum value column with maximum
			String sPrepStmt = sqlp.getProperty("Double_Tab_Min_Update", "");
			msg.setMsg("Prepared Statement String: " + sPrepStmt);

			msg.setMsg("extract the Maximum Value of Double to be Updated");
			smaxDoubleVal = rsSch.extractVal("Double_Tab", 1, sqlp, conn);
			maxDoubleVal = new Double(smaxDoubleVal);

			msg.setMsg("get the PreparedStatement object");
			pstmt = conn.prepareStatement(sPrepStmt);
			pstmt.setObject(1, maxDoubleVal);
			pstmt.executeUpdate();

			msg.setMsg("to query from the database to check the call of pstmt.executeUpdate");
			// to get the query string
			String Min_Val_Query = sqlp.getProperty("Double_Query_Min", "");
			msg.setMsg(Min_Val_Query);
			rs = stmt.executeQuery(Min_Val_Query);
			rs.next();

			rDoubleVal = (Double) rs.getObject(1);

			msg.addOutputMsg("" + maxDoubleVal, "" + rDoubleVal);
			if (rDoubleVal.equals(maxDoubleVal)) {
				msg.setMsg("setObject Method sets the designated parameter with the Object");
			} else {
				msg.printTestError("setObject Method does not set the designated parameter with the Object",
						"test setObject Failed!");

			}
			msg.printTestMsg();
			msg.printOutputMsg();
		} catch (SQLException sqle) {
			msg.printSQLError(sqle, "Call to setObject is Failed!");

		} catch (Exception e) {
			msg.printError(e, "Call to setObject is Failed!");

		}

		finally {
			try {
				if (rs != null) {
					rs.close();
					rs = null;
				}
				if (pstmt != null) {
					pstmt.close();
					pstmt = null;
				}
				if (stmt != null) {
					stmt.close();
					stmt = null;
				}
				rsSch.dropTab("Double_Tab", conn);
			} catch (Exception e) {
			}
		}
	}

	/*
	 * @testName: testSetObject15
	 * 
	 * @assertion_ids: JDBC:SPEC:9; JDBC:JAVADOC:696; JDBC:JAVADOC:697;
	 * JavaEE:SPEC:186;
	 *
	 * @test_Strategy: Get a PreparedStatement object from the connection to the
	 * database. Using the setObject(int parameterIndex, Object x) method,update the
	 * column Null_Val with the minimum value of Double_Tab. Call the getObject(int
	 * columnno) method to retrieve this value. Extract the minimum value from the
	 * tssql.stmt file. Compare this value with the value returned by the
	 * getObject(int columnno) method. Both the values should be equal.
	 */

	public void testSetObject15() throws Exception {
		Double minDoubleVal = null;
		Double rDoubleVal = null;
		String sminDoubleVal = null;

		try {
			// to create the Double Table
			rsSch.createTab("Double_Tab", sqlp, conn);

			// to update Null value column with Minimum value
			String sPrepStmt = sqlp.getProperty("Double_Tab_Null_Update", "");
			msg.setMsg("Prepared Statement String: " + sPrepStmt);

			msg.setMsg("extract the Maximum Value of Double to be Updated");
			sminDoubleVal = rsSch.extractVal("Double_Tab", 2, sqlp, conn);
			minDoubleVal = new Double(sminDoubleVal);

			msg.setMsg("get the PreparedStatement object");
			pstmt = conn.prepareStatement(sPrepStmt);
			pstmt.setObject(1, minDoubleVal);
			pstmt.executeUpdate();

			msg.setMsg("to query from the database to check the call of pstmt.executeUpdate");
			// to get the query string
			String Null_Val_Query = sqlp.getProperty("Double_Query_Null", "");
			msg.setMsg(Null_Val_Query);
			rs = stmt.executeQuery(Null_Val_Query);
			rs.next();

			rDoubleVal = (Double) rs.getObject(1);

			msg.addOutputMsg("" + minDoubleVal, "" + rDoubleVal);
			if (rDoubleVal.equals(minDoubleVal)) {
				msg.setMsg("setObject Method sets the designated parameter with the Object");
			} else {
				msg.printTestError("setObject Method does not set the designated parameter with the Object",
						"test setObject Failed!");

			}
			msg.printTestMsg();
			msg.printOutputMsg();
		} catch (SQLException sqle) {
			msg.printSQLError(sqle, "Call to setObject is Failed!");

		} catch (Exception e) {
			msg.printError(e, "Call to setObject is Failed!");

		}

		finally {
			try {
				if (rs != null) {
					rs.close();
					rs = null;
				}
				if (pstmt != null) {
					pstmt.close();
					pstmt = null;
				}
				if (stmt != null) {
					stmt.close();
					stmt = null;
				}
				rsSch.dropTab("Double_Tab", conn);
			} catch (Exception e) {
			}
		}
	}

	/*
	 * @testName: testSetObject16
	 * 
	 * @assertion_ids: JDBC:SPEC:9; JDBC:JAVADOC:696; JDBC:JAVADOC:697;
	 * JavaEE:SPEC:186;
	 *
	 * @test_Strategy: Get a PreparedStatement object from the connection to the
	 * database. Using the setObject(int parameterIndex, Object x) method,update the
	 * column Min_Val with the maximum value of Float_Tab. Call the getObject(int
	 * columnno) method to retrieve this value. Extract the maximum value from the
	 * tssql.stmt file. Compare this value with the value returned by the
	 * getObject(int columnNo) method. Both the values should be equal.
	 */

	public void testSetObject16() throws Exception {
		Double maxDoubleVal = null;
		Double rDoubleVal = null;
		String smaxDoubleVal = null;

		try {
			// to create the Double Table
			rsSch.createTab("Float_Tab", sqlp, conn);

			// to update Minimum value column with maximum
			String sPrepStmt = sqlp.getProperty("Float_Tab_Min_Update", "");
			msg.setMsg("Prepared Statement String: " + sPrepStmt);

			msg.setMsg("extract the Maximum Value of Float to be Updated");
			smaxDoubleVal = rsSch.extractVal("Float_Tab", 1, sqlp, conn);
			maxDoubleVal = new Double(smaxDoubleVal);

			msg.setMsg("get the PreparedStatement object");
			pstmt = conn.prepareStatement(sPrepStmt);
			pstmt.setObject(1, maxDoubleVal);
			pstmt.executeUpdate();

			msg.setMsg("to query from the database to check the call of pstmt.executeUpdate");
			// to get the query string
			String Min_Val_Query = sqlp.getProperty("Float_Query_Min", "");
			msg.setMsg(Min_Val_Query);
			rs = stmt.executeQuery(Min_Val_Query);
			rs.next();

			rDoubleVal = (Double) rs.getObject(1);

			msg.addOutputMsg("" + maxDoubleVal, "" + rDoubleVal);
			if (rDoubleVal.equals(maxDoubleVal)) {
				msg.setMsg("setObject Method sets the designated parameter with the Object");
			} else {
				msg.printTestError("setObject Method does not set the designated parameter with the Object",
						"test setObject Failed!");

			}
			msg.printTestMsg();
			msg.printOutputMsg();
		} catch (SQLException sqle) {
			msg.printSQLError(sqle, "Call to setObject is Failed!");

		} catch (Exception e) {
			msg.printError(e, "Call to setObject is Failed!");

		}

		finally {
			try {
				if (rs != null) {
					rs.close();
					rs = null;
				}
				if (pstmt != null) {
					pstmt.close();
					pstmt = null;
				}
				if (stmt != null) {
					stmt.close();
					stmt = null;
				}
				rsSch.dropTab("Float_Tab", conn);
			} catch (Exception e) {
			}
		}
	}

	/*
	 * @testName: testSetObject17
	 * 
	 * @assertion_ids: JDBC:SPEC:9; JDBC:JAVADOC:696; JDBC:JAVADOC:697;
	 * JavaEE:SPEC:186;
	 *
	 * @test_Strategy: Get a PreparedStatement object from the connection to the
	 * database. Using the setObject(int parameterIndex, Object x) method,update the
	 * column Null_Val with the minimum value of Float_Tab. Call the getObject(int
	 * columnno) method to retrieve this value. Extract the minimum value from the
	 * tssql.stmt file. Compare this value with the value returned by the
	 * getObject(int columnno) method. Both the values should be equal.
	 */

	public void testSetObject17() throws Exception {
		Double minDoubleVal = null;
		Double rDoubleVal = null;
		String sminDoubleVal = null;

		try {

			// to create the Double Table
			rsSch.createTab("Float_Tab", sqlp, conn);

			// to update Null value column with Minimum value
			String sPrepStmt = sqlp.getProperty("Float_Tab_Null_Update", "");
			msg.setMsg("Prepared Statement String: " + sPrepStmt);

			msg.setMsg("extract the Maximum Value of Float to be Updated");
			sminDoubleVal = rsSch.extractVal("Float_Tab", 2, sqlp, conn);
			minDoubleVal = new Double(sminDoubleVal);

			msg.setMsg("get the PreparedStatement object");
			pstmt = conn.prepareStatement(sPrepStmt);
			pstmt.setObject(1, minDoubleVal);
			pstmt.executeUpdate();

			msg.setMsg("to query from the database to check the call of pstmt.executeUpdate");
			// to get the query string
			String Null_Val_Query = sqlp.getProperty("Float_Query_Null", "");
			msg.setMsg(Null_Val_Query);
			rs = stmt.executeQuery(Null_Val_Query);
			rs.next();

			rDoubleVal = (Double) rs.getObject(1);

			msg.addOutputMsg("" + minDoubleVal, "" + rDoubleVal);
			if (rDoubleVal.equals(minDoubleVal)) {
				msg.setMsg("setObject Method sets the designated parameter with the Object");
			} else {
				msg.printTestError("setObject Method does not set the designated parameter with the Object",
						"test setObject Failed!");

			}
			msg.printTestMsg();
			msg.printOutputMsg();
		} catch (SQLException sqle) {
			msg.printSQLError(sqle, "Call to setObject is Failed!");

		} catch (Exception e) {
			msg.printError(e, "Call to setObject is Failed!");

		}

		finally {
			try {
				if (rs != null) {
					rs.close();
					rs = null;
				}
				if (pstmt != null) {
					pstmt.close();
					pstmt = null;
				}
				if (stmt != null) {
					stmt.close();
					stmt = null;
				}
				rsSch.dropTab("Float_Tab", conn);
			} catch (Exception e) {
			}
		}
	}

	/*
	 * @testName: testSetObject18
	 * 
	 * @assertion_ids: JDBC:SPEC:9; JDBC:JAVADOC:696; JDBC:JAVADOC:697;
	 * JavaEE:SPEC:186;
	 *
	 * @test_Strategy: Get a PreparedStatement object from the connection to the
	 * database. Using the setObject(int parameterIndex, Object x) method,update the
	 * column Null_Val with the Non Null value of Date_Tab. Call the getObject(int
	 * columnno) method to retrieve this value. Extract the Non Null value from the
	 * tssql.stmt file. Compare this value with the value returned by the
	 * getObject(int columnno) method. Both the values should be equal.
	 */

	public void testSetObject18() throws Exception {
		java.sql.Date mfgDateVal = null;
		String sMfgDateVal = null;
		java.sql.Date rDateVal = null;

		try {
			rsSch.createTab("Date_Tab", sqlp, conn);
			String sPrepStmt = sqlp.getProperty("Date_Tab_Null_Update", "");
			msg.setMsg("Prepared Statement String: " + sPrepStmt);

			msg.setMsg("extract the Value of Date to be Updated");
			sMfgDateVal = rsSch.extractVal("Date_Tab", 1, sqlp, conn);
			sMfgDateVal = sMfgDateVal.substring(sMfgDateVal.indexOf('\'') + 1, sMfgDateVal.lastIndexOf('\''));

			// to convert String value into java.sql.Date value
			mfgDateVal = mfgDateVal.valueOf(sMfgDateVal);

			msg.setMsg("get the PreparedStatement object");
			pstmt = conn.prepareStatement(sPrepStmt);
			pstmt.setObject(1, mfgDateVal);
			pstmt.executeUpdate();

			msg.setMsg("to query from the database to check the call of pstmt.executeUpdate");
			// to get the query string
			String Null_Val_Query = sqlp.getProperty("Date_Query_Null", "");
			msg.setMsg(Null_Val_Query);
			rs = stmt.executeQuery(Null_Val_Query);
			rs.next();

			java.util.Date urDateVal = (java.util.Date) rs.getObject(1);

			long ld = urDateVal.getTime();
			rDateVal = new java.sql.Date(ld);

			msg.addOutputMsg("" + mfgDateVal, "" + rDateVal);
			if (rDateVal.compareTo(mfgDateVal) == 0) {
				msg.setMsg("setObject Method sets the designated parameter with the Object");
			} else {
				msg.printTestError("setObject Method does not set the designated parameter with the Object",
						"test setObject Failed!");

			}
			msg.printTestMsg();
			msg.printOutputMsg();
		} catch (SQLException sqle) {
			msg.printSQLError(sqle, "Call to setObject is Failed!");

		} catch (Exception e) {
			msg.printError(e, "Call to setObject is Failed!");

		}

		finally {
			try {
				if (rs != null) {
					rs.close();
					rs = null;
				}
				if (pstmt != null) {
					pstmt.close();
					pstmt = null;
				}
				if (stmt != null) {
					stmt.close();
					stmt = null;
				}
				rsSch.dropTab("Date_Tab", conn);
			} catch (Exception e) {
			}
		}
	}

	/*
	 * @testName: testSetObject19
	 * 
	 * @assertion_ids: JDBC:SPEC:9; JDBC:JAVADOC:696; JDBC:JAVADOC:697;
	 * JavaEE:SPEC:186;
	 *
	 * @test_Strategy: Get a PreparedStatement object from the connection to the
	 * database. Using the setObject(int parameterIndex, Object x) method,update the
	 * column Null_Val with the Non Null value of Time_Tab. Call the getObject(int
	 * columnno) method to retrieve this value. Extract the Non Null value from the
	 * tssql.stmt file. Compare this value with the value returned by the
	 * getObject(int columnno) method. Both the values should be equal.
	 */

	public void testSetObject19() throws Exception {
		java.sql.Time brkTimeVal = null;
		String sBrkTimeVal = null;
		java.sql.Time rTimeVal = null;

		try {
			rsSch.createTab("Time_Tab", sqlp, conn);
			String sPrepStmt = sqlp.getProperty("Time_Tab_Null_Update", "");
			msg.setMsg("Prepared Statement String: " + sPrepStmt);

			msg.setMsg("extract the Value of Time to be Updated");
			sBrkTimeVal = rsSch.extractVal("Time_Tab", 1, sqlp, conn);
			sBrkTimeVal = sBrkTimeVal.substring(sBrkTimeVal.indexOf('\'') + 1, sBrkTimeVal.lastIndexOf('\''));

			// to convert String value into java.sql.Time value
			brkTimeVal = brkTimeVal.valueOf(sBrkTimeVal);

			msg.setMsg("get the PreparedStatement object");
			pstmt = conn.prepareStatement(sPrepStmt);
			pstmt.setObject(1, brkTimeVal);
			pstmt.executeUpdate();

			msg.setMsg("to query from the database to check the call of pstmt.executeUpdate");
			// to get the query string
			String Null_Val_Query = sqlp.getProperty("Time_Query_Null", "");
			msg.setMsg(Null_Val_Query);
			rs = stmt.executeQuery(Null_Val_Query);
			rs.next();

			java.util.Date urTimeVal = (java.util.Date) rs.getObject(1);

			long lt = urTimeVal.getTime();
			rTimeVal = new java.sql.Time(lt);

			msg.addOutputMsg("" + brkTimeVal, "" + rTimeVal);
			if (rTimeVal.toString().trim().equals(brkTimeVal.toString().trim())) {
				msg.setMsg("setObject Method sets the designated parameter with the Object");
			} else {
				msg.printTestError("setObject Method does not set the designated parameter with the Object",
						"test setObject Failed!");

			}
			msg.printTestMsg();
			msg.printOutputMsg();
		} catch (SQLException sqle) {
			msg.printSQLError(sqle, "Call to setObject is Failed!");

		} catch (Exception e) {
			msg.printError(e, "Call to setObject is Failed!");

		} finally {
			try {
				if (rs != null) {
					rs.close();
					rs = null;
				}
				if (pstmt != null) {
					pstmt.close();
					pstmt = null;
				}
				if (stmt != null) {
					stmt.close();
					stmt = null;
				}
				rsSch.dropTab("Time_Tab", conn);
			} catch (Exception e) {
			}
		}
	}

	/*
	 * @testName: testSetObject20
	 * 
	 * @assertion_ids: JDBC:SPEC:9; JDBC:JAVADOC:696; JDBC:JAVADOC:697;
	 * JavaEE:SPEC:186;
	 *
	 * @test_Strategy: Get a PreparedStatement object from the connection to the
	 * database. Using the setObject(int parameterIndex, Object x) method,update the
	 * column Null_Val with the Non Null value of Timestamp_Tab. Call the
	 * getObject(int columnno) method to retrieve this value. Extract the Non Null
	 * value from the tssql.stmt file. Compare this value with the value returned by
	 * the getObject(int columnno) method. Both the values should be equal.
	 */

	public void testSetObject20() throws Exception {
		java.sql.Timestamp inTimeVal = null;
		String sInTimeVal = null;
		java.sql.Timestamp rTimestampVal = null;

		try {
			rsSch.createTab("Timestamp_Tab", sqlp, conn);
			String sPrepStmt = sqlp.getProperty("Timestamp_Tab_Null_Update", "");
			msg.setMsg("Prepared Statement String: " + sPrepStmt);

			msg.setMsg("extract the Value of Timestamp to be Updated");
			sInTimeVal = rsSch.extractVal("Timestamp_Tab", 1, sqlp, conn);
			sInTimeVal = sInTimeVal.substring(sInTimeVal.indexOf('\'') + 1, sInTimeVal.lastIndexOf('\''));

			// to convert String value into java.sql.Timestamp
			inTimeVal = inTimeVal.valueOf(sInTimeVal);

			msg.setMsg("get the PreparedStatement object");
			pstmt = conn.prepareStatement(sPrepStmt);
			pstmt.setObject(1, inTimeVal);
			pstmt.executeUpdate();

			msg.setMsg("to query from the database to check the call of pstmt.executeUpdate");
			// to get the query string
			String Null_Val_Query = sqlp.getProperty("Timestamp_Query_Null", "");
			msg.setMsg(Null_Val_Query);
			rs = stmt.executeQuery(Null_Val_Query);
			rs.next();

			rTimestampVal = (java.sql.Timestamp) rs.getObject(1);

			msg.addOutputMsg("" + inTimeVal, "" + rTimestampVal);
			if (rTimestampVal.equals(inTimeVal)) {
				msg.setMsg("setObject Method sets the designated parameter with the Object");
			} else {
				msg.printTestError("setObject Method does not set the designated parameter with the Object",
						"test setObject Failed!");

			}
			msg.printTestMsg();
			msg.printOutputMsg();
		} catch (SQLException sqle) {
			msg.printSQLError(sqle, "Call to setObject is Failed!");

		} catch (Exception e) {
			msg.printError(e, "Call to setObject is Failed!");

		}

		finally {
			try {
				if (rs != null) {
					rs.close();
					rs = null;
				}
				if (pstmt != null) {
					pstmt.close();
					pstmt = null;
				}
				if (stmt != null) {
					stmt.close();
					stmt = null;
				}
				rsSch.dropTab("Timestamp_Tab", conn);
			} catch (Exception e) {
			}
		}
	}

	/*
	 * @testName: testSetObject21
	 * 
	 * @assertion_ids: JDBC:SPEC:9; JDBC:JAVADOC:696; JDBC:JAVADOC:697;
	 * JavaEE:SPEC:186;
	 * 
	 * @test_Strategy: Get a PreparedStatement object from the connection to the
	 * database. Using the setObject(int parameterIndex, Object x) method,update the
	 * column Min_Val with the maximum value of Real_Tab. Call the getObject(int
	 * columnno) method to retrieve this value. Extract the maximum value from the
	 * tssql.stmt file. Compare this value with the value returned by the
	 * getObject(int columnno) method. Both the values should be equal.
	 */

	public void testSetObject21() throws Exception {
		Float maxFloatVal = null;
		Float rFloatVal = null;
		String smaxFloatVal = null;

		try {
			// to create the Real Table
			rsSch.createTab("Real_Tab", sqlp, conn);
			String sPrepStmt = sqlp.getProperty("Real_Tab_Min_Update", "");
			msg.setMsg("Prepared Statement String: " + sPrepStmt);

			msg.setMsg("extract the Maximum Value of Float to be Updated");
			smaxFloatVal = rsSch.extractVal("Real_Tab", 1, sqlp, conn);
			maxFloatVal = maxFloatVal.valueOf(smaxFloatVal);

			msg.setMsg("get the PreparedStatement object");
			pstmt = conn.prepareStatement(sPrepStmt);
			pstmt.setObject(1, maxFloatVal);
			pstmt.executeUpdate();

			msg.setMsg("to query from the database to check the call of pstmt.executeUpdate");
			// to get the query string
			String Min_Val_Query = sqlp.getProperty("Real_Query_Min", "");
			msg.setMsg(Min_Val_Query);
			rs = stmt.executeQuery(Min_Val_Query);
			rs.next();

			Object orFloatVal = rs.getObject(1);

			rFloatVal = new Float(orFloatVal.toString());

			msg.addOutputMsg("" + maxFloatVal, "" + rFloatVal);
			if (rFloatVal.equals(maxFloatVal)) {
				msg.setMsg("setObject Method sets the designated parameter with the Object");
			} else {
				msg.printTestError("setObject Method does not set the designated parameter with the Object",
						"test setObject Failed!");

			}
			msg.printTestMsg();
			msg.printOutputMsg();
		} catch (SQLException sqle) {
			msg.printSQLError(sqle, "Call to setObject is Failed!");

		} catch (Exception e) {
			msg.printError(e, "Call to setObject is Failed!");

		} finally {
			try {
				if (rs != null) {
					rs.close();
					rs = null;
				}
				if (pstmt != null) {
					pstmt.close();
					pstmt = null;
				}
				if (stmt != null) {
					stmt.close();
					stmt = null;
				}
				rsSch.dropTab("Real_Tab", conn);
			} catch (Exception e) {
			}
		}
	}

	/*
	 * @testName: testSetObject22
	 * 
	 * @assertion_ids: JDBC:SPEC:9; JDBC:JAVADOC:696; JDBC:JAVADOC:697;
	 * JavaEE:SPEC:186;
	 *
	 * @test_Strategy: Get a PreparedStatement object from the connection to the
	 * database. Using the setObject(int parameterIndex, Object x) method,update the
	 * column Null_Val with the minimum value of Real_Tab. Call the getObject(int
	 * columnno) method to retrieve this value. Extract the minimum value from the
	 * tssql.stmt file. Compare this value with the value returned by the
	 * getObject(int columnno) method. Both the values should be equal.
	 */

	public void testSetObject22() throws Exception {
		Float minFloatVal = null;
		Float rFloatVal = null;
		String sminFloatVal = null;

		try {
			// to create the Real Table
			rsSch.createTab("Real_Tab", sqlp, conn);

			// to update Null value column with Minimum value
			String sPrepStmt = sqlp.getProperty("Real_Tab_Null_Update", "");
			msg.setMsg("Prepared Statement String: " + sPrepStmt);

			msg.setMsg("extract the Maximum Value of Float to be Updated");
			sminFloatVal = rsSch.extractVal("Real_Tab", 2, sqlp, conn);
			minFloatVal = minFloatVal.valueOf(sminFloatVal);
			msg.setMsg("get the PreparedStatement object");
			pstmt = conn.prepareStatement(sPrepStmt);
			pstmt.setObject(1, minFloatVal);
			pstmt.executeUpdate();

			msg.setMsg("to query from the database to check the call of pstmt.executeUpdate");
			// to get the query string
			String Null_Val_Query = sqlp.getProperty("Real_Query_Null", "");
			msg.setMsg(Null_Val_Query);
			rs = stmt.executeQuery(Null_Val_Query);
			rs.next();

			Object orFloatVal = rs.getObject(1);
			rFloatVal = new Float(orFloatVal.toString());

			msg.addOutputMsg("" + minFloatVal, "" + rFloatVal);
			if (rFloatVal.equals(minFloatVal)) {
				msg.setMsg("setObject Method sets the designated parameter with the Object");
			} else {
				msg.printTestError("setObject Method does not set the designated parameter with the Object",
						"test setObject Failed!");

			}
			msg.printTestMsg();
			msg.printOutputMsg();
		} catch (SQLException sqle) {
			msg.printSQLError(sqle, "Call to setObject is Failed!");

		} catch (Exception e) {
			msg.printError(e, "Call to setObject is Failed!");

		}

		finally {
			try {
				if (rs != null) {
					rs.close();
					rs = null;
				}
				if (pstmt != null) {
					pstmt.close();
					pstmt = null;
				}
				if (stmt != null) {
					stmt.close();
					stmt = null;
				}
				rsSch.dropTab("Real_Tab", conn);
			} catch (Exception e) {
			}
		}
	}

	/*
	 * @testName: testSetObject23
	 * 
	 * @assertion_ids: JDBC:SPEC:9; JDBC:JAVADOC:696; JDBC:JAVADOC:697;
	 * JavaEE:SPEC:186;
	 *
	 * @test_Strategy: Get a PreparedStatement object from the connection to the
	 * database. Using the setObject(int parameterIndex, Object x) method,update the
	 * column Min_Val with the maximum value of Tinyint_Tab. Call the getObject(int
	 * columnno) method to retrieve this value. Extract the maximum value from the
	 * tssql.stmt file. Compare this value with the value returned by the
	 * getObject(int columnno) method. Both the values should be equal.
	 */

	public void testSetObject23() throws Exception {
		Integer maxTinyintVal = null;
		Integer rTinyintVal = null;
		String smaxTinyintVal = null;

		try {
			// to create the Tinyint Table
			rsSch.createTab("Tinyint_Tab", sqlp, conn);

			// to update Minimum (false) value column with maximum (true)
			String sPrepStmt = sqlp.getProperty("Tinyint_Tab_Min_Update", "");
			msg.setMsg("Prepared Statement String: " + sPrepStmt);

			msg.setMsg("extract the Maximum Value of Tinyint to be Updated");
			smaxTinyintVal = rsSch.extractVal("Tinyint_Tab", 1, sqlp, conn);
			maxTinyintVal = maxTinyintVal.valueOf(smaxTinyintVal);
			msg.setMsg("get the PreparedStatement object");
			pstmt = conn.prepareStatement(sPrepStmt);
			pstmt.setObject(1, maxTinyintVal);
			pstmt.executeUpdate();

			msg.setMsg("to query from the database to check the call of pstmt.executeUpdate");
			// to get the query string
			String Min_Val_Query = sqlp.getProperty("Tinyint_Query_Min", "");
			msg.setMsg(Min_Val_Query);
			rs = stmt.executeQuery(Min_Val_Query);
			rs.next();

			Object orTinyintVal = rs.getObject(1);

			msg.addOutputMsg(smaxTinyintVal, orTinyintVal.toString());
			if ((orTinyintVal.toString().trim()).equals(smaxTinyintVal.trim())) {
				msg.setMsg("setObject Method sets the designated parameter with the Object");
			} else {
				msg.printTestError("setObject Method does not set the designated parameter with the Object",
						"test setObject Failed!");

			}
			msg.printTestMsg();
			msg.printOutputMsg();
		} catch (SQLException sqle) {
			msg.printSQLError(sqle, "Call to setObject is Failed!");

		} catch (Exception e) {
			msg.printError(e, "Call to setObject is Failed!");

		}

		finally {
			try {
				if (rs != null) {
					rs.close();
					rs = null;
				}
				if (pstmt != null) {
					pstmt.close();
					pstmt = null;
				}
				if (stmt != null) {
					stmt.close();
					stmt = null;
				}
				rsSch.dropTab("Tinyint_Tab", conn);
			} catch (Exception e) {
			}
		}
	}

	/*
	 * @testName: testSetObject24
	 * 
	 * @assertion_ids: JDBC:SPEC:9; JDBC:JAVADOC:696; JDBC:JAVADOC:697;
	 * JavaEE:SPEC:186;
	 *
	 * @test_Strategy: Get a PreparedStatement object from the connection to the
	 * database. Using the setObject(int parameterIndex, Object x) method,update the
	 * column Null_Val with the minimum value of Tinyint_Tab. Call the getObject(int
	 * columnno) method to retrieve this value. Extract the minimum value from the
	 * tssql.stmt file. Compare this value with the value returned by the
	 * getObject(int columnNo) method. Both the values should be equal.
	 */

	public void testSetObject24() throws Exception {
		Integer minTinyintVal = null;
		Integer rTinyintVal = null;
		String sminTinyintVal = null;

		try {
			// to create the Tinyint Table
			rsSch.createTab("Tinyint_Tab", sqlp, conn);

			// to update Null value column with Minimum value
			String sPrepStmt = sqlp.getProperty("Tinyint_Tab_Null_Update", "");
			msg.setMsg("Prepared Statement String: " + sPrepStmt);

			msg.setMsg("extract the Maximum Value of Tinyint to be Updated");
			sminTinyintVal = rsSch.extractVal("Tinyint_Tab", 2, sqlp, conn);
			minTinyintVal = minTinyintVal.valueOf(sminTinyintVal);

			msg.setMsg("get the PreparedStatement object");
			pstmt = conn.prepareStatement(sPrepStmt);
			pstmt.setObject(1, minTinyintVal);
			pstmt.executeUpdate();

			msg.setMsg("to query from the database to check the call of pstmt.executeUpdate");
			// to get the query string
			String Null_Val_Query = sqlp.getProperty("Tinyint_Query_Null", "");
			msg.setMsg(Null_Val_Query);
			rs = stmt.executeQuery(Null_Val_Query);
			rs.next();

			Object orTinyintVal = rs.getObject(1);

			msg.addOutputMsg(sminTinyintVal, orTinyintVal.toString());
			if (orTinyintVal.toString().trim().equals(sminTinyintVal.trim())) {
				msg.setMsg("setObject Method sets the designated parameter with the Object");
			} else {
				msg.printTestError("setObject Method does not set the designated parameter with the Object",
						"test setObject Failed!");

			}
			msg.printTestMsg();
			msg.printOutputMsg();
		} catch (SQLException sqle) {
			msg.printSQLError(sqle, "Call to setObject is Failed!");

		} catch (Exception e) {
			msg.printError(e, "Call to setObject is Failed!");

		}

		finally {
			try {
				if (rs != null) {
					rs.close();
					rs = null;
				}
				if (pstmt != null) {
					pstmt.close();
					pstmt = null;
				}
				if (stmt != null) {
					stmt.close();
					stmt = null;
				}
				rsSch.dropTab("Tinyint_Tab", conn);
			} catch (Exception e) {
			}
		}
	}

	/*
	 * @testName: testSetObject25
	 * 
	 * @assertion_ids: JDBC:SPEC:9; JDBC:JAVADOC:696; JDBC:JAVADOC:697;
	 * JavaEE:SPEC:186;
	 *
	 * @test_Strategy: Get a PreparedStatement object from the connection to the
	 * database. Using the setObject(int parameterIndex, Object x) method,update the
	 * column Min_Val with the maximum value of Smallint_Tab. Call the getObject(int
	 * columnno) method to retrieve this value. Extract the maximum value from the
	 * tssql.stmt file. Compare this value with the value returned by the
	 * getObject(int columnno) method. Both the values should be equal.
	 */

	public void testSetObject25() throws Exception {
		Integer maxSmallintVal = null;
		Integer rSmallintVal = null;
		String smaxSmallintVal = null;

		try {
			// to create the Smallint Table
			rsSch.createTab("Smallint_Tab", sqlp, conn);

			// to update Minimum (false) value column with maximum (true)
			String sPrepStmt = sqlp.getProperty("Smallint_Tab_Min_Update", "");
			msg.setMsg("Prepared Statement String: " + sPrepStmt);

			msg.setMsg("extract the Maximum Value of Smallint to be Updated");
			smaxSmallintVal = rsSch.extractVal("Smallint_Tab", 1, sqlp, conn);
			maxSmallintVal = maxSmallintVal.valueOf(smaxSmallintVal);

			msg.setMsg("get the PreparedStatement object");
			pstmt = conn.prepareStatement(sPrepStmt);
			pstmt.setObject(1, maxSmallintVal);
			pstmt.executeUpdate();

			msg.setMsg("to query from the database to check the call of pstmt.executeUpdate");
			// to get the query string
			String Min_Val_Query = sqlp.getProperty("Smallint_Query_Min", "");
			msg.setMsg(Min_Val_Query);
			rs = stmt.executeQuery(Min_Val_Query);
			rs.next();

			Object orSmallintVal = rs.getObject(1);

			msg.addOutputMsg(smaxSmallintVal, orSmallintVal.toString());
			if ((orSmallintVal.toString()).trim().equals((smaxSmallintVal.trim()))) {
				msg.setMsg("setObject Method sets the designated parameter with the Object");
			} else {
				msg.printTestError("setObject Method does not set the designated parameter with the Object",
						"test setObject Failed!");

			}
			msg.printTestMsg();
			msg.printOutputMsg();
		} catch (SQLException sqle) {
			msg.printSQLError(sqle, "Call to setObject is Failed!");

		} catch (Exception e) {
			msg.printError(e, "Call to setObject is Failed!");

		}

		finally {
			try {
				if (rs != null) {
					rs.close();
					rs = null;
				}
				if (pstmt != null) {
					pstmt.close();
					pstmt = null;
				}
				if (stmt != null) {
					stmt.close();
					stmt = null;
				}
				rsSch.dropTab("Smallint_Tab", conn);
			} catch (Exception e) {
			}
		}
	}

	/*
	 * @testName: testSetObject26
	 * 
	 * @assertion_ids: JDBC:SPEC:9; JDBC:JAVADOC:696; JDBC:JAVADOC:697;
	 * JavaEE:SPEC:186;
	 *
	 * @test_Strategy: Get a PreparedStatement object from the connection to the
	 * database. Using the setObject(int parameterIndex, Object x) method,update the
	 * column Null_Val with the minimum value of Smallint_Tab. Call the
	 * getObject(int columnno) method to retrieve this value. Extract the minimum
	 * value from the tssql.stmt file. Compare this value with the value returned by
	 * the getObject(int columnno) method. Both the values should be equal.
	 */

	public void testSetObject26() throws Exception {
		Integer minSmallintVal = null;
		Integer rSmallintVal = null;
		String sminSmallintVal = null;

		try {
			// to create the Smallint Table
			rsSch.createTab("Smallint_Tab", sqlp, conn);

			// to update Null value column with Minimum value
			String sPrepStmt = sqlp.getProperty("Smallint_Tab_Null_Update", "");
			msg.setMsg("Prepared Statement String: " + sPrepStmt);

			msg.setMsg("extract the Maximum Value of Smallint to be Updated");
			sminSmallintVal = rsSch.extractVal("Smallint_Tab", 2, sqlp, conn);
			minSmallintVal = minSmallintVal.valueOf(sminSmallintVal);

			msg.setMsg("get the PreparedStatement object");
			pstmt = conn.prepareStatement(sPrepStmt);
			pstmt.setObject(1, minSmallintVal);
			pstmt.executeUpdate();

			msg.setMsg("to query from the database to check the call of pstmt.executeUpdate");
			// to get the query string
			String Null_Val_Query = sqlp.getProperty("Smallint_Query_Null", "");
			msg.setMsg(Null_Val_Query);
			rs = stmt.executeQuery(Null_Val_Query);
			rs.next();

			Object orSmallintVal = rs.getObject(1);

			msg.addOutputMsg(sminSmallintVal, orSmallintVal.toString());

			if ((orSmallintVal.toString()).trim().equals((sminSmallintVal.trim()))) {
				msg.setMsg("setObject Method sets the designated parameter with the Object");
			} else {
				msg.printTestError("setObject Method does not set the designated parameter with the Object",
						"test setObject Failed!");

			}
			msg.printTestMsg();
			msg.printOutputMsg();
		} catch (SQLException sqle) {
			msg.printSQLError(sqle, "Call to setObject is Failed!");

		} catch (Exception e) {
			msg.printError(e, "Call to setObject is Failed!");

		}

		finally {
			try {
				if (rs != null) {
					rs.close();
					rs = null;
				}
				if (pstmt != null) {
					pstmt.close();
					pstmt = null;
				}
				if (stmt != null) {
					stmt.close();
					stmt = null;
				}
				rsSch.dropTab("Smallint_Tab", conn);
			} catch (Exception e) {
			}
		}
	}

	/*
	 * @testName: testSetObject27
	 * 
	 * @assertion_ids: JDBC:SPEC:9; JDBC:JAVADOC:696; JDBC:JAVADOC:697;
	 * JavaEE:SPEC:186;
	 *
	 * @test_Strategy: Get a PreparedStatement object from the connection to the
	 * database.Update the column value of the Binary_Tab with a byte array using
	 * the PreparedStatement.setBytes(int columnIndex) method. Call the
	 * getObject(int parameterIndex) method.to retrieve the byte array. It should
	 * return the byte array object that has been set.
	 */

	public void testSetObject27() throws Exception {
		byte retByteArr[] = null;
		String binarySize = null;

		try {
			rsSch.createTab("Binary_Tab", sqlp, conn);

			// to extract the Binary Table size from property file
			binarySize = props.getProperty("binarySize");
			msg.setMsg("Binary Table Size : " + binarySize);
			String sPrepStmt = sqlp.getProperty("Binary_Tab_Val_Update", "");
			msg.setMsg("Prepared Statement String: " + sPrepStmt);

			int bytearrsize = Integer.parseInt(binarySize);
			byte[] bytearr = new byte[bytearrsize];
			String sbyteval = null;

			// to get the bytearray value
			for (int count = 0; count < bytearrsize; count++) {
				sbyteval = Integer.toString(count % 255);
				bytearr[count] = Byte.parseByte(sbyteval);
			}

			msg.setMsg("get the PreparedStatement object");
			pstmt = conn.prepareStatement(sPrepStmt);
			pstmt.setObject(1, bytearr);
			pstmt.executeUpdate();

			msg.setMsg("to query from the database to check the call of pstmt.executeUpdate");
			// to get the query string
			String Binary_Val_Query = sqlp.getProperty("Binary_Query_Val", "");
			msg.setMsg(Binary_Val_Query);
			rs = stmt.executeQuery(Binary_Val_Query);
			rs.next();

			retByteArr = (byte[]) rs.getObject(1);

			for (int i = 0; i < bytearrsize; i++) {
				msg.addOutputMsg(Byte.toString(bytearr[i]), Byte.toString(retByteArr[i]));
				if (retByteArr[i] != bytearr[i]) {
					msg.printTestError("setObject Method does not set the designated parameter with the object",
							"test setObject Failed!");

				}
			}
			msg.setMsg("setObject Method sets the designated parameter with the object");
			msg.printTestMsg();
			msg.printOutputMsg();
		} catch (SQLException sqle) {
			msg.printSQLError(sqle, "Call to setObject is Failed!");

		} catch (Exception e) {
			msg.printError(e, "Call to setObject is Failed!");

		}

		finally {
			try {
				if (rs != null) {
					rs.close();
					rs = null;
				}
				if (pstmt != null) {
					pstmt.close();
					pstmt = null;
				}
				if (stmt != null) {
					stmt.close();
					stmt = null;
				}
				rsSch.dropTab("Binary_Tab", conn);
			} catch (Exception e) {
			}
		}
	}

	/*
	 * @testName: testSetObject28
	 * 
	 * @assertion_ids: JDBC:SPEC:9; JDBC:JAVADOC:696; JDBC:JAVADOC:697;
	 * JavaEE:SPEC:186;
	 *
	 * @test_Strategy: Get a PreparedStatement object from the connection to the
	 * database.Update the column value of the Varbinary_Tab with a byte array using
	 * the PreparedStatement.setBytes(int columnIndex) method. Call the
	 * getObject(int parameterIndex) method.to retrieve the byte array. It should
	 * return the byte array object that has been set.
	 */

	public void testSetObject28() throws Exception {
		byte retByteArr[] = null;
		String varbinarySize = null;

		try {
			rsSch.createTab("Varbinary_Tab", sqlp, conn);

			// to extract the Varbinary Table size from property file
			varbinarySize = props.getProperty("varbinarySize");
			msg.setMsg("Varbinary Table Size : " + varbinarySize);
			String sPrepStmt = sqlp.getProperty("Varbinary_Tab_Val_Update", "");
			msg.setMsg("Prepared Statement String: " + sPrepStmt);

			int bytearrsize = Integer.parseInt(varbinarySize);
			byte[] bytearr = new byte[bytearrsize];
			String sbyteval = null;

			// to get the bytearray value
			for (int count = 0; count < bytearrsize; count++) {
				sbyteval = Integer.toString(count % 255);
				bytearr[count] = Byte.parseByte(sbyteval);
			}

			msg.setMsg("get the PreparedStatement object");
			pstmt = conn.prepareStatement(sPrepStmt);
			pstmt.setObject(1, bytearr);
			pstmt.executeUpdate();

			msg.setMsg("to query from the database to check the call of pstmt.executeUpdate");
			// to get the query string
			String Varbinary_Val_Query = sqlp.getProperty("Varbinary_Query_Val", "");
			msg.setMsg(Varbinary_Val_Query);
			rs = stmt.executeQuery(Varbinary_Val_Query);
			rs.next();

			retByteArr = (byte[]) rs.getObject(1);

			for (int i = 0; i < bytearrsize; i++) {
				msg.addOutputMsg(Byte.toString(bytearr[i]), Byte.toString(retByteArr[i]));
				if (retByteArr[i] != bytearr[i]) {
					msg.printTestError("setObject Method does not set the designated parameter with the object",
							"test steObject Failed!");

				}
			}
			msg.setMsg("setObject Method sets the designated parameter with the object");
			msg.printTestMsg();
			msg.printOutputMsg();
		} catch (SQLException sqle) {
			msg.printSQLError(sqle, "Call to setObject is Failed!");

		} catch (Exception e) {
			msg.printError(e, "Call to setObject is Failed!");

		}

		finally {
			try {
				if (rs != null) {
					rs.close();
					rs = null;
				}
				if (pstmt != null) {
					pstmt.close();
					pstmt = null;
				}
				if (stmt != null) {
					stmt.close();
					stmt = null;
				}
				rsSch.dropTab("Varbinary_Tab", conn);
			} catch (Exception e) {
			}
		}
	}

	/*
	 * @testName: testSetObject29
	 * 
	 * @assertion_ids: JDBC:SPEC:9; JDBC:JAVADOC:696; JDBC:JAVADOC:697;
	 * JavaEE:SPEC:186;
	 *
	 * @test_Strategy: Get a PreparedStatement object from the connection to the
	 * database.Update the column value of the Longvarbinary_Tab with a byte array
	 * using the PreparedStatement.setBytes(int columnIndex) method. Call the
	 * getObject(int parameterIndex) method to retrieve the byte array. It should
	 * return the byte array object that has been set.
	 */

	public void testSetObject29() throws Exception {
		byte retByteArr[] = null;

		try {
			rsSch.createTab("Longvarbinary_Tab", sqlp, conn);
			String sPrepStmt = sqlp.getProperty("Longvarbinary_Tab_Val_Update", "");
			msg.setMsg("Prepared Statement String: " + sPrepStmt);

			// to get the byte array value to be updated
			String binsize = props.getProperty("longvarbinarySize");
			int bytearrsize = Integer.parseInt(binsize);

			byte[] bytearr = new byte[bytearrsize];
			String sbyteval = null;

			// to get the bytearray value
			for (int count = 0; count < bytearrsize; count++) {
				sbyteval = Integer.toString(count % 255);
				bytearr[count] = Byte.parseByte(sbyteval);
			}

			msg.setMsg("get the PreparedStatement object");
			pstmt = conn.prepareStatement(sPrepStmt);
			pstmt.setObject(1, bytearr);
			pstmt.executeUpdate();

			msg.setMsg("to query from the database to check the call of pstmt.executeUpdate");
			// to get the query string
			String Longvarbinary_Val_Query = sqlp.getProperty("Longvarbinary_Query_Val", "");
			msg.setMsg(Longvarbinary_Val_Query);
			rs = stmt.executeQuery(Longvarbinary_Val_Query);
			rs.next();

			retByteArr = (byte[]) rs.getObject(1);

			for (int i = 0; i < bytearrsize; i++) {
				msg.addOutputMsg(Byte.toString(bytearr[i]), Byte.toString(retByteArr[i]));
				if (retByteArr[i] != bytearr[i]) {
					msg.printTestError("setObject Method does not set the designated parameter with the object ",
							"Call to setObject is Failed!");

				}
			}
			msg.setMsg("setObject Method sets the designated parameter with the object");
			msg.printTestMsg();
			msg.printOutputMsg();
		} catch (SQLException sqle) {
			msg.printSQLError(sqle, "Call to setObject is Failed!");

		} catch (Exception e) {
			msg.printError(e, "Call to setObject is Failed!");

		}

		finally {
			try {
				if (rs != null) {
					rs.close();
					rs = null;
				}
				if (pstmt != null) {
					pstmt.close();
					pstmt = null;
				}
				if (stmt != null) {
					stmt.close();
					stmt = null;
				}
				rsSch.dropTab("Longvarbinary_Tab", conn);
			} catch (Exception e) {
			}
		}
	}

	/* cleanup */
	public void cleanup() throws Exception {
		try {
			if (pstmt != null) {
				pstmt.close();
				pstmt = null;
			}
			if (stmt != null) {
				stmt.close();
				stmt = null;
			}
			// Close the database
			rsSch.dbUnConnect(conn);
			logMsg("Cleanup ok;");
		} catch (Exception e) {
			logErr("An error occurred while closing the database connection", e);
		}
	}
}
