/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.css;

import com.gargoylesoftware.css.dom.CSSMediaRuleImpl;
import com.gargoylesoftware.css.dom.MediaListImpl;
import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.css.CssMediaList;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.SupportedBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.css.CSSConditionRule;
import com.gargoylesoftware.htmlunit.javascript.host.css.CSSStyleSheet;
import com.gargoylesoftware.htmlunit.javascript.host.css.MediaList;
import org.apache.commons.lang3.StringUtils;

@JsxClass
public class CSSMediaRule
extends CSSConditionRule {
    private MediaList media_;

    public CSSMediaRule() {
    }

    @Override
    @JsxConstructor(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public void jsConstructor() {
        super.jsConstructor();
    }

    protected CSSMediaRule(CSSStyleSheet stylesheet, CSSMediaRuleImpl rule) {
        super(stylesheet, rule);
    }

    @JsxGetter
    public MediaList getMedia() {
        if (this.media_ == null) {
            CSSStyleSheet parent = this.getParentStyleSheet();
            MediaListImpl ml = this.getMediaRule().getMediaList();
            this.media_ = new MediaList(parent, new CssMediaList(ml));
        }
        return this.media_;
    }

    private CSSMediaRuleImpl getMediaRule() {
        return (CSSMediaRuleImpl)this.getRule();
    }

    @Override
    public String getCssText() {
        String cssText = super.getCssText();
        BrowserVersion browserVersion = this.getBrowserVersion();
        if (browserVersion.hasFeature(BrowserVersionFeatures.CSS_CSSTEXT_IE_STYLE)) {
            cssText = StringUtils.replace((String)cssText, (String)"\n  ", (String)"\n\t");
            cssText = StringUtils.replace((String)cssText, (String)" { }", (String)" {  }");
        }
        return cssText;
    }
}

