/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.websocket.ee.jakarta.websocket.throwingcoder.annotated;

import com.sun.ts.tests.websocket.common.util.IOUtil;
import jakarta.websocket.MessageHandler;
import jakarta.websocket.OnError;
import jakarta.websocket.OnMessage;
import jakarta.websocket.OnOpen;
import jakarta.websocket.Session;
import jakarta.websocket.server.ServerEndpoint;
import java.io.IOException;
import java.nio.ByteBuffer;

@ServerEndpoint(value="/simpleecho")
public class WSCSimpleEchoServer {
    private static final System.Logger logger = System.getLogger(WSCSimpleEchoServer.class.getName());

    @OnOpen
    public void onOpen(final Session session) {
        session.addMessageHandler((MessageHandler)new MessageHandler.Whole<ByteBuffer>(){

            public void onMessage(ByteBuffer message) {
                String ret = WSCSimpleEchoServer.this.echo(IOUtil.byteBufferToString((ByteBuffer)message));
                try {
                    session.getBasicRemote().sendText(ret);
                }
                catch (IOException e) {
                    try {
                        WSCSimpleEchoServer.this.onError(session, e);
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        });
    }

    @OnMessage
    public String echo(String echo) {
        return echo;
    }

    @OnError
    public void onError(Session session, Throwable t) throws IOException {
        logger.log(System.Logger.Level.INFO, "@OnError in" + this.getClass().getName());
        t.printStackTrace();
        String message = IOUtil.printStackTrace((Throwable)t);
        session.getBasicRemote().sendText(message);
    }
}

