/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.websocket.ee.jakarta.websocket.server.pathparam;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.websocket.common.client.WebSocketCommonClient;
import com.sun.ts.tests.websocket.common.util.IOUtil;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.server.pathparam.OPS;
import java.io.IOException;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.Filters;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class WSClientIT
extends WebSocketCommonClient {
    private static final long serialVersionUID = -6963654147324631018L;

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"ws_ee_jakarta_websocket_server_pathparam_web.war");
        archive.addPackages(true, Filters.exclude((Class[])new Class[]{WSClientIT.class}), new String[]{"com.sun.ts.tests.websocket.ee.jakarta.websocket.server.pathparam"});
        archive.addClasses(new Class[]{IOUtil.class});
        return archive;
    }

    public WSClientIT() throws Exception {
        this.setContextRoot("ws_ee_jakarta_websocket_server_pathparam_web");
    }

    @Test
    public void multipleStringParamsOnMessageTest() throws Exception {
        this.multipleStringParams(OPS.MESSAGE);
    }

    @Test
    public void noStringParamsOnMessageTest() throws Exception {
        this.noStringParams(OPS.MESSAGE);
    }

    @Test
    public void directStringParamOnMessageTest() throws Exception {
        this.directStringParam(OPS.MESSAGE);
    }

    @Test
    public void primitiveBooleanAndCharParamsOnMessageTest() throws Exception {
        this.primitiveBooleanAndCharParams(OPS.MESSAGE);
    }

    @Test
    public void fullDoubleAndFloatParamsOnMessageTest() throws Exception {
        this.fullDoubleAndFloatParams(OPS.MESSAGE);
    }

    @Test
    public void multipleStringParamsOnOpenTest() throws Exception {
        this.multipleStringParams(OPS.OPEN);
    }

    @Test
    public void noStringParamsOnOpenTest() throws Exception {
        this.noStringParams(OPS.OPEN);
    }

    @Test
    public void directStringParamOnOpenTest() throws Exception {
        this.directStringParam(OPS.OPEN);
    }

    @Test
    public void primitiveBooleanAndCharParamsOnOpenTest() throws Exception {
        this.primitiveBooleanAndCharParams(OPS.OPEN);
    }

    @Test
    public void fullDoubleAndFloatParamsOnOpenTest() throws Exception {
        this.fullDoubleAndFloatParams(OPS.OPEN);
    }

    @Test
    public void multipleStringParamsOnIOETest() throws Exception {
        this.multipleStringParams(OPS.IOEXCEPTION);
    }

    @Test
    public void noStringParamsOnIOETest() throws Exception {
        this.noStringParams(OPS.IOEXCEPTION);
    }

    @Test
    public void directStringParamOnIOETest() throws Exception {
        this.directStringParam(OPS.IOEXCEPTION);
    }

    @Test
    public void primitiveBooleanAndCharParamsOnIOETest() throws Exception {
        this.primitiveBooleanAndCharParams(OPS.IOEXCEPTION);
    }

    @Test
    public void fullDoubleAndFloatParamsOnIOTest() throws Exception {
        this.fullDoubleAndFloatParams(OPS.IOEXCEPTION);
    }

    @Test
    public void multipleStringParamsOnRETest() throws Exception {
        this.multipleStringParams(OPS.RUNTIMEEXCEPTION);
    }

    @Test
    public void noStringParamsOnRETest() throws Exception {
        this.noStringParams(OPS.RUNTIMEEXCEPTION);
    }

    @Test
    public void directStringParamOnRETest() throws Exception {
        this.directStringParam(OPS.RUNTIMEEXCEPTION);
    }

    @Test
    public void primitiveBooleanAndCharParamsOnRETest() throws Exception {
        this.primitiveBooleanAndCharParams(OPS.RUNTIMEEXCEPTION);
    }

    @Test
    public void fullDoubleAndFloatParamsOnRETest() throws Exception {
        this.fullDoubleAndFloatParams(OPS.RUNTIMEEXCEPTION);
    }

    @Test
    public void multipleStringParamsOnCloseTest() throws Exception {
        String param = "param";
        StringBuilder sb = new StringBuilder();
        for (int i = 1; i != 12; ++i) {
            this.invoke("onclose", "-1", new String[]{"path params has been reset"});
            sb.append("/").append(param).append(i);
            this.setProperty(WebSocketCommonClient.Property.REQUEST, this.buildRequest(new String[]{param, sb.toString()}));
            this.setProperty(WebSocketCommonClient.Property.SEARCH_STRING, sb.toString().replace("/", ""));
            this.setProperty(WebSocketCommonClient.Property.CONTENT, OPS.MESSAGE.name());
            this.invoke();
            TestUtil.sleepMsec((int)200);
            for (int j = 0; j != i; ++j) {
                this.invoke("onclose", String.valueOf(j), new String[]{param + String.valueOf(j + 1)});
            }
        }
    }

    @Test
    public void noStringParamsOnCloseTest() throws Exception {
        this.invoke("onclose", "-1", new String[]{"path params has been reset"});
        String search = this.noStringParams(OPS.MESSAGE);
        TestUtil.sleepMsec((int)200);
        this.invoke("onclose", "0", new String[]{search});
    }

    @Test
    public void directStringParamOnCloseTest() throws Exception {
        this.invoke("onclose", "-1", new String[]{"path params has been reset"});
        String search = this.directStringParam(OPS.MESSAGE);
        TestUtil.sleepMsec((int)200);
        this.invoke("onclose", "0", new String[]{search});
    }

    @Test
    public void primitiveBooleanAndCharParamsOnCloseTest() throws Exception {
        this.invoke("onclose", "-1", new String[]{"path params has been reset"});
        String[] search = this.primitiveBooleanAndCharParams(OPS.MESSAGE);
        TestUtil.sleepMsec((int)200);
        this.invoke("onclose", "0", new String[]{search[0]});
        this.invoke("onclose", "1", new String[]{search[1]});
    }

    @Test
    public void fullDoubleAndFloatParamsOnCloseTest() throws Exception {
        this.invoke("onclose", "-1", new String[]{"path params has been reset"});
        String[] search = this.fullDoubleAndFloatParams(OPS.RUNTIMEEXCEPTION);
        TestUtil.sleepMsec((int)200);
        this.invoke("onclose", "0", new String[]{search[0]});
        this.invoke("onclose", "1", new String[]{search[1]});
    }

    private void multipleStringParams(OPS op) throws Exception {
        String param = "param";
        StringBuilder sb = new StringBuilder();
        for (int i = 1; i != 12; ++i) {
            sb.append("/").append(param).append(i);
            this.setProperty(WebSocketCommonClient.Property.REQUEST, this.buildRequest(new String[]{param, sb.toString()}));
            this.setProperty(WebSocketCommonClient.Property.SEARCH_STRING, sb.toString().replace("/", ""));
            this.setProperty(WebSocketCommonClient.Property.CONTENT, op.name());
            this.invoke();
        }
    }

    private String noStringParams(OPS op) throws Exception {
        String param = "nonused/nonused";
        String search = "null";
        this.setProperty(WebSocketCommonClient.Property.REQUEST, this.buildRequest(new String[]{param}));
        this.setProperty(WebSocketCommonClient.Property.SEARCH_STRING, search);
        this.setProperty(WebSocketCommonClient.Property.CONTENT, op.name());
        this.invoke();
        return search;
    }

    private String directStringParam(OPS op) throws Exception {
        String param = "1234567890";
        this.setProperty(WebSocketCommonClient.Property.REQUEST, this.buildRequest(new String[]{param}));
        this.setProperty(WebSocketCommonClient.Property.SEARCH_STRING, param);
        this.setProperty(WebSocketCommonClient.Property.CONTENT, op.name());
        this.invoke();
        return param;
    }

    private String[] primitiveBooleanAndCharParams(OPS op) throws Exception {
        String[] param = new String[]{"true", "0"};
        this.setProperty(WebSocketCommonClient.Property.REQUEST, this.buildRequest(new String[]{"different/", param[0], "/", param[1]}));
        this.setProperty(WebSocketCommonClient.Property.SEARCH_STRING, param[0] + param[1]);
        this.setProperty(WebSocketCommonClient.Property.CONTENT, op.name());
        this.invoke();
        return param;
    }

    private String[] fullDoubleAndFloatParams(OPS op) throws Exception {
        String[] param = new String[]{String.valueOf(12.34), String.valueOf(56.78f)};
        this.setProperty(WebSocketCommonClient.Property.REQUEST, this.buildRequest(new String[]{"full/", param[0], "/", param[1]}));
        this.setProperty(WebSocketCommonClient.Property.SEARCH_STRING, param[0] + param[1]);
        this.setProperty(WebSocketCommonClient.Property.CONTENT, op.name());
        this.invoke();
        return param;
    }
}

