/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.gitflow.op;

import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.egit.gitflow.GitFlowRepository;
import org.eclipse.egit.gitflow.WrongGitFlowStateException;
import org.eclipse.egit.gitflow.internal.CoreText;
import org.eclipse.egit.gitflow.op.AbstractReleaseOperation;
import org.eclipse.osgi.util.NLS;

public final class ReleaseFinishOperation
extends AbstractReleaseOperation {
    public ReleaseFinishOperation(GitFlowRepository repository, String releaseName) {
        super(repository, releaseName);
    }

    public ReleaseFinishOperation(GitFlowRepository repository) throws WrongGitFlowStateException, CoreException, IOException {
        this(repository, ReleaseFinishOperation.getReleaseName(repository));
    }

    public void execute(IProgressMonitor monitor) throws CoreException {
        String releaseBranchName = this.repository.getConfig().getReleaseBranchName(this.versionName);
        String master = this.repository.getConfig().getMaster();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)3);
        this.mergeResult = this.mergeTo((IProgressMonitor)progress.newChild(1), releaseBranchName, master, false, false);
        if (!this.mergeResult.getMergeStatus().isSuccessful()) {
            return;
        }
        this.safeCreateTag((IProgressMonitor)progress.newChild(1), this.repository.getConfig().getVersionTagPrefix() + this.versionName, NLS.bind((String)CoreText.ReleaseFinishOperation_releaseOf, (Object)this.versionName));
        this.finish((IProgressMonitor)progress.newChild(1), releaseBranchName, false, false, false);
    }
}

