/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.graph.json.text.conversion;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.List;
import org.eclipse.elk.core.data.LayoutMetaDataService;
import org.eclipse.elk.core.data.LayoutOptionData;
import org.eclipse.elk.graph.json.text.services.ElkGraphJsonGrammarAccess;
import org.eclipse.elk.graph.properties.IProperty;
import org.eclipse.elk.graph.properties.Property;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.conversion.ValueConverterException;
import org.eclipse.xtext.conversion.impl.AbstractValueConverter;
import org.eclipse.xtext.conversion.impl.IDValueConverter;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class PropertyKeyValueConverter
extends AbstractValueConverter<IProperty<?>> {
    private IDValueConverter idValueConverter;

    @Inject
    public void initialize(Provider<IDValueConverter> idValueConverterProvider, ElkGraphJsonGrammarAccess grammarAccess) {
        IDValueConverter _doubleArrow;
        IDValueConverter _get = (IDValueConverter)idValueConverterProvider.get();
        Procedures.Procedure1 _function = it -> it.setRule((AbstractRule)grammarAccess.getIDRule());
        this.idValueConverter = _doubleArrow = (IDValueConverter)ObjectExtensions.operator_doubleArrow((Object)_get, (Procedures.Procedure1)_function);
    }

    public String toString(IProperty<?> value) throws ValueConverterException {
        String _plus;
        if (value == null) {
            throw new ValueConverterException("IProperty value may not be null.", null, null);
        }
        LayoutMetaDataService metaDataService = LayoutMetaDataService.getInstance();
        List split = Strings.split((String)value.getId(), (String)".");
        Object suffix = null;
        int _size = split.size();
        int i = _size - 1;
        while (i >= 0) {
            if (suffix == null) {
                int _minusMinus = i--;
                suffix = this.idValueConverter.toString((Object)((String)split.get(_minusMinus)));
            } else {
                int _minusMinus_1 = i--;
                String _string = this.idValueConverter.toString((Object)((String)split.get(_minusMinus_1)));
                _plus = _string + ".";
                String _plus_1 = (String)_plus + (String)suffix;
                suffix = _plus_1;
            }
            LayoutOptionData knownOption = metaDataService.getOptionDataBySuffix((String)suffix);
            if (knownOption == null || !StringExtensions.isNullOrEmpty((String)knownOption.getGroup()) && !((String)suffix).contains(knownOption.getGroup())) continue;
            return suffix;
        }
        Functions.Function1 _function = it -> this.idValueConverter.toString(it);
        String _join = IterableExtensions.join((Iterable)ListExtensions.map((List)split, (Functions.Function1)_function), (CharSequence)".");
        _plus = "\"" + _join;
        return _plus + "\"";
    }

    public IProperty<?> toValue(String string, INode node) throws ValueConverterException {
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)string);
        if (_isNullOrEmpty) {
            throw new ValueConverterException("Cannot convert empty string to a property identifier.", node, null);
        }
        Functions.Function1 _function = it -> this.idValueConverter.toValue(it, node);
        String idSuffix = IterableExtensions.join((Iterable)ListExtensions.map((List)Strings.split((String)this.unquoteIfNecessary(string), (String)"."), (Functions.Function1)_function), (CharSequence)".");
        LayoutOptionData optionData = LayoutMetaDataService.getInstance().getOptionDataBySuffix(idSuffix);
        if (optionData == null) {
            return new Property(string);
        }
        return optionData;
    }

    private String unquoteIfNecessary(String s) {
        if (s.length() >= 2 && (s.startsWith("\"") && s.endsWith("\"") || s.startsWith("'") && s.endsWith("'"))) {
            int _length = s.length();
            int _minus = _length - 1;
            return s.substring(1, _minus);
        }
        return s;
    }
}

