/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.resultset;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.query.ARQ;
import org.apache.jena.query.ResultSet;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.rowset.RowSetWriter;
import org.apache.jena.riot.rowset.RowSetWriterFactory;
import org.apache.jena.riot.rowset.RowSetWriterRegistry;
import org.apache.jena.sparql.exec.RowSet;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sparql.util.Symbol;
import org.apache.jena.sys.JenaSystem;

public class ResultsWriter {
    private final Lang lang;
    private final Context context;

    public static Builder create() {
        return new Builder();
    }

    private ResultsWriter(Lang lang, Context context2) {
        this.lang = lang;
        this.context = context2;
    }

    public void write(String filename, ResultSet resultSet) {
        Objects.requireNonNull(filename);
        Objects.requireNonNull(resultSet);
        this.write(filename, RowSet.adapt(resultSet));
    }

    public void write(String filename, RowSet rowSet) {
        Objects.requireNonNull(filename);
        Objects.requireNonNull(rowSet);
        try (OutputStream out = this.openURL(filename);){
            this.write(out, rowSet);
        }
        catch (IOException ex) {
            IO.exception(ex);
        }
    }

    public void write(OutputStream output, ResultSet resultSet) {
        Objects.requireNonNull(output);
        Objects.requireNonNull(resultSet);
        this.write(output, RowSet.adapt(resultSet));
    }

    public void write(OutputStream output, RowSet rowSet) {
        Objects.requireNonNull(output);
        Objects.requireNonNull(rowSet);
        this.write(output, rowSet, null, this.lang);
    }

    public void write(String filename, boolean booleanResult) {
        Objects.requireNonNull(filename);
        try (OutputStream out = this.openURL(filename);){
            this.write(out, booleanResult);
        }
        catch (IOException ex) {
            IO.exception(ex);
        }
    }

    public void write(OutputStream output, boolean booleanResult) {
        Objects.requireNonNull(output);
        this.write(output, null, booleanResult, this.lang);
    }

    private void write(OutputStream output, RowSet resultSet, Boolean result, Lang lang) {
        if (resultSet == null && result == null) {
            throw new RiotException("No result set and no boolean result");
        }
        if (resultSet != null && result != null) {
            throw new RiotException("Both result set and boolean result supplied");
        }
        if (!RowSetWriterRegistry.isRegistered(lang)) {
            throw new RiotException("Not registered as a SPARQL result set output syntax: " + lang);
        }
        RowSetWriterFactory factory = RowSetWriterRegistry.getFactory(lang);
        if (factory == null) {
            throw new RiotException("No ResultSetReaderFactory for " + lang);
        }
        RowSetWriter writer = factory.create(lang);
        if (resultSet != null) {
            writer.write(output, resultSet, this.context);
        } else {
            writer.write(output, result, this.context);
        }
    }

    private OutputStream openURL(String filename) {
        return IO.openOutputFile(filename);
    }

    static {
        JenaSystem.init();
    }

    public static class Builder {
        private Lang lang = null;
        private Context context = null;

        public Builder lang(Lang lang) {
            this.lang = lang;
            return this;
        }

        public Builder context(Context context2) {
            this.context = context2;
            return this;
        }

        private void ensureContext() {
            if (this.context == null) {
                this.context = new Context();
            }
        }

        public Builder set(Symbol symbol, Object value) {
            if (this.context == null) {
                this.context = ARQ.getContext().copy();
            }
            this.context.set(symbol, value);
            return this;
        }

        public Builder unset(Symbol symbol) {
            if (this.context == null) {
                return this;
            }
            this.context.unset(symbol);
            return this;
        }

        public ResultsWriter build() {
            return new ResultsWriter(this.lang, this.context);
        }

        public void write(String url, ResultSet resultSet) {
            this.build().write(url, resultSet);
        }

        public void write(OutputStream output, ResultSet resultSet) {
            this.build().write(output, resultSet);
        }

        public void write(String url, RowSet rowSet) {
            this.build().write(url, rowSet);
        }

        public void write(OutputStream output, RowSet rowSet) {
            this.build().write(output, rowSet);
        }

        public void write(String url, boolean booleanResult) {
            this.build().write(url, booleanResult);
        }

        public void write(OutputStream output, boolean booleanResult) {
            this.build().write(output, booleanResult);
        }
    }
}

