/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.launcher.listeners.session;

import java.util.List;
import org.apiguardian.api.API;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.launcher.LauncherSessionListener;
import org.junit.platform.launcher.listeners.session.CompositeLauncherSessionListener;

@API(status=API.Status.INTERNAL, since="1.8")
public class LauncherSessionListeners {
    private LauncherSessionListeners() {
    }

    public static LauncherSessionListener composite(List<LauncherSessionListener> listeners) {
        Preconditions.notNull(listeners, "listeners must not be null");
        Preconditions.containsNoNullElements(listeners, "listeners must not contain any null elements");
        if (listeners.isEmpty()) {
            return LauncherSessionListener.NOOP;
        }
        if (listeners.size() == 1) {
            return listeners.get(0);
        }
        return new CompositeLauncherSessionListener(listeners);
    }
}

