/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.typechecker;

import java.util.List;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.common.CifTypeUtils;
import org.eclipse.escet.cif.metamodel.cif.types.BoolType;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.cif.types.IntType;
import org.eclipse.escet.cif.metamodel.cif.types.RealType;
import org.eclipse.escet.cif.typechecker.CifTypeChecker;
import org.eclipse.escet.cif.typechecker.ErrMsg;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.FormatDecoder;
import org.eclipse.escet.common.java.FormatDescription;
import org.eclipse.escet.common.java.Numbers;
import org.eclipse.escet.common.java.TextPosition;
import org.eclipse.escet.common.position.common.PositionUtils;
import org.eclipse.escet.common.position.metamodel.position.Position;
import org.eclipse.escet.common.typechecker.SemanticException;

public class CifFormatPatternChecker {
    private CifFormatPatternChecker() {
    }

    public static void checkFormatPattern(CifTypeChecker tchecker, List<CifType> valueTypes, List<Position> valuePositions, String pattern, Position patternPos) {
        Assert.check((valueTypes.size() == valuePositions.size() ? 1 : 0) != 0);
        FormatDecoder decoder = new FormatDecoder();
        List parts = decoder.decode(pattern);
        boolean decodingFailed = false;
        for (FormatDescription part : parts) {
            if (part.conversion != FormatDescription.Conversion.ERROR) continue;
            decodingFailed = true;
            tchecker.addProblem(ErrMsg.FMT_PAT_DECODE_ERR, CifFormatPatternChecker.createSubPos(patternPos, part), part.text);
        }
        if (decodingFailed) {
            throw new SemanticException();
        }
        int valueCount = valueTypes.size();
        boolean[] used = new boolean[valueCount];
        int implicitIndex = 0;
        for (FormatDescription part : parts) {
            int idx1;
            if (part.conversion == FormatDescription.Conversion.LITERAL) continue;
            if (!part.index.isEmpty()) {
                idx1 = part.getExplicitIndex();
                if (idx1 == -1) {
                    tchecker.addProblem(ErrMsg.FMT_PAT_IDX_OVERFLOW, CifFormatPatternChecker.createSubPos(patternPos, part), new String[0]);
                    throw new SemanticException();
                }
            } else {
                idx1 = ++implicitIndex;
            }
            if (idx1 < 1 || idx1 > valueCount) {
                tchecker.addProblem(ErrMsg.FMT_PAT_IDX_OUT_OF_RANGE, CifFormatPatternChecker.createSubPos(patternPos, part), Numbers.toOrdinal((int)idx1));
                throw new SemanticException();
            }
            int idx0 = idx1 - 1;
            used[idx0] = true;
            CifType type = valueTypes.get(idx0);
            CifType ntype = CifTypeUtils.normalizeType((CifType)type);
            switch (part.conversion) {
                case BOOLEAN: {
                    if (ntype instanceof BoolType) break;
                    tchecker.addProblem(ErrMsg.FMT_PAT_WRONG_TYPE, CifFormatPatternChecker.createSubPos(patternPos, part), part.text, "bool", Numbers.toOrdinal((int)idx1), CifTextUtils.typeToStr((CifType)type));
                    break;
                }
                case INTEGER: {
                    if (ntype instanceof IntType) break;
                    tchecker.addProblem(ErrMsg.FMT_PAT_WRONG_TYPE, CifFormatPatternChecker.createSubPos(patternPos, part), part.text, "int", Numbers.toOrdinal((int)idx1), CifTextUtils.typeToStr((CifType)type));
                    break;
                }
                case REAL: {
                    if (ntype instanceof RealType) break;
                    tchecker.addProblem(ErrMsg.FMT_PAT_WRONG_TYPE, CifFormatPatternChecker.createSubPos(patternPos, part), part.text, "real", Numbers.toOrdinal((int)idx1), CifTextUtils.typeToStr((CifType)type));
                    break;
                }
                case STRING: {
                    if (!CifTypeUtils.hasComponentLikeType((CifType)ntype)) break;
                    tchecker.addProblem(ErrMsg.FMT_PAT_COMP_TYPE, CifFormatPatternChecker.createSubPos(patternPos, part), part.text, Numbers.toOrdinal((int)idx1), CifTextUtils.typeToStr((CifType)type));
                    break;
                }
                case LITERAL: 
                case ERROR: {
                    String msg = "Unexpected: " + String.valueOf(part.conversion);
                    throw new RuntimeException(msg);
                }
            }
        }
        int i = 0;
        while (i < used.length) {
            if (!used[i]) {
                tchecker.addProblem(ErrMsg.FMT_PAT_UNUSED_VALUE, valuePositions.get(i), Numbers.toOrdinal((int)(i + 1)));
            }
            ++i;
        }
    }

    private static TextPosition createSubPos(Position pos, FormatDescription fd) {
        return PositionUtils.toTextPosition((Position)PositionUtils.getSubRange((Position)pos, (int)(fd.offset + 1), (int)fd.length));
    }
}

