/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.datasynth.options;

import org.eclipse.escet.cif.bdd.settings.CifBddSettingsDefaults;
import org.eclipse.escet.cif.bdd.settings.ExplorationStrategy;
import org.eclipse.escet.common.app.framework.options.EnumOption;
import org.eclipse.escet.common.app.framework.options.Options;

public class ExplorationStrategyOption
extends EnumOption<ExplorationStrategy> {
    public ExplorationStrategyOption() {
        super("Exploration strategy", "Specify the exploration strategy to be used for symbolic reachability computations. Specify \"chaining-fixed\" to use the chaining strategy with a fixed edge ordering. Specify \"chaining-workset\" to use the chaining strategy where the edge workset algorithm is used to dynamically choose the best edge to apply during reachability computations. Specify \"saturation\" (default) to use the saturation strategy.", null, "exploration-strategy", "STRATEGY", (Enum)CifBddSettingsDefaults.EXPLORATION_STRATEGY_DEFAULT, true, "Specify the exploration strategy to be used for symbolic reachability computations.");
    }

    protected String getDialogText(ExplorationStrategy strategy) {
        switch (strategy) {
            case CHAINING_FIXED: {
                return "The chaining strategy with a fixed edge ordering";
            }
            case CHAINING_WORKSET: {
                return "The chaining strategy with a dynamic edge ordering determined by the edge workset algorithm";
            }
            case SATURATION: {
                return "The saturation strategy";
            }
        }
        throw new RuntimeException("Unknown strategy: " + String.valueOf(strategy));
    }

    public static ExplorationStrategy getStrategy() {
        return (ExplorationStrategy)Options.get(ExplorationStrategyOption.class);
    }
}

