/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.simulator.compiler;

import org.eclipse.emf.common.util.EList;
import org.eclipse.escet.cif.metamodel.cif.ComplexComponent;
import org.eclipse.escet.cif.metamodel.cif.Component;
import org.eclipse.escet.cif.metamodel.cif.Group;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.automata.Location;
import org.eclipse.escet.cif.simulator.compiler.CifCompilerContext;
import org.eclipse.escet.cif.simulator.compiler.JavaCodeFile;
import org.eclipse.escet.common.box.CodeBox;

public class UrgLocsCodeGenerator {
    private UrgLocsCodeGenerator() {
    }

    public static void gencodeUrgLocs(Specification spec, CifCompilerContext ctxt) {
        JavaCodeFile file = ctxt.addCodeFile("UrgLocs");
        CodeBox h = file.header;
        h.add("/** Urgent locations. */");
        h.add("public final class UrgLocs {");
        CodeBox c = file.body;
        c.add("public static boolean evalUrgLocs(State state) {");
        c.indent();
        UrgLocsCodeGenerator.gencodeUrgLocsComponent((ComplexComponent)spec, ctxt, c);
        c.add();
        c.add("return false;");
        c.dedent();
        c.add("}");
    }

    private static void gencodeUrgLocsComponent(ComplexComponent comp, CifCompilerContext ctxt, CodeBox c) {
        if (comp instanceof Automaton) {
            Automaton aut = (Automaton)comp;
            c.add("switch (state.%s.%s) {", new Object[]{ctxt.getAutSubStateFieldName(aut), ctxt.getLocationPointerFieldName(aut)});
            c.indent();
            EList locs = aut.getLocations();
            int locIdx = 0;
            while (locIdx < locs.size()) {
                Location loc = (Location)locs.get(locIdx);
                if (loc.isUrgent()) {
                    c.add("case %s: return true;", new Object[]{ctxt.getLocationValueText(loc, locIdx)});
                }
                ++locIdx;
            }
            c.dedent();
            c.add("}");
        }
        if (comp instanceof Group) {
            for (Component child : ((Group)comp).getComponents()) {
                UrgLocsCodeGenerator.gencodeUrgLocsComponent((ComplexComponent)child, ctxt, c);
            }
        }
    }
}

