/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.ide;

import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.common.base.BasePackage;
import org.eclipse.etrice.core.fsm.fSM.ChoicepointTerminal;
import org.eclipse.etrice.core.fsm.fSM.FSMPackage;
import org.eclipse.etrice.core.fsm.fSM.InitialTransition;
import org.eclipse.etrice.core.fsm.fSM.NonInitialTransition;
import org.eclipse.etrice.core.fsm.fSM.StateTerminal;
import org.eclipse.etrice.core.fsm.fSM.SubStateTrPointTerminal;
import org.eclipse.etrice.core.fsm.fSM.TrPointTerminal;
import org.eclipse.etrice.core.fsm.fSM.TransitionTerminal;
import org.eclipse.etrice.core.room.Attribute;
import org.eclipse.etrice.core.room.Message;
import org.eclipse.etrice.core.room.Operation;
import org.eclipse.etrice.core.room.RefableType;
import org.eclipse.etrice.core.room.RoomPackage;
import org.eclipse.lsp4j.SymbolKind;
import org.eclipse.xtext.ide.server.symbol.DocumentSymbolMapper;

public class RoomSymbolMapper {

    public static class RoomSymbolDetailsProvider
    extends DocumentSymbolMapper.DocumentSymbolDetailsProvider {
        public String getDetails(EObject object) {
            if (object instanceof Attribute) {
                Attribute attr = (Attribute)object;
                return this.getRefTypeName(attr.getType());
            }
            if (object instanceof Operation) {
                Operation operation = (Operation)object;
                String params = operation.getArguments().stream().map(param -> this.getRefTypeName(param.getRefType())).collect(Collectors.joining(", ", "(", ")"));
                String returnType = operation.getReturnType() != null ? this.getRefTypeName(operation.getReturnType()) : "void";
                return params + " -> " + returnType;
            }
            if (object instanceof Message) {
                Message message = (Message)object;
                String payloadType = message.getData() != null ? this.getRefTypeName(message.getData().getRefType()) : "void";
                boolean isIncoming = message.eContainmentFeature().getFeatureID() == 8;
                return payloadType + (isIncoming ? " (incoming)" : " (outgoing)");
            }
            if (object instanceof InitialTransition) {
                InitialTransition tr = (InitialTransition)object;
                String to = this.getTransitionTerminalName(tr.getTo());
                return "initial -> " + to;
            }
            if (object instanceof NonInitialTransition) {
                NonInitialTransition tr = (NonInitialTransition)object;
                String from = this.getTransitionTerminalName(tr.getFrom());
                String to = this.getTransitionTerminalName(tr.getTo());
                return from + " -> " + to;
            }
            return "";
        }

        private String getTransitionTerminalName(TransitionTerminal terminal) {
            SubStateTrPointTerminal subStateTerminal;
            TrPointTerminal trPointTerminal;
            StateTerminal stateTerminal;
            ChoicepointTerminal choicepointTerminal;
            if (terminal instanceof ChoicepointTerminal && (choicepointTerminal = (ChoicepointTerminal)terminal).getCp() != null && choicepointTerminal.getCp().getName() != null) {
                return choicepointTerminal.getCp().getName();
            }
            if (terminal instanceof StateTerminal && (stateTerminal = (StateTerminal)terminal).getState() != null && stateTerminal.getState().getName() != null) {
                return stateTerminal.getState().getName();
            }
            if (terminal instanceof TrPointTerminal && (trPointTerminal = (TrPointTerminal)terminal).getTrPoint() != null && trPointTerminal.getTrPoint().getName() != null) {
                return "my." + trPointTerminal.getTrPoint().getName();
            }
            if (terminal instanceof SubStateTrPointTerminal && (subStateTerminal = (SubStateTrPointTerminal)terminal).getState() != null && subStateTerminal.getState().getName() != null && subStateTerminal.getTrPoint() != null && subStateTerminal.getTrPoint().getName() != null) {
                return subStateTerminal.getState().getName() + "." + subStateTerminal.getTrPoint().getName();
            }
            return "?";
        }

        private String getRefTypeName(RefableType refType) {
            if (refType == null || refType.getType() == null || refType.getType().getName() == null) {
                return "?";
            }
            return refType.getType().getName() + (refType.isRef() ? " ref" : "");
        }
    }

    public static class RoomSymbolKindProvider
    extends DocumentSymbolMapper.DocumentSymbolKindProvider {
        protected SymbolKind getSymbolKind(EClass clazz) {
            if (clazz == null) {
                return null;
            }
            if (clazz.getEPackage() == RoomPackage.eINSTANCE) {
                switch (clazz.getClassifierID()) {
                    case 9: 
                    case 12: {
                        return SymbolKind.TypeParameter;
                    }
                    case 10: {
                        return SymbolKind.Enum;
                    }
                    case 13: {
                        return SymbolKind.Struct;
                    }
                    case 19: {
                        return SymbolKind.Interface;
                    }
                    case 25: 
                    case 32: 
                    case 35: {
                        return SymbolKind.Class;
                    }
                    case 14: {
                        return SymbolKind.Field;
                    }
                    case 18: {
                        return SymbolKind.Constructor;
                    }
                    case 16: {
                        return SymbolKind.Method;
                    }
                    case 11: {
                        return SymbolKind.EnumMember;
                    }
                    case 20: {
                        return SymbolKind.Event;
                    }
                    case 17: {
                        return SymbolKind.Method;
                    }
                    case 27: 
                    case 29: 
                    case 30: {
                        return SymbolKind.Interface;
                    }
                    case 47: {
                        return SymbolKind.Class;
                    }
                    case 36: {
                        return SymbolKind.Object;
                    }
                }
            } else if (clazz.getEPackage() == FSMPackage.eINSTANCE) {
                switch (clazz.getClassifierID()) {
                    case 6: {
                        return SymbolKind.Constant;
                    }
                    case 10: {
                        return SymbolKind.Number;
                    }
                    case 11: 
                    case 12: {
                        return SymbolKind.Interface;
                    }
                    case 13: {
                        return SymbolKind.Operator;
                    }
                    case 18: 
                    case 19: 
                    case 20: 
                    case 21: 
                    case 22: {
                        return SymbolKind.Boolean;
                    }
                }
            } else if (clazz.getEPackage() == BasePackage.eINSTANCE) {
                switch (clazz.getClassifierID()) {
                    case 2: {
                        return SymbolKind.String;
                    }
                }
            }
            return null;
        }
    }
}

