/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.ui.imports;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.etrice.core.common.base.util.ImportHelpers;
import org.eclipse.etrice.core.common.ui.imports.IOrganizeImportHelper;
import org.eclipse.etrice.core.room.RoomClass;
import org.eclipse.etrice.core.room.RoomModel;
import org.eclipse.etrice.core.room.RoomPackage;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.XtextResource;

public class RoomOrganizeImportHelper
implements IOrganizeImportHelper {
    @Inject
    ImportHelpers importHelpers;

    public Multimap<EClass, EReference> getTypeReferences() {
        ArrayListMultimap result = ArrayListMultimap.create();
        HashMap<EClass, List<EClass>> subTypes = new HashMap<EClass, List<EClass>>();
        RoomOrganizeImportHelper.getSubTypes((EPackage)RoomPackage.eINSTANCE, subTypes);
        RoomPackage.eINSTANCE.getEClassifiers().stream().filter(EClass.class::isInstance).map(EClass.class::cast).forEach(arg_0 -> this.lambda$2((Multimap)result, subTypes, arg_0));
        return result;
    }

    public QualifiedName getFullyQualifiedName(EObject object) {
        if (object instanceof RoomClass) {
            EObject root = EcoreUtil2.getRootContainer((EObject)object);
            if (root instanceof RoomModel) {
                QualifiedName result = QualifiedName.create((String[])((RoomModel)root).getName().split("\\."));
                result = result.append(((RoomClass)object).getName());
                return result;
            }
        } else if (object instanceof RoomModel) {
            return QualifiedName.create((String[])((RoomModel)object).getName().split("\\."));
        }
        return null;
    }

    public List<QualifiedName> resolveFullyQualifiedName(String refText, EClass type, Resource resource) {
        return this.importHelpers.createModelPathImports(refText, resource, type, false).stream().map(imp -> this.importHelpers.toFQN(imp)).collect(Collectors.toList());
    }

    public IOrganizeImportHelper.ImportRegionResult getImportRegion(XtextResource resource) {
        IOrganizeImportHelper.ImportRegionResult importRegion = super.getImportRegion(resource);
        if (importRegion == null && resource.getContents().get(0) instanceof RoomModel) {
            ICompositeNode node;
            RoomModel roomModel = (RoomModel)resource.getContents().get(0);
            EObject placeBefore = null;
            if (!roomModel.getAnnotationTypes().isEmpty()) {
                placeBefore = (EObject)roomModel.getAnnotationTypes().get(0);
            } else if (!roomModel.getRoomClasses().isEmpty()) {
                placeBefore = (EObject)roomModel.getRoomClasses().get(0);
            }
            if (placeBefore != null && (node = NodeModelUtils.findActualNodeFor((EObject)placeBefore)) != null) {
                return new IOrganizeImportHelper.ImportRegionResult(node.getOffset(), 0, true);
            }
        }
        return importRegion;
    }

    private boolean typeNeedsImport(EClass type) {
        return RoomPackage.Literals.ROOM_CLASS.isSuperTypeOf(type);
    }

    private static void getSubTypes(EPackage ePackage, Map<EClass, List<EClass>> result) {
        for (EClassifier classifier : ePackage.getEClassifiers()) {
            if (!(classifier instanceof EClass)) continue;
            EClass eClass = (EClass)classifier;
            RoomOrganizeImportHelper.getSubType(eClass, EcorePackage.eINSTANCE.getEObject(), result);
            for (EClass eSuperType : eClass.getEAllSuperTypes()) {
                RoomOrganizeImportHelper.getSubType(eClass, eSuperType, result);
            }
        }
    }

    private static void getSubType(EClass eClass, EClass eSuperType, Map<EClass, List<EClass>> result) {
        if (eSuperType.eIsProxy()) {
            return;
        }
        List<EClass> list = result.get(eSuperType);
        if (list == null) {
            list = new ArrayList<EClass>();
            result.put(eSuperType, list);
        }
        list.add(eClass);
    }

    private /* synthetic */ void lambda$2(Multimap multimap, Map map, EClass cls) {
        List refs = cls.getEReferences().stream().filter(ref -> !ref.isContainment() && this.typeNeedsImport(ref.getEReferenceType())).collect(Collectors.toList());
        if (!refs.isEmpty()) {
            multimap.putAll((Object)cls, refs);
            List subClasses = (List)map.get(cls);
            if (subClasses != null) {
                for (EClass subClass : subClasses) {
                    multimap.putAll((Object)subClass, refs);
                }
            }
        }
    }
}

