/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.server.internal.actions;

import com.google.inject.Inject;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.eclipse.glsp.server.actions.Action;
import org.eclipse.glsp.server.actions.ActionHandler;
import org.eclipse.glsp.server.actions.ActionHandlerRegistry;
import org.eclipse.glsp.server.internal.registry.MapMultiRegistry;

public class DefaultActionHandlerRegistry
extends MapMultiRegistry<Class<? extends Action>, ActionHandler>
implements ActionHandlerRegistry {
    @Inject
    public DefaultActionHandlerRegistry(Set<ActionHandler> handlers) {
        handlers.forEach(handler -> handler.getHandledActionTypes().forEach(action -> {
            boolean bl = this.register(action, handler);
        }));
    }

    @Override
    public List<ActionHandler> get(Class<? extends Action> key) {
        Optional<Class> potentialKey;
        List<ActionHandler> result = super.get(key);
        if (result.isEmpty() && (potentialKey = this.elements.keySet().stream().filter(actionClass -> actionClass.isAssignableFrom(key)).findFirst()).isPresent()) {
            result = super.get(potentialKey.get());
            result.forEach(actionClass -> {
                boolean bl = this.register(key, actionClass);
            });
        }
        result.sort(Comparator.comparing(ActionHandler::getPriority));
        return result;
    }
}

