/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.graph.builder.impl;

import java.util.Map;
import java.util.Optional;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.glsp.graph.GPoint;

public final class GArguments {
    public static final String KEY_EDGE_PADDING = "edgePadding";
    public static final String KEY_EDGE_SOURCE_POINT = "edgeSourcePoint";
    public static final String KEY_EDGE_TARGET_POINT = "edgeTargetPoint";
    public static final String KEY_RADIUS_TOP_LEFT = "radiusTopLeft";
    public static final String KEY_RADIUS_TOP_RIGHT = "radiusTopRight";
    public static final String KEY_RADIUS_BOTTOM_RIGHT = "radiusBottomRight";
    public static final String KEY_RADIUS_BOTTOM_LEFT = "radiusBottomLeft";

    private GArguments() {
    }

    public static Map<String, Object> cornerRadius(double radius) {
        return GArguments.cornerRadius(radius, radius, radius, radius);
    }

    public static Map<String, Object> cornerRadius(double topLeftBottomRight, double topRightBottomLeft) {
        return GArguments.cornerRadius(topLeftBottomRight, topRightBottomLeft, topLeftBottomRight, topRightBottomLeft);
    }

    public static Map<String, Object> cornerRadius(double topLeft, double topRight, double bottomRight, double bottomLeft) {
        return Map.of(KEY_RADIUS_TOP_LEFT, topLeft, KEY_RADIUS_TOP_RIGHT, topRight, KEY_RADIUS_BOTTOM_RIGHT, bottomRight, KEY_RADIUS_BOTTOM_LEFT, bottomLeft);
    }

    public static Map.Entry<String, Object> edgePadding(double edgePadding) {
        return Map.entry(KEY_EDGE_PADDING, edgePadding);
    }

    public static Optional<Double> getEdgePadding(Map<String, Object> arguments) {
        return GArguments.getDouble(arguments, KEY_EDGE_PADDING);
    }

    public static Optional<GPoint> getEdgeSourcePoint(Map<String, Object> arguments) {
        return GArguments.get(arguments, KEY_EDGE_SOURCE_POINT, GPoint.class);
    }

    public static Optional<GPoint> getEdgeTargetPoint(Map<String, Object> arguments) {
        return GArguments.get(arguments, KEY_EDGE_TARGET_POINT, GPoint.class);
    }

    public static Optional<Double> getDouble(Map<String, Object> arguments, String key) {
        return GArguments.getNumber(arguments, key).map(Number::doubleValue);
    }

    public static Optional<Integer> getInteger(Map<String, Object> arguments, String key) {
        return GArguments.getNumber(arguments, key).map(Number::intValue);
    }

    public static Optional<Number> getNumber(Map<String, Object> arguments, String key) {
        return GArguments.get(arguments, key, Number.class);
    }

    public static Optional<Boolean> getBoolean(Map<String, Object> arguments, String key) {
        return GArguments.get(arguments, key, Boolean.class);
    }

    public static Optional<String> getString(Map<String, Object> arguments, String key) {
        return GArguments.get(arguments, key, String.class);
    }

    public static <T> Optional<T> get(Map<String, Object> arguments, String key, Class<T> clazz) {
        Object value = arguments.get(key);
        return clazz.isInstance(value) ? Optional.of(clazz.cast(value)) : Optional.empty();
    }

    public static Optional<Double> getEdgePadding(EMap<String, Object> arguments) {
        return GArguments.getDouble(arguments, KEY_EDGE_PADDING);
    }

    public static Optional<GPoint> getEdgeSourcePoint(EMap<String, Object> arguments) {
        return GArguments.get(arguments, KEY_EDGE_SOURCE_POINT, GPoint.class);
    }

    public static Optional<GPoint> getEdgeTargetPoint(EMap<String, Object> arguments) {
        return GArguments.get(arguments, KEY_EDGE_TARGET_POINT, GPoint.class);
    }

    public static Optional<Double> getDouble(EMap<String, Object> arguments, String key) {
        return GArguments.getNumber(arguments, key).map(Number::doubleValue);
    }

    public static Optional<Integer> getInteger(EMap<String, Object> arguments, String key) {
        return GArguments.getNumber(arguments, key).map(Number::intValue);
    }

    public static Optional<Number> getNumber(EMap<String, Object> arguments, String key) {
        return GArguments.get(arguments, key, Number.class);
    }

    public static Optional<Boolean> getBoolean(EMap<String, Object> arguments, String key) {
        return GArguments.get(arguments, key, Boolean.class);
    }

    public static Optional<String> getString(EMap<String, Object> arguments, String key) {
        return GArguments.get(arguments, key, String.class);
    }

    public static <T> Optional<T> get(EMap<String, Object> arguments, String key, Class<T> clazz) {
        Object value = arguments.get((Object)key);
        return clazz.isInstance(value) ? Optional.of(clazz.cast(value)) : Optional.empty();
    }
}

